<?php
/*

    Advanced example for WackoFormatter + Typografica

*/
?>
<html>
<head>
<link href="css/wacko.css" rel="stylesheet" type="text/css" />
</head>
<body>

<form method="post" action="<?php echo $_SERVER["PHP_SELF"];?>">
<textarea name="text" rows="10" cols="100">
<?
$_POST["text"] = stripslashes($_POST["text"]);
echo htmlspecialchars($_POST["text"]);
?>
</textarea>
<input type="submit">
</form>
<?php

// create WackoFormatter
 require_once("classes/WackoFormatter.php");
 $parser = &new WackoFormatter();

// define example customConfig class
 class CustomConfig extends WackoFormatterConfigDefault
 {
  var $config = array(
   "allow_rawhtml" => 1,
  );

  function CustomConfig() {}
  
  //return unique identifier of this page
  function GetPageId() { return $this->id; }

  //preformat links
  function PreLink($url, $text=false) 
  {
   if (!$text) $text = $url;
   return "\xa2\xa2".$url." == ".$text."\xaf\xaf";
  }
 
  //preformat action
  function WrapAction($action) 
  { 
   return "<!--notypo-->\xA1\xA1".$action."\xA1\xA1<!--/notypo-->"; 
  }

  //format link
  function Link ($tag, $options, $text) 
  { 

   $text = htmlspecialchars($text, ENT_NOQUOTES);

   if (preg_match("/^(mailto[:])?[^\\s\"<>&\:]+\@[^\\s\"<>&\:]+\.[^\\s\"<>&\:]+$/", $tag, $matches))
   {// this is a valid Email
     return '<a href="'.($matches[1]=="mailto:" ? $tag : "mailto:".$tag).'">'.$text.'</a>'; 
   }
   else if (preg_match("/^#/", $tag))
   {// html-anchor
     return '<a href="'.$tag.'">'.$text.'</a>'; 
   }                         
   else if (preg_match("/^(http|https|ftp|file):\/\/([^\\s\"<>]+)\.(gif|jpg|jpe|jpeg|png)$/", $tag))
   {// external image 
     return "<img src=\"".$tag."\" ".($text?"alt=\"".$text."\" title=\"".$text."\"":"")." />";
   }
   else if ($this->GetConfigValue("disable_tikilinks")!=1 && preg_match("/^(".UPPER.LOWER.ALPHANUM."*)\.(".ALPHA.ALPHANUM."+)$/s", $tag, $matches)) 
   {// it`s a Tiki link!
     if (!$text) $text = $tag;
     $tag = "/".$matches[1]."/".$matches[2];
     return $this->Link( $tag, $options, $text);
   }
   else if (preg_match("/^(http|https|ftp|file|nntp|telnet):\/\/([^\\s\"<>]+)$/", $tag))
   {// this is a valid external URL
     return '<a href="'.$tag.'">'.$text.'</a>'; 
   } 
   else if (preg_match("/^([\!\.".ALPHANUM_P."]+)(\#[".ALPHANUM_P."\_\-]+)?$/", $tag, $matches))
   {// it's a Wiki link!
     $tag = $matches[1];
     if (!$text) $text = htmlspecialchars($tag, ENT_NOQUOTES);
     return '<a href="'.$tag.'">'.$text.'</a>'; 
   }
   return $text;
  }

 }


if ($_POST["text"])
{

// create object with custom code and config for formatter
 $Config = &new CustomConfig();

 $parser->SetObject($Config);

// make preformatted text 
 $preformatted = $parser->Format($_POST["text"]);

// add typografica & paragrafica
// (if you don`t need them, simply remove next 6 lines)
 require_once("classes/typografica.php");
 require_once("classes/paragrafica.php");
 $typo = new typografica( &$Config );
 $para = new paragrafica( &$Config );
 $preformatted = $typo->correct($preformatted);
 $preformatted = $para->correct($preformatted);

// store it to database
// ....

// when text is needed to display, get it from database
// ....

// make postformatting
 $formatted = $parser->PostFormat($preformatted);

 echo "<hr />".$formatted;
}

?>
<hr /> <a href="http://wackowiki.com/projects/wackoformatter">Download WackoFormatter</a>.
<br /> Copyright &copy; 2003-2004, <a href="http://wackowiki.com/team">WackoWiki team</a>.
<br /> All rights reserved.

</body>
</html>

