<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$help = [

	'admin_massregex' =>
<<<EOD
Description:
	Mass edit using regular expressions

	Enter one or more regular expressions (one per line) for matching, and one or more expressions to replace each match with.
	The first match-expression, if successful, will be replaced with the first replace-expression, and so on.
	See the PHP function preg_replace() for details.

Usage:
	{{admin_massregex}}

Options:
	[page="PageName"]
	[options=1]
	[lang="en"]
	[mute=1]
	[max=Number]
EOD,

	'admin_recovery' =>
<<<EOD
Description:
	Generates the hash for a new recovery_password.

	'recovery_password' => 'add hash here',

Usage:
	{{admin_recovery}}
EOD,

	'admin_replace' =>
<<<EOD
Description:
	Replace edit allows administrators to do a global string find-and-replace on all the content pages of a wiki.

Usage:
	{{admin_replace}}

Options:
	[page="PageName"]
	[options=1]
	[lang="en"]
	[mute=1]
	[max=Number]
EOD,

	'admincache' =>
<<<EOD
Description:
	Clears cache.

Usage:
	{{admincache}}
EOD,

	'adminupdate' =>
<<<EOD
Description:
	Upgrade helper routines.

Usage:
	{{adminupdate}}
EOD,

	'anchor' =>
<<<EOD
Description:
	Creates an anchor to which you can link from any page.

Usage:
	{{anchor href="anchor"}}

Options:
	[text="Index"]
	[title="Title"]
EOD,

	'authors' =>
<<<EOD
Description:
	Print page and revisions authors.

Usage:
	{{authors}}

Options:
	[add="2009 Ivan Ivanov[;2010 John Smith[;...]]"]
		semicolon-separated list of original authors (for reprinted work or such),
		or any appropriate text. wiki-formatting applies.
		note: every semicolon-separated block is printed on the new line
	[add_only=1]
		takes only authors from add= parameter
	[license="CC-BY-SA"]
		some free-form text (wiki-formatting applies) or one of predefined constants:
			- CC-BY-ND		(CreativeCommons-Attribution-NoDerivatives)
			- CC-BY-NC-SA	(CreativeCommons-Attribution-NonCommercial-ShareAlike)
			- CC-BY-NC-ND	(CreativeCommons-Attribution-Non-Commercial No Derivatives)
			- CC-BY-SA		(CreativeCommons-Attribution-ShareAlike)
			- CC-BY-NC		(CreativeCommons-Attribution Non-Commercial)
			- CC-BY			(CreativeCommons-Attribution)
			- CC-Zero		(CreativeCommons-Zero / public domain)
			- GNU-FDL		(GNU Free Documentation License)
			- PD			(Public Domain)
			- CR			(All Rights Reserved)
	[cluster=1]
		consider all cluster subpages (if = 1) or current page only (0, default)
EOD,

	'backlinks' =>
<<<EOD
Description:
	Outputs a list of pages that link to this one.

Usage:
	{{backlinks}}

Options:
	[page="PageName"]
	[max=Number]
	[nomark=1]
	[title=0]
EOD,

	'blog' =>
<<<EOD
Description:
	Creates a blog in the namespace of your choice.

Usage:
	{{blog}}

Options:
	[page="Cluster"]
	[mode="latest|week|from"]
	[date="YYYY-MM-DD"]
	[order="time|tag"]
	[max=Number]
	[title=1]
	[noxml=1]
EOD,

	'calendar' =>
<<<EOD
Description:
	Displays a monthly calendar.

Usage:
	{{calendar}}

Options:
	[year=2012|2013...]
		year to display
	[month=1|2|...]
		month to display
	[highlight=today|1|2|...]
		date to highlight
	[daywidth=3]
		length of weekday name
	[range=1|2|...]
		number of month displayed starting with "month to display" parameter
	[firstday=0|1]
		week starts on: 0 - Sunday, 1 - Monday
EOD,

	'categories' =>
<<<EOD
Description:
	Shows all categories assigned to a particular object (page, file).

Usage:
	{{categories}}

Options:
	[page="Cluster"]
	[list=1]
	[nomark=1]
	[label=0|1]
EOD,

	'category' =>
<<<EOD
Description:
	Shows a list of used categories and pages assigned to a selected category.

Usage:
	{{category}}

Options:
	[page="Cluster"]
		where to start counting from (defaults to current tag)
	[list=0]
		make categories clickable links which display pages of a given category (1 (default) or 0)
	[ids="1,2,3"]
		display pages which belong to these comma-separated categories ids (default none)
	[lang="fr"]
		categories language if necessary (defaults to current page lang)
	[sort="abc|date"]
		order pages alphabetically ('abc', default) or creation date ('date')
	[nomark=1]
		display header and fieldset (1, 2 (no header even in 'categories' mode) or 0 (default))
	[caption=0|1]
		display category description
EOD,

	'changepassword' =>
<<<EOD
Description:
	Displays change password forms: password change and forgotten password reset.

Usage:
	{{changepassword}}

Options:
	[forgot=1]
EOD,

	'changes' =>
<<<EOD
Description:
	Displays a list of the most recent changes in any cluster.

Usage:
	{{changes}}

Options:
	[page="Cluster"]
	[date="YYYY-MM-DD"]
	[max=Number]
	[title=1]
	[noxml=1]
EOD,

	'comment' =>
<<<EOD
Description:
	Sets a link to the comments of a page.

Usage:
	{{comment}}

Options:
	[page="PageName"]
	[text="your text"]
EOD,

	'commented' =>
<<<EOD
Description:
	Displays a list of the most recently commented pages.

Usage:
	{{commented}}

Options:
	[page="Cluster"]
	[max=Number]
	[title=1]
	[noxml=1]
EOD,

	'comments' =>
<<<EOD
Description:
	Displays a list of recent comments.

Usage:
	{{comments}}

Options:
	[page="Cluster"]
	[max=Number]
	[title=1]
	[noxml=1]
EOD,

	'deleted' =>
<<<EOD
Description:
	Displays a list of deleted pages and comments.

Usage:
	{{deleted}}

Options:
	[max=Number]
EOD,

	'edit' =>
<<<EOD
Description:
	Creates a link to the edit handler, if the user has the right to edit the given page.

Usage:
	{{edit}}

Options:
	[page="EditThisPage"]
	[text="your text"]
EOD,

	'editsection' =>
<<<EOD
Description:
	Displays a section edit link.

Usage:
	{{editsection}}

Options:
	[page="PageName"]
	[section=Number]
	[text="your text"]
EOD,

	'embed' =>
<<<EOD
Description:
	Embeds an external application or interactive content, like PDF or videos.

	The CSP directives must allow the selected source.

Usage:
	{{embed url="https://example.com/embed/zhec4tHwLzo"}}

Options:
	[width="400"]
	[height="300"]
	[align="left|center|right"]
EOD,

	'feed' =>
<<<EOD
Description:
	RSS/Atom Feed Integration.

Usage:
	{{feed url="https://...[|https://...|https://...]"}}

Options:
	[title="News feed title|no"]
		"text" - displayed as title
		"no" - means show no title

empty title - title taken from feed
	[images=0] - text only for better readability
	[max=Number]
	[time=1]
	[nomark=1]
		1 - makes feed header h3 and feed-items headers h4
		0 - makes it all default
EOD,

	'filelinks' =>
<<<EOD
Description:
	Outputs a list of files that this page links to.

Usage:
	{{filelinks}}

Options:
	[page="PageName"]
	[max=Number]
	[nomark=1]
	[title=0]
EOD,

	'files' =>
<<<EOD
Description:
	Shows uploaded files.

Usage:
	{{files}}

Options:
	[page="PageName" or global=1 or all=1 or linked=1]
	[order="ext|ext_desc|name_desc|size|size_desc|time|time_desc"]
	[form=1]
	[options=1]
	[owner="UserName"]
	[media=1]
	[max=Number]
EOD,

	'forums' =>
<<<EOD
Description:
	Shows sub forums list.

Usage:
	{{forums}}

Options:
	[pages="subtag1, subtag2, ..."]
		To create multilevel forums this optional parameter passes
		a comma-delimited list of tag names of pages that must be
		considered sub forums, and not topics. Tags must be absolute (not relative).
		If you define pages, it must be done for all sub forums and topic pages.
EOD,

	'gallery' =>
<<<EOD
Description:
	Shows a image gallery.

Usage:
	{{gallery}}

Options:
	[page="PageName"]
		call image from another page
	[global=0|1]
		call global images
	[perrow=Number]
		Number of images per rows (default = 5)
	[caption=1|2]
		1 show file description, 2 show file caption
	[title="Gallery"]
		album title
	[target=1|2]
		show large images without page (if = 2 in new browser window)
	[nomark=1]
		hide external border
	[table=1]
		pictures in table

	[order="ext|name_desc|size|size_desc|time|time_desc"]
	[owner="UserName"]
	[max=Number]
EOD,

	'groups' =>
<<<EOD
Description:
	Shows list with usergroups and their members.

Usage:
	{{groups}}

Options:
	[max=Number]
EOD,

	'hashid' =>
<<<EOD
Description:
	Shows hidden content based on user group or user name.

Usage:
	{{hashid}}

Options:
	[version=0|1]
		0 - link to the page
		1 - link to the current page version (default)

help
No help text available.
EOD,

	'hits' =>
<<<EOD
Description:
	Shows the number of hits for a page.

Usage:
	{{hits}}

Options:
	[page="PageName"]
EOD,

	'imageslider' =>
<<<EOD
Description:
	Showing images as slider for uploaded files.

Usage:
	{{imageslider}}

Options:
	[page="PageName" or global=1]
	[order="time|name_desc|size|size_desc|ext"]
	[owner="UserName"]
	[media=1]
	[max=number]
EOD,

	'import' =>
<<<EOD
Description:
	Import an XML file into a cluster.

	http://example.com/SomeCluster/import --> {{import}}, to = "Test" .
	Will be imported at: http://example.com/Test/*

	i.e. no relative addressing

	This is an Admins only action, it requires always write access and it will overwrite pages indicriminatory.
	The old version of the page can be still accessed via revisions, you might ensure revisions are enabled and not purged.

Usage:
	{{import}}

Options:
	[mute=1]
EOD,

	'include' =>
<<<EOD
Description:
	Writes the content of the included page directly into the body of the page (transclusion).

Usage:
	{{include page="SomePage"}}

Options:
	[nomark=1]
	[notoc=1]
	[nowarning=1]
	[first_anchor="anchor1"]
	[last_anchor="anchor2"]
EOD,

	'interwikilist' =>
<<<EOD
Description:
	Displays all available Interwiki addresses.

Usage:
	{{interwikilist}}
EOD,

	'lastedited' =>
<<<EOD
Description:
	Print last editor of the page.

	Last edited by: SomeUser (22.12.2018 13:08) fixed two typos

Usage:
	{{lastedited}}

Options:
	[icon=0|1]
		show icon
	[label=0|1]
		show 'Last edited by:' label
	[note=0|1]
		show edit note
EOD,

	'license' =>
<<<EOD
Description:
	Prints page or file license.

Usage:
	{{license}}

Options:
	[license="CC-BY-SA"]
		some free-form text (wiki-formatting applies) or one of predefined constants:
			- CC-BY-ND		(CreativeCommons-Attribution-NoDerivatives)
			- CC-BY-NC-SA	(CreativeCommons-Attribution-NonCommercial-ShareAlike)
			- CC-BY-NC-ND	(CreativeCommons-Attribution-Non-Commercial No Derivatives)
			- CC-BY-SA		(CreativeCommons-Attribution-ShareAlike)
			- CC-BY-NC		(CreativeCommons-Attribution Non-Commercial)
			- CC-BY			(CreativeCommons-Attribution)
			- CC-Zero		(CreativeCommons-Zero / public domain)
			- GNU-FDL		(GNU Free Documentation License)
			- PD			(Public Domain)
			- CR			(All Rights Reserved)
	[license_id=ID]
		assigned db value
	[icon=0|1]
		show license icons
	[intro=0|1]
		show intro text
EOD,

	'login' =>
<<<EOD
Description:
	Displays a login form if you are not yet logged in, or a welcome message if you are already logged in.

Usage:
	{{login}}
EOD,

	'menu' =>
<<<EOD
Description:
	To edit and customize your bookmarks.

Usage:
	{{menu}}

Options:
	[system=1]
		Global default bookmarks are displayed for administrators to edit.
EOD,

	'mostcommented' =>
<<<EOD
Description:
	Shows most commented pages.

Usage:
	{{mostcommented}}

Options:
	[max=50]
		maximum number of pages to retrieve
	[page="PageName"]
		page name to start from in the page hierarchy
	[title=1]

shows the page title
	[nomark=1]
		makes it possible to hide frame around
	[dontrecurse=0|1]
		if set to true the list will only include pages that are direct children of the "page" cluster
	[lang="ru"]
		show pages only in specified language
EOD,

	'mostpopular' =>
<<<EOD
Description:
	Outputs a list of the most visited pages.

Usage:
	{{mostpopular}}

Options:
	[max=50]
		maximum number of pages to retrieve
	[page="PageName"]
		page name to start from in the page hierarchy
	[title=1]
		shows the page title
	[nomark=1]
		makes it possible to hide frame around
	[dontrecurse=0|1]
		if set to true the list will only include pages that are direct children of the "page" cluster
	[counter=0|1]
		shows page hit counter
	[system=0|1]
		excludes system pages
	[lang="ru"]
		show pages only in specified language
EOD,

	'mychanges' =>
<<<EOD
Description:
	Displays a list of pages you have changed, with sorting options.

Usage:
	{{mychanges}}

Options:
	[max=Number]
	[byname=1]
EOD,

	'mychangeswatches' =>
<<<EOD
Description:
	Displays a list of the changed "observed" pages.

Usage:
	{{mychangeswatches}}

Options:
	[max=Number]
	[title=1]
EOD,

	'mygroups' =>
<<<EOD
Description:
	Displays the groups you're a member.

Usage:
	{{mygroups}}

Options:
	[nomark=1]
EOD,

	'mypages' =>
<<<EOD
Description:
	Displays a list of pages that belong to you, sortable by alphabet or modification date.

Usage:
	{{mypages}}

Options:
	[max=Number]
	[bychange=1]
	[bycreation=1]
EOD,

	'mywatches' =>
<<<EOD
Description:
	List of all pages under the "observation" of this user.

Usage:
	{{mywatches}}
EOD,

	'news' =>
<<<EOD
Description:
	Creates a news feed in a predefined news cluster.

Usage:
	{{news}}

Options:
	[page="Cluster"]
	[mode="latest|week|from"]
	[date="YYYY-MM-DD"]
	[order="time|tag"]
	[max=Number]
	[title=1]
	[noxml=1]
EOD,

	'orphaned' =>
<<<EOD
Description:
	Outputs a list of lost pages (those pages that do not have any links to them) for some cluster.

	By default it is equal to the current page. To display it for all namespaces, use root page="/".

Usage:
	{{orphaned}}

Options:
	[page="Cluster"]
	[max=Number]
EOD,

	'pagebreak' =>
<<<EOD
EOD,

	'pageindex' =>
<<<EOD
Description:
	Outputs a complete directory of all pages on the site, ordered alphabetically.

Usage:
	{{pageindex}}

Options:
	[page="Cluster"]
		show page index only for a certain cluster
	[max=50]
		number of pages to show at one time, if there are more pages then the next/prev buttons are shown
	[letter="a"]
		only display pages whose name starts with this letter
	[title=0|1]
		takes title inplace of tag
	[system=0|1]
		includes or excludes system pages
	[lang="ru"]
		show pages only in specified language
EOD,

	'pagelinks' =>
<<<EOD
Description:
	Outputs a list of pages that this page links to.

Usage:
	{{pagelinks}}

Options:
	[page="PageName"]
	[max=Number]
	[nomark=1]
	[title=0]
EOD,

	'paragraphs' =>
<<<EOD
Description:
	It enters numeration for the paragraphs.

Usage:
	{{paragraphs}}

Options:
	[style="before|after|left|right"]
		The style affects where paragraph numbers will be displayed.
	[name="absolute|document-relative"]
EOD,

	'randomimage' =>
<<<EOD
Description:
	Loads a random image.

Usage:
	{{randomimage}}

Options:
	[global=0|1]
		attached to page or global
	[owner="UserName"]
	[category="category"]
	[caption=0|1]

show caption
EOD,

	'randompage' =>
<<<EOD
Description:
	Loads a random page.

Usage:
	{{randompage}}

Options:
	[page="PageName"]
		page name to start from in the page hierarchy
	[test]
		show, don't redirect
EOD,

	'randomphrase' =>
<<<EOD
Description:
	Loads a random line of a page into the body of data.

Usage:
	{{randomphrase}}

Options:
	[page="PageName"]
	[useemptystring=1]
		indicates breaking up a page into blocks separated by an empty line rather than by lines
EOD,

	'redirect' =>
<<<EOD
Description:
	Unconditionally it redirects the user to another page.

Usage:
	{{redirect to="!/NewPage"}}

Options:
	[temporary=0|1]
	[mute=0|1]
EOD,

	'registration' =>
<<<EOD
Description:
	Shows the registration form and performs the entire registration.

Usage:
	{{registration}}
EOD,

	'search' =>
<<<EOD
Description:
	Searches the content of the Wiki.

Usage:
	{{search}}

Options:
	[phrase="Term"]
	[page="PageName"]
	[topic=1]
	[options=1]
	[lang="en"]
	[form=1]
	[nomark=1]
	[style=one of ("br","ul","ol","comma") ]
	[scope=one of ("pages", "all")]
EOD,

	'tagcloud' =>
<<<EOD
Description:
	Creates a tag cloud.

Usage:
	{{tagcloud}}

Options:
	[page="Cluster"]
		where to start counting from (defaults to current tag)
	[lang='fi']
		categories language if necessary (defaults to current page lang)
	[owner="UserName"]

page owner
	[sort="abc|number"]
		order categories alphabetically or by number ('abc'| 'number')
	[nomark=1]
		display header and fieldset (1) or 0 (default))
EOD,

	'toc' =>
<<<EOD
Description:
	Shows the table of content.

Usage:
	{{toc}}

Options:
	[page="!/SubTag"]
	[from="h2"]
	[to="h4"]
	[numerate=0|1]
	[start=0|100]
	[legend="alternate legend"]
	[nomark=0|1]
EOD,

	'topics' =>
<<<EOD
Description:
	Shows forum topics list.

Usage:
	{{topics}}

Options:
	[pages="subtag1, subtag2, ..."]
		When creating multilevel forums this optional parameter passes
		a comma-delimited list of tag names of pages that must be
		considered sub forums, so topics under these cluster subpages
		will not be displayed. Tags must be absolute.
EOD,

	'tree' =>
<<<EOD
Description:
	Builds the page tree starting from the current or specified page.

	Use [page="/"] to get the entire root.

Usage:
	{{tree}}

Options:
	[page="PageName"]
	[depth=3]
	[title=1]
	[nomark=0]
	[legend=""]
	[sort="asc|desc"]
	[system=0|1]
		1 - excludes system pages
	[lang="ru"]
		show pages only in specified language
EOD,

	'upload' =>
<<<EOD
Description:
	Uploads files to global or local namespace.

Usage:
	{{upload}}

Options:
	[global=1]
	[maxsize=200]
	[hide_description=1]
EOD,

	'usergroups' =>
<<<EOD
Description:
	Displays the list of groups and their members.

Usage:
	{{usergroups}}

Options:
	[cols=Number]
	[nomark=1]
EOD,

	'userpages' =>
<<<EOD
Description:
	Displays all user related pages.

Usage:
	{{userpages}}
EOD,

	'users' =>
<<<EOD
Description:
	Shows list with registered users together with a quantity of pages belonging to them.

Usage:
	{{users}}

Options:
	[max=Number]
EOD,

	'usersettings' =>
<<<EOD
Description:
	Displays the settings page for registered users and the registration page for guests.

Usage:
	{{usersettings}}
EOD,

	'wanted' =>
<<<EOD
Description:
	Shows pages that do not yet exist and are linked to for some cluster.

	By default it is equal to the current page. To display it for all namespaces, use root page="/".

Usage:
	{{wanted}}

Options:
	[page="Cluster"]
	[max=Number]
EOD,

	'watchers' =>
<<<EOD
Description:
	Outputs a list of users watching this page.

Usage:
	{{watchers}}

Options:
	[page="PageName"]
	[nomark=1]
EOD,

	'whatsnew' =>
<<<EOD
Description:
	Displays a list of all new, deleted, or changed pages, new attachments, and comments.

Usage:
	{{whatsnew}}

Options:
	[page="Cluster"]
	[max=Number]
	[noxml=1]
EOD,

];