<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Dansk',
		'code'		=> 'da',
		'dir'		=> 'ltr',
		'locale'	=> 'da_DK.UTF-8',
	],

	// common
	'AddButton'					=> 'Tilføj',
	'ArchiveButton'				=> 'Arkiv',
	'CancelButton'				=> 'Fortryd',
	'ContinueButton'			=> 'Continue',
	'ConvertButton'				=> 'Convert',
	'CreateButton'				=> 'Opret',
	'DeleteButton'				=> 'Slet',
	'RemoveButton'				=> 'Fjern',
	'RenameButton'				=> 'Omdøb',
	'ResetButton'				=> 'Reset',
	'RestoreButton'				=> 'Gendan',
	'SaveButton'				=> 'Gem',
	'SearchButton'				=> 'Søg',
	'SendButton'				=> 'Send',
	'SetButton'					=> 'Set',
	'SubmitButton'				=> 'Indsend',
	'UpdateButton'				=> 'Opdatér',

	'FormInvalid'				=> 'Den indsendte formular var ugyldig. Prøv at indsende igen.',

	// logged in panel
	'AccountText'				=> 'Min konto',
	'AccountTip'				=> 'Bruger indstillinger',
	'AdminText'					=> 'Admin',
	'AdminTip'					=> 'Administratorkontrolpanel',
	'LogoutLink'				=> 'Log af',
	'LogoutButton'				=> 'Log af',
	'LogoutAreYouSure'			=> 'Er du sikker på, at du vil logge af?',

	// registration panel
	'RegistrationWelcome'		=> 'Ny bruger registrering:',
	'RegistrationButton'		=> 'Registrer mig!',
	'UserNameOwned'				=> 'Dette brugernavn er allerede i brug. Vælg et andet.',
	'SiteRegistered'			=> 'Du har med succes registreret dig på siden %1.',
	'RegistrationEmailInfo'		=> 'En gyldig e-mail-adresse. Alle e-mails fra systemet sendes til denne adresse. E-mail-adressen bliver ikke offentliggjort og bruges kun, hvis du ønsker at modtage en ny adgangskode eller ønsker at modtage visse nyheder eller meddelelser via e-mail.',
	'SiteEmailConfirm'			=> 'Bekræft din e-mail-adresse ved at klikke på linket i instruktionerne sendt til dig. <br> Hvis du ikke verificerer din e-mail-adresse, vil du ikke kunne hente en mulig mistet adgangskode. Derudover vil du ikke blive underrettet om de seneste sideændringer og kommentarer.',
	'NameTooShort'				=> 'Brugernavn er for kort, et minimum på %2 tegn er påkrævet.',
	'NameTooLong'				=> 'Brugernavn er for langt, et maksimum på %2 tegn er tilladt.',
	'NameAlphanumOnly'			=> 'Brugernavn skal være mellem %1 og %2 tegn langt og brug kun alfanumeriske tegn.',
	'NameCamelCaseOnly'			=> 'Brugernavn skal være mellem %1 og %2 tegn langt og WikiNavn formateret.',
	'NewUserAccount'			=> 'ny brugerkonto',

	'NewAccountSubject'			=> 'Kontoregistrering',
	'NewAccountAdminCreated'	=> 'The user %1 has created an account for you with username "%2". In order to complete your registration, visit the following URL (make sure it is entered as the single line) and set your own access password:',
	'NewAccountUsername'		=> 'Brugernavn:',
	'AccountLanguage'			=> 'Sprog:',
	'NewAccountEmail'			=> 'E-mail:',
	'NewAccountIP'				=> 'Fjern-IP-adresse:',
	'NewAccountSignupInfo'		=> 'Følgende konto er blevet oprettet:',

	'UserWaitingApproval'		=> 'An email has been sent to the site administrator. The administrator will review the information that has been submitted and either approve or deny your request.',
	'UserRequiresApproval'		=> 'To approve or deny this user access to %1 go to the admin panel.',
	'UserApprovalInfo'			=> 'After you register, your request will be sent to the site administrator for approval. You will then receive an email with further instructions.',
	'UserApprovalHint'			=> 'The successful activation of your account will be announced in a specific e-mail. Until then, a login is not possible.',

	'UserApprovalPending'		=> 'Your account is still pending approval.',
	'UserApprovalDenied'		=> 'Your account has been denied access to this site.',

	'RegistrationApproved'		=> 'Registrering godkendt',
	'RegistrationDenied'		=> 'Registrering afvist',
	'PendingApproval'			=> 'Afventer godkendelse',

	'UserApprovedInfo'			=> 'You have been approved to access %1.',
	'UserDeniedInfo'			=> 'You have been denied access to %1.',

	'RegistrationThreshold'		=> 'Den tid, det tager at udfylde formularen, bør ikke være mindre end %1 sekunder.',
	'Language'					=> 'Sprog',

	// login panel
	'LoginWelcome'				=> 'Log ind',
	'CreateAccount'				=> 'Registrering',
	'RegistrationLink'			=> 'Registrering',
	'LoginName'					=> 'Dit brugernavn',
	'Password'					=> 'Din adgangskode',
	'LoginButton'				=> 'Log ind',
	'LoginLink'					=> 'Log på',
	'PersistentCookie'			=> 'Forbliv logget ind',
	'Session'					=> 'Session',
	'SessionTip'				=> 'parameters of current session',
	'SessionDuration'			=> 'Sessionens varighed',
	'SessionDurationSession'	=> 'browser session',
	'SessionDurationDay'		=> '1 dag',
	'SessionDurationWeek'		=> '1 uge',
	'SessionDurationMonth'		=> '1 måned',
	'LoggedInAs'				=> 'Du er logget ind som',

	'ClearCookies'				=> 'Slet alle cookies',
	'BindSessionIp'				=> 'Bind session to the IP-address',
	'BindSessionIpOn'			=> 'enabled (current IP %1)',
	'TrafficProtection'			=> 'Traffic Protection',
	'SessionEnds'				=> 'The current session ends',
	'LastVisit'					=> 'Last visit was recorded',

	'LoginIncorrect'			=> 'Det brugernavn eller adgangskode, du har indtastet, er ugyldigt.',
	'WelcomeBack'				=> 'Velkommen tilbage, %1',
	'LoginAttemptsExceeded'		=> 'Du har overskredet antallet af tilladte loginforsøg.<br>Oven i at skulle angive dit brugernavn og dit kodeord igen skal du nu bekræfte billedet du ser herunder.',

	// session notice
	'IPAddressChanged'			=> 'IP-adresse ændret til %1 (var %2)',

	'SessionReplay'				=> 'Session terminated due to replay.',
	'SessionObsolete'			=> 'Session is outdated.',
	'SessionExpired'			=> 'Session has expired.',
	'SessionTimeout'			=> 'Session terminated due to timeout.',
	'SessionInactivity'			=> 'Session terminated due to inactivity.',
	'SessionUaChange'			=> 'Session terminated due to user agent change.',
	'SessionTLSChange'			=> 'Session terminated due to TLS change.',
	'SessionIPChange'			=> 'Session terminated due to IP change.',

	// other
	'Guest'						=> 'Gæst',
	'Help'						=> 'Hjælp',
	'TopicSearchText'			=> 'Søg i titler',
	'WordprocessorVersion'		=> 'Kopieringsvenlig version',

	// notifications
	'EmailHello'				=> 'Hej ',
	'EmailModerator'			=> 'Moderator',
	'WatchedPageChanged'		=> 'Siden er ændret ',
	'SomeoneChangedThisPage'	=> ' ændrede den side som du overvåger: ',
	'NewPageCreatedSubj'		=> 'En ny side',
	'NewPageCreatedBody'		=> 'Bruger %1 har oprettet en ny side: ',
	'FileUploadedSubj'			=> 'En ny fil',
	'FileUploadedBody'			=> 'Bruger %1 har uploadet en ny fil: ',
	'FileReplacedBody'			=> 'Bruger %1 har erstattet filen: ',

	'ActionDenied'				=> 'Nej, nej, nej, det må du ikke!',
	'TocTitle'					=> 'Indhold ',
	'OuterLink2'				=> 'Udgående link',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF Dokument',
	'RDFLink'					=> 'RDF Dokument',
	'EmailLink'					=> 'Skriv en email (mailprogram opstartes)',
	'JabberLink'				=> 'Chat via XMPP (Jabber client launch)',
	'PermaLink'					=> 'Permanent link',
	'PermaLinkTip'				=> 'Permanent henvisning til denne version af denne side',
	'PermaLink0Tip'				=> 'Permanent henvisning til denne side',

	'ShowTip'					=> 'Klik for at vende tilbage til visning',
	'ShowText'					=> 'Vis',
	'WikieditAutocomplete'		=> 'Complete wikilinks by Ctrl+Space',
	'WikiEditInactiveJs'		=> 'For at kunne bruge WikiEdit skal du aktivere JavaScript i din browser.',
	'NumerateLinks'				=> 'Numerate links in print view',
	'Comment'					=> 'Kommentar',
	'Comments0'					=> 'Ingen kommentarer til denne side.',
	'Comments1'					=> 'En kommentar til denne side.',
	'CommentsN'					=> 'Der er %1 kommentarer til denne side.',
	'Comments'					=> 'Kommentarer',
	'CommentHint'				=> '<a href="%1">Log ind</a> eller <a href="%2">opret en konto</a> for at skrive en kommentar.',
	'CommentEdited'				=> 'redigeret',
	'Links'						=> 'Links',
	'Version'					=> 'Version',

	// details formatter
	'ShowHideDetails'			=> 'Detaljer',

	'PrivacyPolicy'				=> 'Privacy Policy',
	'TermsOfUse'				=> 'Vilkår for brug',
	'AcceptTermsOfUse'			=> ' I accept',

	'ShowComments'				=> 'Vis kommentarer',
	'HideComments'				=> 'Gem kommentarer',
	'AddComment'				=> 'Skriv en kommentar til denne side:',
	'AddCommentTitle'			=> 'Title of the comment:',
	'CommentTitleRe'			=> 'Re:',
	'AddCommentButton'			=> 'Post kommentar',
	'HereLink'					=> 'her',
	'PageHandlerMoreTip'		=> 'mere',

	'ThemeCorrupt'				=> 'Theme is corrupt',
	'InvalidNamespace'			=> 'Invalid namespace given.',
	'DoesNotExists'				=> 'Denne side eksisterer endnu ikke.',
	'PromptCreate'				=> 'Vil du <strong><a href="%1">oprette</a></strong> den?',
	'RevisionHint'				=> 'Dette er en ældre version af <a href="%1">%2</a> fra %3 redigeret af %4.',
	'ReadAccessDenied'			=> 'Du har ikke lov til at se denne side.',
	'ReadAccessDeniedHintGuest'	=> 'For at læse denne side skal du logge ind.',
	'PageDeletedInfo'			=> 'Denne side er blevet slettet.',
	'RevisionDeletedInfo'		=> 'Denne revision er blevet slettet.',
	'CommentDeletedInfo'		=> 'Denne kommentar er blevet slettet.',

	'LastEditedBy'				=> 'Senest redigeret af',
	'YouAreOwner'				=> 'Du ejer denne side.',
	'Owner'						=> 'Ejer:',
	'Nobody'					=> 'Ingen',
	'TakeOwnership'				=> 'Overtag ejerskabet',
	'FilesTip'					=> 'Manage attached files',
	'FilesText'					=> 'Vedhæftede filer',
	'DeleteTip'					=> 'Klik her for at slette siden.',
	'DeleteCommentTip'			=> 'Klik her for at slette kommentar.',
	'DeleteText'				=> 'Slet',
	'AclText'					=> 'Rediger tilladelser',
	'AclTip'					=> 'Rediger Tilladelser',

	'PropertiesText'			=> 'Egenskaber',
	'PropertiesTip'				=> 'Rediger sideegenskaber',
	'EditTip'					=> 'Klik her for at redigere siden.',
	'EditText'					=> 'Rediger siden',
	'EditSection'				=> 'Redigér afsnit %1',
	'EditSectionHint'			=> 'Section %1 of %2',
	'SectionHeadline'			=> 'Afsnit',
	'EditCommentTip'			=> 'Rediger kommentar',
	'EditComment'				=> 'Rediger denne kommentar',
	'ReplyComment'				=> 'Svar',
	'ReplyCommentTip'			=> 'Besvar denne kommentar',
	'RevisionTip'				=> 'Klik for at se seneste sideændringer',
	'RevisionText'				=> 'Versioner',
	'ReferrersTip'				=> 'Klik for at se links til denne side',
	'ReferrersText'				=> 'Henvisninger',
	'ModerateTip'				=> 'Moderering af emner og forumindlæg',
	'ModerateText'				=> 'Moderat',
	'SearchText'				=> 'Søg: ',

	'AclUpdated'				=> 'Tilladelsesliste opdateret',
	'AclGaveOwnership'			=> ' og har overgivet ejeskab til %1.',
	'AclNoNewOwner'				=> 'Page ownership is not transferred, because the user %1 was not found.',
	'NewPageOwnership'			=> 'Overført sideejerskab',
	'YouAreNewOwner'			=> 'den tidligere ejer %1 har følgende side ' . "\n" . ' overført til dig',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Se tilladelser:',
	'AclWrite'					=> 'Angiv tilladelser:',
	'AclComment'				=> 'Kommentartilladelser:',
	'AclCreate'					=> 'Opret:',
	'AclUpload'					=> 'Fortsæt:',
	'AclFor'					=> 'Tilladelser for %1',
	'SetOwner'					=> 'Angiv ejer:',
	'OwnerDontChange'			=> 'Ingen ændringer',
	'AclAccessDenied'			=> 'Du er ikke ejer af denne side.',
	'AclSyntaxError'			=> 'Access control list syntax error',
	'AclHelp'					=> '<code>*</code> - everyone is allowed<br>' .
									'<code>$</code> - only registered users<br>' .
									'<code>!</code> - a preceding exclamation mark denies the respective right<br>' .
									'<code>[UserName]</code> - names of allowed users<br>' .
									'<code>[GroupName]</code> - names of allowed usergroup (alias)<br>' .
									'<code>(an empty list)</code> - only the page owner has access',

	'AccessMode'				=> 'Sigtbarhed',
	'AccessDenied'				=> 'denied',
	'AccessPublic'				=> 'public',
	'AccessRegistered'			=> 'registrerede',
	'AccessPrivate'				=> 'private',
	'AccessCustom'				=> 'custom',

	// purge handler
	'PurgePage'					=> 'Rens side',
	'NotOwnerAndCantPurge'		=> 'You are not the owner of the page and you can not purge it.',
	'ReallyPurge'				=> 'ATTENTION: Purging the page is irreversible!',
	'SelectPurgeOptions'		=> 'Vælg de nødvendige rensemuligheder:',
	'PurgeComments'				=> 'Rens alle kommentarer på siden',
	'CommentsPurged'			=> 'Alle kommentarer blev slettet.',
	'PurgeFiles'				=> 'Fjern alle vedhæftede filer',
	'FilesPurged'				=> 'Alle vedhæftede filer blev fjernet.',
	'PurgeRevisions'			=> 'Rens alle revisioner af siden',
	'RevisionsPurged'			=> 'Revisionerne blev udrenset.',
	'PurgeButton'				=> 'Rense',

	// categories handler
	'Categories'				=> 'Kategorier',
	'CategoriesAssign'			=> 'tildele',
	'CategoriesEdit'			=> 'redigere',
	'Category'					=> 'Kategori',
	'CategoriesFor'				=> 'Kategorier for',
	'CategoriesTip'				=> 'Rediger kategorier',
	'CategoriesText'			=> 'Kategorier',
	'CategoriesUpdated'			=> 'Kategorier opdateret',
	'CategoriesAlreadyExists'	=> 'Denne kategori %1 er der allerede.',
	'CategoriesAdded'			=> 'Kategori %1 tilføjet.',
	'CategoriesRenamed'			=> 'Kategori held omdøbt.',
	'CategoriesUngrouped'		=> 'Category debundled successfully.',
	'CategoriesGrouped'			=> 'The category entered in the new group.',
	'NoMultilevelGrouping'		=> 'Multilevel grouping categories is not possible.',
	'CategoriesDeleted'			=> 'De kategorien var slettet fra databasen og alle sider.',
	'CategoriesAdd'				=> 'Tilføj en ny kategori',
	'CategoryDescription'		=> 'Beskrivelse',
	'CategoriesAddGrouped'		=> 'Grupperet med den kategori',
	'CategoriesAddGroupedNo'	=> 'Ingen gruppe.',
	'CategoriesRename'			=> 'Omdøb kategori %1',
	'CategoriesRenameInfo'		=> '* Note: Change will affect all pages that are assigned to that category.',
	'CategoriesGroup'			=> 'Group categories %1 with',
	'CategoriesGroupInfo'		=> '* Select [no group], to debundled the category.',
	'CategoriesNoGroup'			=> '[ingen gruppe]',
	'CategoriesDelete'			=> 'Er du sikker på du vil fjerne kategori %1?',
	'CategoriesDeleteInfo'		=> '* Note: Change will affect all pages that are assigned to that category. If the word has a sub-category, they will not be deleted, but only debundled.',
	'CategoriesStoreInfo'		=> 'For at tildele kategorier til en side markere afkrydsningsfelterne.',
	'CategoriesStoreButton'		=> 'Gem Kategorier',
	'CategoriesGroupButton'		=> 'Gruppen',
	'CategoriesEditInfo'		=> 'For at redigere kategorilisten vælg alternativknappen.',
	'NoCategoriesForThisLang'	=> 'Kategorier for dette sprog er ikke angivet.',
	'PagesCategory'				=> 'Sider kategori',
	'CategoryNotExists'			=> 'Kategori eksisterer ikke.',
	'CategoryEmpty'				=> 'Kategori tom.',
	'NoCategorySelected'		=> 'Ingen kategori valgt.',
	'NoCategoriesAssigned'		=> 'Ingen tildelte kategorier for dette sprog.',
	'TagCloud'					=> 'Ordsky',
	'PagesTaggedWith'			=> '%1 pages tagged with %2',
	'CategoriesOfCluster'		=> 'of cluster',
	'TaggedWithTip'				=> 'Vis sider mærket med %1',

	// source handler
	'SourceText'				=> 'Kilde',
	'SourceTip'					=> 'View the wiki-source',
	'SourceCopyToClipboard'		=> 'Kopier til udklipsholder',
	'SourceFor'					=> 'Se kilde til %1',

	// Groups action
	'GroupsSearch'				=> 'Find Grupper',
	'GroupsNoMatching'			=> 'Matching groups not found. Try a softer search criteria.',
	'GroupsOpenProfile'			=> 'Se profil',
	'GroupsName'				=> 'Gruppe',
	'GroupsMembers'				=> 'Medlemmer',
	'GroupsDescription'			=> 'Beskrivelse',
	'GroupsCreated'				=> 'Oprettede',
	'GroupsNotFound'			=> 'Group %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'GroupsProfile'				=> 'Profil',
	'GroupsList'				=> 'Se hele listen over grupper',
	'GroupSpace'				=> 'Gruppe plads',

	'MetaUpdated'				=> 'Meta data opdateret',

	'PreviewButton'				=> 'Forhåndsvisning',
	'Preview'					=> 'Forhåndsvisning',
	'Chars'						=> 'chars',
	'PageBody'					=> 'Page body',
	'EditNote'					=> 'Rediger oversigt',
	'EditNoteMissing'			=> 'Rediger resumé mangler',
	'EditMinor'					=> 'Mindre redigere',
	'MinorEditHide'				=> 'Skjul mindre ændring',
	'MinorEditShow'				=> 'Vis mindre ændring',
	'PostAnonymously'			=> 'Send anonymt uden at give dit navn',
	'NotifyMe'					=> 'Advisér mig om nye kommentarer og ændringer af siden',
	'OverwriteAlert'			=> 'OVERSKRIVNING ADVARSEL: Denne side blev ændret af en anden mens du redigerede den.<br>Kopier venligst dine ændringer, og rediger forfra.',
	'TextDbOversize'			=> 'Opmærksomhed: Din tekst overskrider længdegrænsen med %1 tegn. Du bedes forkorte din tekst til et rimeligt antal tegn. Tip: Du kan placere den resterende tekst på en separat side.',
	'EditingRevisionWarning'	=> 'Du redigerer en gammel version af denne side. Hvis du gemmer den, vil alle ændringer foretaget siden denne revision blive overskrevet. Du kan eventuelt redigere den nuværende revision i stedet.',
	'WriteAccessDenied'			=> 'Du har ikke tilladelse til at skrive denne side.',
	'EmptyPage'					=> 'Sidekroppen var tom - ikke gemt!',
	'EmptyComment'				=> 'Hov, den er tom - ikke gemt!',
	'CommentAccessDenied'		=> 'Beklager, men du har ikke tilladelse til at kommentere på denne side.',
	'CommentFlooded'			=> 'Intervallet mellem offentliggørelsen af bidragene må ikke være mindre end %1 sekunder.',
	'CommentAdded'				=> 'Kommentar tilføjet.',
	'YouAreNowTheOwner'			=> 'Du er nu ejer af denne side.',
	'PageSaved'					=> 'Side version %1 gemt.',
	'CommentSaved'				=> 'Kommentar gemt.',

	'RevisionsFor'				=> 'Versionshistorik for %1',
	'DefaultDiffMode'			=> 'Standard diff-tilstand',
	'DiffMode'		=> [
		'0'		=> 'Full diff',
		'1'		=> 'Simple ændringer',
		'2'		=> 'Kilde',
		'3'		=> 'Side by side',
		'4'		=> 'Inline',
		'5'		=> 'Merged',
		'6'		=> 'Unified',
		'7'		=> 'Context',
	],

	'PreviousEdit'				=> 'Gå til forrige forskel',
	'NextEdit'					=> 'Gå til næste forskel',

	'Diff'						=> 'forskel',
	'PreviousVersion'			=> 'Ældre version',
	'LatestVersion'				=> 'Nuværende version',
	'NextVersion'				=> 'Nyere version',

	'ShowDifferencesButton'		=> 'Vis ændringer',
	'CancelReturnButton'		=> 'Tilbage til noden / Fortryd',
	'Comparison'				=> 'Sammenligning for %1',
	'RevisionAsOf'				=> 'Version %1 i',
	'SimpleDiffAdditions'		=> 'Tilføjelser:',
	'SimpleDiffDeletions'		=> 'Sletninger:',
	'NoDifferences'				=> 'Ingen forskelle.',
	'ReEditOldRevision'			=> 'Genrediger denne gamle version',

	'ExternalPages'				=> 'Eksterne sider som linker til %1 (%2) (<a href="%3">se liste over domæner</a>):',
	'ExternalPagesGlobal'		=> 'Netsteder som linker til denne WackoWiki (%2) (<a href="%1">se liste over domæner</a>):',
	'Last24Hours'				=> 'seneste 24 timer',
	'LastDays'					=> 'seneste %1 dage',
	'DomainsSitesPages'			=> 'Domæner/netsteder som linker til  %1 (%2)  (<a href="%3">se liste over forskellige URLer</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domains/sites linking to this WackoWiki (<a href="%1">see list of different URLs</a>):',
	'ViewReferrersPage'			=> 'til side',
	'ViewReferrersPerPage'		=> 'per side',
	'ViewReferrersByTime'		=> 'efter tid',
	'ViewReferrersGlobal'		=> 'alle',
	'NoneReferrers'				=> 'Ingen',
	'NotOwnerCantDelete'		=> 'Du ejer ikke denne side og kan ikke slette den.',

	// remove
	'RemovePage'				=> 'Fjern side',
	'RemoveRevision'			=> 'Fjern revision',
	'RemoveComment'				=> 'Slet kommentar',
	'RemoveCluster'				=> 'Remove all pages of the cluster',
	'RemoveDontKeep'			=> 'Do not save a copy of a removed page and comments',
	'RemoveDontKeepRevision'	=> 'Gem ikke en kopi af den fjernede revision',
	'RemoveDontKeepComment'		=> 'Gem ikke en kopi af den fjernede kommentar',
	'RemoveDontKeepFile'		=> 'Gem ikke en kopi af den fjernede fil',
	'ReferrersRemoved'			=> 'Links til er fjernet.',
	'LinksRemoved'				=> 'Links fra siden fjernet.',
	'CategoriesRemoved'			=> 'Sider kategorier slettet.',
	'RatingRemoved'				=> 'Rating removed.',
	'AclsRemoved'				=> 'Sidetilladelser for fjernet.',
	'BookmarksRemoved'			=> 'Bookmarks from page removed.',
	'WatchesRemoved'			=> 'Watches from page removed.',
	'CommentsRemoved'			=> 'Comments from page removed.',
	'FilesRemoved'				=> 'Files from page removed.',
	'PageRemoved'				=> 'Siden fjernet.',
	'PageCachePurged'			=> 'Cache renset.',
	'ClusterRemoved'			=> 'All pages of the cluster removed.',
	'RevisionRemoved'			=> 'Revision %1 fjernet.',
	'RevisionsRemoved'			=> 'Revisions from page fjernet.',
	'ActionHaveNoUndo'			=> 'Denne handling kan du ikke fortryde!',

	// restore
	'PageRestored'				=> 'Side gendannet.',
	'RevisionRestored'			=> 'Revision gendannet.',
	'LocalFilesRestored'		=> 'Lokale filer gendannet.',

	'PrintVersion'				=> 'Udskrivningsversion',
	'PrintText'					=> 'Udskrivning',
	'LinkedPages'				=> 'Koblede sider:',
	'NoLinkedPages'				=> 'Der er ingen linkede sider',
	'ReferringPages'			=> 'Henvisningssider:',
	'NoReferringPages'			=> 'Der er ingen henvisninger.',
	'Footnotes'					=> 'Fodnoter:',
	'Footnote'					=> 'Fodnote',
	'MostPopularPages'			=> 'Mest populære sider',
	'MostCommentedPages'		=> 'Mest kommenterede sider',
	'NoAccessToSourcePage'		=> 'Du har ikke tilladelse til at se denne side.',
	'SourcePageDoesntExist'		=> 'Sidekilde findes ikke.',
	'NotLoggedInThusEdited'		=> 'Du er ikke logget ind, så vi kan ikke vise dine sider/ændringer.',
	'DidntEditAnyPage'			=> 'Du har endnu ikke redigeret nogle sider.',
	'NoPagesFound'				=> 'Fandt ingen sider.',
	'MyChangesTitle1'			=> 'Her er de sider du har redigeret',
	'MyChangesTitle2'			=> 'Her er de sider du har redigeret',
	'OrderABC'					=> 'sorter alfabetisk',
	'OrderDate'					=> 'sorter kronologisk',
	'OrderChange'				=> 'sorter efter ændringer',
	'ListOwnedPages'			=> 'Her er de sider som du ejer (alfabetisk)',
	'ListOwnedPages2'			=> 'Her er de sider som du ejer (kronologisk)',
	'ListOwnedPages3'			=> 'Her er de sider som du ejer (opdateringer)',
	'NotLoggedInThusOwned'		=> 'Du er ikke logget ind, og derfor kan vi ikke finde dine sider!.',
	'NoOrphaned'				=> 'Ingen forældreløse sider. Godt!',
	'NoRecentComments'			=> 'Ingen nylige kommentarer.',
	'LatestCommentBy'			=> 'seneste kommentar af ',
	'NoRecentlyCommented'		=> 'Ingen sider med nye kommentarer.',
	'NoDeletedPages'			=> 'No deleted pages found.',
	'NoDeletedRevisions'		=> 'Ingen slettede revisioner fundet.',
	'NoDeletedFiles'			=> 'No deleted files found.',
	'CommentsDisabled'			=> 'Kommentarer er ikke tilgængelige.',

	'SearchResults'				=> 'Søgeresultater for ',
	'NotFound'					=> 'ikke fundet',
	'NoResultsFor'				=> 'Ingen resultater for ',
	'SearchFor'					=> 'Søg efter:',
	'TopicSearchResults'		=> 'Emnesøgning for ',
	'NotFoundInTopics'			=> 'ikke fundet blandt emnerne',
	'FilterLangNotAvailable'	=> 'Det valgte sprog er ikke tilgængeligt!',

	'PostedBy'					=> 'Indsendt af',
	'ThisIsCommentOn'			=> 'Dette er en kommentar til',
	'At'						=> 'at',
	'To'						=> 'to',
	'By'						=> 'af',
	'From'						=> 'fra',
	'For'						=> 'for',
	'ReturnToCommented'			=> 'Tilbage til kommenteret side',
	'AbandonedComment'			=> 'Den side, denne kommentar tilhører, findes ikke længere!',

	'PagesLinkingTo'			=> 'Sider som linker til',
	'NoPageLinkingTo'			=> 'Ingen sider linker til',
	'NoWantedPages'				=> 'Ingen eftersøgte sider. Godt!',
	'RemoveWatch'				=> 'Fjern overvågning af denne side',
	'SetWatch'					=> 'Overvåg denne side',
	'WatchText'					=> 'Overvåg',
	'UnwatchText'				=> 'Not follow',
	'UserSettingsStored'		=> 'Brugeropsætningen gemt!',
	'LoggedOut'					=> 'Du er nu logget ud.',
	'LoggedOutAuto'				=> 'For sikkerhed er din session afsluttet. Log venligst ind igen.',

	// user settings
	'EmailConfirmResent'		=> 'Repeated email confirmation code sent to your address.',
	'EmailConfirmNotSent'		=> 'Unable to send the confirmation code: email is not specified!',
	'Hello'						=> 'Hej',
	'UserName'					=> 'Brugernavn',
	'EmailAddress'				=> 'Din emailadresse',
	'RealName'					=> 'Real name',
	'MenuItemsShown'			=> 'Menu items shown',
	'RecordsPerPage'			=> 'Registreringer per side',
	'DoShowComments'			=> 'Vis kommentarer',
	'DoubleclickEditing'		=> 'Doubleclick redigering',
	'UpdateSettingsButton'		=> 'Gem opsætningen',

	'AccountDisabled'			=> 'Din konto er måske deaktiveret.',
	'WrongPassword'				=> 'Forkert password!',
	'ConfirmPassword'			=> 'Bekræft password',
	'Email'						=> 'Emailadresse',
	'MustBeWikiName'			=> 'Brugernavn skal være <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiNavn</a> formateret!',
	'SpecifyEmail'				=> 'Du skal oplyse en emailadresse.',
	'NotAEmail'					=> 'Det ligner ikke en rigtig adresse.',
	'EmailTaken'				=> 'Den indtastede emailadresse er allerede i brug.',
	'EmailDomainNotAllowed'		=> 'The entered email address %1 is not in allowed domains list.',
	'PasswordsDidntMatch'		=> 'Passwords stemmer ikke.',
	'SpacesArentAllowed'		=> 'Ingen mellemrum!',
	'ListMyPages'				=> 'Liste dine sider',
	'ListMyChanges'				=> 'Liste dine ændringer',
	'ListMyWatches'				=> 'Liste over overvågede sider',
	'ListMyChangesWatches'		=> 'Ændringer blandt overvågede sider',
	'SeeListOfPages'			=> 'Se en oversigt over sider du ejer (MyPages) og sider du har ændret (MyChanges).',
	'AddBookmark'				=> 'Tilføj til HurtigLinks',
	'RemoveBookmark'			=> 'Fjern fra bookmarks',

	'YourLanguage'				=> 'Vælg sprog',
	'ShowSpaces'				=> 'Vis mellemrum i WikiNavne',
	'WrongPage4Redirect'		=> 'Hov, den kan vi ikke finde',
	'RedirectsToItself'			=> 'Webstedet omdirigerer til sig selv.',
	'ReallyDeletePage'			=> 'Er du sikker på at du vil SLETTE siden?<br>Der er ingen fortrydelsesret!<br><br>ADVARSEL: Alle versioner af siden slettes.',
	'CommentForWatchedPage'		=> 'Nye kommentarer til siden ',
	'SomeoneCommented'			=> ' kommenterer en side du overvåger: ',
	'AlertReferringPages'		=> 'Følgende sider henviser til denne',

	'AccountDelete'				=> 'Slet konto',
	'AccountDeleteConfirm'		=> 'Er du sikker på, du vil slette denne konto?',
	'AccountDeleted'			=> 'Kontoen er nu slettet',
	'AccountDeleteHeader'		=> 'Slet konto %1',
	'AccountDeleteInfo'			=> 'I videst muligt omfang bliver brugergenereret data (f.eks e-mails, præferencer, vedhæftede filer, wiki-bidrag m.m.) slettet. Bemærk dog, at data, såsom vedhæftede filer og bidrag til wiki, ikke kan slettes uden at påvirke andre brugeres arbejde. Sådanne data bliver som følge heraf hensat på en særlig konto kaldet %1. Da data fra alle slettede brugerkonti overflyttes til denne konto, vil det ikke være muligt at skelne mellem data oprettet af den ene eller den anden, slettede bruger(-konto).',
	'AccountDeleteWarning'		=> 'Sletning af kontoen er en uigenkaldelig handling.',
	'AccountDeleteHint'			=> 'Din konto vil blive slettet fra systemet. Derfor vil du ikke længere kunne logge ind med dine nuværende oplysninger. Du vil dog kunne blive bruger af denne app igen med en ny registrering.',
	'AccountDeleteVerify'		=> 'Enter your login %1 to verify the deletion. Once submitted, you will be asked to confirm your password.',

	'MarkRead'					=> 'Markér alle som læst',
	'CurrentTime'				=> 'current time',
	'Created'					=> 'oprettede',
	'Modified'					=> 'ændret',

	'EditIcon'					=> 'ret',
	'TreeClusterTitle'			=> 'Træ for området %1',
	'TreeSiteTitle'				=> 'Træ for ',
	'TreeEmpty'					=> '%1 har ingen undersider',
	'TreeEmptyLevels'			=> '%1 has not subpages for given levels of depth. Increase the value for depth.',
	'TreeTooBig'				=> 'for mange delsider',

	// clone handler
	'ClonePage'					=> 'Klon side',
	'CloneText'					=> 'Klon',
	'CloneName'					=> 'Indtast et nyt navn for en klon denne side',
	'CloneButton'				=> 'Klon',
	'PageCloned'				=> 'Side %1 klonet.',
	'ClonedFrom'				=> 'Cloned from %1.',
	'MassClone'					=> 'Clone entire cluster',
	'MassCloning'				=> 'Cloning cluster.',
	'CloneCannotRead'			=> 'Unreadable page %1.',
	'CloneCannotCreate'			=> 'Uncreatable page %1.',

	'SortComment'				=> 'Sorter kommentar ved',
	'SortCommentAsc'			=> 'Nyeste på bunden',
	'SortCommentDesc'			=> 'Seneste på toppen',

	'RenamePage'				=> 'Omdøb side',
	'RenameText'				=> 'Omdøb',
	'RenameTip'					=> 'Omdøb side',
	'NewName'					=> 'Skriv nyt navn for siden',
	'AlreadyExists'				=> 'Siden %1 findes allerede.',
	'AlreadyNamed'				=> 'Siden hedder allerede %1.',
	'PageRenamed'				=> 'Siden omdøbt.',
	'NewNameOfPage'				=> 'Nyt navn til denne side: ',
	'NotOwnerCantRename'		=> 'Du ejer ikke siden og kan ikke omdøbe den',
	'NeedRedirect'				=> 'Lav automatisk omstilling for siden',
	'RedirectCreated'			=> 'Siden %1 omstiller den den nye',

	'UserSettings'				=> 'Brugerindstillinger',
	'UserSettingsGeneral'		=> 'General',
	'UserSettingsNotifications'	=> 'Underretninger',

	'NotifyMinorEdit'			=> 'Notify also minor edit',
	'NotifyPageEdit'			=> 'Redigere',
	'NotifyComment'				=> 'Kommentar',
	'NotifyOff'					=> 'Af',
	'NotifyAlways'				=> 'Altid',
	'NotifyPending'				=> 'Verserende',
	'NotifyDigest'				=> 'Digest',
	'NotifyPendingPageTip'		=> 'Only one notification is sent for the first page change of a page you are watching.',
	'NotifyPendingCommentTip'	=> 'Only one notification is sent for the first comment to a page you are watching.',
	'NotifyPendingTip'			=> 'Notification is automatically re-enabled when you visit the current version of the page.',

	'FurtherPending'			=> 'There will be no other notifications in case of further changes unless you visit this page.',

	'UserSettingsEmailMe'		=> 'Email me when ...',

	'UserSettingsExtended'		=> 'Udvidet',
	'UserSettingsOther'			=> 'Andre indstillinger',
	'UserSpace'					=> 'Bruger plads',
	'ChooseTheme'				=> 'Vælg tema',

	'CreatePage'				=> 'Opret denne side',
	'CreateNewPage'				=> 'Opret en ny side',
	'CreateNewPageText'			=> 'Opret',
	'CreateNewPageTip'			=> 'Opret en ny side.',

	'CreateRandomPage'			=> 'Opret en tilfældig side:',
	'CreateSubPage'				=> 'Create a sub page in the cluster:',
	'CreatePageParentCluster'	=> 'Create a page in the parent cluster:',
	'CreatePageDenied'			=> 'Du har ikke de nødvendige adgangsrettigheder.',
	'CreatePageDeniedAddress'	=> 'Du har ikke ret til at oprette siden på denne adresse.',
	'PageAlreadyExists'			=> 'I henhold til den angivne adresse findes siden %1 allerede.',
	'PageAlreadyExistsEdit'		=> 'Do you want %1 it?',
	'PageAlreadyExistsEdit2'	=> 'ret',
	'PageAlreadyExistsEditDenied'	=> 'Du kan ikke redigere det.',

	'SimilarPagesExists'		=> 'Lignende sider til% 1 findes allerede:',
	'SimilarPagesHint'			=> 'Der findes eksisterende lignende sider til %1:',

	'PageReservedWord'			=> 'Du kan ikke bruge %1 som en del af adressen, da det er et reserveret ord.',
	'UserReservedWord'			=> 'Brugernavne kan ikke indeholde %1 da det er et reserveret ord.',

	'DontRedirect'				=> 'Tillad ikke viderestilling ved handlingen Viderestil.',
	'SendWatchEmail'			=> 'Send notifikationsmail når nogen ændrer en side du overvåger.',
	'AllowIntercom'				=> 'Jeg ønsker at modtage masse-emails afsendt fra administratorer',
	'AllowMassemail'			=> 'Administrators can email me information',
	'HideLastSession'			=> 'Skjul sidste session',
	'ValidateIP'				=> 'Tying session to IP',
	'AnonymousPub'				=> 'Preferably, published anonymously (to hide the name)',
	'PageMoved'					=> 'Denne side er flyttet. Du kan finde den på',
	'RedirectedFrom'			=> 'Omdirigeret fra %1',
	'RedirectedTo'				=> 'Omdirigeret til',
	'CurrentPassword'			=> 'Nuværende password',
	'NewPassword'				=> 'Nyt password',
	'YouWantChangePassword'		=> 'Skift password',
	'ChangePasswordButton'		=> 'Skift password',
	'PasswordChanged'			=> 'Password ændret',
	'EmailWelcome'				=> 'Du blev registreret den ',
	'EmailRegistered'			=> 'Du er nu registreret i %1.' . "\n" . 'Dit brugernavn: %2' . "\n\n",
	'EmailVerify'				=> 'Hvis du vil modtage notifikationer, skal du godkende din mail. Følg ' . "\n" . '%1' . "\n" . 'dette link for at godkende din mail.',
	'EmailRegisteredLogin'		=> 'Gå tilbage til Wiki og log ind med dit nye brugernavn og adgangskode.',
	'EmailRegisteredIgnore'		=> 'Hvis du ikke har prøvet at registrere dig skal du bare se bort fra denne meddelelse og ingenting vil ske.',
	'EmailDoNotReply'			=> 'SVAR IKKE PÅ DENNE MEDDELELSE',
	'EmailReverify'				=> 'Du er nu registreret i %1.' . "\n" . 'Dit brugernavn: %2' . "\n\n" . 'Hvis du vil modtage notifikationer, skal du godkende din mail. Følg ' . "\n" . '%3' . "\n" . 'dette link for at godkende din mail.' . "\n\n",
	'EmailConfirm'				=> 'Bekræft din mail',
	'EmailConfirmed'			=> 'Din mail er bekræftet.',
	'EmailNotConfirmed'			=> 'Kan ikke bekræfte din mail. This may be due to an incorrect confirmation code or the email address may already be confirmed. You can check if the email address is already confirmed by logging in and viewing its status on your %1 page.',
	'EmailNotVerified'			=> 'Email ikke verificeret!',
	'EmailNotVerifiedDesc'		=> 'You will not receive notification of changes or comments of watched pages, ' .
									'messages from other users, as well you <strong>will not be able to recover a forgotten password</strong>, ' .
									'until your email-address was confirmed, by following the link in the email sent to you. ' .
									'If, within days after registration You never got a email, ask for it again by clicking ',

	'ForgotPasswordHint'		=> 'Oplys dit brugernavn og din emailadresse,' . "\n" . 'så sender vi en mail med instruktioner.',
	'ForgotPassword'			=> 'Glemt password?',
	'UserNotFound'				=> 'Ingen bruger med disse oplysninger.',
	'NotConfirmedEmail'			=> 'Din mailadresse er ikke bekræftet.<br>Vi kan derfor ikke sende dig en mail.',
	'EmailForgotSubject'		=> 'Password opdatering for ',
	'EmailForgotMessage'		=> 'Dette er en reminder om password for %1.' . "\n" . 'Dit brugerlogin: %2'."\n\n" . 'Følg dette link: ' . "\n" . '%3' . "\n\n",
	'CodeWasSent'				=> 'Password instruktioner sendt til din mail.',
	'WrongCode'					=> 'Forkert kode',
	'ChangePasswordForUser'		=> '%1\'s password opdatering',

	'Watchers'					=> 'Abonnenter til %1',
	'WatchersFor'				=> 'Abonnenter til',
	'NoWatchers'				=> 'Ingen abonnenter til %1',
	'NotOwnerToViewWatchers'	=> 'Du har ikke adgang til denne information.',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Generer kodeordets hash for dit <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Importer til dette område:',
	'ImportWhat'				=> 'XML-fil til import:',
	'ImportButton'				=> 'Importer',
	'ImportSuccess'				=> 'Importen lykkedes.',
	'ImportFailed'				=> 'Import mislykkedes.',
	'ImportHint'				=> 'Angiv en klynge, du vil importere til, uden relativ adressering.',
	'ImportAttention'			=> 'OBS: Overskriver de samme sider i klyngen.',
	'ImportNote'				=> 'Imported page',

	// mywatches action
	'WatchedPages'				=> 'List of all pages you follow for changes ',
	'UnwatchedPages'			=> 'List of all pages you do not watch',
	'NoWatchedPages'			=> 'You have no watched pages.',
	'NoUnwatchedPages'			=> 'You watch for changes in all pages.',
	'ViewWatchedPages'			=> 'Show watched pages',
	'ViewUnwatchedPages'		=> 'Show unwatched page',
	'NotLoggedInWatches'		=> 'You are not logged in, hence we couldn\'t identify so your list of watches.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'List of all pages you watched that were edited by others since your last editing',
	'ResetChangesWatches'		=> 'reset the list of changes',
	'NoChangesWatches'			=> 'Among your watched pages are no changes...',

	// whatsnew action
	'NewCommentAdded'			=> 'Tilføjet ny kommentar',
	'NewFileAdded'				=> 'Tilføjet ny fil',
	'NewPageCreated'			=> 'Oprettet en ny side',
	'NewRevisionAdded'			=> 'Ændret side',
	'Cluster'					=> 'cluster',
	'PageDeleted'				=> 'Side slettet',
	'CommentDeleted'			=> 'Kommentar slettet',
	'FileDeleted'				=> 'Fil slettet',

	// users action
	'UsersSearch'				=> 'Find brugere',
	'UsersOpenProfile'			=> 'Se profil',
	'UsersNoMatching'			=> 'Matching users not found. Try a softer search criteria.',
	'UsersName'					=> 'Navn',
	'UsersPages'				=> 'Sider',
	'UsersChanges'				=> 'Ændringer',
	'UsersSubscription'			=> 'Abonnement',
	'UsersWatches'				=> 'Watches',
	'UsersComments'				=> 'Kommentarer',
	'UsersUploads'				=> 'Uploads',
	'UploadQuota'				=> 'Brugt plads',
	'UploadQuotaTip'			=> 'Upload Space Quota',
	'UsersLogins'				=> 'Logins',
	'UsersRevisions'			=> 'Revisioner',
	'UsersSignup'				=> 'Tilmelde',
	'UsersLastSession'			=> 'Last session',
	'UsersNotFound'				=> 'User %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'UsersProfile'				=> 'Profil',
	'UsersContact'				=> 'Kontakt',
	'UsersList'					=> 'Se hele listen over brugere',
	'UsersNA'					=> '[ikke indstillet]',
	'UsersNA2'					=> '[No]',
	'UsersSignupDate'			=> 'Signup date',
	'UsersGroupMembership'		=> 'Gruppemedlemskab',
	'UsersPersonalInfo'			=> 'Personlig information',
	'UsersOwnedPages'			=> 'Ejede sider:',
	'UsersCommentsPosted'		=> 'Kommentarer indsendt:',
	'UsersFilesUploaded'		=> 'Filer uploadet:',
	'UsersRevisionsMade'		=> 'Revisioner foretaget:',
	'UsersDocsSortName'			=> '[Sorter efter navn]',
	'UsersDocsSortDate'			=> '[Sorter efter oprettelsesdato]',
	'UsersChangesSortAsc'		=> '[Sortér stigende]',
	'UsersChangesSortDesc'		=> '[Sortér faldende]',
	'UsersSessionNA'			=> '[ikke optaget]',
	'UsersSessionHidden'		=> '[skjult]',
	'IntercomSubject'			=> 'Emne:',
	'IntercomMessage'			=> 'Besked:',
	'IntercomCopy'				=> 'Send mig en kopi',
	'IntercomSubjectN'			=> '[Start et nyt emne]',
	'IntercomDisabled'			=> 'Beklager, du ønsker ikke eller kan ikke modtage personlige beskeder.',
	'IntercomHint'				=> 'Du skal først logge ind og følge linket igen, hvis du vil svare på den personlige besked, du har modtaget.',
	'IntercomDesc'				=> 'Bemærk: At sende personlige beskeder til modtagerens e-mailadresse uden at oplyse din adresse. Modtageren har mulighed for at svare dig ved hjælp af den samme formular på din profilside. ',
	'PMOversized'				=> 'Længden på meddelelsen overstiger den maksimale størrelse med %1. Forkort din besked, og send den igen.',
	'PMFlooded'					=> 'Intervallet mellem afsendelse af personlige meddelelser bør ikke være mindre end %1 sekunder.',
	'PMSent'					=> 'Den personlige meddelelse er blevet sendt til brugeren.',
	'PMBody'					=> 'Denne meddelelse er blevet sendt til dig af brugeren %1.',
	'PMBodyCopy'				=> 'Du har sendt følgende besked til brugeren %1.',
	'PMReply'					=> 'Hvis du vil besvare denne e-mail, skal du klikke på følgende link (du må ikke bruge \'Svar\'-knappen i dit mailprogram):',
	'PMNotLoggedIn'				=> 'Du er ikke logget ind på systemet og kan ikke sende nogen personlige beskeder til brugerne.',

	// admin_replace action
	'ReplaceText'				=> 'Udskift tekst',
	'TextOriginal'				=> 'Oprindelig tekst:',
	'TextReplacement'			=> 'Erstatningstekst:',
	'ReplaceTextRegex'			=> 'Brug regulære udtryk',
	'Namespace'					=> 'Navnerum:',
	'ReplaceTextCluster'		=> 'Søg og erstat kun inden for denne klynge:',
	'ReplaceTextEditPages'		=> 'Udskiftning af tekst i sidens indhold',
	'ReplaceTextEditComments'	=> 'Udskiftning af tekst i kommentarer',
	'ReplaceTextEditTitles'		=> 'Udskiftning af tekst i sidetitler',
	'ReplaceTextGiveTarget'		=> 'Du skal angive den streng, der skal erstattes.',
	'ReplaceTextNoNamespace'	=> 'Du skal vælge mindst ét navnerum.',
	'ReplaceTextNoDifference'	=> 'Der er ingen forskel mellem erstatte tekst og måltekst.',
	'ReplaceTextNoOption'		=> 'Du skal vælge mindst en af erstatningsmulighederne.',
	'ReplaceTextPagesEdit'		=> 'Udskift %1 med %2 i teksten på følgende %3 sider:',
	"ReplaceTextTitlesEdit"		=> 'Udskift %1 med %2 i titlerne på følgende %3 sider: ',
	'ReplaceTextReplace'		=> 'Udskift',
	'ReplaceTextSuccess'		=> '%1 er blevet erstattet med %2 på %3 sider.',
	'ReplaceTextNoMatch'		=> 'Der blev ikke fundet nogen sider, der indeholder strengen %1.',
	'ReplaceTextNoTitleMatch'	=> 'Der blev ikke fundet nogen sider, hvis titel indeholder %1.',
	'ReplaceTextEditFailed'		=> 'Erstatning af tekst mislykkedes',
	'ReplaceTextTitleTooBig'	=> 'Original- eller erstatningsteksten er for stor til titlen.',
	'ReplaceTextReturn'			=> 'Tilbage til formularen',
	'ReplaceTextWarning'		=> 'Advarsel: Der er %1 sider, der allerede indeholder erstatningsstrengen %2. Hvis du foretager denne erstatning, kan du ikke adskille dine erstatninger fra disse strenge.',
	'ReplaceTextBlankWarning'	=> 'Advarsel: Da erstatningsstrengen er tom, kan denne operation ikke omgøres.',
	'ReplaceTextEditSummary'	=> 'Erstatning af tekst: %1 → %2',
	'InvertSelection'			=> 'Omvendt valg',

	// rating handler
	'RatingDenied'				=> 'You can not rate this page.',
	'RatingSuccess'				=> 'Thank you for your evaluation',
	'RatingDuplicate'			=> 'You have already rated this page.',
	'RatingHeader'				=> 'Rate this page',
	'RatingHeaderResults'		=> 'Overall page rating',
	'RatingResults'				=> 'show results',
	'RatingForm'				=> 'show form',
	'RatingVoters'				=> 'Voters',
	'RatingTotal'				=> 'Average rating',
	'RatingNotRated'			=> 'Page not yet rated',
	'RatingTopPages'			=> 'Best readers rated pages',
	'RatingBottomPages'			=> 'Worst readers rated pages',
	'RatingNoPagesRated'		=> 'are none',

	// Properties
	'PropertiesFor'				=> 'Indstillinger for %1',
	'MetaTag'					=> 'Tag',
	'MetaTitle'					=> 'Titel',
	'MetaKeywords'				=> 'Nøgleord',
	'MetaDescription'			=> 'Meta Description (beskrivelse)',
	'On'						=> 'På',
	'Off'						=> 'Af',
	'Registered'				=> 'Registrerede',
	'MetaComments'				=> 'Vis kommentarer',
	'MetaFiles'					=> 'Vis filer panel',
	'MetaRating'				=> 'Vis bedømmelsespanel',
	'MetaToc'					=> 'Vis indholdsfortegnelse',
	'MetaIndex'					=> 'Show cluster section panel',
	'MetaIndexMode'				=> 'Show Level Mode',
	'MetaIndexFull'				=> 'Tree',
	'MetaIndexUpper'			=> 'Upper',
	'MetaIndexLower'			=> 'Lower',
	'MetaHtml'					=> 'HTML-support til side',
	'MetaSafeHtml'				=> 'Filtrering af usikre HTML',
	'MetaNoIndex'				=> 'Bloker søgemaskiner',
	'SettingsID'				=> 'Side ID',
	'SettingsSize'				=> 'Størrelse',
	'SettingsSizeTip'			=> 'source / compiled',
	'SettingsCreated'			=> 'Oprettede',
	'SettingsCurrent'			=> 'Ændret',
	'SettingsTotalRevs'			=> 'Revisioner',
	'SettingsTotalComs'			=> 'Kommentarer',
	'SettingsWatchers'			=> 'Watchers',
	'SettingsHits'				=> 'Visninger',
	'SettingsRating'			=> 'Readers rating',
	'SettingsText'				=> 'Indstillinger',
	'SettingsEdit'				=> 'Rediger',
	'SettingsRevisions'			=> 'Versioner',
	'SettingsClone'				=> 'Klon',
	'SettingsRename'			=> 'Omdøb',
	'MassRename'				=> 'for hele området',
	'SettingsRemove'			=> 'Slet',
	'SettingsPurge'				=> 'Rense',
	'SettingsModerate'			=> 'Moderat',
	'SettingsPermissions'		=> 'Tilladelser',
	'AclForEntireCluster'		=> 'for hele området',
	'SettingsAttachments'		=> 'Vedhæftede filer',
	'SettingsUpload'			=> 'Fortsæt',
	'SettingsCategories'		=> 'Kategorier',
	'SettingsLanguages'			=> 'Languages',
	'SettingsReferrers'			=> 'Henvisninger',
	'SettingsWatch'				=> 'Overvåg',
	'SettingsLatex'				=> 'LaTeX version',
	'SettingsXML'				=> 'Export to XML',
	'NeedToChangeLang'			=> 'Unsupported page language %1 needs to be changed.',
	'SetLang'					=> 'Sidens sprog',
	'SetMenuLabel'				=> 'Menu label',
	'SetShowMenuLabel'			=> 'Show in navigation',

	// upload
	'UploadFiles'				=> 'Upload filer',
	'UploadFor'					=> 'Filupload:',
	'UploadButton'				=> 'Fortsæt',
	'UploadGlobalText'			=> 'for alle',
	'UploadGlobal'				=> 'global',
	'UploadLocalText'			=> 'brugere som må se denne side',
	'UploadAsName'				=> 'Indtast wikinavn (valgfrit):',
	'UploadOverwrite'			=> 'Overskriv eksisterende filer',
	'FileDesc'					=> 'Beskrivelse:',
	'UploadForbidden'			=> 'Du må ikke uploade filer her.',
	'UploadOverwriteDenied'		=> 'Kun filens ejer eller administrator kan overskrive %1-filen.',
	'UploadNoFile'				=> 'Hmmm, der var ikke nogen fil.',
	'UploadMaxSizeReached'		=> 'Filen er for stor!',
	'UploadDirNotWritable'		=> 'Filmappen kan ikke skrives!',
	'UploadNotAPicture'			=> 'Kan desværre ikke genkende filformatet, og kan derfor ikke tillade upload',
	'UploadEmptyExtension'		=> 'Filnavnet og også udvidelsen kan ikke være tomme.',
	'FilenameTooLong'			=> 'Filnavne må ikke være længere end 240 bytes.',
	'BannedFiletype'			=> '%1 er en uønsket filtype.',
	'PermittedFiletype'			=> 'Tilladte filtyper: %1.',
	'UploadMimeMismatch'		=> 'Filendelsen %1 svarer ikke til filens MIME-type (%2).',
	'UploadBadMime'				=> 'Filer med MIME-typen %1 må ikke uploades.',
	'FileIsDuplicate'			=> 'Uploaden er en nøjagtig kopi af den aktuelle version.',
	'FileHasDuplicate'			=> 'Denne fil er en dublet af de nedenstående filer:',

	'UploadMaxFileQuota'		=> 'Sikke mange filer du uploader. Snak med administrator.',
	'UploadDone'				=> 'Filupload lykkedes',
	'UploadFileForbidden'		=> 'Filadgang nægtet',
	'UploadTitle'				=> 'Filer relateret til denne side',
	'UploadTitleGlobal'			=> 'Filer med global adgang',

	'UploadFile'				=> 'Fortsæt',
	'UploadMax'					=> 'Højst ',
	'UploadUsedStorage'			=> 'Storage in use ',

	// attachments
	'Attachments'				=> 'Vedhæftede filer',
	'Attachment'				=> 'Vedhæftet fil',
	'AttachmentsToPage'			=> 'Til side',
	'AttachmentsToCluster'		=> 'cluster',
	'AttachmentsByTime'			=> 'efter tid',
	'AttachmentsGlobal'			=> 'global',
	'AttachmentsAll'			=> 'alle',
	'AttachmentsLinked'			=> 'brugt',

	'FileViewProperties'		=> 'Udsigt',
	'FileViewPropertiesTip'		=> 'Se metadataene for denne fil',
	'FileEditProperties'		=> 'redigere',
	'FileEditPropertiesTip'		=> 'Rediger metadataene for denne fil',
	'FileEditedMeta'			=> 'Opdateret metadata af denne fil',
	'FileEditDenied'			=> 'Du har ikke lov til at redigere denne fil',
	'FileLabel'					=> 'Label',
	'FileLabelTip'				=> 'Label this file',
	'FileRemove'				=> 'slet',
	'FileRemovedFromDB'			=> 'Filen er nu slettet',
	'FileRemovedFromFS'			=> 'Filen er fjernet',
	'FileRemovedFromFSError'	=> 'Der er problemer med at slette filen.!',
	'FileRemoveConfirm'			=> 'Er du sikker på, at du vil slette filen?',
	'FileRemoveDenied'			=> 'Du har ikke tilladelse til at slette filen',
	'FileNotFound'				=> 'Ingen fil',

	'FileSearch'				=> 'Find fil:',
	'UploadBy'					=> 'Uploadet af:',
	'FileAdded'					=> 'Lagt:',
	'FileModified'				=> 'Ændret:',
	'FileSize'					=> 'Størrelse:',
	'FileDimension'				=> 'Dimensioner:',
	'MimeType'					=> 'MIME-Type:',
	'FileName'					=> 'Navn:',
	'FileCaption'				=> 'Billedtekst:',
	'FileAuthor'				=> 'Forfatter:',
	'FileSource'				=> 'Kilde:',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> 'Fastgjort til:',
	'FileSyntax'				=> 'Syntaks:',
	'FileAbsolutePath'			=> 'absolut sti',
	'FileRelativePath'			=> 'relativ sti',
	'FileUsage'					=> 'Filanvendelse:',
	'FileUsageText'				=> 'De følgende sider henviser til denne fil:',
	'NoFileUsage'				=> 'Der er ingen sider der henviser til denne fil.',

	'FileSortExt'				=> 'extension',
	'FileSortName'				=> 'name',
	'FileSortSize'				=> 'size',
	'FileSortTime'				=> 'created',

	'SortBy'					=> 'Sort by',
	'Ascending'					=> 'ascending',
	'Decending'					=> 'decending',

	'Files0'					=> 'Der er ingen filer tilknyttet denne side.',
	'Files1'					=> 'Der er en fil tilknyttet denne side.',
	'FilesN'					=> 'Der er %1 filer tilknyttet denne side.',
	'Files'						=> 'Filer',
	'File'						=> 'Fil',
	'ShowFiles'					=> 'Vis filer',
	'HideFiles'					=> 'Skjul filer',
	'DoShowFiles'				=> 'Vis altid filer',
	'NoAttachments'				=> 'Der er ingen vedhæftede filer at vise.',

	'RegistrationLang'			=> 'Dit sprog',
	'InvalidWikiName'			=> 'Valgt navn er desværre ikke tilladt',
	'InvalidUserName'			=> 'Valgt navn er desværre ikke tilladt',
	'Bookmarks'					=> 'Bogmærker',
	'ReallyDeleteComment'		=> 'Er du sikker på, at du vil slette kommentaren?',
	'ReallyDeleteRevision'		=> 'Er du sikker på, at du vil slette denne revision?',

	'RegistrationClosed'		=> 'Registrering ikke mulig. Kontakt Administrator.',
	'AclAreYouSure'				=> 'Du ændrer nu adgangstilladelser for denne side og alle dens undersider. Vil du fortsætte?',

	'BookmarkDeleteSelected'	=> 'Slet valgt',
	'BookmarkMark'				=> 'Mærke',
	'BookmarkNumber'			=> 'No.',
	'BookmarkNone'				=> 'Du har ingen bogmærker.',
	'BookmarkTitle'				=> 'Bogmærke Titel',
	'BookmarkPage'				=> 'Side',
	'BookmarkSaveChanges'		=> 'Gem ændringer',
	'BookmarksAddPage'			=> 'Indstil et bogmærke for den følgende side',
	'BookmarkAlreadyExists'		=> 'Bogmærket eksisterer allerede.',

	'PoweredBy'					=> 'Powered by',

	'MassRenaming'				=> 'Omdøb hele området',
	'MassNewName'				=> 'Angiv nyt navn for dette område',
	'MassNeedRedirect'			=> 'Opret henvisning hertil på den gamle side',

	// pagination
	'ToOverview'				=> 'Back to overview',
	'ToThePage'					=> 'Til side:',
	'Next'						=> 'Næste',
	'Prev'						=> 'Forrige',
	'NextAcr'					=> 'Næste',
	'PrevAcr'					=> 'Forrige',
	'Back'						=> 'Tilbage',

	// filter
	'Filter'					=> 'Filtrér',
	'OptionalFilters'			=> 'Valgfrie filtre:',
	'Any'						=> 'Nogen',

	// My Groups
	'UserGroups'				=> 'Brugergrupper',
	'MyGroups'					=> 'Gruppeforeninger',
	'Group'						=> 'gruppe',
	'Groups'					=> 'grupper',

	// license action
	'DistributedUnder'			=> 'Material is distributed under',
	'AuthorsDisplayHint'		=> 'The list of authors will be displayed when saving the page.',
	'AnonymousUsers'			=> 'Anonyme brugere',
	'License'					=> 'Licens',
	'LicenseArray'				=> [
		'1'		=> 'Attribution-NoDerivatives.',
		'2'		=> 'Attribution-NonCommercial-ShareAlike',
		'3'		=> 'Attribution-NonCommercial-NoDerivatives',
		'4'		=> 'Attribution-ShareAlike',
		'5'		=> 'Attribution-NonCommercial',
		'6'		=> 'Attribution',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation License',
		'9'		=> 'Public Domain / Free Use',
		'10'	=> 'All Rights Reserved',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Public domain',
		'2'		=> 'Some rights reserved',
		'3'		=> 'All Rights Reserved',
	],

	// Cache
	'ClearCache'				=> 'Clear cache',
	'CacheCleared'				=> 'Cache cleared.',
	'ConfigCache'				=> 'Config cache',
	'FeedCache'					=> 'Feed cache',
	'PageCache'					=> 'Page cache',
	'SQLCache'					=> 'SQL cache',
	'TemplateCache'				=> 'Template cache',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Angiv adressen på den ressource ved hjælp url parameter. (e.g. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Feed Title',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Please specify a Feed with the Parameter url. (e.g. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Could not load or parse feed',
	'FeedSource'				=> 'Kilde:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Recent changes',
	'ChangesXML'				=> 'Recent changes to the ',
	'CommentsXMLTitle'			=> ' - Recent comments',
	'CommentsXML'				=> 'Recent comments to the ',
	'NewsXMLTitle'				=> ' - Recent news',
	'NewsXML'					=> 'Recent news to the ',
	'RevisionXMLTip'			=> 'Klik for at se seneste sideændringer i XML format.',
	'CommentsXMLTip'			=> 'Click to view recent comments in XML format.',
	'ChangesXMLTip'				=> 'Click to view recent changes in XML format.',
	'NewsXMLTip'				=> 'Click to view recent news in XML format.',
	'RevisionsXML'				=> 'Revisions of ',
	'ExportClusterXML'			=> 'Export of entire cluster of ',
	'AccessDeniedXML'			=> 'Du har ikke adgang til disse oplysninger.',

	'ChangesFeed'				=> 'Ændringer',
	'CommentsFeed'				=> 'Kommentarer',
	'NewsFeed'					=> 'Nyheder',
	'RevisionsFeed'				=> 'Revisions of ',

	'LastModification'			=> 'Sidste ændring',

	// Captcha
	'Captcha'					=> 'Indtast det ord du læser i billedet',
	'CaptchaFailed'				=> 'Du har indtastet captcha ordet forkert. Prøv venligst igen.',
	'CaptchaReload'				=> 'Ny Captcha',
	'CaptchaReloadWarning'		=> 'Beklager, kan ikke genindlæse captcha-billedet, du bliver nødt til at genindlæse siden for at gøre det',

	// news
	'News'						=> 'Nyheder',
	'NewsName'					=> 'Titel:',
	'NewsNoName'				=> 'You forgot to add news headline.',
	'NewsNotAvailable'			=> 'Ingen nyheder til rådighed.',
	'NewsNoClusterDefined'		=> 'No News cluster defined.',
	'NewsDiscuss'				=> 'Diskuter denne artikel...',

	// blog
	'BlogNewTopic'				=> 'Create a new post',
	'NoPostAvailable'			=> 'No post available yet.',

	// Review
	'Reviewer'					=> 'Reviewer',
	'Reviewed'					=> 'reviewed',
	'Review'					=> 'review',
	'ReviewedBy'				=> 'reviewed by',
	'RemoveReview'				=> 'Remove review for this page',
	'SetReview'					=> 'Reviewed this page',
	'SetAsReviewed'				=> 'Set page as reviewed',
	'SetAsUnreviewed'			=> 'Set page as unreviewed',

	// word filter
	'PotentialSpam'				=> 'Identified Potential Spam',

	// moderation handler
	'Moderation'				=> 'Moderation',
	'Topics'					=> 'emner',
	'ModerateSection'			=> 'section / page ',

	'NotModerator'				=> 'You do not have authority to moderate this page / chapter',
	'ModerateDeleteTopic'		=> 'Slet emne / side',
	'ModerateDeletePosts'		=> 'Slet kommentarer',
	'ModerateMove'				=> 'Flyt',
	'ModerateSplit'				=> 'Split / Flyt kommentarer',
	'ModerateMerge'				=> 'Fusionere',
	'ModerateLock'				=> 'Lock',
	'ModerateUnlock'			=> 'Unlock',
	'ModerateAccept'			=> 'Accept',
	'ModerateDeleteConfirm'		=> 'Are you sure you want to <strong>remove</strong> the following topics?',
	'ModerateRenameConfirm'		=> 'Enter a new title for the selected page',
	'ModerateRenameExists'		=> 'Der findes allerede en side med samme navn! Vælg et andet navn.',
	'ModerateRename1Only'		=> 'Note: only the first page you selected will be renamed!',
	'ModerateMovesConfirm'		=> 'Select the target partition to move the forum to',
	'ModerateMoveConfirm'		=> 'Select the forum or specify the cluster to move these topics. To move a page to the root of the site, type &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Specify the name of the cluster, in which to place the page. To move a page to the root of the site, type &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operation aborted: in this section already exists topics with the same name %1. If you still need to transfer the above-mentioned topics, please rename them first.',
	'ModerateMoveNotExists'		=> 'The page / cluster does not exist. Please check the name and try again.',
	'ModerateMergeConfirm'		=> 'Choose a topic, which should combine the remaining',
	'ModerateMerge2Min'			=> 'To join you must select at least two topics!',
	'ModerateComDelConfirm'		=> 'Are you sure you want to <strong>remove</strong> %1 %2?',
	'ModerateComment'			=> 'Kommentar',
	'ModerateComments'			=> 'Kommentarer',
	'ModerateSplitNewName'		=> 'Specify a name for separable topic and select a separation schema',
	'ModerateSplitPageName'		=> 'Enter the name of the page / topic, where to move detachable comments, and select a separation schema',
	'ModerateSplitAllAfter'		=> 'Detach all the comments after the first selected (and including)',
	'ModerateSplitSelected'		=> 'Separated only selected comments (total %1)',
	'ModerateUserProfile'		=> 'profil',
	'ModerateNoItemChosen'		=> 'Please select at least one item via the Set button.',

	'ModerateSection2'			=> 'moderate section',
	'ModerateTopicsDeleted'		=> 'Selected topics successfully deleted.',
	'ModerateTopicsRelocated'	=> 'Selected topics successfully relocated.',
	'ModerateTopicsRenamed'		=> 'Emne med succes omdøbt.',
	'ModerateTopicsMerged'		=> 'Selected topics successfully merged.',
	'ModerateTopicsBlocked'		=> 'Selected topics successfully blocked',
	'ModerateTopicsUnlocked'	=> 'Selected topics successfully unlocked.',
	'ModerateTopicDeleted'		=> 'Emnet er blevet fjernet.',
	'ModeratePageMoved'			=> 'Siden blev flyttet.',
	'ModerateTopicRenamed'		=> 'Emne med succes omdøbt.',
	'ModerateTopicBlocked'		=> 'Emnet blev blokeret.',
	'ModerateTopicUnlocked'		=> 'Topic successfully unlocked.',
	'ModerateCommentsDeleted'	=> 'Udvalgte kommentarer fjernet med succes.',
	'ModerateCommentsSplit'		=> 'Selected comments successfully separated in a new topic.',
	'ModerateCommentsSplitFailed'	=> 'Note: For some reason to separate the selected comments to a new topic failed.<br>Usually this should not happen, so let the incident site administrator.<br>As a precaution, issue has been preserved in its original form.',
	'ModerateCommentsMoved'		=> 'Selected comments successfully migrated to the given page.',

	// forum
	'ForumSubforums'			=> 'Forum',
	'ForumTopic'				=> 'Emne',
	'ForumTopics'				=> 'Emner',
	'ForumPosts'				=> 'Indlæg',
	'ForumReplies'				=> 'Svar',
	'ForumAuthor'				=> 'Forfatter',
	'ForumViews'				=> 'Visninger',
	'ForumCreated'				=> 'Oprettede',
	'ForumComments'				=> 'Kommentarer',
	'ForumLastComment'			=> 'Sidste kommentar',
	'ForumNoComments'			=> 'Ingen kommentarer',
	'ForumNoTopics'				=> 'Der er ingen emner eller indlæg i dette forum.',
	'ForumNewTopic'				=> 'Start en ny diskussion',
	'ForumTopicName'			=> 'Emne navn:',
	'ForumTopicSubmit'			=> 'Indsend emne',
	'ForumNoTopicName'			=> 'Specify a name for the new page.',
	'ForumNewPosts'				=> 'new post',
	'ForumLocked'				=> 'section locked',
	'ForumUpdated'				=> 'opdateret',
	'ForumNoClusterDefined'		=> 'No Forum cluster defined.',
	'ForumOutsideCluster'		=> 'Ensure that the %1 action is located inside the forum cluster.',

	// password complexity
	'PwdCplxShort'				=> 'Adgangskoden er for kort.',
	'PwdCplxEquals'				=> 'Adgangskoden indeholder brugernavnet.',
	'PwdCplxWeak'				=> 'Adgangskode opfylder ikke kompleksitetskrav.',
	'PwdCplxDesc1'				=> 'Krav til adgangskoden: ',
	'PwdCplxDesc2'				=> 'password should not be less than %1 characters',
	'PwdCplxDesc3'				=> 'must not contain your username',
	'PwdCplxDesc4'				=> 'should consist of ',
	'PwdCplxDesc41'				=> 'letters and numbers',
	'PwdCplxDesc42'				=> 'uppercase and lowercase letters and numbers',
	'PwdCplxDesc43'				=> 'uppercase and lowercase letters, digits and non-alphabetic characters',
	'PwdCplxDesc5'				=> 'You can use any letters, numbers and special characters, but gaps.',

	'PasswordTooShort'			=> 'Password for kort.',
	'PasswordTooCommon'			=> 'Den adgangskode er for udbredt.',
	'PasswordSameAsUsername'	=> 'Dit password er det samme som dit brugernavn.',
	'PasswordSameAsEmail'		=> 'Dit password er det samme som din email adresse.',

	// POLLS ADD-ON
	'PollsTopic'				=> 'Emne',
	'PollsVariant'				=> 'Svar',
	'PollsPlural'				=> 'You can select multiple answers',
	'PollsSingular'				=> 'You can select only one answer',
	'PollsAddVariant'			=> 'add option',
	'PollsDelVariant'			=> 'delete option',
	'PollsNeedTopic'			=> 'You did not specify the topic or question for the poll.',
	'PollsNeedAnswers'			=> 'You must specify at least two options.',
	'PollsSubmitted'			=> 'Your poll has been successfully added.',
	'PollsSubmittedMod'			=> 'After confirming the moderator, he will appear in the list of active polls.',
	'PollsCurrent'				=> 'Current polls',
	'PollsModeration'			=> 'Awaiting moderation',
	'PollsEnded'				=> 'Completed surveys',
	'PollsArchiveYear'			=> 'All surveys for %1 year',
	'PollsArchiveAll'			=> 'All polls',
	'PollsConfirmDelete'		=> 'Confirm delete',
	'PollsError'				=> 'Error',
	'PollsStartMod'				=> 'Activate poll',
	'PollsEmptyList'			=> 'Polls List is empty.',
	'PollsNotExists'			=> 'Requested survey does not exist.',
	'PollsAlreadyVoted'			=> 'You have already participated in this survey.',
	'PollsAlreadyEnded'			=> 'This survey has been completed.',
	'PollsDone'					=> 'Thank you for your participation! Your vote is taken.',
	'PollsStop'					=> 'stop',
	'PollsActivate'				=> 'activate',
	'PollsEdit'					=> 'ret',
	'PollsResults'				=> 'results',
	'PollsLasts'				=> 'Poll is (days)',
	'PollsLasted'				=> 'Poll went (days)',
	'PollsAdded'				=> 'Lagt',
	'PollsTotalVotes'			=> 'Total votes',
	'PollsShow'					=> 'Show',
	'PollsAll'					=> 'All',
	'PollsNotifySubj'			=> 'Added a new poll',
	'PollsNotifyBody'			=> 'User %1 added a new poll. To view details, confirm or reject the poll go to this link:',
	'PollsNone'					=> 'No active poll.',

	'Timezone'					=> 'Tidszone',
	'DST'						=> 'Sommertid',
	'TzZoneArray'	=> [
		'-12'	=> '[UTC - 12] Howard- & Baker-øerne',
		'-11'	=> '[UTC - 11] Midway-øerne',
		'-10'	=> '[UTC - 10] Hawaii, Cook-øerne',
		'-9.5'	=> '[UTC - 9:30] Fransk Polynesien',
		'-9'	=> '[UTC - 9] Alaska, Gambier-øerne',
		'-8'	=> '[UTC - 8] Stillehavstid (San Francisco m.fl)',
		'-7'	=> '[UTC - 7] Bjergtid (Salt Lake City m.fl)',
		'-6'	=> '[UTC - 6] Centraltid (Houston, Chicago m.fl)',
		'-5'	=> '[UTC - 5] Østkysttid (New York m.fl)',
		'-4.5'	=> '[UTC - 4:30] Venezuela',
		'-4'	=> '[UTC - 4] Atlanterhavstid (Thule Air Base m.fl)',
		'-3.5'	=> '[UTC - 3:30] Newfoundland',
		'-3'	=> '[UTC - 3] Amazontid, Vestgrønland',
		'-2'	=> '[UTC - 2] Fernando de Noronha & Sydlige Sandwich-øer',
		'-1'	=> '[UTC - 1] Azorerne, Østgrønland',
		'0'		=> '[UTC] Vesteuropa (England, Færøerne m.fl)',
		'1'		=> '[UTC + 1] Centraleuropa & Vestafrika (Danmark m.fl)',
		'2'		=> '[UTC + 2] Østeuropa & Centralafrika',
		'3'		=> '[UTC + 3] Moskva & Østafrika',
		'3.5'	=> '[UTC + 3:30] Iran',
		'4'		=> '[UTC + 4] Golfen & Samara',
		'4.5'	=> '[UTC + 4:30] Afghanistan',
		'5'		=> '[UTC + 5] Vestasien & Jekaterinburg',
		'5.5'	=> '[UTC + 5:30] Indien',
		'5.75'	=> '[UTC + 5:45] Nepal',
		'6'		=> '[UTC + 6] Bangladesh, Bhutan & Omsk',
		'6.5'	=> '[UTC + 6:30] Burma & Coco-øerne',
		'7'		=> '[UTC + 7] Indonesien, Krasnoyarsk',
		'8'		=> '[UTC + 8] Kina, Vestaustralien & Irkutsk',
		'8.75'	=> '[UTC + 8:45] Central vestaustralien',
		'9'		=> '[UTC + 9] Japan, Korea & Yakutsk',
		'9.5'	=> '[UTC + 9:30] Central Australien',
		'10'	=> '[UTC + 10] Østaustralien & Vladivostok',
		'10.5'	=> '[UTC + 10:30] Lord Howe',
		'11'	=> '[UTC + 11] Solomon-øerne & Magadan',
		'11.5'	=> '[UTC + 11:30] Norfolk-øerne',
		'12'	=> '[UTC + 12] New Zealand & Kamchatka',
		'12.75'	=> '[UTC + 12:45] Chatham-øerne',
		'13'	=> '[UTC + 13] Tonga & Føniks-øerne',
		'14'	=> '[UTC + 14] Linie-øerne',
	],

	'LanguageArray'	=> [
		'bg' => 'Bulgarsk',
		'da' => 'Dansk',
		'de' => 'Tysk',
		'el' => 'Græsk',
		'en' => 'Engelsk',
		'es' => 'Spansk',
		'et' => 'Estisk',
		'fa' => 'Persisk',
		'fr' => 'Fransk',
		'hi' => 'Hindi',
		'hu' => 'Ungarsk',
		'it' => 'Italiensk',
		'ja' => 'Japansk',
		'ko' => 'Koreansk',
		'nl' => 'Hollandsk',
		'pl' => 'Polsk',
		'pt' => 'Portugisisk',
		'ru' => 'Russisk',
		'zh' => 'Kinesisk',
		'zh-tw' => 'Kinesisk',
	],

	'AccountStatus'				=> 'Konto status',
	'AccountStatusArray' => [
		'0' => 'aktiv',
		'1' => 'afventer',
		'2' => 'blokeret',
		'3' => 'inaktiv',
	],

	'JustNow'		=> 'lige nu',
	'MinuteAgo'		=> 'et minut siden',
	'MinutesAgo'	=> '%1 minutter siden',
	'HourAgo'		=> 'en time siden',
	'HoursAgo'		=> '%1 timer siden',
	'DayAgo'		=> 'i går',
	'DaysAgo'		=> '%1 dage siden',
	'WeekAgo'		=> 'en uge siden',
	'WeeksAgo'		=> '%1 uge siden',
	'MonthAgo'		=> 'for en måned siden',
	'MonthsAgo'		=> '%1 måned siden',
	'YearAgo'		=> 'for et år siden',
	'YearsAgo'		=> '%1 år siden',

	'InAMoment'		=> 'om et øjeblik',
	'InAMinute'		=> 'lige om lidt',
	'InMinutes'		=> 'i %1 minutter',
	'InAnHour'		=> 'om en time',
	'InHours'		=> 'om %1 timer',
	'Tomorrow'		=> 'i morgen',
	'InDays'		=> 'i %1 dage',
	'InAWeek'		=> 'om en uge',
	'InWeeks'		=> 'om %1 uger',
	'InAMonth'		=> 'om en måned',
	'InMonths'		=> 'i %1 måneder',
	'InAYear'		=> 'om et år',
	'InYears'		=> 'i %1 år',

	// binary multiples
	'DecimalPrefixShort'		=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'DecimalPrefixLong'			=> ['Byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'BinaryPrefixShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'BinaryPrefixLong'			=> ['Byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],

	// loading error
	'UnknownAction'				=> 'Ukendt handling',
	'UnknownMethod'				=> 'Ukendt metode',
	'FormatterNotFound'			=> 'Formatter %1 blev ikke fundet',

	// log
	'LogAdminLoginSuccess'		=> 'Successful login into the administrative panel',
	'LogAdminLogout'			=> 'Logout of the administrative panel',
	'LogAdminLoginFailed'		=> '!!Failure to authorize into the administrative panel!!',
	'LogAdminLoginLocked'		=> 'Locked login into the administrative panel',
	'LogUserCookieForged'		=> '!!**An attempt to login on a forged cookie with login ##%1##**!!',
	'LogInvalidFormToken'		=> 'Potential CSRF attack in progress detected: %1',
	'LogRemovedPage'			=> '!!Removed page ##%1## (user %2)!!',
	'LogRemovedCluster'			=> '!!Removed **cluster** ##%1## (user %2)!!',
	'LogRemovedRevision'		=> '!!Removed revision ##%3## of page [[/%1]] (user %2)!!',
	'LogRemovedComment'			=> '!!Removed comment from %3 on page [[/%1]] (user %2)!!',
	'LogRemovedFile'			=> '!!Removed file ##%2## from page [[/%1]]!!',
	'LogRemovedPoll'			=> '!!Removed poll with ID %1!!',
	'LogRemovedAllComments'		=> '!!Removed all comments of the page [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Removed all revisions of the page [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Removed all files, attached to [[/%1]]!!',
	'LogTopicLocked'			=> 'Forum topic is locked [[/%1]]',
	'LogTopicUnlocked'			=> 'Unlocked forum topic [[/%1]]',
	'LogAclUpdated'				=> 'Updated ACL page [[/%1]]',
	'LogOwnershipChanged'		=> 'Ownership of the page [[/%1]] transferred to the user ##%2##',
	'LogUserLoginFailed'		=> '!!Unsuccessful attempts to log in with ##~%1##!!',
	'LogClonedPage'				=> 'Page ##%1## cloned to [[/%2]]',
	'LogRenamedPage'			=> 'Page ##%1## renamed to [[/%2]]',
	'LogRenamedPage2'			=> '. On the old page, a link to the new',
	'LogSplittedPage'			=> 'Comments on the page [[/%1]] splitted to page [[/%2]]',
	'LogMergedPages'			=> 'Pages %1 merged to page [[/%2]]',
	'LogUserPasswordReminded'	=> 'User ##%1## asked for the password recovery process to address ##%2##',
	'LogUserPasswordRecovered'	=> 'User ##%1## successfully recover his forgotten password',
	'LogUserPasswordChanged'	=> 'User ##%1## successfully updated (changed) his password',
	'LogUserPasswordMismatch'	=> '!!User ##%1## failed to change his password: Password mismatch with current!!',
	'LogUserIPSwitched'			=> 'Unauthorized switched IP-address of the user %1 from %2 to %3',
	'LogPageImported'			=> 'Imported page [[/%1]]',
	'LogSaveNoRights'			=> 'No appropriate rights to save the page [[/%1]]',
	'LogPageCreated'			=> 'Created new page [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Updated page properties [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'You claimed ownership of the page [[/%1]]',
	'LogPollCreated'			=> 'A new poll with ID %1',
	'LogPollChanged'			=> 'Changed content of the poll with ID %1',
	'LogPollStarted'			=> 'Started poll with ID %1',
	'LogPollReset'				=> 'Reset results from poll with ID %1',
	'LogPollStopped'			=> 'Stopped poll with ID %1',
	'LogFileUploadedLocal'		=> 'To page [[/%1]] uploaded new file ##%2## (size %3)',
	'LogFileUploadedGlobal'		=> 'Uploaded a new file to global folder ##%2## (size %3)',
	'LogPMSent'					=> 'Personal message ##%1## -> ##%2## successfully sent',
	'LogUserSimilarName'		=> 'There were attempts to register under the same user name: ##%1##',
	'LogUserEmailNotAllowed'	=> 'Email ##%1## not in allowed domains list',
	'LogRegisterTiming'			=> 'Registrering mislykkedes, formulartidstærsklen er ##%1## sekunder (var ##%2##)',
	'LogUserRegistered'			=> 'Successfully registered a new user ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Successfully activated email ##%1## of user ##%2##',
	'LogCommentPosted'			=> 'Added [[/%1 new comment]] to page [[/%2]]',
	'LogUserLoginOK'			=> 'User ##%1## successfully logged in the system',
	'LogUserLoggedOut'			=> 'User ##%1## successfully logged out the system',
	'LogUserSessionContinued'	=> 'User ##%1## continued to suspend the session',
	'LogUserSettingsUpdate'		=> 'User ##%1## updated personal settings',
	'LogPageEdited'				=> 'Edited page [[/%1]]',
	'LogCommentEdited'			=> 'Edited comment [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Updated file metadata for ##%2## from page [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Updated file categories for ##%2## from page [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'XML Sitemap generated',
	'LogReferrersPurged'		=> 'Maintenance: referrers purged',
	'LogRevisionsPurged'		=> 'Maintenance: outdated pages revisions purged',
	'LogDeletedPagesPurged'		=> 'Maintenance: deleted pages purged',
	'LogSystemLogPurged'		=> 'Maintenance: system log purged',
	'LogCachedPagesPurged'		=> 'Maintenance: cached pages purged',
	'LogSqlCachePurged'			=> 'Maintenance: cached sql results purged',
	'LogExpiredTokensPurged'	=> 'Maintenance: expired cookie_tokens purged',
	'LogErrorSplitComments'		=> 'Error when separating comments from the topic [[/%1]] a new topic ##%2##: page was not created',
	'LogCategoriesUpdated'		=> 'Updated page categories [[/%1]]',
	'LogCategoryCreated'		=> 'Created a new category //%1//',
	'LogCategoryRenamed'		=> 'Category ##%1## renamed to ##%2##',
	'LogCategoryDebundled'		=> 'Category ##%1## debundled',
	'LogCategoryGrouped'		=> 'Category ##%1## grouped with the word ##%2##',
	'LogCategoryRemoved'		=> 'Category ##%1## removed from the database',

	'ErrorMinPHPVersion'		=> 'PHP-versionen skal være større end <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' din server ser ud til at køre en <strong>' . PHP_VERSION . '</strong>.' .
									'  Du bør opgradere til en nyere PHP-version for at få WackoWiki til at fungere korrekt.',

];
