<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'French',
		'code'		=> 'fr',
		'dir'		=> 'ltr',
		'locale'	=> 'fr_FR.UTF-8',
	],

	// common
	'AddButton'					=> 'Ajouter',
	'ArchiveButton'				=> 'Archives',
	'CancelButton'				=> 'Annuler',
	'ContinueButton'			=> 'Continuer',
	'ConvertButton'				=> 'Convertir',
	'CreateButton'				=> 'Créer',
	'DeleteButton'				=> 'Supprimer',
	'RemoveButton'				=> 'Enlever',
	'RenameButton'				=> 'Renommer',
	'ResetButton'				=> 'Réinitialiser',
	'RestoreButton'				=> 'Restaurer',
	'SaveButton'				=> 'Enregistrer',
	'SearchButton'				=> 'Rechercher',
	'SendButton'				=> 'Envoyer',
	'SetButton'					=> 'Définir',
	'SubmitButton'				=> 'Sauvegarder',
	'UpdateButton'				=> 'Mise à jour',

	'FormInvalid'				=> 'Le formulaire que vous avez envoyé est incorrect. Veuillez essayer de le renvoyer.',

	// logged in panel
	'AccountText'				=> 'Mon compte',
	'AccountTip'				=> 'Réglages du compte',
	'AdminText'					=> 'Admin',
	'AdminTip'					=> 'Panneau de contrôle d’administration',
	'LogoutLink'				=> 'Déconnexion',
	'LogoutButton'				=> 'Vous déconnecter',
	'LogoutAreYouSure'			=> 'Êtes-vous sûr de vouloir vous déconnecter ?',

	// registration panel
	'RegistrationWelcome'		=> 'Enregistrement d’un nouvel utilisateur :',
	'RegistrationButton'		=> 'Enregistrez-moi !',
	'UserNameOwned'				=> 'Ce nom est déjà utilisé. Merci d’en choisir un autre.',
	'SiteRegistered'			=> 'Vous êtes bien enregistré sur le site %1.',
	'RegistrationEmailInfo'		=> 'Une adresse courriel valide. Tous les courriels émis par le système seront envoyés à cette adresse. Cette adresse courriel ne sera pas rendue publique et sera utilisée seulement si vous souhaitez recevoir un nouveau mot de passe ou recevoir certaines nouvelles ou notifications par courriel.',
	'SiteEmailConfirm'			=> 'Merci de confirmer votre adresse courriel en suivant les instructions qui vous ont été envoyées. <br> Notez que sans vérification de cette adresse, vous ne pourrez pas récupérer votre mot de passe !',
	'NameTooShort'				=> 'Le nom d’utilisateur est trop court, un minimum de %2 caractères est obligatoire.',
	'NameTooLong'				=> 'Le nom d’utilisateur est trop long, un maximum de %2 caractères est autorisé.',
	'NameAlphanumOnly'			=> 'Le nom d’utilisateur doit être compris entre %1 et %2 caractères de long et ne doit contenir que des caractères alphanumériques.',
	'NameCamelCaseOnly'			=> 'Le nom d’utilisateur doit être compris entre %1 et %2 caractères de long et WikiName formatted.',
	'NewUserAccount'			=> 'Nouveau compte utilisateur',

	'NewAccountSubject'			=> 'Enregistrement de compte',
	'NewAccountAdminCreated'	=> 'L’utilisateur %1 vous a créé un compte avec le nom d’utilisateur « %2 ». Pour terminer la création, visitez l’URL suivante (soyez sûr qu’elle soit entrée comme une seule ligne) et définissez votre mot de passe :',
	'NewAccountUsername'		=> 'Utilisateur :',
	'AccountLanguage'			=> 'Langue :',
	'NewAccountEmail'			=> 'Courriel :',
	'NewAccountIP'				=> 'Adresse IP distante :',
	'NewAccountSignupInfo'		=> 'Le compte suivant a été créé :',

	'UserWaitingApproval'		=> 'Un courriel a été envoyé à l’administrateur du site, qui examinera les informations soumises et approuvera ou rejettera votre demande.',
	'UserRequiresApproval'		=> 'Pour approuver ou rejeter l’accès de l’utilisateur à %1 ouvrez le tableau de bord de l’administrateur.',
	'UserApprovalInfo'			=> 'Après votre inscription, votre demande sera transmise à l’administrateur du site pour approbation. Vous recevrez ensuite un courriel avec des instructions supplémentaires.',
	'UserApprovalHint'			=> 'Vous serz informé de l’activation de votre compte par courriel. Il n’est pas possible de vous connecter avant.',

	'UserApprovalPending'		=> 'Votre inscription est toujours en attente d’approbation.',
	'UserApprovalDenied'		=> 'Votre inscription sur ce site a été refusée".',

	'RegistrationApproved'		=> 'Inscription approuvée',
	'RegistrationDenied'		=> 'Inscription refusée',
	'PendingApproval'			=> 'En attente d’approbation',

	'UserApprovedInfo'			=> 'Votre accès à %1 a été autorisé.',
	'UserDeniedInfo'			=> 'Votre accès à %1 a été refusé.',

	'RegistrationThreshold'		=> 'Le temps nécessaire pour remplir le formulaire ne doit pas être inférieur à %1 secondes.',
	'Language'					=> 'Langue',

	// login panel
	'LoginWelcome'				=> 'Connexion',
	'CreateAccount'				=> 'Enregistrement',
	'RegistrationLink'			=> 'Enregistrement',
	'LoginName'					=> 'Nom d’utilisateur',
	'Password'					=> 'Mot de Passe ',
	'LoginButton'				=> 'Connexion',
	'LoginLink'					=> 'Connexion',
	'PersistentCookie'			=> 'Rester connecté',
	'Session'					=> 'Session',
	'SessionTip'				=> 'Paramètres de la session en cours',
	'SessionDuration'			=> 'Durée de la session',
	'SessionDurationSession'	=> 'Session navigateur',
	'SessionDurationDay'		=> '1 jour',
	'SessionDurationWeek'		=> '1 semaine',
	'SessionDurationMonth'		=> '1 mois',
	'LoggedInAs'				=> 'Vous êtes connecté en tant que ',

	'ClearCookies'				=> 'Effacer tous les cookies',
	'BindSessionIp'				=> 'Lier la session à l’adresse IP',
	'BindSessionIpOn'			=> 'en fonction (IP en cours %1)',
	'TrafficProtection'			=> 'Protection du trafic',
	'SessionEnds'				=> 'La session en cours se termine',
	'LastVisit'					=> 'La dernière visite a été enregistrée',

	'LoginIncorrect'			=> 'Le nom d’utilisateur ou le mot de passe est erroné.',
	'WelcomeBack'				=> 'Re bonjour, %1',
	'LoginAttemptsExceeded'		=> 'Vous avez dépassé le nombre maximum de tentatives de connexions autorisées.<br>En plus de votre nom d’utilisateur et de votre mot de passe, vous devez à présent saisir le code de confirmation visuelle que vous devriez voir ci-dessous.',

	// session notice
	'IPAddressChanged'			=> 'Adresse IP changée en %1 (était %2)',

	'SessionReplay'				=> 'Session terminée en raison d’ une relecture.',
	'SessionObsolete'			=> 'Session obsolète.',
	'SessionExpired'			=> 'La session a expiré.',
	'SessionTimeout'			=> 'Session terminée car échue.',
	'SessionInactivity'			=> 'Session terminée pour inactivité.',
	'SessionUaChange'			=> 'Session terminée suite à changement d’utilisateur.',
	'SessionTLSChange'			=> 'Session terminée pour modification de TLS.',
	'SessionIPChange'			=> 'Session terminée pour modification d’adresse IP.',

	// other
	'Guest'						=> 'Invité',
	'Help'						=> 'Aide',
	'TopicSearchText'			=> 'Chercher seulement dans les titres',
	'WordprocessorVersion'		=> 'Version pour logiciel de traitement de texte',

	// notifications
	'EmailHello'				=> 'Bonjour ',
	'EmailModerator'			=> 'Modérateur',
	'WatchedPageChanged'		=> 'Une page que vous surveillez a été modifiée ',
	'SomeoneChangedThisPage'	=> ' a modifié cette page que vous surveillez : ',
	'NewPageCreatedSubj'		=> 'A nouvelle page',
	'NewPageCreatedBody'		=> 'L’utilisateur %1 a créé une nouvelle page: ',
	'FileUploadedSubj'			=> 'Un nouveau fichier',
	'FileUploadedBody'			=> 'L’utilisateur %1 a déposée un nouveau fichier: ',
	'FileReplacedBody'			=> 'L’utilisateur %1 a remplacé le fichier: ',

	'ActionDenied'				=> 'Action non autorisée ici.',
	'TocTitle'					=> 'Contenu ',
	'OuterLink2'				=> 'Lien externe',
	'FileLink'					=> 'Fichier',
	'PDFLink'					=> 'Document PDF',
	'RDFLink'					=> 'Document RDF',
	'EmailLink'					=> 'Écrire un courriel (lancement du programme de courriel)',
	'JabberLink'				=> 'Discussion via XMPP (lancement du client Jabber)',
	'PermaLink'					=> 'Lien permanent',
	'PermaLinkTip'				=> 'Adresse permanente de cette version de la page',
	'PermaLink0Tip'				=> 'Adresse permanente de la page',

	'ShowTip'					=> 'Cliquez pour revenir au mode vue',
	'ShowText'					=> 'Voir',
	'WikieditAutocomplete'		=> 'Confirmer les liens Wiki ou wikilinks par Ctrl+Espace',
	'WikiEditInactiveJs'		=> 'Pour pouvoir utiliser WikiEdit, merci d’activer JavaScript dans votre navigateur.',
	'NumerateLinks'				=> 'Numérotation des liens en vue d’impression',
	'Comment'					=> 'Commentaire',
	'Comments0'					=> 'Cette page n’a pas été commentée.',
	'Comments1'					=> 'Cette page a suscité un commentaire.',
	'CommentsN'					=> 'Cette page a suscité %1 commentaires.',
	'Comments'					=> 'Commentaires',
	'CommentHint'				=> '<a href="%1">Connectez-vous</a> ou <a href="%2">créez un compte</a> pour publier un commentaire.',
	'CommentEdited'				=> 'édité',
	'Links'						=> 'Liens',
	'Version'					=> 'Version',

	// details formatter
	'ShowHideDetails'			=> 'Détails',

	'PrivacyPolicy'				=> 'Politique de confidentialité',
	'TermsOfUse'				=> 'Règles d’utilisation',
	'AcceptTermsOfUse'			=> 'J’accepte',

	'ShowComments'				=> 'Montrer les commentaires/le formulaire pour commenter la page',
	'HideComments'				=> 'Cacher les commentaires/le formulaire',
	'AddComment'				=> 'Rédigez votre commentaire :',
	'AddCommentTitle'			=> 'Titre du commentaire :',
	'CommentTitleRe'			=> 'Re :',
	'AddCommentButton'			=> 'Enregistrer ce commentaire',
	'HereLink'					=> 'ici',
	'PageHandlerMoreTip'		=> 'davantage',

	'ThemeCorrupt'				=> 'Ce Thème est corrompu',
	'InvalidNamespace'			=> 'Espace de noms non valide.',
	'DoesNotExists'				=> 'Cette page n’existe pas encore.',
	'PromptCreate'				=> 'Peut-être voulez-vous la <strong><a href="%1">créer</a></strong> ?',
	'RevisionHint'				=> 'Ceci est une ancienne version de <a href="%1">%2</a> de %3 édité par %4.',
	'ReadAccessDenied'			=> 'Vous n’êtes pas autorisé(e) à  voir cette page.',
	'ReadAccessDeniedHintGuest'	=> 'Pour lire cette page, vous devez vous connecter.',
	'PageDeletedInfo'			=> 'Cette page a été supprimée".',
	'RevisionDeletedInfo'		=> 'Cette révision a été supprimée.',
	'CommentDeletedInfo'		=> 'Ce commentaire a été supprimé.',

	'LastEditedBy'				=> 'Dernière édition par',
	'YouAreOwner'				=> 'Vous êtes le propriétaire de cette page.',
	'Owner'						=> 'Propriétaire :',
	'Nobody'					=> 'Personne',
	'TakeOwnership'				=> 'S’approprier',
	'FilesTip'					=> 'gérer les fichiers attachés',
	'FilesText'					=> 'Fichiers',
	'DeleteTip'					=> 'Cliquez ici pour supprimer cette page.',
	'DeleteCommentTip'			=> 'Cliquez ici pour supprimer ce commentaire.',
	'DeleteText'				=> 'Supprimer',
	'AclText'					=> 'Changer les droits',
	'AclTip'					=> 'Modifier les permissions',

	'PropertiesText'			=> 'Propriétés',
	'PropertiesTip'				=> 'Modifier les propriétés de page',
	'EditTip'					=> 'Cliquez ici pour éditer cette page.',
	'EditText'					=> 'Éditer cette page',
	'EditSection'				=> 'Modifier la section %1',
	'EditSectionHint'			=> 'Section %1 of %2',
	'SectionHeadline'			=> 'Section',
	'EditCommentTip'			=> 'Cliquer pour éditer ce commentaire.',
	'EditComment'				=> 'Éditer ce commentaire',
	'ReplyComment'				=> 'Répondre',
	'ReplyCommentTip'			=> 'Répondre à ce commentaire',
	'RevisionTip'				=> 'Cliquez ici pour voir les dernières révisions de cette page',
	'RevisionText'				=> 'Révisions',
	'ReferrersTip'				=> 'Voir les URLs qui renvoient à cette page',
	'ReferrersText'				=> 'Référents',
	'ModerateTip'				=> 'Modération des sujets et des messages des forums',
	'ModerateText'				=> 'Modérer',
	'SearchText'				=> 'Recherche : ',

	'AclUpdated'				=> 'Droits modifiés',
	'AclGaveOwnership'			=> ' et rendre propriétaire %1.',
	'AclNoNewOwner'				=> 'Propriété de la page a été transférée, car l’utilisateur %1 n’a pas été trouvé.',
	'NewPageOwnership'			=> 'Propriété de la page transférée',
	'YouAreNewOwner'			=> 'Le précédent propriétaire %1 vous a transféré la propriété ' . "\n" . 'du site suivant',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Droit de lire :',
	'AclWrite'					=> 'Droit d’écrire :',
	'AclComment'				=> 'Droit de commenter :',
	'AclCreate'					=> 'Droit de créer :',
	'AclUpload'					=> 'Droit de télécharger :',
	'AclFor'					=> 'Droits pour %1',
	'SetOwner'					=> 'Changer le propriétaire :',
	'OwnerDontChange'			=> 'ne pas changer',
	'AclAccessDenied'			=> 'Vous n’êtes pas le propriétaire de cette page.',
	'AclSyntaxError'			=> 'Erreur de syntaxe dans la liste de contrôle d’accès',
	'AclHelp'					=> '<code>*</code> - tout le monde est autorisé<br>' .
									'<code>$</code> - seuls les utilisateurs enregistrés<br>' .
									'<code>!</code> - un point d’exclamation précédent nie le droit respectif<br>' .
									'<code>[UserName]</code> - noms des utilisateurs autorisés<br>' .
									'<code>[GroupName]</code> - noms des groupes d’utilisateurs autorisés (alias)<br>' .
									'<code>(une liste vide)</code> - seul le propriétaire de la page a accès',

	'AccessMode'				=> 'Visibilité',
	'AccessDenied'				=> 'refusé',
	'AccessPublic'				=> 'public',
	'AccessRegistered'			=> 'enregistré',
	'AccessPrivate'				=> 'private',
	'AccessCustom'				=> 'personnalisée',

	// purge handler
	'PurgePage'					=> 'Purger la page',
	'NotOwnerAndCantPurge'		=> 'Vous n’êtes pas le propriétaire de la page et ne pouvez pas la purger.',
	'ReallyPurge'				=> 'ATTENTION: purger la page est irréversible !',
	'SelectPurgeOptions'		=> 'Choisissez les options de purge :',
	'PurgeComments'				=> 'Purger les commentaires de la page',
	'CommentsPurged'			=> 'Tous les commentaires ont été effacés.',
	'PurgeFiles'				=> 'Enlever tous les fichiers attachés',
	'FilesPurged'				=> 'Tous les fichiers attachés ont été enlevés.',
	'PurgeRevisions'			=> 'Effacer toutes les versions antérieures de la page',
	'RevisionsPurged'			=> 'Les versions antérieures ont été supprimées.',
	'PurgeButton'				=> 'purger',

	// categories handler
	'Categories'				=> 'Catégories',
	'CategoriesAssign'			=> 'Assigner',
	'CategoriesEdit'			=> 'Éditer',
	'Category'					=> 'Catégorie',
	'CategoriesFor'				=> 'Catégories pour',
	'CategoriesTip'				=> 'Cliquer pour éditer les mots clefs',
	'CategoriesText'			=> 'Catégories',
	'CategoriesUpdated'			=> 'Catégories mises à jour',
	'CategoriesAlreadyExists'	=> 'Ce mot clef %1 est déjà là.',
	'CategoriesAdded'			=> 'Ajout du mot clef %1 réussi.',
	'CategoriesRenamed'			=> 'Changement du mot clef réussi.',
	'CategoriesUngrouped'		=> 'Dégroupage du mot clef réussi.',
	'CategoriesGrouped'			=> 'Le mot clef a été inclus dans le nouveau groupe.',
	'NoMultilevelGrouping'		=> 'Le regroupement de mots clefs sur plusieurs niveaux n’est pas possible.',
	'CategoriesDeleted'			=> 'Le mot clef a été effacé de la base de données et de toutes les pages.',
	'CategoriesAdd'				=> 'Ajouter un nouveau mot clef',
	'CategoryDescription'		=> 'Description',
	'CategoriesAddGrouped'		=> 'Groupé avec le mot clef',
	'CategoriesAddGroupedNo'	=> 'Pas de groupe.',
	'CategoriesRename'			=> 'Renommer le mot clef %1 ',
	'CategoriesRenameInfo'		=> '* Note: la modification affectera toutes les pages auxquelles ce mot clef est attaché.',
	'CategoriesGroup'			=> 'Groupe de mots clefs %1 avec',
	'CategoriesGroupInfo'		=> '* Choisissez [pas de groupe], pour dégrouper le mot clef.',
	'CategoriesNoGroup'			=> '[pas de groupe]',
	'CategoriesDelete'			=> 'Êtes-vous sûr de vouloir supprimer le mot clef %1?',
	'CategoriesDeleteInfo'		=> '* Note: la modification affectera toutes les pages auxquelles ce mot clef est attaché. Si le mot a une sous-catégorie, ses membres ne seront pas effacés mais seulement dégroupés.',
	'CategoriesStoreInfo'		=> 'Pour attacher des mots clefs à une page cochez-les.',
	'CategoriesStoreButton'		=> 'Sauvegarder les mots clefs',
	'CategoriesGroupButton'		=> 'Grouper',
	'CategoriesEditInfo'		=> 'Pour éditer la liste de mots clefs choisissez le bouton radio.',
	'NoCategoriesForThisLang'	=> 'Les mots clefs pour cette langue ne sont pas définis.',
	'PagesCategory'				=> 'Catégorie de pages',
	'CategoryNotExists'			=> 'Catégorie inexistante.',
	'CategoryEmpty'				=> 'Catégorie vide.',
	'NoCategorySelected'		=> 'Pas de catégorie sélectionnée.',
	'NoCategoriesAssigned'		=> 'Aucune catégorie assignée pour cette langue.',
	'TagCloud'					=> 'Nuage de mots-clés',
	'PagesTaggedWith'			=> '%1 pages étiquetées avec %2',
	'CategoriesOfCluster'		=> 'de groupe',
	'TaggedWithTip'				=> 'Afficher les pages marquées %1',

	// source handler
	'SourceText'				=> 'Source',
	'SourceTip'					=> 'Voir le code source du wiki',
	'SourceCopyToClipboard'		=> 'copier vers le presse-papier',
	'SourceFor'					=> 'Voir la source de %1',

	// Groups action
	'GroupsSearch'				=> 'Trouver des groupes',
	'GroupsNoMatching'			=> 'Pas de groupe correspondant trouvé. essayez un critère de recherche plus large.',
	'GroupsOpenProfile'			=> 'Voir le profil',
	'GroupsName'				=> 'Groupe',
	'GroupsMembers'				=> 'Membres',
	'GroupsDescription'			=> 'Description',
	'GroupsCreated'				=> 'Créé',
	'GroupsNotFound'			=> 'Groupe %2 non trouvé. Cliquer <a href="%1">ici</a>, pour aller à la liste principale.',
	'GroupsProfile'				=> 'Profil',
	'GroupsList'				=> 'Voir la liste complète des groupes',
	'GroupSpace'				=> 'Espace du groupe',

	'MetaUpdated'				=> 'Méta données modifiées',

	'PreviewButton'				=> 'Aperçu',
	'Preview'					=> 'Aperçu',
	'Chars'						=> 'caractères',
	'PageBody'					=> 'Page body',
	'EditNote'					=> 'Éditer le sommaire',
	'EditNoteMissing'			=> 'Éditer le sommaire manquant',
	'EditMinor'					=> 'Édition mineure',
	'MinorEditHide'				=> 'Cacher les éditions mineures',
	'MinorEditShow'				=> 'Montrer les éditions mineures',
	'PostAnonymously'			=> 'Poster de manière anonyme',
	'NotifyMe'					=> 'Me notifier les nouveaux commentaires et modifications de la page',
	'OverwriteAlert'			=> 'ALERTE: Cette page a été modifiée par une autre personne pendant que vous l’éditiez.<br>Copiez vos modifications et rééditez la.',
	'TextDbOversize'			=> 'Attention : Votre texte dépasse la limite de longueur de %1 caractères. Veuillez raccourcir votre texte à un nombre raisonnable de caractères. Conseil : vous pouvez placer le texte restant sur une page séparée.',
	'EditingRevisionWarning'	=> 'Vous éditez une ancienne révision de cette page. Si vous le publiez, toutes les modifications apportées depuis lors seront supprimées. Vous pouvez éditer la révision en cours à la place. ',
	'WriteAccessDenied'			=> 'Vous n’êtes pas autorisé(e) à écrire sur cette page.',
	'EmptyPage'					=> 'La page était vide - elle n’a pas été enregistré !',
	'EmptyComment'				=> 'Le commentaire était vide - il n’a pas été enregistré !',
	'CommentAccessDenied'		=> 'Vous n’êtes pas autorisé à commenter cette page.',
	'CommentFlooded'			=> 'Les publications de messages doivent être espacées d’au moins une seconde.',
	'CommentAdded'				=> 'Commentaires ajoutés.',
	'YouAreNowTheOwner'			=> 'Vous n’êtes pas le propriétaire de cette page.',
	'PageSaved'					=> 'Version %1 de la page sauvegardée.',
	'CommentSaved'				=> 'Commentaire enregistré.',

	'RevisionsFor'				=> 'Historique de %1',
	'DefaultDiffMode'			=> 'Mode d’affichage des différence par défaut',
	'DiffMode'		=> [
		'0'		=> 'Différence complète',
		'1'		=> 'Simple différence entre les deux versions',
		'2'		=> 'Source',
		'3'		=> 'Côte à côte',
		'4'		=> 'En ligne',
		'5'		=> 'Fusionné',
		'6'		=> 'Unifié',
		'7'		=> 'Contextuel',
	],

	'PreviousEdit'				=> 'Modification précédente',
	'NextEdit'					=> 'Modification suivante',

	'Diff'						=> 'diff',
	'PreviousVersion'			=> 'Version précédente',
	'LatestVersion'				=> 'Version actuelle',
	'NextVersion'				=> 'Version suivante',

	'ShowDifferencesButton'		=> 'Montrer les différences',
	'CancelReturnButton'		=> 'Annuler et revenir',
	'Comparison'				=> 'Différences entre versions de %1',
	'RevisionAsOf'				=> 'Version %1 de',
	'SimpleDiffAdditions'		=> 'Ajouts :',
	'SimpleDiffDeletions'		=> 'Suppressions :',
	'NoDifferences'				=> 'Versions identiques.',
	'ReEditOldRevision'			=> 'Rééditer cette ancienne version',

	'ExternalPages'				=> 'Liens externes vers %1 (%2) (<a href="%3">Voir la liste des domaines</a>):',
	'ExternalPagesGlobal'		=> 'Sites ayant des liens vers ce Wiki (<a href="%1">Voir la liste des domaines</a>):',
	'Last24Hours'				=> 'Dernières 24 heures',
	'LastDays'					=> 'Derniers %1 jours',
	'DomainsSitesPages'			=> 'Domaines/sites ayant des liens vers %1 (%2)  (<a href="%3">Voir la liste des différents URLs</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domaines/sites ayant des liens vers ce Wiki (<a href="%1">Voir la liste des différents URLs</a>):',
	'ViewReferrersPage'			=> 'à la page',
	'ViewReferrersPerPage'		=> 'par page',
	'ViewReferrersByTime'		=> 'par heure',
	'ViewReferrersGlobal'		=> 'globaux',
	'NoneReferrers'				=> 'Aucun référent',
	'NotOwnerCantDelete'		=> 'Vous n’êtes pas le propriétaire de cette page et ne pouvez la supprimer',

	// remove
	'RemovePage'				=> 'Supprimer la page',
	'RemoveRevision'			=> 'Supprimer la révision',
	'RemoveComment'				=> 'supprimer le commentaire',
	'RemoveCluster'				=> 'Supprimer toutes les pages du groupe',
	'RemoveDontKeep'			=> 'Ne pas garder une copie d’une page supprimée et des commentaires',
	'RemoveDontKeepRevision'	=> 'Ne pas conserver une copie de la révision supprimée',
	'RemoveDontKeepComment'		=> 'Ne pas conserver une copie du commentaire supprimé',
	'RemoveDontKeepFile'		=> 'Ne pas conserver une copie du fichier supprimé',
	'ReferrersRemoved'			=> 'Référents enlevés.',
	'LinksRemoved'				=> 'Liens depuis la page enlevés.',
	'CategoriesRemoved'			=> 'Pages mots-clés effacées.',
	'RatingRemoved'				=> 'Note supprimée.',
	'AclsRemoved'				=> 'Droits de la page supprimés.',
	'BookmarksRemoved'			=> 'Signets de la page supprimées.',
	'WatchesRemoved'			=> 'Surveillances de la page supprimées.',
	'CommentsRemoved'			=> 'Commentaires de la page effacés.',
	'FilesRemoved'				=> 'Fichiers pour la page enlevés.',
	'PageRemoved'				=> 'Page effacée.',
	'PageCachePurged'			=> 'Cache purgé.',
	'ClusterRemoved'			=> 'Toutes le pages du groupe ont été effacées.',
	'RevisionRemoved'			=> 'Révision %1 supprimée.',
	'RevisionsRemoved'			=> 'Anciennes versions de la page effacées.',
	'ActionHaveNoUndo'			=> 'Cette action ne peut être annulée.',

	// restore
	'PageRestored'				=> 'Page restaurée.',
	'RevisionRestored'			=> 'Révision restaurée.',
	'LocalFilesRestored'		=> 'Fichiers locaux restaurés.',

	'PrintVersion'				=> 'Version pour impression',
	'PrintText'					=> 'Impression',
	'LinkedPages'				=> 'Pages liées :',
	'NoLinkedPages'				=> 'Il n’y a pas de pages liées',
	'ReferringPages'			=> 'Pages qui renvoient à celle-ci :',
	'NoReferringPages'			=> 'Aucune page ne renvoie à celle-ci',
	'Footnotes'					=> 'Notes de pied de page :',
	'Footnote'					=> 'Note de pied de page',
	'MostPopularPages'			=> 'Pages les plus lues',
	'MostCommentedPages'		=> 'Pages les plus commentées',
	'NoAccessToSourcePage'		=> 'Vous n’êtes pas autorisé(e) à voir la source des actions.',
	'SourcePageDoesntExist'		=> 'La page à laquelle se réfère cette fonction n’existe pas encore',
	'NotLoggedInThusEdited'		=> 'Vous n’êtes pas connecté(e], nous ne savons donc pas quelles pages vous avez modifiées.',
	'DidntEditAnyPage'			=> 'Vous n’avez encore édité aucune page.',
	'NoPagesFound'				=> 'Aucune page n’a été trouvée.',
	'MyChangesTitle1'			=> 'Ceci est la liste des pages que vous avez éditées, ordonnée selon la date de votre dernière modification',
	'MyChangesTitle2'			=> 'Ceci est la liste des pages que vous avez éditées, avec la date de votre dernière modification',
	'OrderABC'					=> 'dans l’ordre alphabétique',
	'OrderDate'					=> 'dans l’ordre chronologique',
	'OrderChange'				=> 'ans l’ordre des modifications effectuées',
	'ListOwnedPages'			=> 'Ceci est la liste des pages dont vous êtes le propriétaire, dans l’ordre alphabétique',
	'ListOwnedPages2'			=> 'Ceci est la liste des pages dont vous êtes le propriétaire, dans l’ordre chronologique',
	'ListOwnedPages3'			=> 'Ceci est la liste des pages dont vous êtes le propriétaire, dans l’ordre des modifications effectuées',
	'NotLoggedInThusOwned'		=> 'Vous n’êtes pas connecté(e], nous ne savons donc pas quelles sont vos pages !',
	'NoOrphaned'				=> 'Aucune pages orpheline. Bien !',
	'NoRecentComments'			=> 'Aucun commentaire récent.',
	'LatestCommentBy'			=> 'Dernier commentaire par',
	'NoRecentlyCommented'		=> 'Aucune page commentée récemment.',
	'NoDeletedPages'			=> 'Aucune page effacée n’a été trouvée.',
	'NoDeletedRevisions'		=> 'Aucune révision supprimée trouvée.',
	'NoDeletedFiles'			=> 'Aucun fichier supprimé n’a été trouvé.',
	'CommentsDisabled'			=> 'Les commentaires sont désactivés.',

	'SearchResults'				=> 'Résultat de la recherche pour ',
	'NotFound'					=> 'non trouvé',
	'NoResultsFor'				=> 'Aucun résultat pour ',
	'SearchFor'					=> 'Rechercher :',
	'TopicSearchResults'		=> 'Résultat de la recherche dans les sujets ',
	'NotFoundInTopics'			=> 'non trouvé dans les sujets',
	'FilterLangNotAvailable'	=> 'La langue sélectionnée n’est pas disponible !',

	'PostedBy'					=> 'posté par',
	'ThisIsCommentOn'			=> 'Ceci est un commentaire sur',
	'At'						=> 'à',
	'To'						=> 'à',
	'By'						=> 'par',
	'From'						=> 'de',
	'For'						=> 'pour',
	'ReturnToCommented'			=> 'Retour vers la page commentée',
	'AbandonedComment'			=> 'La page à laquelle appartient ce commentaire n’existe plus !',

	'PagesLinkingTo'			=> 'Pages ayant un lien vers',
	'NoPageLinkingTo'			=> 'Aucune page n’a de lien vers',
	'NoWantedPages'				=> 'Aucune page en attente de rédaction. Bien !',
	'RemoveWatch'				=> 'Cesser de surveiller cette page',
	'SetWatch'					=> 'Surveiller cette page',
	'WatchText'					=> 'Surveiller',
	'UnwatchText'				=> 'Ne pas surveiller',
	'UserSettingsStored'		=> 'Vos préférences ont été enregistrées !',
	'LoggedOut'					=> 'Vous êtes maintenant déconnecté(e).',
	'LoggedOutAuto'				=> 'Votre session a été close par sécurité. merci de vous reconnecter.',

	// user settings
	'EmailConfirmResent'		=> 'code de confirmation du courriel répété envoyé à votre adresse.',
	'EmailConfirmNotSent'		=> 'Envoi du code de confirmation impossible: adresse courriel non spécifiée!',
	'Hello'						=> 'Bonjour',
	'UserName'					=> 'Nom d’utilisateur',
	'EmailAddress'				=> 'Votre adresse de messagerie ',
	'RealName'					=> 'Votre nom',
	'MenuItemsShown'			=> 'Menu des items affiché',
	'RecordsPerPage'			=> 'Enregistrements par page ',
	'DoShowComments'			=> 'Montrer les commentaires par défaut ',
	'DoubleclickEditing'		=> 'Éditer par “double clic” ',
	'UpdateSettingsButton'		=> 'Enregistrer vos préférences',

	'AccountDisabled'			=> 'Votre compte est peut être désactivé.',
	'WrongPassword'				=> 'Mot de passe incorrect !',
	'ConfirmPassword'			=> 'Confirmez votre mot de passe ',
	'Email'						=> 'Adresse de messagerie ',
	'MustBeWikiName'			=> 'Votre nom d’utilisateur doit prendre la forme d’un <a href="https://wackowiki.org/doc/Doc/Français/NomWiki" target="_blank">NomWiki</a> !',
	'SpecifyEmail'				=> 'Vous devez indiquer une adresse de messagerie.',
	'NotAEmail'					=> 'Ceci ne ressemble pas vraiment à une adresse de messagerie.',
	'EmailTaken'				=> 'L’adresse e-mail que vous avez saisie est déjà utilisée.',
	'EmailDomainNotAllowed'		=> 'L’adresse e-mail %1 est pas dans la liste des domaines autorisés.',
	'PasswordsDidntMatch'		=> 'Mots de passe non identiques.',
	'SpacesArentAllowed'		=> 'Le caractère espace n’est pas autorisé dans les mots de passe.',
	'ListMyPages'				=> 'Lister vos pages',
	'ListMyChanges'				=> 'Lister vos modifications',
	'ListMyWatches'				=> 'Lister les pages surveillées',
	'ListMyChangesWatches'		=> 'Modifications parmi les pages surveillées',
	'SeeListOfPages'			=> 'Voir la liste des pages dont vous êtes le propriétaire (MesPages) et les pages que vous avez modifiées (MesModifications).',
	'AddBookmark'				=> 'Ajouter la page courante aux signets',
	'RemoveBookmark'			=> 'Supprimer des signets',

	'YourLanguage'				=> 'Choisissez votre langue ',
	'ShowSpaces'				=> 'Insérer des espaces dans les NomWiki ',
	'WrongPage4Redirect'		=> 'Cette page semble vous diriger vers une autre, non trouvée. Vous pouvez éditer cette page pour connaître le nom de l’autre.',
	'RedirectsToItself'			=> 'La page se redirige vers elle-même. ',
	'ReallyDeletePage'			=> 'Voulez-vous vraiment EFFACER cette page?<br>Cette effacement sera définitif !<br><br>AVERTISSEMENT : supprimer cette page entraîne la suppression ou effacement de toutes ses versions, commentaires, pièces jointes, droits associés et référents.',
	'CommentForWatchedPage'		=> 'Nouveau commentaire sur la page ',
	'SomeoneCommented'			=> ' a commenté cette page que vous surveillez : ',
	'AlertReferringPages'		=> 'Cette page est référencée depuis les pages suivantes ',

	'AccountDelete'				=> 'Supprimer le compte',
	'AccountDeleteConfirm'		=> 'Êtes-vous sûr de vouloir supprimer le compte ?',
	'AccountDeleted'			=> 'Compte supprimé avec succès',
	'AccountDeleteHeader'		=> 'Supprimer le compte %1',
	'AccountDeleteInfo'			=> 'Les données que vous avez créées (e.g. e-mail, préférences, pièces jointes, entrées wiki) seront supprimées autant que possible. Notez toutefois que les données comme les pièces jointes et les entrées wiki ne peuvent pas être supprimées sans impacter le travail des autres utilisateurs. Ces données sont donc réaffectées à un compte appelé %1. Étant donné que les données de chaque compte supprimé sont réaffectées à ce compte, il ne sera plus possible de distinguer les données que vous avez créées de celles d’un autre compte supprimé.',
	'AccountDeleteWarning'		=> 'Supprimer votre compte d’utilisateur est une action irréversible.',
	'AccountDeleteHint'			=> 'Votre compte sera supprimé du système. Par conséquent, vous ne serez plus en mesure de vous identifier avec vos informations d’identification actuelles. Vous pourrez choisir de redevenir un utilisateur de cette application en suivant les procédures habituelles.',
	'AccountDeleteVerify'		=> 'Entrez votre login %1 pour vérifier la suppression. Une fois celui-ci soumis, vous devrez confirmer votre mot de passe.',

	'MarkRead'					=> 'Marquer tout comme lu',
	'CurrentTime'				=> 'heure actuelle',
	'Created'					=> 'créé',
	'Modified'					=> 'modifié',

	'EditIcon'					=> 'Édition',
	'TreeClusterTitle'			=> 'Arbre du groupe %1',
	'TreeSiteTitle'				=> 'Arbre du site',
	'TreeEmpty'					=> '%1 n’a pas de pages subordonnées ou sous-pages',
	'TreeEmptyLevels'			=> '%1 n’a pas de pages subordonnées pour les niveau de profondeur indiqué. Accroître le niveau de profondeur.',
	'TreeTooBig'				=> 'trop de sous-pages',

	// clone handler
	'ClonePage'					=> 'Cloner la page',
	'CloneText'					=> 'Cloner',
	'CloneName'					=> 'Indiquez un nom pour le clone de cette page',
	'CloneButton'				=> 'Cloner',
	'PageCloned'				=> 'Page %1 clonée.',
	'ClonedFrom'				=> 'Clonée à partir de %1.',
	'MassClone'					=> 'Cloner le groupe tout entier',
	'MassCloning'				=> 'Clonage du groupe.',
	'CloneCannotRead'			=> 'Page %1 illisible.',
	'CloneCannotCreate'			=> 'Page %1 impossible à créer.',

	'SortComment'				=> 'Trier le commentaires par',
	'SortCommentAsc'			=> 'Le plus récent au fond',
	'SortCommentDesc'			=> 'Le plus récent au-dessus',

	'RenamePage'				=> 'Renommer cette page',
	'RenameText'				=> 'Renommer',
	'RenameTip'					=> 'Renommer cette page',
	'NewName'					=> 'Donner un nouveau nom à cette page',
	'AlreadyExists'				=> 'La page %1 existe déjà .',
	'AlreadyNamed'				=> 'Cette page s’appelle déjà %1.',
	'PageRenamed'				=> 'Page renommée.',
	'NewNameOfPage'				=> 'Nouveau nom de cette page: ',
	'NotOwnerCantRename'		=> 'Vous ne pouvez pas renommer cette page dont vous n’êtes pas le propriétaire',
	'NeedRedirect'				=> 'Créer une redirection de l’ancienne vers la nouvelle page',
	'RedirectCreated'			=> 'Une redirection de la page %1 vers la nouvelle page a été mise en place',

	'UserSettings'				=> 'Réglages utilisateur',
	'UserSettingsGeneral'		=> 'Général',
	'UserSettingsNotifications'	=> 'Notifications',

	'NotifyMinorEdit'			=> 'Notifier aussi des modifications minimes',
	'NotifyPageEdit'			=> 'Modifier',
	'NotifyComment'				=> 'Commentaire',
	'NotifyOff'					=> 'Non',
	'NotifyAlways'				=> 'Toujours',
	'NotifyPending'				=> 'En attendant',
	'NotifyDigest'				=> 'Digest',
	'NotifyPendingPageTip'		=> 'Une notification est envoyée seulement pour le première modification d’une page que vous surveillez.',
	'NotifyPendingCommentTip'	=> 'Une notification est envoyée seulement pour le premier commentaire d’une page que vous surveillez.',
	'NotifyPendingTip'			=> 'La notification est réactivée dès que vous visitez la version actuelle de la page.',

	'FurtherPending'			=> 'Vous ne recevrez pas de nouvelle notification en cas de modification ultérieure avant que vous ne visitiez cette page de nouveau.',

	'UserSettingsEmailMe'		=> 'Envoyez-moi un courriel quand ...',

	'UserSettingsExtended'		=> 'Étendus',
	'UserSettingsOther'			=> 'Autres réglages',
	'UserSpace'					=> 'Espace utilisateur',
	'ChooseTheme'				=> 'Choisir un thème',

	'CreatePage'				=> 'Créer cette page',
	'CreateNewPage'				=> 'Créer une nouvelle page',
	'CreateNewPageText'			=> 'Créer',
	'CreateNewPageTip'			=> 'Cliquer pour créer une page.',

	'CreateRandomPage'			=> 'Créer une page au hasard :',
	'CreateSubPage'				=> 'Créer une sous-page dans le groupe :',
	'CreatePageParentCluster'	=> 'Créer une page dans le groupe parent :',
	'CreatePageDenied'			=> 'Vous n’avez pas les droits d’accès nécessaires.',
	'CreatePageDeniedAddress'	=> 'Vous n’avez pas le droit de créer une page à cette adresse.',
	'PageAlreadyExists'			=> 'Selon l’adresse fournie la page %1 existe déjà.',
	'PageAlreadyExistsEdit'		=> 'Voulez-vous %1',
	'PageAlreadyExistsEdit2'	=> 'l’éditer',
	'PageAlreadyExistsEditDenied'	=> 'Vous ne pouvez pas l’éditer.',

	'SimilarPagesExists'		=> 'Des pages similaires à %1 existent déjà :',
	'SimilarPagesHint'			=> 'Il existe des pages similaires à %1 :',

	'PageReservedWord'			=> 'Vous ne pouvez pas inclure %1 dans l’ adresse car c’est un mot réservé.',
	'UserReservedWord'			=> 'Les noms d’ utrilisateurs ne pevent pas contenir %1 car c’est un mot réservé.',

	'DontRedirect'				=> 'Ne pas autoriser la redirection automatique par l’action de redirection {{redirect}} ',
	'SendWatchEmail'			=> 'Envoyer un courriel de notification quand quelqu’un<br> (à part vous) a modifié une page que vous surveillez ',
	'AllowIntercom'				=> 'Autoriser les autres utilisateurs à vous envoyer des messages privés',
	'AllowMassemail'			=> 'Les administrateurs peuvent m’informer par courriel',
	'HideLastSession'			=> 'Masquer la dernière session',
	'ValidateIP'				=> 'Attacher la session à l’adresse IP',
	'AnonymousPub'				=> 'Publier de manière anonyme de préférence (masquer le nom)',
	'PageMoved'					=> 'Cette page a été déplacée ou a changé de nom. Vous pouvez la trouverez ici : ',
	'RedirectedFrom'			=> 'Redirigé depuis %1',
	'RedirectedTo'				=> 'Redirigé vers',
	'CurrentPassword'			=> 'Mot de passe actuel ',
	'NewPassword'				=> 'Nouveau mot de passe (au moins 5 caractères) ',
	'YouWantChangePassword'		=> 'Changement de mot de passe',
	'ChangePasswordButton'		=> 'Changement de mot de passe',
	'PasswordChanged'			=> 'Le mot de passe a été changé',
	'EmailWelcome'				=> 'Bienvenue sur ',
	'EmailRegistered'			=> 'Votre enregistrement est confirmé sur %1.' . "\n" . 'Votre nom d’utilisateur ou NomWiki est : %2' . "\n\n",
	'EmailVerify'				=> 'Nous vous conseillons de confirmer votre adresse de messagerie ; ceci vous permettra :' . "\n" . ' - de recevoir des courriels pour vous informer de changements ou commentaires sur certaines pages,' . "\n" . ' - et d’obtenir un nouveau mot de passe en cas de perte.' . "\n\n" . 'Pour confirmer votre adresse de messagerie suivez ' . "\n" . '%1' . "\n" . 'ce lien, ou copiez-le dans la barre d’adresses de votre navigateur.',
	'EmailRegisteredLogin'		=> 'Merci de revenir au wiki et de vous connecter avec vos nouveaux identifiant et mot de passe.',
	'EmailRegisteredIgnore'		=> 'Si vous n’aviez fait aucune demande d’enregistrement, ignorez ce message et rien ne sera fait.',
	'EmailDoNotReply'			=> 'NE PAS RÉPONDRE À CE MESSAGE',
	'EmailReverify'				=> 'Quelqu’un (peut-être vous) a donné votre adresse de messagerie pour recevoir des notifications des modifications ou commentaires sur %1.' . "\n" . 'Votre nom d’utilisateur (NomWiki) : %2'."\n\n" . 'Si vous voulez recevoir des notifications, vous devez confirmer votre adresse de messagerie. Pour cela suivez ' . "\n" . '%3' . "\n" . 'ce lien.'."\n\n",
	'EmailConfirm'				=> 'Merci de vérifier votre adresse de messagerie',
	'EmailConfirmed'			=> 'Adresse de messagerie confirmée.',
	'EmailNotConfirmed'			=> 'Adresse de messagerie non confirmée. Ceci peut être dû à un code de confirmation erroné, mais cette adresse peut aussi avoir été déjà confirmée. Identifiez-vous et vérifiez-le sur votre page %1.',
	'EmailNotVerified'			=> 'Adresse courriel non vérifiée!',
	'EmailNotVerifiedDesc'		=> 'Vous ne serez pas informé des modifications ou commentaires sur les pages que vous surveillez, des' .
									'messages des autres utilisateurs et <strong>ne pourrez pas récupérer un mot des passe oublié</strong>, jusqu’à' .
									'confirmation de votre adresse de messagerie en suivant le lien contenu dans le courriel qui vous a été envoyé. ' .
									'Si, les jours suivant votre enregistrement vous n’avez pas reçu ce courriel, demandez-le en cliquant ',

	'ForgotPasswordHint'		=> 'Indiquez votre NomWiki et votre adresse de messagerie,' . "\n" . 'un courriel avec des instructions vous sera envoyé.',
	'ForgotPassword'			=> 'Avez-vous oublié votre mot de passe ?',
	'UserNotFound'				=> 'Aucun utilisateur avec ce nom ou cette adresse de messagerie n’a été trouvé.',
	'NotConfirmedEmail'			=> 'Vous n’avez pas confirmé votre adresse de messagerie suite au courriel que vous avez dû recevoir.<br>Aucun courriel ne peut être envoyé à une adresse non confirmée.',
	'EmailForgotSubject'		=> 'Renouvellement du mot de passe pour ',
	'EmailForgotMessage'		=> 'Quelqu’un (peut-être vous) a perdu son mot de passe pour %1.' . "\n" . 'Votre nom d’utilisateur ou NomWiki : %2' . "\n\n" . 'Cliquez sur le lien ou copiez-le dans votre navigateur pour changer votre mot de passe.' . "\n" . '%3' . "\n\n",
	'CodeWasSent'				=> 'Les instructions pour obtenir un nouveau mot de passe vous ont été envoyées par courriel.',
	'WrongCode'					=> 'Code erroné',
	'ChangePasswordForUser'		=> 'Changement de mot de passe pour %1',

	'Watchers'					=> 'Liste des utilisateurs qui surveillent %1',
	'WatchersFor'				=> 'Observateurs pour',
	'NoWatchers'				=> 'Personne ne surveille %1',
	'NotOwnerToViewWatchers'	=> 'N’étant pas le propriétaire de cette page, vous ne pouvez pas voir la liste des utilisateurs qui la surveillent.',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Générez le hachage de mot de passe pour <code>mot de passe de récupération</code>',

	// import action
	'ImportTo'					=> 'Importation groupée :',
	'ImportWhat'				=> 'Fichier XML pour l’importation :',
	'ImportButton'				=> 'Importer',
	'ImportSuccess'				=> 'Importation réussie.',
	'ImportFailed'				=> 'Importation échouée.',
	'ImportHint'				=> 'Veuillez fournir un cluster vers lequel vous souhaitez importer, pas d’adresse relative.',
	'ImportAttention'			=> 'Attention : Remplace les mêmes pages dans le groupe.',
	'ImportNote'				=> 'Imported page',

	// mywatches action
	'WatchedPages'				=> 'Liste de toutes les pages que vous surveillez',
	'UnwatchedPages'			=> 'Liste de toutes les pages que vous ne surveillez pas',
	'NoWatchedPages'			=> 'Vous ne surveillez aucune page.',
	'NoUnwatchedPages'			=> 'Vous surveillez toutes les pages.',
	'ViewWatchedPages'			=> 'Montrer les pages surveillées',
	'ViewUnwatchedPages'		=> 'Montrer les pages non surveillées',
	'NotLoggedInWatches'		=> 'Vous n’êtes pas connecté(e], nous ne savons donc pas quelles pages vous surveillez.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'Liste de toutes les pages que vous surveillez, modifiées par d’autres depuis votre dernière modification',
	'ResetChangesWatches'		=> 'Réinitialiser la liste des pages surveillées',
	'NoChangesWatches'			=> 'Pas de modification parmi les pages que vous surveillez ...',

	// whatsnew action
	'NewCommentAdded'			=> 'Commentaire ajouté',
	'NewFileAdded'				=> 'Nouveau fichier ajouté',
	'NewPageCreated'			=> 'Nouvelle page créée',
	'NewRevisionAdded'			=> 'Page modifiée',
	'Cluster'					=> 'Groupe',
	'PageDeleted'				=> 'Page supprimée',
	'CommentDeleted'			=> 'Commentaire supprimé',
	'FileDeleted'				=> 'Fichier supprimé',

	// users action
	'UsersSearch'				=> 'Trouver des utilisateurs',
	'UsersOpenProfile'			=> 'Voir le profil',
	'UsersNoMatching'			=> 'Pas d’utilisateurs trouvés. Utilisez des critères de recherche moins stricts',
	'UsersName'					=> 'Nom',
	'UsersPages'				=> 'Pages',
	'UsersChanges'				=> 'Modification',
	'UsersSubscription'			=> 'Enregistrements',
	'UsersWatches'				=> 'Surveillances',
	'UsersComments'				=> 'Commentaires',
	'UsersUploads'				=> 'Dépôts',
	'UploadQuota'				=> 'Espace utilisé',
	'UploadQuotaTip'			=> 'Quota d’espace pour les dépôts',
	'UsersLogins'				=> 'Connexions',
	'UsersRevisions'			=> 'Révisions',
	'UsersSignup'				=> 'Inscription',
	'UsersLastSession'			=> 'Dernière session',
	'UsersNotFound'				=> 'Utilisateur %2 non trouvé. Cliquez <a href="%1">ici</a>, to gafficher la liste principale.',
	'UsersProfile'				=> 'Profil',
	'UsersContact'				=> 'Contact',
	'UsersList'					=> 'Voir la liste de tous les utilisateurs',
	'UsersNA'					=> '[non défini]',
	'UsersNA2'					=> '[Non]',
	'UsersSignupDate'			=> 'Date d’inscription',
	'UsersGroupMembership'		=> 'Groupes dont l’utilisateur est membre',
	'UsersPersonalInfo'			=> 'Informations personnelles',
	'UsersOwnedPages'			=> 'Pages dont l’utilisateur est propriétaire :',
	'UsersCommentsPosted'		=> 'Commentaires postés :',
	'UsersFilesUploaded'		=> 'Fichiers téléchargés :',
	'UsersRevisionsMade'		=> 'Révisions effectuées :',
	'UsersDocsSortName'			=> '[Trier par nom]',
	'UsersDocsSortDate'			=> '[Trier par date de création]',
	'UsersChangesSortAsc'		=> '[Tri croissant]',
	'UsersChangesSortDesc'		=> '[Tri décroissant]',
	'UsersSessionNA'			=> '[non enregistré]',
	'UsersSessionHidden'		=> '[caché]',
	'IntercomSubject'			=> 'Sujet :',
	'IntercomMessage'			=> 'Message :',
	'IntercomCopy'				=> 'Envoyez-moi une copie',
	'IntercomSubjectN'			=> '[commencer un nouveau sujet]',
	'IntercomDisabled'			=> 'Désolé, vous ne souhaitez pas ou ne pouvez pas recevoir de messages privés.',
	'IntercomHint'				=> 'Veuillez d’abord vous connecter et suivre le lien à nouveau, si vous voulez répondre au message personnel que vous avez reçu.',
	'IntercomDesc'				=> 'Note: Envoi de messages personnel à l’adresse courriel du destinataire sans dévoiler votre adresse. Le destinataire pourra vous répondre en utilisant un formulaire similaire sur votre page de profil. ',
	'PMOversized'				=> 'La longueur du message dépasse la taille maximale autorisée de %1. Merci de raccourcir votre le message et de le soumettre à nouveau.',
	'PMFlooded'					=> 'L’intervalle séparant l’envoi de messages personnels doit être d’au moins %1 secondes.',
	'PMSent'					=> 'Le message personnel a été transmis à l’utilisateur.',
	'PMBody'					=> 'Ce message vous a été envoyé par l’utilisateur %1.',
	'PMBodyCopy'				=> 'Vous avez envoyé le message suivant à l\'utilisateur %1.',
	'PMReply'					=> 'Pour répondre à ce courriel, cliquez sur le lien suivant (n’utilisez pas  le bouton "répondre" de votre logiciel de courriel):',
	'PMNotLoggedIn'				=> 'Vous n’êtes pas enregistré dans le système et ne pouvez envoyer de messages privés aux utilisateurs.',

	// admin_replace action
	'ReplaceText'				=> 'Remplacer le texte',
	'TextOriginal'				=> 'Texte d’origine :',
	'TextReplacement'			=> 'Texte de remplacement :',
	'ReplaceTextRegex'			=> 'Utiliser des expressions rationnelles',
	'Namespace'					=> 'Espace de noms :',
	'ReplaceTextCluster'		=> 'Recherche et remplacement uniquement au sein de ce cluster :',
	'ReplaceTextEditPages'		=> 'Remplacer le texte dans le contenu des pages',
	'ReplaceTextEditComments'	=> 'Remplacer le texte dans les commentaires',
	'ReplaceTextEditTitles'		=> 'Remplacer le texte dans le titre des pages',
	'ReplaceTextGiveTarget'		=> 'Vous devez spécifier la chaîne à remplacer.',
	'ReplaceTextNoNamespace'	=> 'Vous devez sélectionner au moins un espace de noms.',
	'ReplaceTextNoDifference'	=> 'Il n\'y a pas de différence entre le texte de remplacement et le texte cible.',
	'ReplaceTextNoOption'		=> 'Vous devez choisir au moins une option de remplacement.',
	'ReplaceTextPagesEdit'		=> 'Remplacer %1 par %2 dans le texte des $3 pages suivantes :',
	"ReplaceTextTitlesEdit"		=> 'Remplacer %1 par %2 dans les titres des %3 pages suivantes :',
	'ReplaceTextReplace'		=> 'Remplacer',
	'ReplaceTextSuccess'		=> '%1 a été remplacé par %2 dans %3 pages.',
	'ReplaceTextNoMatch'		=> 'Aucune page contenant la chaîne « %1 » n’a été trouvé.',
	'ReplaceTextNoTitleMatch'	=> 'Aucune page n’a été trouvée dont le titre contient %1.',
	'ReplaceTextEditFailed'		=> 'Le remplacement du texte a échoué',
	'ReplaceTextTitleTooBig'	=> 'Le texte original ou de remplacement est trop grand pour le titre.',
	'ReplaceTextReturn'			=> 'Revenir au formulaire',
	'ReplaceTextWarning'		=> 'Attention : il y a %1 fichier s qui contiennent déjà la chaîne de remplacement %2.  Si vous effectuez ce remplacement, vous ne pourrez pas distinguer vos remplacements de ces chaînes d’origine.',
	'ReplaceTextBlankWarning'	=> 'Attention : puisque la chaîne de remplacement est vide, cette opération sera irréversible.',
	'ReplaceTextEditSummary'	=> 'Remplacement de texte : %1 → %2',
	'InvertSelection'			=> 'Inverser la sélection',

	// rating handler
	'RatingDenied'				=> 'Vous ne pouvez pas noter cette page.',
	'RatingSuccess'				=> 'Merci de votre évaluation',
	'RatingDuplicate'			=> 'Vous avez déjà noté cette page.',
	'RatingHeader'				=> 'Votre note pour cette page',
	'RatingHeaderResults'		=> 'Instrument d’évaluation globale',
	'RatingResults'				=> 'montrer les résultats',
	'RatingForm'				=> 'montrer le formulaire',
	'RatingVoters'				=> 'Votants',
	'RatingTotal'				=> 'notre moyenne',
	'RatingNotRated'			=> 'Page non encore notée',
	'RatingTopPages'			=> 'Pages les mieux notées',
	'RatingBottomPages'			=> 'Pages les plus mal notées',
	'RatingNoPagesRated'		=> 'sans notes',

	// Properties
	'PropertiesFor'				=> 'Réglages pour %1',
	'MetaTag'					=> 'Étiquette',
	'MetaTitle'					=> 'Titre',
	'MetaKeywords'				=> 'Méta mots-clés',
	'MetaDescription'			=> 'Description',
	'On'						=> 'Oui',
	'Off'						=> 'Non',
	'Registered'				=> 'Enregistré',
	'MetaComments'				=> 'Montrer les commentaires',
	'MetaFiles'					=> 'Montrer les fichiers',
	'MetaRating'				=> 'Montrer les notes',
	'MetaToc'					=> 'Montrer la table des matières',
	'MetaIndex'					=> 'Afficher le panneau de section groupe',
	'MetaIndexMode'				=> 'Afficher le mode de partition',
	'MetaIndexFull'				=> 'Arbre',
	'MetaIndexUpper'			=> 'En haut',
	'MetaIndexLower'			=> 'En bas',
	'MetaHtml'					=> 'Support du HTML pour la page',
	'MetaSafeHtml'				=> 'Filtrage du HTML peu sûr',
	'MetaNoIndex'				=> 'Bloquer les moteurs de recherche',
	'SettingsID'				=> 'Identifiant de la page',
	'SettingsSize'				=> 'Taille',
	'SettingsSizeTip'			=> 'source / compilé',
	'SettingsCreated'			=> 'Créée le',
	'SettingsCurrent'			=> 'Version en cours du',
	'SettingsTotalRevs'			=> 'Révisions',
	'SettingsTotalComs'			=> 'Commentaires',
	'SettingsWatchers'			=> 'Observateurs',
	'SettingsHits'				=> 'Vues',
	'SettingsRating'			=> 'Notes des lecteurs',
	'SettingsText'				=> 'Réglages',
	'SettingsEdit'				=> 'Édition',
	'SettingsRevisions'			=> 'Révisions',
	'SettingsClone'				=> 'Cloner',
	'SettingsRename'			=> 'Renommer',
	'MassRename'				=> 'tout le groupe de pages',
	'SettingsRemove'			=> 'Supprimer',
	'SettingsPurge'				=> 'Purger',
	'SettingsModerate'			=> 'Modérer',
	'SettingsPermissions'		=> 'Droits',
	'AclForEntireCluster'		=> 'Pour tout le groupe de pages',
	'SettingsAttachments'		=> 'Pièces jointes',
	'SettingsUpload'			=> 'Déposer un fichier',
	'SettingsCategories'		=> 'Catégories',
	'SettingsLanguages'			=> 'Languages',
	'SettingsReferrers'			=> 'Référents',
	'SettingsWatch'				=> 'Surveiller',
	'SettingsLatex'				=> 'Version LaTeX',
	'SettingsXML'				=> 'Export en XML',
	'NeedToChangeLang'			=> 'Le code langue %1 n’est pas supporté, il doit être changé.',
	'SetLang'					=> 'Langue de cette page',
	'SetMenuLabel'				=> 'Étiquette de Menu',
	'SetShowMenuLabel'			=> 'Montrer en navigation',

	// upload
	'UploadFiles'				=> 'Télécharger des fichiers',
	'UploadFor'					=> 'Déposer un fichier :',
	'UploadButton'				=> 'Effectuer le dépôt',
	'UploadGlobalText'			=> 'pour accès public',
	'UploadGlobal'				=> 'globaux',
	'UploadLocalText'			=> 'seulement pour les utilisateurs autorisés à voir cette page',
	'UploadAsName'				=> 'Envoyer en tant que (optionnel):',
	'UploadOverwrite'			=> 'Écraser les fichiers existants',
	'FileDesc'					=> 'Description :',
	'UploadForbidden'			=> 'Vous n’êtes pas autorisé à déposer des fichiers ici.',
	'UploadOverwriteDenied'		=> 'Seul le propriétaire ou l’administrateur du fichier peut écraser le fichier %1.',
	'UploadNoFile'				=> 'Il n’y avait pas de fichier joint au formulaire.',
	'UploadMaxSizeReached'		=> 'La taille du fichier excède celle autorisée !',
	'UploadDirNotWritable'		=> 'Le répertoire de dépôt n’est pas accessible en écriture!',
	'UploadNotAPicture'			=> 'Il est seulement permis de déposer des images, que tentez-vous de déposer ?',
	'UploadEmptyExtension'		=> 'Le nom du fichier ainsi que l’extension ne peuvent être vides.',
	'FilenameTooLong'			=> 'Les noms de fichier ne peuvent pas dépasser 240 octets.',
	'BannedFiletype'			=> '%1 n’est pas un type de fichier autorisé.',
	'PermittedFiletype'			=> 'Formats de fichiers autorisés : %1.',
	'UploadMimeMismatch'		=> 'L’extension du fichier %1 ne correspond pas au type MIME détecté du fichier (%2).',
	'UploadBadMime'				=> 'Les fichiers de type MIME %1 ne peuvent pas être téléversés.',
	'FileIsDuplicate'			=> 'Le fichier téléversé est une copie exacte de la version actuelle.',
	'FileHasDuplicate'			=> 'Ce fichier est un doublon des fichiers suivants :',

	'UploadMaxFileQuota'		=> 'Vous avez atteint la taille limite de dépôt autorisée, ce fichier ne peut donc être déposé.',
	'UploadDone'				=> 'Dépôt du fichier réussi',
	'UploadFileForbidden'		=> 'Accès interdit au fichier',
	'UploadTitle'				=> 'Fichiers accessibles depuis de cette page',
	'UploadTitleGlobal'			=> 'Fichiers accessibles de n’importe quelle page',

	'UploadFile'				=> 'Dépôt',
	'UploadMax'					=> 'Pas plus de ',
	'UploadUsedStorage'			=> 'Espace de stockage utilisé pour le dépôt ',

	// attachments
	'Attachments'				=> 'Pièces jointes',
	'Attachment'				=> 'Pièce jointe',
	'AttachmentsToPage'			=> 'à la page',
	'AttachmentsToCluster'		=> 'cluster',
	'AttachmentsByTime'			=> 'par heure',
	'AttachmentsGlobal'			=> 'globaux',
	'AttachmentsAll'			=> 'tous',
	'AttachmentsLinked'			=> 'utilisé',

	'FileViewProperties'		=> 'Voir',
	'FileViewPropertiesTip'		=> 'Voir les métadonnées de ce fichier',
	'FileEditProperties'		=> 'Modifier',
	'FileEditPropertiesTip'		=> 'Modifier les métadonnées de ce fichier',
	'FileEditedMeta'			=> 'Les métadonnées de ce fichier on été modifiées',
	'FileEditDenied'			=> 'Vous n’êtes pas autorisé(e) à modifier ce fichier',
	'FileLabel'					=> 'Étiqueter',
	'FileLabelTip'				=> 'Étiqueter ce fichier',
	'FileRemove'				=> 'Enlever',
	'FileRemovedFromDB'			=> 'Fichier enlevé de la base de données',
	'FileRemovedFromFS'			=> 'Fichier effacé de l’ordinateur hôte',
	'FileRemovedFromFSError'	=> 'Il semble impossible d’effacer le fichier !',
	'FileRemoveConfirm'			=> 'Êtes-vous certain(e) de vouloir enlever ce fichier ?',
	'FileRemoveDenied'			=> 'Vous n’êtes pas autorisé à enlever ce fichier',
	'FileNotFound'				=> 'Fichier non trouvé',

	'FileSearch'				=> 'Trouver fichier :',
	'UploadBy'					=> 'Déposé par :',
	'FileAdded'					=> 'Ajouté :',
	'FileModified'				=> 'Modifié :',
	'FileSize'					=> 'Taille :',
	'FileDimension'				=> 'Dimension :',
	'MimeType'					=> 'Type MIME :',
	'FileName'					=> 'No :',
	'FileCaption'				=> 'Légende :',
	'FileAuthor'				=> 'Auteur :',
	'FileSource'				=> 'Source :',
	'FileSourceUrl'				=> 'URL :',
	'FileAttachedTo'			=> 'Joint à :',
	'FileSyntax'				=> 'Syntaxe :',
	'FileAbsolutePath'			=> 'chemin absolu',
	'FileRelativePath'			=> 'chemin relatif',
	'FileUsage'					=> 'Utilisation du fichier :',
	'FileUsageText'				=> 'Les pages suivantes mentionnent ce fichier :',
	'NoFileUsage'				=> 'Aucune page n’utilise ce fichier.',

	'FileSortExt'				=> 'extension',
	'FileSortName'				=> 'name',
	'FileSortSize'				=> 'size',
	'FileSortTime'				=> 'created',

	'SortBy'					=> 'Sort by',
	'Ascending'					=> 'ascending',
	'Decending'					=> 'decending',

	'Files0'					=> 'Aucun fichier n’est joint à cette page. ',
	'Files1'					=> 'Un seul fichier est joint à cette page.',
	'FilesN'					=> '%1 fichiers sont joints à cette page.',
	'Files'						=> 'Fichiers',
	'File'						=> 'Fichier',
	'ShowFiles'					=> 'Montrer les fichiers joints/le formulaire pour en joindre',
	'HideFiles'					=> 'Cacher les fichiers/le formulaire',
	'DoShowFiles'				=> 'Montrer la liste des fichiers par défaut',
	'NoAttachments'				=> 'Aucune pièce jointe.',

	'RegistrationLang'			=> 'Votre langue',
	'InvalidWikiName'			=> 'Le nom choisi est invalide',
	'InvalidUserName'			=> 'Le nom choisi est invalide',
	'Bookmarks'					=> 'Signets',
	'ReallyDeleteComment'		=> 'Voulez-vous vraiment effacer ce commentaire ?<br>Cet effacement est définitif !',
	'ReallyDeleteRevision'		=> 'Voulez-vous vraiment EFFACER cette révision ?<br>Cet effacement est définitif !',

	'RegistrationClosed'		=> 'Enregistrement non autorisé ici. Contactez l’administrateur du site.',
	'AclAreYouSure'				=> 'Vous allez changer les droits relatifs à cette page et à toutes ses pages subordonnées ou sous-pages. Continuer ?',

	'BookmarkDeleteSelected'	=> 'Effacer les signet sélectionnés',
	'BookmarkMark'				=> 'Marquer',
	'BookmarkNumber'			=> 'Numéro.',
	'BookmarkNone'				=> 'Vous n’avez pas de signet.',
	'BookmarkTitle'				=> 'Titre du signet',
	'BookmarkPage'				=> 'Page',
	'BookmarkSaveChanges'		=> 'Sauvegarder les modifications',
	'BookmarksAddPage'			=> 'Définir un signet pour la page suivante',
	'BookmarkAlreadyExists'		=> 'Le signet existe déjà.',

	'PoweredBy'					=> 'Motorisé par',

	'MassRenaming'				=> 'Renommer tout le groupe',
	'MassNewName'				=> 'Indiquez un nouveau nom pour ce groupe',
	'MassNeedRedirect'			=> 'Rediriger des anciennes pages vers les nouvelles',

	// pagination
	'ToOverview'				=> 'Retour à l’aperçu',
	'ToThePage'					=> 'Vers la page:',
	'Next'						=> 'Suivant',
	'Prev'						=> 'Précédent',
	'NextAcr'					=> 'Suivant',
	'PrevAcr'					=> 'Précédent',
	'Back'						=> 'Arrière',

	// filter
	'Filter'					=> 'Filtrer',
	'OptionalFilters'			=> 'Filtres facultatifs :',
	'Any'						=> 'Tout',

	// My Groups
	'UserGroups'				=> 'Groupes d’utilisateurs',
	'MyGroups'					=> 'Groupes dont je suis membre',
	'Group'						=> 'Groupe',
	'Groups'					=> 'Groupes',

	// license action
	'DistributedUnder'			=> 'La contenu est distribué sous',
	'AuthorsDisplayHint'		=> 'La liste des auteurs sera affichée quand la page sera enregistrée.',
	'AnonymousUsers'			=> 'Utilisateurs anonymes',
	'License'					=> 'Licence',
	'LicenseArray'				=> [
		'1'		=> 'Attribution-NoDerivatives.',
		'2'		=> 'Attribution-NonCommercial-ShareAlike',
		'3'		=> 'Attribution-NonCommercial-NoDerivatives',
		'4'		=> 'Attribution-ShareAlike',
		'5'		=> 'Attribution-NonCommercial',
		'6'		=> 'Attribution',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation License',
		'9'		=> 'Domaine public / Usage libre',
		'10'	=> 'Tous droits réservés',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Domaine public',
		'2'		=> 'Certains droits réservés',
		'3'		=> 'Tous droits réservés',
	],

	// Cache
	'ClearCache'				=> 'Vider le cache',
	'CacheCleared'				=> 'Le cache a été vidé.',
	'ConfigCache'				=> 'Configurer le cache',
	'FeedCache'					=> 'Alimenter le cache',
	'PageCache'					=> 'Cache de la page',
	'SQLCache'					=> 'Cache SQL',
	'TemplateCache'				=> 'Cache de modèle',
	'ThumbCache'				=> 'Cache de vignette',

	// Embed
	'EmbedNoURL'				=> 'Merci de spécifier l’adresse de la ressource avec l’url en paramètre (p.ex. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Titre du flux',
	'FeedMulti'					=> 'Multi-flux',
	'FeedNoURL'					=> 'Merci de spécifier un flux avec l’url en paramètre (p.ex. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Impossible de charger ou d’analyser le flux',
	'FeedSource'				=> 'Source:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Changements récents',
	'ChangesXML'				=> 'Changements récents au ',
	'CommentsXMLTitle'			=> ' - Commentaires récents',
	'CommentsXML'				=> 'Commentaires récents au ',
	'NewsXMLTitle'				=> ' - nouvelles récentes',
	'NewsXML'					=> 'Nouvelles récentes au ',
	'RevisionXMLTip'			=> 'Cliquez ici pour voir les dernières révisions au format XML.',
	'CommentsXMLTip'			=> 'Cliquez ici pour voir les commentaires récents au format XML.',
	'ChangesXMLTip'				=> 'Cliquez ici pour voir les changements récents au format XML.',
	'NewsXMLTip'				=> 'Cliquer pour voir les nouvelles au format XML.',
	'RevisionsXML'				=> 'Révisions de ',
	'ExportClusterXML'			=> 'Export du groupe entier de ',
	'AccessDeniedXML'			=> 'Vous n’êtes pas autorisé(e) à accéder à cette information.',

	'ChangesFeed'				=> 'Changements récents',
	'CommentsFeed'				=> 'Commentaires récents',
	'NewsFeed'					=> 'Nouvelles récents',
	'RevisionsFeed'				=> 'Révisions de ',

	'LastModification'			=> 'Dernière modification',

	// Captcha
	'Captcha'					=> 'Merci de taper le mot que vous voyez dans l’image',
	'CaptchaFailed'				=> 'Le mot que vous avez tapé n’est pas celui de l’image. S’il vous plaît essayez de nouveau.',
	'CaptchaReload'				=> 'Nouveau mot dans une image',
	'CaptchaReloadWarning'		=> 'Désolé, je ne peux pas ré-afficher l’image contenant le mot. Vous devez rafraîchir la page pour ce faire',

	// news
	'News'						=> 'Nouvelles',
	'NewsName'					=> 'Titre :',
	'NewsNoName'				=> 'Vous avez oublié d’ajouter la manchette des nouvelles.',
	'NewsNotAvailable'			=> 'Pas de nouvelles disponibles.',
	'NewsNoClusterDefined'		=> 'Pas de groupes de nouvelles définis.',
	'NewsDiscuss'				=> 'Discuter cet article ...',

	// blog
	'BlogNewTopic'				=> 'Créer un nouveau poste',
	'NoPostAvailable'			=> 'Aucun article n’est encore disponible.',

	// Review
	'Reviewer'					=> 'Réviseur',
	'Reviewed'					=> 'Revue',
	'Review'					=> 'Révision',
	'ReviewedBy'				=> 'Revu par',
	'RemoveReview'				=> 'Enlever les révisions pour cette page',
	'SetReview'					=> 'A revu cette page',
	'SetAsReviewed'				=> 'Définir la page comme revue',
	'SetAsUnreviewed'			=> 'Définir la page comme non revue',

	// word filter
	'PotentialSpam'				=> 'Spam potentiel identifiés',

	// moderation handler
	'Moderation'				=> 'Modération',
	'Topics'					=> 'sujets',
	'ModerateSection'			=> 'section / page ',

	'NotModerator'				=> 'Vous n’êtes pas habilité à modérer cette page / ce chapitre',
	'ModerateDeleteTopic'		=> 'Effacer le sujet / la page',
	'ModerateDeletePosts'		=> 'Effacer les commentaires',
	'ModerateMove'				=> 'Déplacer',
	'ModerateSplit'				=> 'Divise / déplacer les commentaires',
	'ModerateMerge'				=> 'Fusionner',
	'ModerateLock'				=> 'Verrouiller',
	'ModerateUnlock'			=> 'Déverrouiller',
	'ModerateAccept'			=> 'Accepter',
	'ModerateDeleteConfirm'		=> 'Êtes-vous sût(e) de vouloir <strong>enlever</strong> les sujets suivants ',
	'ModerateRenameConfirm'		=> 'Entrez un nouveau titre pour la page sélectionnée',
	'ModerateRenameExists'		=> 'Une page de même nom existe déjà ! Choisissez un nouveau nom.',
	'ModerateRename1Only'		=> 'Note: renommé pour être seulement la première page que vous avez choisie !',
	'ModerateMovesConfirm'		=> 'Choisissez la partition cible où déplacer le forum',
	'ModerateMoveConfirm'		=> 'Choisissez le forum ou spécifiez le groupe ou déplacer ces sujets. Pour déplacer une page à la racine du site, tapez "/"',
	'ModeratePgMoveConfirm'		=> 'Spécifiez le nom du groupe dans lequel placer la page. Pour déplacer une page à la racine du site, tapez "/"',
	'ModerateMoveExists'		=> 'Opération interrompue : des sujets de même nom %1 existent déjà dans cette section. Si vous avez toujours besoin de déplacer ces sujets, renommez-les d’abord.',
	'ModerateMoveNotExists'		=> 'Le page / le groupe n’existe pas. Vérifiez le nom et réessayez.',
	'ModerateMergeConfirm'		=> 'Choisissez un sujet, qui devrait combiner le reste',
	'ModerateMerge2Min'			=> 'Pour fusionner, vous devez choisir au moins deux sujets  !',
	'ModerateComDelConfirm'		=> 'Êtes-vous sûr(e) de vouloir <strong>enlever</strong> %1 %2?',
	'ModerateComment'			=> 'Commentaire',
	'ModerateComments'			=> 'Commentaires',
	'ModerateSplitNewName'		=> 'Choisissez un nom pour le sujet à détacher et un schéma de séparation',
	'ModerateSplitPageName'		=> 'Entrez le nom de la page / du sujet où déplacer les commentaires à détacher et choisissez un schéma de séparation',
	'ModerateSplitAllAfter'		=> 'Détacher tous les commentaires après le premier sélectionné (et inclus)',
	'ModerateSplitSelected'		=> 'Commentaires sélectionnés seulement séparés (total %1)',
	'ModerateUserProfile'		=> 'profil',
	'ModerateNoItemChosen'		=> 'Merci de sélectionner au moins un item le bouton Choisir.',

	'ModerateSection2'			=> 'section modérée',
	'ModerateTopicsDeleted'		=> 'Effacement des sujets sélectionnées effectué.',
	'ModerateTopicsRelocated'	=> 'Déplacement des sujets sélectionnés effectué.',
	'ModerateTopicsRenamed'		=> 'Sujet effectivement renommé.',
	'ModerateTopicsMerged'		=> 'Sujets sélectionnés effectivement fusionnés.',
	'ModerateTopicsBlocked'		=> 'Sujets sélectionnés effectivement verrouillés.',
	'ModerateTopicsUnlocked'	=> 'Sujets sélectionnés effectivement déverrouillés.',
	'ModerateTopicDeleted'		=> 'Effacement du sujet effectué.',
	'ModeratePageMoved'			=> 'Page effectivement déplacée.',
	'ModerateTopicRenamed'		=> 'Sujet effectivement renommé.',
	'ModerateTopicBlocked'		=> 'Sujet effectivement verrouillé',
	'ModerateTopicUnlocked'		=> 'Sujet effectivement déverrouillé.',
	'ModerateCommentsDeleted'	=> 'Commentaire sélectionnés effectivement enlevés.',
	'ModerateCommentsSplit'		=> 'Commentaire sélectionnés effectivement séparés en un nouveau sujet.',
	'ModerateCommentsSplitFailed'	=> 'Note: Pour une certaine raison la séparation des commentaires sélectionnés en un nouveau sujet a échoué.<br>Ceci ne devrait normalement pas arriver, signalez-le donc à l’administrateur du site.<br>Par mesure de précaution, les éléments ont été conservés dans leur forme originelle.',
	'ModerateCommentsMoved'		=> 'commentaires sélectionnés effectivement déplacés vers une page donnée.',

	// forum
	'ForumSubforums'			=> 'Sujets du forum',
	'ForumTopic'				=> 'Sujet',
	'ForumTopics'				=> 'Sujets',
	'ForumPosts'				=> 'Messages',
	'ForumReplies'				=> 'Réponses',
	'ForumAuthor'				=> 'Auteur',
	'ForumViews'				=> 'Vues',
	'ForumCreated'				=> 'Créé',
	'ForumComments'				=> 'Commentaires',
	'ForumLastComment'			=> 'Dernier commentaire',
	'ForumNoComments'			=> 'Pas de commentaire',
	'ForumNoTopics'				=> 'Aucun sujet n’a été publié dans ce forum.',
	'ForumNewTopic'				=> 'Démarrer une nouvelle discussion',
	'ForumTopicName'			=> 'Nom du sujet :',
	'ForumTopicSubmit'			=> 'Soumettre le sujet',
	'ForumNoTopicName'			=> 'Spécifier un nom pour la nouvelle page.',
	'ForumNewPosts'				=> 'nouveau message',
	'ForumLocked'				=> 'section verrouillée',
	'ForumUpdated'				=> 'actualisé',
	'ForumNoClusterDefined'		=> 'Pas de groupe de forum défini.',
	'ForumOutsideCluster'		=> 'Assurez-vous que le code action %1 soit situé à l’ intérieur du groupe de	 forum.',

	// password complexity
	'PwdCplxShort'				=> 'Le mot de passe est trop court.',
	'PwdCplxEquals'				=> 'Le mot de passe contient le nom d’utilisateur.',
	'PwdCplxWeak'				=> 'Le mot de passe est trop simple.',
	'PwdCplxDesc1'				=> 'Exigences pour le mot de passe : ',
	'PwdCplxDesc2'				=> 'le mot de passe doit avoir au moins %1 caractères',
	'PwdCplxDesc3'				=> 'ne doit pas contenir votre nom d’utilisateur',
	'PwdCplxDesc4'				=> 'doit se composer de ',
	'PwdCplxDesc41'				=> 'lettres et chiffres',
	'PwdCplxDesc42'				=> 'lettres en capitales, bas de casse et chiffres',
	'PwdCplxDesc43'				=> 'lettres en capitales, bas de casse, chiffres et caractères non alphabétiques',
	'PwdCplxDesc5'				=> 'Vous pouvez utiliser chiffres, lettres et caractères spéciaux mais pas d’espaces.',

	'PasswordTooShort'			=> 'Mot de passe trop court.',
	'PasswordTooCommon'			=> 'Ce mot de passe est trop commun.',
	'PasswordSameAsUsername'	=> 'Votre mot de passe est le même que votre pseudo.',
	'PasswordSameAsEmail'		=> 'Votre mot de passe est le même que votre adresse mail.',

	// POLLS ADD-ON
	'PollsTopic'				=> 'Sujet',
	'PollsVariant'				=> 'Répondre',
	'PollsPlural'				=> 'Vous pouvez sélectionner plusieurs réponses',
	'PollsSingular'				=> 'Vous devez sélectionner une seule réponse',
	'PollsAddVariant'			=> 'option ajouter',
	'PollsDelVariant'			=> 'option effacer',
	'PollsNeedTopic'			=> 'Vous n’avez pas spécifié le sujet ou la question pour le sondage.',
	'PollsNeedAnswers'			=> 'Vous devez spécifier au moins deux options.',
	'PollsSubmitted'			=> 'L’ajout de votre sondage a été effectué.',
	'PollsSubmittedMod'			=> 'Il apparaîtra dans la liste des sondages actifs après validation par le modérateur.',
	'PollsCurrent'				=> 'Sondage en cours',
	'PollsModeration'			=> 'En attente de modération',
	'PollsEnded'				=> 'Enquête terminée',
	'PollsArchiveYear'			=> 'Toutes les enquêtes pour l’année %1',
	'PollsArchiveAll'			=> 'Tous les sondages',
	'PollsConfirmDelete'		=> 'Confirmer l’effacement',
	'PollsError'				=> 'Erreur',
	'PollsStartMod'				=> 'Sondage actif',
	'PollsEmptyList'			=> 'La liste des sondages est vide.',
	'PollsNotExists'			=> 'L’enquête demandée n’existe pas.',
	'PollsAlreadyVoted'			=> 'Vous avez déjà répondu à cette enquête.',
	'PollsAlreadyEnded'			=> 'L’enquête est terminée.',
	'PollsDone'					=> 'Merci de votre participation ! Votre vote a été pris en compte.',
	'PollsStop'					=> 'arrêt',
	'PollsActivate'				=> 'activer',
	'PollsEdit'					=> 'modifier',
	'PollsResults'				=> 'résultats',
	'PollsLasts'				=> 'Le sondage est de (jours)',
	'PollsLasted'				=> 'Le sondage a duré (jours)',
	'PollsAdded'				=> 'Ajouté',
	'PollsTotalVotes'			=> 'Total des votes',
	'PollsShow'					=> 'Montrer',
	'PollsAll'					=> 'Tous',
	'PollsNotifySubj'			=> 'Ajouter un nouveau sondage',
	'PollsNotifyBody'			=> 'L’utilisateur %1 a ajouté un nouveau sondage. Pour voir les détails, valider ou rejeter le sondage suivez ce lien :',
	'PollsNone'					=> 'Pas de sondage actif.',

	'Timezone'					=> 'Fuseau horaire',
	'DST'						=> 'Heure d’été',
	'TzZoneArray'	=> [
		'-12'	=> '[UTC - 12] Île Baker',
		'-11'	=> '[UTC - 11] Niue, Samoa',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian, Île Cook',
		'-9.5'	=> '[UTC - 9:30] Îles Marquises',
		'-9'	=> '[UTC - 9] Alaska, Île Gambier',
		'-8'	=> '[UTC - 8] Pacifique',
		'-7'	=> '[UTC - 7] Montagnes Rocheuses',
		'-6'	=> '[UTC - 6] Centre',
		'-5'	=> '[UTC - 5] Est',
		'-4.5'	=> '[UTC - 4:30] Venezuela',
		'-4'	=> '[UTC - 4] Atlantique',
		'-3.5'	=> '[UTC - 3:30] Terre-Neuve',
		'-3'	=> '[UTC - 3] Amazonie, Groenland Central',
		'-2'	=> '[UTC - 2] Fernando de Noronha, Géorgie du Sud & les Îles Sandwich du Sud',
		'-1'	=> '[UTC - 1] Açores, Cap-Vert, Groenland de l’Est',
		'0'		=> '[UTC] Europe de l’Ouest, Méridien de Greenwich',
		'1'		=> '[UTC + 1] Europe Centrale, Afrique de l’Ouest',
		'2'		=> '[UTC + 2] Europe de l’Est, Afrique Centrale',
		'3'		=> '[UTC + 3] Moscou, Afrique de l’Est',
		'3.5'	=> '[UTC + 3:30] Iran',
		'4'		=> '[UTC + 4] Gulf, Samara',
		'4.5'	=> '[UTC + 4:30] Afghanistan',
		'5'		=> '[UTC + 5] Pakistan, Iekaterinbourg',
		'5.5'	=> '[UTC + 5:30] Inde, Sri Lanka',
		'5.75'	=> '[UTC + 5:45] Népal',
		'6'		=> '[UTC + 6] Bangladesh, Bhoutan, Novosibirsk',
		'6.5'	=> '[UTC + 6:30] Îles Cocos, Myanmar',
		'7'		=> '[UTC + 7] Indochine, Krasnoyarsk',
		'8'		=> '[UTC + 8] Chine, Australie de l’Ouest, Irkutsk',
		'8.75'	=> '[UTC + 8:45] Australie du Sud-Est',
		'9'		=> '[UTC + 9] Japon, Corée, Chita',
		'9.5'	=> '[UTC + 9:30] Australie Centrale',
		'10'	=> '[UTC + 10] Australie de l’Est, Vladivostok',
		'10.5'	=> '[UTC + 10:30] Lord Howe',
		'11'	=> '[UTC + 11] Île Solomon, Magadan',
		'11.5'	=> '[UTC + 11:30] Île Norfolk',
		'12'	=> '[UTC + 12] Nouvelle Zélande, Fiji, Kamchatka',
		'12.75'	=> '[UTC + 12:45] Îles Chatham',
		'13'	=> '[UTC + 13] Tongo, Îles Phoenix',
		'14'	=> '[UTC + 14] Île de Wight',
	],

	'LanguageArray'	=> [
		'bg' => 'Bulgare',
		'da' => 'Danois',
		'de' => 'Allemand',
		'el' => 'Grec',
		'en' => 'Anglais',
		'es' => 'Espagnol',
		'et' => 'Estonien',
		'fa' => 'Persian',
		'fr' => 'Français',
		'hi' => 'Hindi',
		'hu' => 'Hongrois',
		'it' => 'Italien',
		'ja' => 'Japonais',
		'ko' => 'Coréen',
		'nl' => 'Néerlandais',
		'pl' => 'Polonais',
		'pt' => 'Portugais',
		'ru' => 'Russe',
		'zh' => 'Chinois',
		'zh-tw' => 'Chinois',
	],

	'AccountStatus'				=> 'Statut du compte',
	'AccountStatusArray' => [
		'0' => 'actif',
		'1' => 'en attendant',
		'2' => 'bloqué',
		'3' => 'inactif',
	],

	'JustNow'		=> 'juste maintenant',
	'MinuteAgo'		=> 'il y a une minute',
	'MinutesAgo'	=> 'il y a %1 minutes',
	'HourAgo'		=> 'il y a une heure',
	'HoursAgo'		=> 'il y a %1 heures',
	'DayAgo'		=> 'hier',
	'DaysAgo'		=> 'il y a %1 jours',
	'WeekAgo'		=> 'il y a une semaine',
	'WeeksAgo'		=> 'il y a %1 semaines',
	'MonthAgo'		=> 'il y a un mois',
	'MonthsAgo'		=> 'il y a %1 mois',
	'YearAgo'		=> 'il y a un an',
	'YearsAgo'		=> 'il y a %1 ans',

	'InAMoment'		=> 'dans un moment',
	'InAMinute'		=> 'dans une minute',
	'InMinutes'		=> 'dans %1 minutes',
	'InAnHour'		=> 'dans une heure',
	'InHours'		=> 'dans %1 heures',
	'Tomorrow'		=> 'demain',
	'InDays'		=> 'dans %1 jours',
	'InAWeek'		=> 'dans une semaine',
	'InWeeks'		=> 'dans %1 semaines',
	'InAMonth'		=> 'dans un mois',
	'InMonths'		=> 'dans %1 mois',
	'InAYear'		=> 'dans un an',
	'InYears'		=> 'dans %1 ans',

	// binary multiples
	'DecimalPrefixShort'		=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'DecimalPrefixLong'			=> ['Octet', 'Kilooctets', 'Megaoctets', 'Gigaoctets', 'Teraoctets', 'Petaoctets', 'Exaoctets', 'Zettaoctets', 'Yottaoctets'],
	'BinaryPrefixShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'BinaryPrefixLong'			=> ['Octet', 'Kibioctets', 'Mebioctets', 'Gibioctets', 'Tebioctets', 'Pebioctets', 'Exbioctets', 'Zebioctets', 'Yobioctets'],

	// loading error
	'UnknownAction'				=> 'Action inconnue',
	'UnknownMethod'				=> 'Méthode inconnue',
	'FormatterNotFound'			=> 'Formateur %1 n\'a pas trouvé',

	// log
	'LogAdminLoginSuccess'		=> 'Connexion réussie au panneau d’administration',
	'LogAdminLogout'			=> 'Déconnexion du panneau d’administration',
	'LogAdminLoginFailed'		=> '!!Échec de la connexion au panneau d’administration!!',
	'LogAdminLoginLocked'		=> 'connexion verrouillée dans le panneau d’administration',
	'LogUserCookieForged'		=> '!!**tentative de connexion avec un cookie piraté à ##%1##**!!',
	'LogInvalidFormToken'		=> 'Attaque potentielle CSRF détectée en cours: %1',
	'LogRemovedPage'			=> '!!page ##%1##  supprimée (utilisateur %2)!!',
	'LogRemovedCluster'			=> '!!**Groupe** supprimé ##%1## (utilisateur %2)!!',
	'LogRemovedRevision'		=> '!!Révision ##%3## supprimée de la page [[/%1]] (utilisateur %2)!!',
	'LogRemovedComment'			=> '!!Commentaire effacé de %3 sur la page [[/%1]] (utilisateur %2)!!',
	'LogRemovedFile'			=> '!!Fichier ##%2## enlevé de la page [[/%1]]!!',
	'LogRemovedPoll'			=> '!!Sondage avec l’ID %1 enlevé!!',
	'LogRemovedAllComments'		=> '!!Tous commentaires de la page [[/%1]] effacés!!',
	'LogRemovedAllRevisions'	=> '!!Toutes versions antérieures de la page [[/%1]] supprimées!!',
	'LogRemovedAllFiles'		=> '!!Tous fichiers attachés à [[/%1]] enlevés!!',
	'LogTopicLocked'			=> 'Le sujet de forum est verrouillé [[/%1]]',
	'LogTopicUnlocked'			=> 'Sujet de forum déverrouillé [[/%1]]',
	'LogAclUpdated'				=> 'Droits de la page [[/%1]] mis à jour',
	'LogOwnershipChanged'		=> 'Propriété de la page [[/%1]] transférée à l’utilisateur ##%2##',
	'LogUserLoginFailed'		=> '!!Échec de la connexion avec ##~%1##!!',
	'LogClonedPage'				=> 'Page ##%1## clonée en [[/%2]]',
	'LogRenamedPage'			=> 'Page ##%1## renommée en [[/%2]]',
	'LogRenamedPage2'			=> '. Sur l’ancienne page, un lien  vers la nouvelle',
	'LogSplittedPage'			=> 'Commentaires sur la page [[/%1]] transférés à la page [[/%2]]',
	'LogMergedPages'			=> 'Pages %1 fusionnée à la page [[/%2]]',
	'LogUserPasswordReminded'	=> 'L’utilisateur ##%1## a demandé une récupération de mot de passe à l’adresse ##%2##',
	'LogUserPasswordRecovered'	=> 'L’utilisateur ##%1## a récupéré son mot de passe oublié',
	'LogUserPasswordChanged'	=> 'L’utilisateur ##%1## a réussi à modifier (changer) son mot de passe',
	'LogUserPasswordMismatch'	=> '!!L’utilisateur ##%1## a échoué à modifier son mot de passe : le mot de passe ne correspond pas avec celui en cours!!',
	'LogUserIPSwitched'			=> 'Changement non autorisé de l’adresse IP de l’utilisateur %1 de %2 à %3',
	'LogPageImported'			=> 'Page [[/%1]] importée',
	'LogSaveNoRights'			=> 'Droits insuffisants pour enregistrer la page [[/%1]]',
	'LogPageCreated'			=> 'Nouvelle page [[/%1]] créée',
	'LogPagePropertiesUpdated'	=> 'Mise à jour des méta données de [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'Vous avez revendiqué la propriété de la page [[/%1]]',
	'LogPollCreated'			=> 'Nouveau sondage avec l’ID %1',
	'LogPollChanged'			=> 'Contenu du sondage avec l’ID %1 modifié',
	'LogPollStarted'			=> 'Sondage démarré avec l’ID %1',
	'LogPollReset'				=> 'Réinitialisation des résultats du sondage avec l’ID %1',
	'LogPollStopped'			=> 'Arrêt du sondage avec l’ID %1',
	'LogFileUploadedLocal'		=> 'Pour la page [[/%1]] nouveau fichier attaché ##%2## (taille %3)',
	'LogFileUploadedGlobal'		=> 'Attaché un nouveau fichier au dossier global ##%2## (taille %3)',
	'LogPMSent'					=> 'Message personnel ##%1## -> ##%2## envoyé',
	'LogUserSimilarName'		=> 'Il y a eu des tentatives d’enregistrement sous le même nom d’utilisateur : ##%1##',
	'LogUserEmailNotAllowed'	=> 'Email ##%1## pas dans la liste des domaines autorisés',
	'LogRegisterTiming'			=> 'L\'enregistrement a échoué, le seuil de temps du formulaire est de ##%1## secondes (était ##%2##)',
	'LogUserRegistered'			=> 'Enregistrement réussi d’un nouvel utilisateur ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Activation réussie de l’adresse de messagerie ##%1## de l’utilisateur ##%2##',
	'LogCommentPosted'			=> 'Ajouté [[/%1 nouveau commentaire(s)]] à la page [[/%2]]',
	'LogUserLoginOK'			=> 'Connexion réussie de l’utilisateur ##%1## au système',
	'LogUserLoggedOut'			=> 'Déconnexion réussie de l’utilisateur ##%1## du système',
	'LogUserSessionContinued'	=> 'L’utilisateur ##%1## a poursuivi la suspension de la session',
	'LogUserSettingsUpdate'		=> 'L’utilisateur ##%1## a mis à jour ses paramètres personnels',
	'LogPageEdited'				=> 'Page [/%1]] modifiée',
	'LogCommentEdited'			=> 'Commentaire [[/%1]] modifié',
	'LogUpdatedFileMeta'		=> 'Mis à jour les métadonnées du fichier pour ##%2## à partir de la page [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Catégories de fichiers pour ##%2## mises à jour à partir de la page [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'Plan de site XML généré',
	'LogReferrersPurged'		=> 'Maintenance: référents purgés',
	'LogRevisionsPurged'		=> 'Maintenance: révisions de pages obsolètes purgées',
	'LogDeletedPagesPurged'		=> 'Maintenance: pages supprimées purgées',
	'LogSystemLogPurged'		=> 'Maintenance: journal système purgé',
	'LogCachedPagesPurged'		=> 'Maintenance: pages en caches purgées',
	'LogSqlCachePurged'			=> 'Maintenance: résultats sql en cache purgés',
	'LogExpiredTokensPurged'	=> 'Maintenance: cookie_jetons expirés purgés',
	'LogErrorSplitComments'		=> 'Erreur lors de la séparation des commentaires du sujet [[/%]] d’un nouveau sujet ##%2##: la page n’a pas été créée',
	'LogCategoriesUpdated'		=> 'page de catégories [[/%1]] mis à jour',
	'LogCategoryCreated'		=> 'Créé une nouvelle catégorie //%1//',
	'LogCategoryRenamed'		=> 'Catégorie ##%1## renommée en ##%2##',
	'LogCategoryDebundled'		=> 'Catégorie ##%1## dégroupée',
	'LogCategoryGrouped'		=> 'Catégorie ##%1## groupée avec le mot ##%2##',
	'LogCategoryRemoved'		=> 'Catégorie ##%1## supprimée de la base de données',

	'ErrorMinPHPVersion'		=> 'La version PHP doit être supérieure à  <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' votre serveur apparaît utiliser une version <strong>' . PHP_VERSION . '</strong>.' .
									'  Vous devriez utiliser une version plus récente de PHP pour que WackoWiki fonctionne correctement',

];
