<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'English',
		'code'		=> 'en',
		'dir'		=> 'ltr',
		'locale'	=> 'en_US',
	],

	'date_formats'	 => [
		'default'	=> 'dd-MM-y',
		'dmy'		=> 'dd-MM-y',
		'mdy'		=> 'MM/dd/y',
	],

	// common
	'AddButton'					=> 'Add',
	'ArchiveButton'				=> 'Archive',
	'CancelButton'				=> 'Cancel',
	'ContinueButton'			=> 'Continue',
	'ConvertButton'				=> 'Convert',
	'CreateButton'				=> 'Create',
	'DeleteButton'				=> 'Delete',
	'RemoveButton'				=> 'Remove',
	'RenameButton'				=> 'Rename',
	'ResetButton'				=> 'Reset',
	'RestoreButton'				=> 'Restore',
	'SaveButton'				=> 'Save',
	'SearchButton'				=> 'Search',
	'SendButton'				=> 'Send',
	'SetButton'					=> 'Set',
	'SubmitButton'				=> 'Submit',
	'UpdateButton'				=> 'Update',

	'FormInvalid'				=> 'The submitted form was invalid. Try submitting again.',
	'UnitPixel'					=> 'px',
	'Number'					=> 'Number',

	// logged in panel
	'AccountText'				=> 'Account',
	'AccountTip'				=> 'Account Settings',
	'AdminText'					=> 'Admin',
	'AdminTip'					=> 'Administrative Panel',
	'LogoutLink'				=> 'Logout',
	'LogoutButton'				=> 'Log out',
	'LogoutAreYouSure'			=> 'Do you really want to log out?',

	// registration panel
	'RegistrationWelcome'		=> 'New user registration:',
	'RegistrationButton'		=> 'Register me',
	'UserNameOwned'				=> 'This username is already registered. Please choose another.',
	'SiteRegistered'			=> 'You have successfully registered on the site %1.',
	'RegistrationEmailInfo'		=> 'A valid email address. All emails from the system will be sent to this address. The email address is not made public and will only be used if you wish to receive a new password or wish to receive certain news or notifications by email.',
	'EmailConfirmHint'			=> 'Please confirm your E-mail address by clicking on the link in the instructions sent to you. <br>If you do not verify your email address, you will not be able to retrieve a possible lost password. <br>Furthermore you will not be notified of recent page changes and comments.',
	'EmailConfirmRequired'		=> 'Without confirmed E-mail address you\'ll not be allowed to login.',
	'NameTooShort'				=> 'The Username is too short, a minimum of %2 characters is required.',
	'NameTooLong'				=> 'The Username is too long, a maximum of %2 characters is allowed.',
	'NameAlphanumOnly'			=> 'Username must be between %1 and %2 chars long and use only alphanumeric characters. Upper case characters are OK.',
	'NameCamelCaseOnly'			=> 'Username must be between %1 and %2 chars long and WikiName formatted.',
	'NewUserAccount'			=> 'new user account',

	'NewAccountSubject'			=> 'Account registration',
	'NewAccountAdminCreated'	=> 'The user %1 has created an account for you with username "%2". In order to complete your registration, visit the following URL (make sure it is entered as the single line) and set your own access password:',
	'NewAccountUsername'		=> 'Username:',
	'AccountLanguage'			=> 'Language:',
	'NewAccountEmail'			=> 'Email:',
	'NewAccountIP'				=> 'Remote IP address:',
	'NewAccountSignupInfo'		=> 'The following account has been created:',

	'UserWaitingApproval'		=> 'An email has been sent to the site administrator. The administrator will review the information that has been submitted and either approve or deny your request.',
	'UserRequiresApproval'		=> 'To approve or deny this user access to %1 go to the admin panel.',
	'UserApprovalInfo'			=> 'After you register, your request will be sent to the site administrator for approval. You will then receive an email with further instructions.',
	'UserApprovalHint'			=> 'The successful activation of your account will be announced in a specific e-mail. Until then, a login is not possible.',

	'UserApprovalPending'		=> 'Your account is still pending approval.',
	'UserApprovalDenied'		=> 'Your account has been denied access to this site.',

	'RegistrationApproved'		=> 'Registration Approved',
	'RegistrationDenied'		=> 'Registration Denied',
	'PendingApproval'			=> 'Pending Approval',

	'UserApprovedInfo'			=> 'You have been approved to access %1.',
	'UserDeniedInfo'			=> 'You have been denied access to %1.',

	'RegistrationThreshold'		=> 'The time for filling out the form should not be less than %1 seconds.',
	'Language'					=> 'Language',

	// login panel
	'LoginWelcome'				=> 'Login',
	'CreateAccount'				=> 'Create new account',
	'RegistrationLink'			=> 'Registration',
	'LoginName'					=> 'Username',
	'Password'					=> 'Password',
	'LoginButton'				=> 'Login',
	'LoginLink'					=> 'Login',
	'PersistentCookie'			=> 'Stay signed in',
	'Session'					=> 'Session',
	'SessionTip'				=> 'parameters of current session',
	'SessionDuration'			=> 'Session duration',
	'SessionDurationSession'	=> 'browser session',
	'SessionDurationDay'		=> '1 day',
	'SessionDurationWeek'		=> '1 week',
	'SessionDurationMonth'		=> '1 month',
	'LoggedInAs'				=> 'You are logged in as',

	'ClearCookies'				=> 'Delete all cookies',
	'BindSessionIp'				=> 'Bind session to the IP address',
	'BindSessionIpOn'			=> 'enabled (current IP %1)',
	'TrafficProtection'			=> 'Traffic Protection',
	'SessionEnds'				=> 'The current session ends',
	'LastVisit'					=> 'Last visit was recorded',

	'LoginIncorrect'			=> 'The username or password you have entered is invalid.',
	'WelcomeBack'				=> 'Welcome back, %1',
	'LoginAttemptsExceeded'		=> 'You exceeded the maximum allowed number of login attempts.<br>In addition to your username and password you now also have to solve the CAPTCHA below.',

	// session notice
	'IPAddressChanged'			=> 'IP address changed to %1 (was %2)',

	'SessionReplay'				=> 'Session terminated due to replay.',
	'SessionObsolete'			=> 'Session is outdated.',
	'SessionExpired'			=> 'Session has expired.',
	'SessionTimeout'			=> 'Session terminated due to timeout.',
	'SessionInactivity'			=> 'Session terminated due to inactivity.',
	'SessionUaChange'			=> 'Session terminated due to user agent change.',
	'SessionTLSChange'			=> 'Session terminated due to TLS change.',
	'SessionIPChange'			=> 'Session terminated due to IP change.',

	// other
	'Guest'						=> 'Guest',
	'Everybody'					=> 'Everybody',
	'Help'						=> 'Help',
	'TopicSearchText'			=> 'Search in titles only',
	'WordprocessorVersion'		=> 'Word processor version',

	// notifications
	'EmailHello'				=> 'Hello ',
	'EmailModerator'			=> 'Moderator',
	'WatchedPageChanged'		=> 'Page changed ',
	'SomeoneChangedThisPage'	=> ' changed a page that you are watching: ',
	'NewPageCreatedSubj'		=> 'A new page',
	'NewPageCreatedBody'		=> 'User %1 has created a new page: ',
	'FileUploadedSubj'			=> 'A new file',
	'FileUploadedBody'			=> 'User %1 has uploaded a new file: ',
	'FileReplacedBody'			=> 'User %1 has replaced the file: ',

	'ActionDenied'				=> 'Action is denied here.',
	'TocTitle'					=> 'Contents ',
	'OuterLink2'				=> 'Outgoing link',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF Document',
	'RDFLink'					=> 'RDF Document',
	'EmailLink'					=> 'Write an email (mail client launch)',
	'GeoLink'					=> 'Show this location (map app launch)',
	'JabberLink'				=> 'Chat via XMPP (Jabber client launch)',
	'TelLink'					=> 'Call this number (phone app launch)',
	'PermaLink'					=> 'Permalink',
	'PermaLinkTip'				=> 'Permanent link to this revision of the page',
	'PermaLink0Tip'				=> 'Permanent link to this page',

	'ShowTip'					=> 'Return in view mode',
	'ShowText'					=> 'View',
	'WikieditAutocomplete'		=> 'Complete wikilinks by Ctrl+Space',
	'WikiEditInactiveJs'		=> 'In order to be able to use WikiEdit, please enable JavaScript in your browser.',
	'NumerateLinks'				=> 'Numerate links in print view',
	'Comment'					=> 'Comment',
	'Comments0'					=> 'Add your comment',
	'Comments1'					=> 'Read comment (1 comment)',
	'CommentsN'					=> 'Read comments (%1 comments)',
	'Comments'					=> 'Comments',
	'CommentHint'				=> '<a href="%1">Log in</a> or <a href="%2">create an account</a> to post a comment.',
	'CommentEdited'				=> 'edited',
	'Links'						=> 'Links',
	'Version'					=> 'Version',

	// details formatter
	'ShowHideDetails'			=> 'Details',

	'PrivacyPolicy'				=> 'Privacy Policy',
	'TermsOfUse'				=> 'Terms of Use',
	'AcceptTermsOfUse'			=> 'I have read, understood and agree to the Terms of Service of the site.',

	'ShowComments'				=> 'Display comments / form',
	'HideComments'				=> 'Hide comments / form',
	'AddComment'				=> 'Attach a comment to this page:',
	'AddCommentTitle'			=> 'Title of the comment:',
	'CommentTitleRe'			=> 'Re:',
	'AddCommentButton'			=> 'Attach Comment',
	'HereLink'					=> 'here',
	'PageHandlerMoreTip'		=> 'more',

	'ThemeCorrupt'				=> 'Theme is corrupt',
	'InvalidNamespace'			=> 'Invalid namespace given.',
	'DoesNotExists'				=> 'This page doesn\'t exist.',
	'PromptCreate'				=> 'Maybe you want to <strong><a href="%1">create</a></strong> it?',
	'RevisionHint'				=> 'This is an old revision of <a href="%1">%2</a> from %3 edited by %4.',
	'ReadAccessDenied'			=> 'You aren\'t allowed to read this page.',
	'ReadAccessDeniedHintGuest'	=> 'To read this page, you should log in.',
	'PageDeletedInfo'			=> 'This page has been deleted.',
	'RevisionDeletedInfo'		=> 'This revision has been deleted.',
	'CommentDeletedInfo'		=> 'This comment has been deleted.',

	'LastEditedBy'				=> 'Last edited by',
	'YouAreOwner'				=> 'You are the owner of this page.',
	'Owner'						=> 'Owner:',
	'Nobody'					=> 'Nobody',
	'TakeOwnership'				=> 'Take Ownership',
	'FilesTip'					=> 'Manage attached files',
	'FilesText'					=> 'Attachments',
	'DeleteTip'					=> 'Delete page, its files and comments',
	'DeleteCommentTip'			=> 'Delete comment',
	'DeleteText'				=> 'Delete',
	'AclText'					=> 'Permissions',
	'AclTip'					=> 'Edit Permissions',

	'PropertiesText'			=> 'Properties',
	'PropertiesTip'				=> 'Edit Page Properties',
	'EditTip'					=> 'Edit this page.',
	'EditText'					=> 'Edit',
	'EditSection'				=> 'Edit section %1',
	'EditSectionHint'			=> 'Section %1 of %2',
	'SectionHeadline'			=> 'Section',
	'EditCommentTip'			=> 'Edit comment',
	'EditComment'				=> 'Edit this comment',
	'ReplyComment'				=> 'Reply',
	'ReplyCommentTip'			=> 'Reply this comment',
	'RevisionTip'				=> 'View page revisions',
	'RevisionText'				=> 'Revisions',
	'ReferrersTip'				=> 'View a list of URLs referring to this page',
	'ReferrersText'				=> 'Referrers',
	'ModerateTip'				=> 'Moderation of topics and forum posts',
	'ModerateText'				=> 'Moderate',
	'SearchText'				=> 'Search: ',

	'AclUpdated'				=> 'Access control lists updated',
	'AclGaveOwnership'			=> ' and gave ownership to %1.',
	'AclNoNewOwner'				=> 'Page ownership is not transferred, because the user %1 was not found.',
	'NewPageOwnership'			=> 'Transferred page ownership',
	'YouAreNewOwner'			=> 'former owner %1 transferred ownership ' . "\n" . 'of following page to you',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Read:',
	'AclWrite'					=> 'Write:',
	'AclComment'				=> 'Comments:',
	'AclCreate'					=> 'Create:',
	'AclUpload'					=> 'Upload:',
	'AclFor'					=> 'Access Control Lists for %1',
	'SetOwner'					=> 'Set Owner:',
	'OwnerDontChange'			=> 'Don\'t change',
	'AclAccessDenied'			=> 'You are not the owner of this page.',
	'AclSyntaxError'			=> 'Access control list syntax error',
	'AclHelp'					=> '<code>*</code> - everyone is allowed<br>' .
									'<code>$</code> - only registered users<br>' .
									'<code>!</code> - a preceding exclamation mark denies the respective right<br>' .
									'<code>[UserName]</code> - names of allowed users<br>' .
									'<code>[GroupName]</code> - names of allowed usergroup (alias)<br>' .
									'<code>(an empty list)</code> - only the page owner has access',

	'AccessMode'				=> 'Visibility',
	'AccessDenied'				=> 'denied',
	'AccessPublic'				=> 'public',
	'AccessRegistered'			=> 'registered',
	'AccessPrivate'				=> 'private',
	'AccessCustom'				=> 'custom',

	// purge handler
	'PurgePage'					=> 'Purge page',
	'NotOwnerAndCantPurge'		=> 'You are not the owner of the page and you cannot purge it.',
	'ReallyPurge'				=> 'ATTENTION: Purging the page is irreversible!',
	'SelectPurgeOptions'		=> 'Select the necessary purge options:',
	'PurgeComments'				=> 'Purge all comments of the page',
	'CommentsPurged'			=> 'All comments were deleted.',
	'PurgeFiles'				=> 'Remove all attached files',
	'FilesPurged'				=> 'All attached files were removed.',
	'PurgeRevisions'			=> 'Purge all revisions of the page',
	'RevisionsPurged'			=> 'Revisions were purged.',
	'PurgeButton'				=> 'Purge',

	// categories handler
	'Categories'				=> 'Categories',
	'CategoriesAssign'			=> 'assign',
	'CategoriesEdit'			=> 'edit',
	'Category'					=> 'Category',
	'CategoriesFor'				=> 'Categories for',
	'CategoriesTip'				=> 'Edit categories',
	'CategoriesText'			=> 'Categories',
	'CategoriesUpdated'			=> 'Categories updated',
	'CategoriesAlreadyExists'	=> 'Category %1 already exists.',
	'CategoriesAdded'			=> 'Category %1 added successfully.',
	'CategoriesRenamed'			=> 'Category successfully renamed.',
	'CategoriesUngrouped'		=> 'Category debundled successfully.',
	'CategoriesGrouped'			=> 'The category entered in the new group.',
	'NoMultilevelGrouping'		=> 'Multilevel grouping categories is not possible.',
	'CategoriesDeleted'			=> 'The category was deleted from the database and all pages.',
	'CategoriesAdd'				=> 'Add a new category',
	'CategoryDescription'		=> 'Description',
	'CategoriesAddGrouped'		=> 'Grouped with the category',
	'CategoriesAddGroupedNo'	=> 'No group.',
	'CategoriesRename'			=> 'Rename the category %1 to',
	'CategoriesRenameInfo'		=> '* Note: Change will affect all pages that are assigned to that category.',
	'CategoriesGroup'			=> 'Group categories %1 with',
	'CategoriesGroupInfo'		=> '* Select [no group] to debundle the category.',
	'CategoriesNoGroup'			=> '[no group]',
	'CategoriesDelete'			=> 'Are you sure you want to remove category %1?',
	'CategoriesDeleteInfo'		=> '* Note: Change will affect all pages that are assigned to that category. If the word has a sub-category, they will not be deleted, but only debundled.',
	'CategoriesStoreInfo'		=> 'To assign categories to a page, select the checkboxes.',
	'CategoriesStoreButton'		=> 'Save Categories',
	'CategoriesGroupButton'		=> 'Group',
	'CategoriesEditInfo'		=> 'To edit the Category list select the radio button.',
	'NoCategoriesForThisLang'	=> 'Categories for this language are not specified.',
	'PagesCategory'				=> 'Pages category',
	'CategoryNotExists'			=> 'Category does not exist.',
	'CategoryEmpty'				=> 'Category empty.',
	'NoCategorySelected'		=> 'No category selected.',
	'NoCategoriesAssigned'		=> 'No assigned categories for this language.',
	'TagCloud'					=> 'Tag Cloud',
	'PagesTaggedWith'			=> '%1 pages tagged with %2',
	'CategoriesOfCluster'		=> 'of cluster',
	'TaggedWithTip'				=> 'show pages tagged %1',

	// source handler
	'SourceText'				=> 'Source',
	'SourceTip'					=> 'View the wiki source',
	'SourceCopyToClipboard'		=> 'copy to clipboard',
	'SourceFor'					=> 'View source for %1',

	// Groups action
	'GroupsSearch'				=> 'Find Groups',
	'GroupsNoMatching'			=> 'Matching groups not found. Try a less strict search criteria.',
	'GroupsOpenProfile'			=> 'View Profile',
	'GroupsName'				=> 'Group',
	'GroupsMembers'				=> 'Members',
	'GroupsDescription'			=> 'Description',
	'GroupsCreated'				=> 'Created',
	'GroupsNotFound'			=> 'Group %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'GroupsProfile'				=> 'Profile',
	'GroupsList'				=> 'View the entire list of groups',
	'GroupSpace'				=> 'Group space',

	'MetaUpdated'				=> 'Meta data updated',

	'PreviewButton'				=> 'Preview',
	'Preview'					=> 'Preview',
	'Chars'						=> 'chars',
	'PageBody'					=> 'Page body',
	'EditNote'					=> 'Edit summary',
	'EditNoteMissing'			=> 'Edit summary missing',
	'EditMinor'					=> 'Minor edit',
	'MinorEditHide'				=> 'Hide minor edit',
	'MinorEditShow'				=> 'Show minor edit',
	'PostAnonymously'			=> 'Post anonymously without giving your name',
	'NotifyMe'					=> 'Notify me about new comments and changes of the page',
	'OverwriteAlert'			=> 'OVERWRITE ALERT: This page was modified by someone else while you were editing it.<br>Please copy your changes and re-edit this page.',
	'TextDbOversize'			=> 'Warning: Your text exceeds the length limit by %1 characters. Please shorten your text to an acceptable number of characters. Tip: You may place the remaining text on a separate page.',
	'EditingRevisionWarning'	=> 'You are editing an old revision of this page. If you publish it, any changes made since then will be removed. <br>You may wish to edit the current revision instead.',
	'WriteAccessDenied'			=> 'You don\'t have write access to this page.',
	'EmptyPage'					=> 'Page body was empty - not saved!',
	'EmptyComment'				=> 'Comment body was empty - not saved!',
	'CommentAccessDenied'		=> 'Sorry, you\'re not allowed to post comments to this page.',
	'CommentFlooded'			=> 'The interval between the publication of the posts shall not be less than %1 seconds.',
	'CommentAdded'				=> 'Comment added.',
	'YouAreNowTheOwner'			=> 'You are now the owner of this page.',
	'PageSaved'					=> 'Page version %1 saved.',
	'CommentSaved'				=> 'Comment saved.',

	'RevisionsFor'				=> 'Revisions for %1',
	'DefaultDiffMode'			=> 'Default diff mode',
	'DiffMode'		=> [
		'0'		=> 'Full diff',
		'1'		=> 'Simple diff',
		'2'		=> 'Source',
		'3'		=> 'Side by side',
		'4'		=> 'Inline',
		'5'		=> 'Merged',
		'6'		=> 'Unified',
		'7'		=> 'Context',
	],

	'PreviousEdit'				=> 'Previous edit',
	'NextEdit'					=> 'Next edit',

	'Diff'						=> 'Diff',
	'PreviousVersion'			=> 'Previous revision',
	'LatestVersion'				=> 'Latest revision',
	'NextVersion'				=> 'Next revision',

	'ShowDifferencesButton'		=> 'Show Differences',
	'CancelReturnButton'		=> 'Cancel and return to page',
	'Comparison'				=> 'Difference between revisions for %1',
	'RevisionAsOf'				=> 'Revision %1 as of',
	'SimpleDiffAdditions'		=> 'Additions:',
	'SimpleDiffDeletions'		=> 'Deletions:',
	'NoDifferences'				=> 'No differences.',
	'ReEditOldRevision'			=> 'Re-edit this old revision',

	'ExternalPages'				=> 'External pages linking to %1 (%2) (<a href="%3">see list of domains</a>):',
	'ExternalPagesGlobal'		=> 'Sites linking to this WackoWiki (%2) (<a href="%1">see list of domains</a>):',
	'Last24Hours'				=> 'last 24 hours',
	'LastDays'					=> 'last %1 days',
	'DomainsSitesPages'			=> 'Domains/sites pages linking to  %1 (%2)  (<a href="%3">see list of different URLs</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domains/sites linking to this WackoWiki (<a href="%1">see list of different URLs</a>):',
	'ViewReferrersPage'			=> 'to page',
	'ViewReferrersPerPage'		=> 'per page',
	'ViewReferrersByTime'		=> 'by time',
	'ViewReferrersGlobal'		=> 'global',
	'NoneReferrers'				=> 'None',
	'NotOwnerCantDelete'		=> 'You aren\'t owner of this page and can\'t delete it',

	// remove
	'RemovePage'				=> 'Remove page',
	'RemoveRevision'			=> 'Remove revision',
	'RemoveComment'				=> 'Delete comment',
	'RemoveCluster'				=> 'Remove all pages of the cluster',
	'RemoveDontKeep'			=> 'Do not save a copy of a removed page and comments',
	'RemoveDontKeepPurge'		=> 'Do not save a copy of the removed files, revisions and comments',
	'RemoveDontKeepRevision'	=> 'Do not save a copy of the removed revision',
	'RemoveDontKeepComment'		=> 'Do not save a copy of the removed comment',
	'RemoveDontKeepFile'		=> 'Do not save a copy of the removed file',
	'ReferrersRemoved'			=> 'Referrers removed.',
	'LinksRemoved'				=> 'Links removed.',
	'CategoriesRemoved'			=> 'Pages categories deleted.',
	'AclsRemoved'				=> 'Page acls removed.',
	'BookmarksRemoved'			=> 'Bookmarks removed.',
	'WatchesRemoved'			=> 'Watches removed.',
	'CommentsRemoved'			=> 'Comments from page removed.',
	'FilesRemoved'				=> 'Files from page removed.',
	'PageRemoved'				=> 'Page removed.',
	'PageCachePurged'			=> 'Cache purged.',
	'ClusterRemoved'			=> 'All pages of the cluster removed.',
	'RevisionRemoved'			=> 'Revision %1 removed.',
	'RevisionsRemoved'			=> 'Revisions removed.',
	'ActionHaveNoUndo'			=> 'This action cannot be undone.',

	// restore
	'PageRestored'				=> 'Page restored.',
	'RevisionRestored'			=> 'Revision restored.',
	'LocalFilesRestored'		=> 'Local files restored.',

	'PrintVersion'				=> 'Print version',
	'PrintText'					=> 'Print',
	'LinkedPages'				=> 'Linked pages:',
	'NoLinkedPages'				=> 'There are no linked pages',
	'ReferringPages'			=> 'Referring pages:',
	'NoReferringPages'			=> 'There are no referring pages',
	'Footnotes'					=> 'Footnotes:',
	'Footnote'					=> 'Footnote',
	'MostPopularPages'			=> 'Most popular pages',
	'MostCommentedPages'		=> 'Most commented pages',
	'NoAccessToSourcePage'		=> 'You aren\'t allowed to read action source page.',
	'SourcePageDoesntExist'		=> 'Action source page doesn\'t exist yet',
	'NotLoggedInThusEdited'		=> 'You are not logged in, hence we couldn\'t identify the pages you\'ve edited.',
	'DidntEditAnyPage'			=> 'You haven\'t edited any pages yet.',
	'NoPagesFound'				=> 'No pages found.',
	'MyChangesTitle1'			=> 'This is the list of pages you\'ve edited, ordered by the time of your last change',
	'MyChangesTitle2'			=> 'This is the list of pages you\'ve edited, along with the time of your last change',
	'OrderABC'					=> 'alphabetically',
	'OrderCreation'				=> 'by creation',
	'OrderChange'				=> 'by change',
	'ListOwnedPages'			=> 'This is the list of pages you own (ordered alphabetically)',
	'ListOwnedPages2'			=> 'This is the list of pages you own (ordered by date)',
	'ListOwnedPages3'			=> 'This is the list of pages you own (ordered by change)',
	'NotLoggedInThusOwned'		=> 'You\'re not logged in, hence we couldn\'t retrieve your pages.',
	'NoOrphaned'				=> 'No orphaned pages. Good.',
	'NoRecentComments'			=> 'No recent comments.',
	'LatestCommentBy'			=> 'latest comment by',
	'NoRecentlyCommented'		=> 'No recently commented page.',
	'NoDeletedPages'			=> 'No deleted pages found.',
	'NoDeletedRevisions'		=> 'No deleted revisions found.',
	'NoDeletedFiles'			=> 'No deleted files found.',
	'CommentsDisabled'			=> 'Comments are not available.',

	'SearchResults'				=> 'Search results for ',
	'NotFound'					=> 'not found',
	'NoResultsFor'				=> 'No results for ',
	'SearchFor'					=> 'Search for:',
	'TopicSearchResults'		=> 'Topics search results for ',
	'NotFoundInTopics'			=> 'not found in topics',
	'FilterLangNotAvailable'	=> 'The selected language is not available!',

	'PostedBy'					=> 'posted by',
	'ThisIsCommentOn'			=> 'This is a comment on',
	'At'						=> 'at',
	'To'						=> 'to',
	'By'						=> 'by',
	'From'						=> 'from',
	'For'						=> 'for',
	'ReturnToCommented'			=> 'Return to commented page',
	'AbandonedComment'			=> 'The page to which this comment belongs no longer exists!',

	'PagesLinkingTo'			=> 'Pages linking to',
	'NoPageLinkingTo'			=> 'No page is linking to',
	'NoWantedPages'				=> 'No wanted pages. Good.',
	'RemoveWatch'				=> 'Remove watch for this page',
	'SetWatch'					=> 'Watch this page',
	'WatchText'					=> 'Watch',
	'UnwatchText'				=> 'Not follow',
	'UserSettingsStored'		=> 'User settings saved.',
	'LoggedOut'					=> 'You are now logged out.',
	'LoggedOutAuto'				=> 'For security, your session has ended. Please log in again.',

	// user settings
	'EmailConfirmResent'		=> 'Email confirmation code resent to your address.',
	'EmailConfirmNotSent'		=> 'Unable to send the confirmation code: email is not specified!',
	'Hello'						=> 'Hello',
	'UserName'					=> 'User name',
	'EmailAddress'				=> 'Email address',
	'RealName'					=> 'Real name',
	'MenuItemsShown'			=> 'Menu items shown',
	'RecordsPerPage'			=> 'Records per page',
	'DoShowComments'			=> 'Show comments by default',
	'DoubleclickEditing'		=> 'Doubleclick Editing',
	'UpdateSettingsButton'		=> 'Update Settings',

	'AccountDisabled'			=> 'Your account may be disabled or blocked.',
	'WrongPassword'				=> 'Wrong password!',
	'ConfirmPassword'			=> 'Confirm password',
	'Email'						=> 'Email address',
	'MustBeWikiName'			=> 'User name must be <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> formatted!',
	'SpecifyEmail'				=> 'You must specify an email address.',
	'NotAEmail'					=> 'That doesn\'t look like a valid email address.',
	'EmailTaken'				=> 'The entered email address is already in use.',
	'EmailDomainNotAllowed'		=> 'The entered email address %1 is not in allowed domains list.',
	'PasswordsDidntMatch'		=> 'Passwords didn\'t match.',
	'SpacesArentAllowed'		=> 'Spaces aren\'t allowed in passwords.',
	'ListMyPages'				=> 'List your pages',
	'ListMyChanges'				=> 'List your changes',
	'ListMyWatches'				=> 'List of watched pages',
	'ListMyChangesWatches'		=> 'Changes among watched pages',
	'SeeListOfPages'			=> 'See a list of pages you own (MyPages) and pages you\'ve edited (MyChanges).',
	'AddBookmark'				=> 'Add current page to bookmarks',
	'RemoveBookmark'			=> 'Remove from bookmarks',

	'YourLanguage'				=> 'Select language',
	'ShowSpaces'				=> 'Show spaces in WikiNames',
	'WrongPage4Redirect'		=> 'Cannot redirect because of wrong redirect parameter',
	'RedirectsToItself'			=> 'The page redirects to itself.',
	'ReallyDeletePage'			=> 'Do you really want to DELETE this page?<br>There is no undo for this action!<br><br>WARNING: Deleting this page will delete all page versions, comments, attachments, ACLs and referrers.',
	'CommentForWatchedPage'		=> 'New comment for page ',
	'SomeoneCommented'			=> ' commented this page that you are watching: ',
	'AlertReferringPages'		=> 'This page is referred to by these pages',

	'AccountDelete'				=> 'Delete account',
	'AccountDeleteConfirm'		=> 'Are you sure you want to delete the account?',
	'AccountDeleted'			=> 'Account successfully deleted',
	'AccountDeleteHeader'		=> 'Delete account %1',
	'AccountDeleteInfo'			=> 'Of the data you created (e.g. email, preferences, attachments, wiki entries) as much as possible will be deleted. Note, however, that data like attachments and wiki entries cannot be deleted without impeding the work of the other users. Such data is hence reassigned to an account called %1. As the data of every deleted account is reassigned to this account it will not be possible to distinguish the data you created from the data of another deleted account.',
	'AccountDeleteWarning'		=> 'Deleting the user account is an irreversible action.',
	'AccountDeleteHint'			=> 'Your account will be deleted from the system. Therefore, you will no longer be able to log in with your current credentials. If you choose to become a user of this application again, you can do so by using the means this application grants.',
	'AccountDeleteVerify'		=> 'Enter your login %1 to verify the deletion. Once submitted, you will be asked to confirm your password.',

	'MarkRead'					=> 'Mark all as read',
	'CurrentTime'				=> 'It is currently',
	'Created'					=> 'created',
	'Modified'					=> 'modified',

	'EditIcon'					=> 'edit',
	'TreeClusterTitle'			=> 'Tree of cluster %1',
	'TreeSiteTitle'				=> 'Site tree',
	'TreeEmpty'					=> '%1 has no subpages',
	'TreeEmptyLevels'			=> '%1 has no subpages for given levels of depth. Increase the value for depth.',
	'TreeTooBig'				=> 'too many subpages',

	// clone handler
	'ClonePage'					=> 'Clone page',
	'CloneText'					=> 'Clone',
	'CloneName'					=> 'Enter new name for a clone of this page',
	'CloneButton'				=> 'Clone',
	'PageCloned'				=> 'Page %1 cloned.',
	'ClonedFrom'				=> 'Cloned from %1.',
	'MassClone'					=> 'Clone entire cluster',
	'MassCloning'				=> 'Cloning cluster.',
	'CloneCannotRead'			=> 'Unreadable page %1.',
	'CloneCannotCreate'			=> 'Uncreatable page %1.',

	'CommentOffset'				=> 'Comments page',
	'CommentOffsetFirst'		=> 'first page',
	'CommentOffsetLast'			=> 'last page',
	'SortComment'				=> 'Sort comments by',
	'SortCommentAsc'			=> 'Most recent on bottom',
	'SortCommentDesc'			=> 'Most recent on top',

	'RenamePage'				=> 'Rename page',
	'RenameText'				=> 'Rename',
	'RenameTip'					=> 'Rename page',
	'NewName'					=> 'Enter new name for this page',
	'AlreadyExists'				=> 'Page %1 already exists.',
	'AlreadyNamed'				=> 'This page already named %1.',
	'PageRenamed'				=> 'Page renamed.',
	'NewNameOfPage'				=> 'New name of this page: ',
	'NotOwnerCantRename'		=> 'You aren\'t owner of this page and hence can\'t rename it',
	'NeedRedirect'				=> 'Create redirect to the new page on the old page',
	'RedirectCreated'			=> 'In the page %1 created redirect to the new one',

	'UserSettings'				=> 'User settings',
	'UserSettingsGeneral'		=> 'General',
	'UserSettingsNotifications'	=> 'Notifications',

	'NotifyMinorEdit'			=> 'Notify also minor edit',
	'NotifyPageEdit'			=> 'Edit',
	'NotifyComment'				=> 'Comment',
	'NotifyOff'					=> 'Off',
	'NotifyAlways'				=> 'Always',
	'NotifyPending'				=> 'Pending',
	'NotifyDigest'				=> 'Digest',
	'NotifyPendingPageTip'		=> 'Only one notification is sent for the first page change of a page you are watching.',
	'NotifyPendingCommentTip'	=> 'Only one notification is sent for the first comment to a page you are watching.',
	'NotifyPendingTip'			=> 'Notification is automatically re-enabled when you visit the current version of the page.',

	'FurtherPending'			=> 'There will be no other notifications in case of further changes unless you visit this page.',

	'UserSettingsEmailMe'		=> 'Email me when ...',

	'UserSettingsExtended'		=> 'Extended',
	'UserSettingsOther'			=> 'Other settings',
	'UserSpace'					=> 'User space',
	'ChooseTheme'				=> 'Choose theme',

	'CreatePage'				=> 'Create this page',
	'CreateNewPage'				=> 'Create a new page',
	'CreateNewPageText'			=> 'Create',
	'CreateNewPageTip'			=> 'Create a new page',

	'CreateRandomPage'			=> 'Create a random page:',
	'CreateSubPage'				=> 'Create a sub page in the cluster:',
	'CreatePageParentCluster'	=> 'Create a page in the parent cluster:',
	'CreatePageDenied'			=> 'You do not have the necessary access rights.',
	'CreatePageDeniedAddress'	=> 'You do not have the right to create the page at this address.',
	'PageAlreadyExists'			=> 'According to the address provided the page %1 already exists.',
	'PageAlreadyExistsEdit'		=> 'Do you want %1 it?',
	'PageAlreadyExistsEdit2'	=> 'edit',
	'PageAlreadyExistsEditDenied'	=> 'You can\'t edit it.',

	'SimilarPagesExists'		=> 'Similar pages to %1 already exists:',
	'SimilarPagesHint'			=> 'There are existing similar pages to %1:',

	'PageReservedWord'			=> 'You can\'t use %1 as the part of the address as it\'s a reserved word.',
	'UserReservedWord'			=> 'User names cannot contain %1 as it\'s a reserved word.',

	'DontRedirect'				=> 'Do not allow automatic redirection by action Redirect.',
	'SendWatchEmail'			=> 'Send notifying email when someone (except you) changes any page you are watching',
	'AllowIntercom'				=> 'Allow personal messages from users of the system',
	'AllowMassemail'			=> 'Administrators can email me information',
	'HideLastSession'			=> 'Hide last session',
	'ValidateIP'				=> 'Tying session to IP',
	'AnonymousPub'				=> 'Preferably, published anonymously (to hide the name)',
	'PageMoved'					=> 'This page moved. You can find it at',
	'RedirectedFrom'			=> 'Redirected from %1',
	'RedirectedTo'				=> 'Redirected to',
	'CurrentPassword'			=> 'Current password',
	'NewPassword'				=> 'New password',
	'YouWantChangePassword'		=> 'Change password',
	'ChangePasswordButton'		=> 'Change password',
	'PasswordChanged'			=> 'Password changed',
	'EmailWelcome'				=> 'You\'ve registered at ',
	'EmailRegistered'			=> 'You\'ve successfully registered at %1.' . "\n" . 'Your username: %2' . "\n\n",
	'EmailVerify'				=> 'If you want to receive notifications, you must verify your email address. Please click on or copy the following link to a web browser: ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Please return to the Wiki and login with your new username and password.',
	'EmailRegisteredIgnore'		=> 'If you did not request this registration, ignore this message and nothing will happen.',
	'EmailDoNotReply'			=> 'Do not reply to this message.',
	'EmailReverify'				=> 'Someone (maybe you) submitted your email as notification address at %1.' . "\n" . 'Your username: %2'."\n\n" . 'If you want to receive notifications, you need to approve your email. Please follow the link to do this.' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'Please verify your email',
	'EmailConfirmed'			=> 'Email successfully confirmed.',
	'EmailNotConfirmed'			=> 'Email cannot be confirmed. This may be due to an incorrect confirmation code or the email address may already be confirmed. You can check if the email address is already confirmed by logging in and viewing its status on your %1 page.',
	'EmailNotVerified'			=> 'Email not verified!',
	'EmailNotVerifiedDesc'		=> 'You will not receive notification of changes or comments of watched pages, ' .
									'or messages from other users. Also, you <strong>will not be able to recover a forgotten password</strong>, ' .
									'until your email address is confirmed by following the link in the email sent to you. ' .
									'If, within days after registration you do not receive an email, ask for it again by clicking ',

	'ForgotPasswordHint'		=> 'Enter your login and email address,' . "\n" . 'then an email with instructions will be send to you.',
	'ForgotPassword'			=> 'Forgot password?',
	'UserNotFound'				=> 'User with this name or email address was not found.',
	'NotConfirmedEmail'			=> 'Your email address is not confirmed.<br>Mail can\'t be send to a non-confirmed address.',
	'EmailForgotSubject'		=> 'Password renewal for ',
	'EmailForgotMessage'		=> 'Someone (maybe you) forgot your password for %1.' . "\n" . 'Your login: %2'."\n\n" . 'Click the link or copy it to the browser address line to change your password.' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> 'Password recovery instruction was sent to you by email.',
	'WrongCode'					=> 'Wrong code',
	'ChangePasswordForUser'		=> '%1\'s password change',

	'Watchers'					=> 'List of watchers for %1',
	'WatchersFor'				=> 'Watchers for',
	'NoWatchers'				=> 'There are no watchers for %1',
	'NotOwnerToViewWatchers'	=> 'You are not the owner of this page and you can\'t see list of watchers for it.',

	// thumbnail
	'TbnError'					=> 'Error creating thumbnail: %1',
	'TbnImageAreaTooBig'		=> 'File with dimensions greater than %1',
	'TbnImageMissing'			=> 'File seems to be missing: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Generate the password hash for your <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Import in cluster:',
	'ImportWhat'				=> 'XML file to import:',
	'ImportButton'				=> 'Import',
	'ImportSuccess'				=> 'Imported successfully.',
	'ImportFailed'				=> 'IMPORT failed.',
	'ImportHint'				=> 'Please provide a cluster you want to import to, no relative addressing.',
	'ImportAttention'			=> 'Attention: Overwrites the same pages in the cluster.',
	'ImportNote'				=> 'Imported page',

	// mywatches action
	'WatchedPages'				=> 'List of all pages you follow for changes ',
	'UnwatchedPages'			=> 'List of all pages you do not watch',
	'NoWatchedPages'			=> 'You have no watched pages.',
	'NoUnwatchedPages'			=> 'You watch for changes in all pages.',
	'ViewWatchedPages'			=> 'Show watched pages',
	'ViewUnwatchedPages'		=> 'Show unwatched page',
	'NotLoggedInWatches'		=> 'You are not logged in, hence we couldn\'t identify your list of watches.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'List of all pages you watched that were edited by others since your last editing',
	'ResetChangesWatches'		=> 'reset the list of changes',
	'NoChangesWatches'			=> 'Among your watched pages are no changes...',

	// whatsnew action
	'NewCommentAdded'			=> 'Added new comment',
	'NewFileAdded'				=> 'Added new file',
	'NewPageCreated'			=> 'Created a new page',
	'NewRevisionAdded'			=> 'Changed page',
	'Cluster'					=> 'cluster',
	'PageDeleted'				=> 'Page deleted',
	'CommentDeleted'			=> 'Comment deleted',
	'FileDeleted'				=> 'File deleted',

	// users action
	'UsersSearch'				=> 'Find Users',
	'UsersOpenProfile'			=> 'View Profile',
	'UsersNoMatching'			=> 'Matching users not found. Try a less strict search criteria.',
	'UsersName'					=> 'Name',
	'UsersPages'				=> 'Pages',
	'UsersChanges'				=> 'Changes',
	'UsersSubscription'			=> 'Subscription',
	'UsersWatches'				=> 'Watches',
	'UsersComments'				=> 'Comments',
	'UsersUploads'				=> 'Uploads',
	'UploadQuota'				=> 'Used space',
	'UploadQuotaTip'			=> 'Upload Space Quota',
	'UsersLogins'				=> 'Logins',
	'UsersRevisions'			=> 'Revisions',
	'UsersSignup'				=> 'Signup',
	'UsersLastSession'			=> 'Last session',
	'UsersNotFound'				=> 'User %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'UsersProfile'				=> 'Profile',
	'UsersContact'				=> 'Contact',
	'UsersList'					=> 'View the entire list of users',
	'UsersNA'					=> '[not set]',
	'UsersNA2'					=> '[No]',
	'UsersSignupDate'			=> 'Signup date',
	'UsersGroupMembership'		=> 'Group membership',
	'UsersPersonalInfo'			=> 'Personal info',
	'UsersOwnedPages'			=> 'Owned pages:',
	'UsersCommentsPosted'		=> 'Comments posted:',
	'UsersFilesUploaded'		=> 'Files uploaded:',
	'UsersRevisionsMade'		=> 'Revisions made:',
	'UsersDocsSortName'			=> '[Sort by name]',
	'UsersDocsSortCreation'		=> '[Sort by creation date]',
	'UsersChangesSortAsc'		=> '[Sort ascending]',
	'UsersChangesSortDesc'		=> '[Sort descending]',
	'UsersSessionNA'			=> '[not recorded]',
	'UsersSessionHidden'		=> '[hidden]',
	'IntercomSubject'			=> 'Subject:',
	'IntercomMessage'			=> 'Message:',
	'IntercomCopy'				=> 'Send me a copy',
	'IntercomSubjectN'			=> '[start a new topic]',
	'IntercomDisabled'			=> 'Sorry, you do not want or cannot receive personal messages.',
	'IntercomHint'				=> 'Please log in first and follow the link again, if you want to answer the personal message you have received.',
	'IntercomDesc'				=> 'Note: Sending personal messages carried on the email recipient without disclosing your address. The recipient will be able to respond to you, using a similar form on your profile page. ',
	'PMOversized'				=> 'The length of the message exceeds the maximum allowed size by %1. Please shorten your message and submit again.',
	'PMFlooded'					=> 'The interval between sending personal messages should not be less than %1 seconds.',
	'PMSent'					=> 'Personal message was successfully sent to the user.',
	'PMBody'					=> 'This message has been sent to you by the user %1.',
	'PMBodyCopy'				=> 'You sent the following message to the user %1.',
	'PMReply'					=> 'To answer this email, click on the following link (do not use the Reply button / Reply in mailer):',
	'PMNotLoggedIn'				=> 'You are not registered in the system and cannot send personal messages to users.',

	// admin_replace action
	'ReplaceText'				=> 'Replace text',
	'TextOriginal'				=> 'Original text:',
	'TextReplacement'			=> 'Replacement text:',
	'ReplaceTextRegex'			=> 'Use regular expressions',
	'Namespace'					=> 'Namespace:',
	'ReplaceTextCluster'		=> 'Search and replace only within this cluster:',
	'ReplaceTextEditPages'		=> 'Replace text in page contents',
	'ReplaceTextEditComments'	=> 'Replace text in comments',
	'ReplaceTextEditTitles'		=> 'Replace text in page titles',
	'ReplaceTextGiveTarget'		=> 'You must specify the string to be replaced.',
	'ReplaceTextNoNamespace'	=> 'You must select at least one namespace.',
	'ReplaceTextNoDifference'	=> 'There is no difference between replace text and target text.',
	'ReplaceTextNoOption'		=> 'You must select at least one of the replacement options.',
	'ReplaceTextPagesEdit'		=> 'Replace %1 with %2 in the text of the following %3 pages:',
	'ReplaceTextTitlesEdit'		=> 'Replace %1 with %2 in the titles of the following %3 pages:',
	'ReplaceTextReplace'		=> 'Replace',
	'ReplaceTextSuccess'		=> '%1 has been replaced with %2 in %3 pages.',
	'ReplaceTextNoMatch'		=> 'No pages were found containing the string %1.',
	'ReplaceTextNoTitleMatch'	=> 'No pages were found which title contains %1.',
	'ReplaceTextEditFailed'		=> 'Replacing text failed',
	'ReplaceTextTitleTooBig'	=> 'Original or replacement text is too big for title.',
	'ReplaceTextReturn'			=> 'Return to form',
	'ReplaceTextWarning'		=> 'Warning: There are %1 pages that already contain the replacement string, %2. If you make this replacement you will not be able to separate your replacements from these strings.',
	'ReplaceTextBlankWarning'	=> 'Warning: Because the replacement string is blank, this operation will not be reversible.',
	'ReplaceTextEditSummary'	=> 'Text replacement: %1 → %2',
	'InvertSelection'			=> 'Invert selection',

	// Properties
	'PropertiesFor'				=> 'Page properties for %1',
	'MetaTag'					=> 'Tag',
	'MetaTitle'					=> 'Title',
	'MetaKeywords'				=> 'Keywords',
	'MetaDescription'			=> 'Description',
	'On'						=> 'On',
	'Off'						=> 'Off',
	'Registered'				=> 'Registered',
	'MetaComments'				=> 'Show comments',
	'MetaFiles'					=> 'Show files panel',
	'MetaToc'					=> 'Show table of contents',
	'MetaIndex'					=> 'Show cluster section panel',
	'MetaIndexMode'				=> 'Show Level Mode',
	'MetaIndexFull'				=> 'Tree',
	'MetaIndexUpper'			=> 'Upper',
	'MetaIndexLower'			=> 'Lower',
	'MetaHtml'					=> 'HTML support for page',
	'MetaSafeHtml'				=> 'Filtering of unsafe HTML',
	'MetaTypografica'			=> 'Typographical Proofreader',
	'MetaNoIndex'				=> 'Block search engines',
	'SettingsID'				=> 'Page ID',
	'SettingsSize'				=> 'Size',
	'SettingsSizeTip'			=> 'source / compiled',
	'SettingsCreated'			=> 'Created',
	'SettingsCurrent'			=> 'Modified',
	'SettingsTotalRevs'			=> 'Revisions',
	'SettingsTotalComs'			=> 'Comments',
	'SettingsWatchers'			=> 'Watchers',
	'SettingsHits'				=> 'Views',
	'SettingsText'				=> 'Settings',
	'SettingsEdit'				=> 'Edit',
	'SettingsRevisions'			=> 'Revisions',
	'SettingsClone'				=> 'Clone',
	'SettingsRename'			=> 'Rename',
	'MassRename'				=> 'for entire cluster',
	'SettingsRemove'			=> 'Remove',
	'SettingsPurge'				=> 'Purge',
	'SettingsModerate'			=> 'Moderate',
	'SettingsPermissions'		=> 'Permissions',
	'AclForEntireCluster'		=> 'for entire cluster',
	'SettingsAttachments'		=> 'Attachments',
	'SettingsUpload'			=> 'Upload',
	'SettingsCategories'		=> 'Categories',
	'SettingsLanguages'			=> 'Languages',
	'SettingsReferrers'			=> 'Referrers',
	'SettingsWatch'				=> 'Watch',
	'SettingsLatex'				=> 'LaTeX version',
	'SettingsXML'				=> 'Export to XML',
	'NeedToChangeLang'			=> 'Unsupported page language %1 needs to be changed.',
	'SetLang'					=> 'Language of this page',
	'SetMenuLabel'				=> 'Menu label',
	'SetShowMenuLabel'			=> 'Show in navigation',

	// upload
	'UploadFiles'				=> 'Upload files',
	'UploadFor'					=> 'File upload:',
	'UploadButton'				=> 'Upload',
	'UploadGlobalText'			=> 'for public access',
	'UploadGlobal'				=> 'global',
	'UploadLocalText'			=> 'only for users allowed to view current page',
	'UploadAsName'				=> 'Name:',
	'UploadOverwrite'			=> 'Overwrite existing files',
	'FileDesc'					=> 'Description:',
	'UploadForbidden'			=> 'You are not allowed to upload files here.',
	'UploadOverwriteDenied'		=> 'Only the file owner or administrator can overwrite the %1 file.',
	'UploadNoFile'				=> 'There was no file in form, for some reason.',
	'UploadMaxSizeReached'		=> 'File size is over allowed limit!',
	'UploadDirNotWritable'		=> 'File directory is not writable!',
	'UploadNotAPicture'			=> 'Picture uploads only are allowed. What are you trying to upload?',
	'UploadEmptyExtension'		=> 'The file name and the extension can not be empty.',
	'FilenameTooLong'			=> 'Filenames may not be longer than 240 bytes.',
	'BannedFiletype'			=> '%1 is not a permitted file type.',
	'PermittedFiletype'			=> 'Permitted file types:',
	'UploadMimeMismatch'		=> 'File extension %1 does not match the detected MIME type of the file (%2).',
	'UploadBadMime'				=> 'Files of the MIME type %1 are not allowed to be uploaded.',
	'FileIsDuplicate'			=> 'The upload is an exact duplicate of the current version.',
	'FileHasDuplicate'			=> 'This file is a duplicate of the following files:',

	'UploadMaxFileQuota'		=> 'You have reached your upload limit. This file can not be uploaded',
	'UploadDone'				=> 'File upload successful',
	'UploadFileForbidden'		=> 'File access prohibited',
	'UploadTitle'				=> 'Files accessible from this page',
	'UploadTitleGlobal'			=> 'Files accessible from anywhere',

	'UploadFile'				=> 'Upload',
	'UploadMax'					=> 'No more than ',
	'UploadUsedStorage'			=> 'Storage in use ',

	// attachments
	'Attachments'				=> 'Attachments',
	'Attachment'				=> 'Attachment',
	'AttachmentsToPage'			=> 'to page',
	'AttachmentsToCluster'		=> 'cluster',
	'AttachmentsByTime'			=> 'by time',
	'AttachmentsGlobal'			=> 'global',
	'AttachmentsAll'			=> 'all',
	'AttachmentsLinked'			=> 'used',

	'FileViewProperties'		=> 'View',
	'FileViewPropertiesTip'		=> 'View the metadata of this file',
	'FileEditProperties'		=> 'Edit',
	'FileEditPropertiesTip'		=> 'Edit the metadata of this file',
	'FileEditedMeta'			=> 'Updated metadata of this file',
	'FileEditDenied'			=> 'You are not allowed to edit this file',
	'FileLabel'					=> 'Label',
	'FileLabelTip'				=> 'Label this file',
	'FileRemove'				=> 'Remove',
	'FileRemovedFromDB'			=> 'File removed from database',
	'FileRemovedFromFS'			=> 'File erased from physical hosting',
	'FileRemovedFromFSError'	=> 'It seems to be impossible to erase file!',
	'FileRemoveConfirm'			=> 'Sure to remove this file?',
	'FileRemoveDenied'			=> 'You are not allowed to remove this file',
	'FileNotFound'				=> 'File not found.',

	'FileSearch'				=> 'Find File',
	'UploadBy'					=> 'Uploaded by:',
	'FileAdded'					=> 'Added:',
	'FileModified'				=> 'Modified:',
	'FileSize'					=> 'Size:',
	'FileDimension'				=> 'Dimension:',
	'MimeType'					=> 'Mimetype:',
	'FileName'					=> 'Name:',
	'FileCaption'				=> 'Caption:',
	'FileAuthor'				=> 'Author:',
	'FileSource'				=> 'Source:',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> 'Attached to:',
	'FileSyntax'				=> 'Syntax:',
	'FileAbsolutePath'			=> 'absolute path',
	'FileRelativePath'			=> 'relative path',
	'FileUsage'					=> 'File usage:',
	'FileUsageText'				=> 'The following pages link to this file:',
	'NoFileUsage'				=> 'No pages link to this file.',

	'FileSortExt'				=> 'extension',
	'FileSortName'				=> 'name',
	'FileSortSize'				=> 'size',
	'FileSortTime'				=> 'created',

	'SortBy'					=> 'Sort by',
	'Ascending'					=> 'ascending',
	'Decending'					=> 'decending',

	'Files0'					=> 'Attach Files',
	'Files1'					=> 'Show Files (1 file)',
	'FilesN'					=> 'Show Files (%1 files)',
	'Files'						=> 'Files',
	'File'						=> 'File',
	'ShowFiles'					=> 'Display files / form',
	'HideFiles'					=> 'Hide files / form',
	'DoShowFiles'				=> 'Show files lists by default',
	'NoAttachments'				=> 'There are no attached files to display.',

	'RegistrationLang'			=> 'Your language',
	'InvalidWikiName'			=> 'Chosen name is invalid',
	'InvalidUserName'			=> 'Chosen user name is invalid',
	'Bookmarks'					=> 'Bookmarks',
	'ReallyDeleteComment'		=> 'Do you really want to DELETE this comment?<br>There is no undo for this action!',
	'ReallyDeleteRevision'		=> 'Do you really want to DELETE this revision?<br>There is no undo for this action!',

	'RegistrationClosed'		=> 'Registration is not available here. Try to contact site administrator.',
	'AclAreYouSure'				=> 'You are going to change ACLs of this page and all of its subpages. Continue?',

	'BookmarkDeleteSelected'	=> 'Delete selected',
	'BookmarkMark'				=> 'Mark',
	'BookmarkNumber'			=> 'No.',
	'BookmarkNone'				=> 'You have no bookmarks.',
	'BookmarkTitle'				=> 'Bookmark title',
	'BookmarkPage'				=> 'Page',
	'BookmarkSaveChanges'		=> 'Save changes',
	'BookmarksAddPage'			=> 'Set a bookmark for the following page',
	'BookmarkAlreadyExists'		=> 'The bookmark already exists.',

	'PoweredBy'					=> 'Powered by',

	'MassRenaming'				=> 'Rename entire cluster',
	'MassNewName'				=> 'Enter new name for this cluster',
	'MassNeedRedirect'			=> 'Create redirect to the new pages on the old pages',

	// pagination
	'ToOverview'				=> 'Back to overview',
	'Overview'					=> 'Overview',
	'ToThePage'					=> 'To page:',
	'Next'						=> 'Next',
	'Prev'						=> 'Prev',
	'NextAcr'					=> 'Next',
	'PrevAcr'					=> 'Prev',
	'Back'						=> 'Back',

	// filter
	'Filter'					=> 'Filter',
	'OptionalFilters'			=> 'Optional filters:',
	'Any'						=> 'Any',

	// My Groups
	'UserGroups'				=> 'Groups of users',
	'MyGroups'					=> 'Group Associations',
	'Group'						=> 'group',
	'Groups'					=> 'groups',

	// license action
	'DistributedUnder'			=> 'Material is distributed under',
	'AuthorsDisplayHint'		=> 'The list of authors will be displayed when saving the page.',
	'AnonymousUsers'			=> 'Anonymous users',
	'License'					=> 'License',
	'LicenseArray'				=> [
		'1'		=> 'Attribution-NoDerivatives',
		'2'		=> 'Attribution-NonCommercial-ShareAlike',
		'3'		=> 'Attribution-NonCommercial-NoDerivatives',
		'4'		=> 'Attribution-ShareAlike',
		'5'		=> 'Attribution-NonCommercial',
		'6'		=> 'Attribution',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation License',
		'9'		=> 'Public Domain / Free Use',
		'10'	=> 'All Rights Reserved',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Public domain',
		'2'		=> 'Some rights reserved',
		'3'		=> 'All Rights Reserved',
	],

	// Cache
	'ClearCache'				=> 'Clear cache',
	'CacheCleared'				=> 'Cache cleared.',
	'ConfigCache'				=> 'Config cache',
	'FeedCache'					=> 'Feed cache',
	'PageCache'					=> 'Page cache',
	'SQLCache'					=> 'SQL cache',
	'TemplateCache'				=> 'Template cache',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Please specify a address of the resource with the Parameter URL. (e.g. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Feed Title',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Please specify a Feed with the Parameter URL. (e.g. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Could not load or parse feed',
	'FeedSource'				=> 'Source:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Recent changes',
	'ChangesXML'				=> 'Recent changes to the ',
	'CommentsXMLTitle'			=> ' - Recent comments',
	'CommentsXML'				=> 'Recent comments to the ',
	'NewsXMLTitle'				=> ' - Recent news',
	'NewsXML'					=> 'Recent news to the ',
	'RevisionXMLTip'			=> 'Click to view recent page revisions in XML format.',
	'CommentsXMLTip'			=> 'Click to view recent comments in XML format.',
	'ChangesXMLTip'				=> 'Click to view recent changes in XML format.',
	'NewsXMLTip'				=> 'Click to view recent news in XML format.',
	'RevisionsXML'				=> 'Revisions of ',
	'ExportClusterXML'			=> 'Export of entire cluster of ',
	'AccessDeniedXML'			=> 'You\'re not allowed to access this information.',

	'ChangesFeed'				=> 'Changes',
	'CommentsFeed'				=> 'Comments',
	'NewsFeed'					=> 'News',
	'RevisionsFeed'				=> 'Revisions of ',

	'LastModification'			=> 'Last Modification',

	// Captcha
	'Captcha'					=> 'Please type the word you read in the image',
	'CaptchaFailed'				=> 'You have entered the captcha word incorrectly. Please try again.',
	'CaptchaReload'				=> 'New Captcha',
	'CaptchaReloadWarning'		=> 'Sorry, cannot reload the captcha image, you will have to reload the page to do that',

	// news
	'News'						=> 'News',
	'NewsName'					=> 'Title:',
	'NewsNoName'				=> 'You forgot to add news headline.',
	'NewsNotAvailable'			=> 'No News available.',
	'NewsNoClusterDefined'		=> 'No News cluster defined.',
	'NewsDiscuss'				=> 'Discuss this article...',

	// blog
	'BlogNewTopic'				=> 'Create a new post',
	'NoPostAvailable'			=> 'No post available yet.',

	// Review
	'Reviewer'					=> 'Reviewer',
	'Reviewed'					=> 'reviewed',
	'Review'					=> 'review',
	'ReviewedBy'				=> 'reviewed by',
	'RemoveReview'				=> 'Remove review for this page',
	'SetReview'					=> 'Reviewed this page',
	'SetAsReviewed'				=> 'Set page as reviewed',
	'SetAsUnreviewed'			=> 'Set page as unreviewed',

	// word filter
	'PotentialSpam'				=> 'Identified Potential Spam',

	// moderation handler
	'Moderation'				=> 'Moderation',
	'Topics'					=> 'topics',
	'ModerateSection'			=> 'section / page ',

	'NotModerator'				=> 'You do not have authority to moderate this page / chapter',
	'ModerateDeleteTopic'		=> 'Delete topic / page',
	'ModerateDeletePosts'		=> 'Delete comments',
	'ModerateMove'				=> 'Move',
	'ModerateSplit'				=> 'Split / Move comments',
	'ModerateMerge'				=> 'Merge',
	'ModerateLock'				=> 'Lock',
	'ModerateUnlock'			=> 'Unlock',
	'ModerateAccept'			=> 'Accept',
	'ModerateDeleteConfirm'		=> 'Are you sure you want to <strong>remove</strong> the following topics?',
	'ModerateRenameConfirm'		=> 'Enter a new title for the selected page',
	'ModerateRenameExists'		=> 'Page with same name already exists! Choose a different name.',
	'ModerateRename1Only'		=> 'Note: only the first page you selected will be renamed!',
	'ModerateMovesConfirm'		=> 'Select the target partition to move the forum to',
	'ModerateMoveConfirm'		=> 'Select the forum or specify the cluster to move these topics. To move a page to the root of the site, type &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Specify the name of the cluster in which to place the page. To move a page to the root of the site, type &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operation aborted: In this section already exists topics with the same name %1. If you still need to transfer the above-mentioned topics, please rename them first.',
	'ModerateMoveNotExists'		=> 'The page / cluster does not exist. Please check the name and try again.',
	'ModerateMergeConfirm'		=> 'Choose a topic, which should combine the remaining',
	'ModerateMerge2Min'			=> 'To join you must select at least two topics!',
	'ModerateComDelConfirm'		=> 'Are you sure you want to <strong>remove</strong> %1 %2?',
	'ModerateComment'			=> 'Comment',
	'ModerateComments'			=> 'Comments',
	'ModerateSplitNewName'		=> 'Specify a name for a separable topic and select a separation schema',
	'ModerateSplitPageName'		=> 'Enter the name of the page / topic, where to move detachable comments, and select a separation schema',
	'ModerateSplitAllAfter'		=> 'Detach all the comments after the first selected (and including)',
	'ModerateSplitSelected'		=> 'Separated only selected comments (total %1)',
	'ModerateUserProfile'		=> 'profile',
	'ModerateNoItemChosen'		=> 'Please select at least one item via the Set button.',

	'ModerateSection2'			=> 'moderate section',
	'ModerateTopicsDeleted'		=> 'Selected topics successfully deleted.',
	'ModerateTopicsRelocated'	=> 'Selected topics successfully relocated.',
	'ModerateTopicsRenamed'		=> 'Topic successfully renamed.',
	'ModerateTopicsMerged'		=> 'Selected topics successfully merged.',
	'ModerateTopicsBlocked'		=> 'Selected topics successfully blocked',
	'ModerateTopicsUnlocked'	=> 'Selected topics successfully unlocked.',
	'ModerateTopicDeleted'		=> 'Topic has been successfully removed.',
	'ModeratePageMoved'			=> 'Page successfully moved.',
	'ModerateTopicRenamed'		=> 'Topic successfully renamed.',
	'ModerateTopicBlocked'		=> 'Topic successfully blocked',
	'ModerateTopicUnlocked'		=> 'Topic successfully unlocked.',
	'ModerateCommentsDeleted'	=> 'Selected comments removed successfully.',
	'ModerateCommentsSplit'		=> 'Selected comments successfully separated in a new topic.',
	'ModerateCommentsSplitFailed'	=> 'Note: For some reason separating the selected comments to a new topic failed.<br>Usually this should not happen, so please notify the site administrator.<br>As a precaution, the issue has been preserved in its original form.',
	'ModerateCommentsMoved'		=> 'Selected comments successfully migrated to the given page.',

	// forum
	'ForumSubforums'			=> 'Forum',
	'ForumTopic'				=> 'Topic',
	'ForumTopics'				=> 'Topics',
	'ForumPosts'				=> 'Posts',
	'ForumReplies'				=> 'Replies',
	'ForumAuthor'				=> 'Author',
	'ForumViews'				=> 'Views',
	'ForumCreated'				=> 'Created',
	'ForumComments'				=> 'Comments',
	'ForumLastComment'			=> 'Last comment',
	'ForumNoComments'			=> 'No comments',
	'ForumNoTopics'				=> 'There are no topics or posts in this forum.',
	'ForumNewTopic'				=> 'Start a new discussion',
	'ForumTopicName'			=> 'Topic name:',
	'ForumTopicSubmit'			=> 'Submit topic',
	'ForumNoTopicName'			=> 'Specify a name for the new page.',
	'ForumNewPosts'				=> 'new post',
	'ForumLocked'				=> 'section locked',
	'ForumUpdated'				=> 'updated',
	'ForumNoClusterDefined'		=> 'No Forum cluster defined.',
	'ForumOutsideCluster'		=> 'Ensure that the %1 action is located inside the forum cluster.',

	// password complexity
	'PwdCplxShort'				=> 'Password is too short.',
	'PwdCplxEquals'				=> 'Password contains the user name.',
	'PwdCplxWeak'				=> 'Password does not meet complexity requirements.',
	'PwdCplxDesc1'				=> 'Requirements for the password: ',
	'PwdCplxDesc2'				=> 'password should not be less than %1 characters',
	'PwdCplxDesc3'				=> 'must not contain your username',
	'PwdCplxDesc4'				=> 'should consist of ',
	'PwdCplxDesc41'				=> 'letters and numbers',
	'PwdCplxDesc42'				=> 'uppercase and lowercase letters and numbers',
	'PwdCplxDesc43'				=> 'uppercase and lowercase letters, digits and non-alphanumeric characters',
	'PwdCplxDesc5'				=> 'You can use any letters, numbers and special characters except spaces.',

	'PasswordTooShort'			=> 'Password too short.',
	'PasswordTooCommon'			=> 'That password is too common.',
	'PasswordSameAsUsername'	=> 'Your password is the same as your username.',
	'PasswordSameAsEmail'		=> 'Your password is the same as your email.',

	'Timezone'					=> 'Timezone',
	'DateFormat'				=> 'Date format',

	'LanguageArray'	=> [
		'ar' => 'Arabic',
		'bg' => 'Bulgarian',
		'cs' => 'Czech',
		'da' => 'Danish',
		'de' => 'German',
		'el' => 'Greek',
		'en' => 'English',
		'es' => 'Spanish',
		'et' => 'Estonian',
		'fa' => 'Persian',
		'fi' => 'Finnish',
		'fr' => 'French',
		'hi' => 'Hindi',
		'hu' => 'Hungarian',
		'id' => 'Indonesian',
		'it' => 'Italian',
		'ja' => 'Japanese',
		'ko' => 'Korean',
		'nl' => 'Dutch',
		'no' => 'Norwegian',
		'pl' => 'Polish',
		'pt' => 'Portuguese',
		'pt-br' => 'Portuguese-Brazil',
		'ro' => 'Romainian',
		'ru' => 'Russian',
		'sv' => 'Swedish',
		'ta' => 'Tamil',
		'uk' => 'Ukrainian',
		'zh' => 'Chinese',
		'zh-tw' => 'Chinese',
	],

	'AccountStatus'				=> 'Account status',
	'AccountStatusArray' => [
		'0' => 'active',
		'1' => 'pending',
		'2' => 'blocked',
		'3' => 'inactive',
	],

	'JustNow'		=> 'just now',
	'MinuteAgo'		=> 'a minute ago',
	'MinutesAgo'	=> '%1 minutes ago',
	'HourAgo'		=> 'an hour ago',
	'HoursAgo'		=> '%1 hours ago',
	'DayAgo'		=> 'yesterday',
	'DaysAgo'		=> '%1 days ago',
	'WeekAgo'		=> 'a week ago',
	'WeeksAgo'		=> '%1 weeks ago',
	'MonthAgo'		=> 'a month ago',
	'MonthsAgo'		=> '%1 months ago',
	'YearAgo'		=> 'a year ago',
	'YearsAgo'		=> '%1 years ago',

	'InAMoment'		=> 'in a moment',
	'InAMinute'		=> 'in a minute',
	'InMinutes'		=> 'in %1 minutes',
	'InAnHour'		=> 'in an hour',
	'InHours'		=> 'in %1 hours',
	'Tomorrow'		=> 'tomorrow',
	'InDays'		=> 'in %1 days',
	'InAWeek'		=> 'in a week',
	'InWeeks'		=> 'in %1 weeks',
	'InAMonth'		=> 'in a month',
	'InMonths'		=> 'in %1 months',
	'InAYear'		=> 'in a year',
	'InYears'		=> 'in %1 years',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['Byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['Byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'GP', 'TP', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['pixel', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Unknown action',
	'UnknownMethod'				=> 'Unknown method',
	'FormatterNotFound'			=> 'Formatter %1 not found',

	// log
	'LogAdminLoginSuccess'		=> 'Successful login into the administrative panel',
	'LogAdminLogout'			=> 'Logout of the administrative panel',
	'LogAdminLoginFailed'		=> '!!Failure to authorize access to administrative panel!!',
	'LogAdminLoginLocked'		=> 'Locked login to the administrative panel',
	'LogUserCookieForged'		=> '!!**An attempt to login on a forged cookie with login ##%1##**!!',
	'LogInvalidFormToken'		=> 'Potential CSRF attack in progress detected: %1',
	'LogRemovedPage'			=> '!!Removed page ##%1## (user %2)!!',
	'LogRemovedCluster'			=> '!!Removed **cluster** ##%1## (user %2)!!',
	'LogRemovedRevision'		=> '!!Removed revision ##%3## of page [[/%1]] (user %2)!!',
	'LogRemovedComment'			=> '!!Removed comment from %3 on page [[/%1]] (user %2)!!',
	'LogRemovedFile'			=> '!!Removed file ##%2## from page [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!Removed all comments of the page [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Removed all revisions of the page [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Removed all files, attached to [[/%1]]!!',
	'LogTopicLocked'			=> 'Forum topic is locked [[/%1]]',
	'LogTopicUnlocked'			=> 'Unlocked forum topic [[/%1]]',
	'LogAclUpdated'				=> 'Updated ACL page [[/%1]]',
	'LogOwnershipChanged'		=> 'Ownership of the page [[/%1]] transferred to the user ##%2##',
	'LogUserLoginFailed'		=> '!!Unsuccessful attempts to log in with ##~%1##!!',
	'LogClonedPage'				=> 'Page ##%1## cloned to [[/%2]]',
	'LogRenamedPage'			=> 'Page ##%1## renamed to [[/%2]]',
	'LogRenamedPage2'			=> '. The old page set as the link to the new one',
	'LogSplittedPage'			=> 'Comments on the page [[/%1]] split to page [[/%2]]',
	'LogMergedPages'			=> 'Pages %1 merged to page [[/%2]]',
	'LogUserPasswordReminded'	=> 'User ##%1## asked for the password recovery process to address ##%2##',
	'LogUserPasswordRecovered'	=> 'User ##%1## successfully recovered the forgotten password',
	'LogUserPasswordChanged'	=> 'User ##%1## successfully updated (changed) the password',
	'LogUserPasswordMismatch'	=> '!!User ##%1## failed to change the password: current password mismatch!!',
	'LogUserIPSwitched'			=> 'Unauthorized IP address change of the user %1 from %2 to %3',
	'LogPageImported'			=> 'Imported page [[/%1]]',
	'LogSaveNoRights'			=> 'No appropriate rights to save the page [[/%1]]',
	'LogPageCreated'			=> 'Created new page [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Updated page properties [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'The user got ownership of the page [[/%1]]',
	'LogFileUploadedLocal'		=> 'New file ##%2## uploaded to the page [[/%1]] (size %3)',
	'LogFileUploadedGlobal'		=> 'New file ##%2## uploaded to the global folder (size %3)',
	'LogPMSent'					=> 'Personal message ##%1## -> ##%2## successfully sent',
	'LogUserSimilarName'		=> 'There were attempts to register under the same user name: ##%1##',
	'LogUserEmailNotAllowed'	=> 'Email ##%1## not in allowed domains list',
	'LogRegisterTiming'			=> 'Registration failed, form time threshold is ##%1## seconds (was ##%2##)',
	'LogUserRegistered'			=> 'Successfully registered a new user ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Successfully activated email ##%1## of user ##%2##',
	'LogCommentPosted'			=> 'Added [[/%1 new comment(s)]] to page [[/%2]]',
	'LogUserLoginOK'			=> 'User ##%1## successfully logged in the system',
	'LogUserLoggedOut'			=> 'User ##%1## successfully logged out the system',
	'LogUserSessionContinued'	=> 'User ##%1## continued the suspended session',
	'LogUserSettingsUpdate'		=> 'User ##%1## updated personal settings',
	'LogPageEdited'				=> 'Edited page [[/%1]]',
	'LogCommentEdited'			=> 'Edited comment [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Updated file metadata for ##%2## from page [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Updated file categories for ##%2## from page [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'XML Sitemap generated',
	'LogReferrersPurged'		=> 'Maintenance: referrers purged',
	'LogRevisionsPurged'		=> 'Maintenance: outdated pages revisions purged',
	'LogDeletedPagesPurged'		=> 'Maintenance: deleted pages purged',
	'LogSystemLogPurged'		=> 'Maintenance: system log purged',
	'LogCachedPagesPurged'		=> 'Maintenance: cached pages purged',
	'LogSqlCachePurged'			=> 'Maintenance: cached sql results purged',
	'LogExpiredTokensPurged'	=> 'Maintenance: expired cookie_tokens purged',
	'LogErrorSplitComments'		=> 'Error when separating comments from the topic [[/%1]] a new topic ##%2##: page was not created',
	'LogCategoriesUpdated'		=> 'Updated page categories [[/%1]]',
	'LogCategoryCreated'		=> 'Created a new category //%1//',
	'LogCategoryRenamed'		=> 'Category ##%1## renamed to ##%2##',
	'LogCategoryDebundled'		=> 'Category ##%1## debundled',
	'LogCategoryGrouped'		=> 'Category ##%1## grouped with the word ##%2##',
	'LogCategoryRemoved'		=> 'Category ##%1## removed from the database',
	'LogThumbnailGeneration'	=> 'Thumbnail generation %1 sec.',

	'ErrorMinPHPVersion'		=> 'The PHP Version must be greater than <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' your server appears to be running <strong>' . PHP_VERSION . '</strong>.' .
									'  You should upgrade to a more recent PHP version for WackoWiki to work correctly.',

];
