<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Japanese',
		'code'		=> 'ja',
		'dir'		=> 'ltr',
		'locale'	=> 'ja_JP',
	],

	'date_formats'	 => [
		'default'	=> 'y年MM月dd日',
	],

	// common
	'AddButton'					=> '追加',
	'ArchiveButton'				=> 'アーカイブ',
	'CancelButton'				=> 'キャンセル',
	'ContinueButton'			=> '続行',
	'ConvertButton'				=> '変換',
	'CreateButton'				=> '作成',
	'DeleteButton'				=> '削除',
	'RemoveButton'				=> '削除',
	'RenameButton'				=> '名前を変更',
	'ResetButton'				=> 'リセット',
	'RestoreButton'				=> '復元',
	'SaveButton'				=> '保存',
	'SearchButton'				=> '検索',
	'SendButton'				=> '送信',
	'SetButton'					=> '設定',
	'SubmitButton'				=> '送信',
	'UpdateButton'				=> '更新',

	'FormInvalid'				=> '送信されたフォームが無効です。もう一度送信してください。',
	'UnitPixel'					=> 'ピクセル',
	'Number'					=> '数値',

	// logged in panel
	'AccountText'				=> 'アカウント',
	'AccountTip'				=> 'アカウントの設定',
	'AdminText'					=> '管理',
	'AdminTip'					=> '管理パネル',
	'LogoutLink'				=> 'ログアウト',
	'LogoutButton'				=> 'ログアウト',
	'LogoutAreYouSure'			=> '本当にログアウトしますか？',

	// registration panel
	'RegistrationWelcome'		=> 'アカウント作成:',
	'RegistrationButton'		=> 'アカウントを作成',
	'UserNameOwned'				=> 'このユーザー名は既に登録されています。他のユーザー名を選択してください。',
	'SiteRegistered'			=> 'サイト %1への登録に成功しました。',
	'RegistrationEmailInfo'		=> '有効なメールアドレス システムからのすべてのメールがこのアドレスに送信されます。 メールアドレスは公開されておらず、新しいパスワードを受け取りたい場合や、特定のニュースや通知をメールで受け取りたい場合にのみ使用されます。',
	'EmailConfirmHint'			=> '送信された手順のリンクをクリックして、電子メール アドレスを確認してください。<br>電子メール アドレスを確認しないと、紛失した可能性のあるパスワードを取得できなくなります。<br>さらに、最近のページの変更やコメントに関する通知も届きません。',
	'EmailConfirmRequired'		=> 'メールアドレスが確認できない場合は、ログインできません。',
	'NameTooShort'				=> 'ユーザー名が短すぎます。少なくとも %2 文字が必要です。',
	'NameTooLong'				=> 'ユーザー名が長すぎます。最大 %2 文字が許可されています。',
	'NameAlphanumOnly'			=> 'ユーザー名は %1 文字から %2 文字の間で、英数字のみを使用する必要があります。大文字はOKです。',
	'NameCamelCaseOnly'			=> 'ユーザー名は %1 と %2 文字の間でなければならず、WikiName フォーマットされています。',
	'NewUserAccount'			=> '新しいユーザーアカウント',

	'NewAccountSubject'			=> 'アカウントの登録',
	'NewAccountAdminCreated'	=> 'ユーザー %1 は、ユーザー名 "%2" のアカウントを作成しました。 登録を完了するには、以下のURL(単一行で入力されていることを確認してください)を参照し、独自のアクセスパスワードを設定してください:',
	'NewAccountUsername'		=> 'ユーザー名：',
	'AccountLanguage'			=> '言語：',
	'NewAccountEmail'			=> 'メールアドレス：',
	'NewAccountIP'				=> 'リモートIPアドレス：',
	'NewAccountSignupInfo'		=> '次のアカウントが作成されました:',

	'UserWaitingApproval'		=> 'サイト管理者にメールが送信されました。 管理者は、送信された情報を確認し、あなたのリクエストを承認または拒否します。',
	'UserRequiresApproval'		=> 'このユーザーの %1 へのアクセスを承認または拒否するには、管理者パネルにアクセスしてください。',
	'UserApprovalInfo'			=> '登録すると、リクエストがサイト管理者に送信され、承認が求められます。その後、詳細な手順が記載されたメールが届きます。',
	'UserApprovalHint'			=> 'アカウントの有効化に成功すると、特定の電子メールで通知されます。それまでは、ログインはできません。',

	'UserApprovalPending'		=> 'あなたのアカウントは承認待ちです。',
	'UserApprovalDenied'		=> 'あなたのアカウントはこのサイトへのアクセスが拒否されました。',

	'RegistrationApproved'		=> '登録が承認されました',
	'RegistrationDenied'		=> '登録が拒否されました',
	'PendingApproval'			=> '承認待ち',

	'UserApprovedInfo'			=> '%1へのアクセスが承認されました。',
	'UserDeniedInfo'			=> '%1 へのアクセスが拒否されました。',

	'RegistrationThreshold'		=> 'フォームに入力する時間は、%1秒以下であってはなりません',
	'Language'					=> '言語',

	// login panel
	'LoginWelcome'				=> 'ログイン',
	'CreateAccount'				=> 'アカウントの作成',
	'RegistrationLink'			=> 'アカウント作成',
	'LoginName'					=> 'ユーザー名',
	'Password'					=> 'パスワード',
	'LoginButton'				=> 'ログイン',
	'LoginLink'					=> 'ログイン',
	'PersistentCookie'			=> 'ログイン状態を保持',
	'Session'					=> 'セッション',
	'SessionTip'				=> '現在のセッションのパラメータ',
	'SessionDuration'			=> 'セッション時間',
	'SessionDurationSession'	=> 'ブラウザセッション',
	'SessionDurationDay'		=> '1日',
	'SessionDurationWeek'		=> '1週',
	'SessionDurationMonth'		=> '1ヶ月',
	'LoggedInAs'				=> '次のようにログインしています：',

	'ClearCookies'				=> 'すべてのCookieを削除',
	'BindSessionIp'				=> 'セッションを IP アドレスにバインド',
	'BindSessionIpOn'			=> '有効 (現在 IP %1)',
	'TrafficProtection'			=> 'トラフィック保護',
	'SessionEnds'				=> '現在のセッションは終了します',
	'LastVisit'					=> '前回の訪問は記録されました',

	'LoginIncorrect'			=> '入力したユーザー名またはパスワードは無効です。',
	'WelcomeBack'				=> 'おかえりなさい、 %1',
	'LoginAttemptsExceeded'		=> 'ログイン試行回数の上限を超えました。<br>ユーザー名とパスワードに加えて、以下のCAPTCHAを解決する必要があります。',

	// session notice
	'IPAddressChanged'			=> 'IPアドレスが %1 に変更されました( %2)',

	'SessionReplay'				=> 'リプレイのためセッションが終了しました。',
	'SessionObsolete'			=> 'セッションが古いです。',
	'SessionExpired'			=> 'セッションの有効期限が切れました。',
	'SessionTimeout'			=> 'タイムアウトのためセッションが終了しました。',
	'SessionInactivity'			=> '非アクティブのためセッションが終了しました。',
	'SessionUaChange'			=> 'ユーザーエージェントの変更によりセッションが終了しました。',
	'SessionTLSChange'			=> 'TLS変更によりセッションが終了しました。',
	'SessionIPChange'			=> 'IPの変更によりセッションが終了しました。',

	// other
	'Guest'						=> 'ゲスト',
	'Everybody'					=> '誰でも',
	'Help'						=> 'ヘルプ',
	'TopicSearchText'			=> 'タイトルのみを検索',
	'WordprocessorVersion'		=> 'ワードプロセッサのバージョン',

	// notifications
	'EmailHello'				=> 'こんにちは ',
	'EmailModerator'			=> 'モデレータ',
	'WatchedPageChanged'		=> 'ページの変更 ',
	'SomeoneChangedThisPage'	=> ' ページを変更しました。 ',
	'NewPageCreatedSubj'		=> '新しいページ',
	'NewPageCreatedBody'		=> 'ユーザー %1 が新しいページを作成しました: ',
	'FileUploadedSubj'			=> '新しいファイル',
	'FileUploadedBody'			=> 'ユーザー %1 が新しいファイルをアップロードしました: ',
	'FileReplacedBody'			=> 'ユーザー %1 がファイルを置き換えました: ',

	'ActionDenied'				=> 'ここではアクションが拒否されます。',
	'TocTitle'					=> '目次 ',
	'OuterLink2'				=> '送信リンク',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF ドキュメント',
	'RDFLink'					=> 'RDF ドキュメント',
	'EmailLink'					=> 'メールを書く (メールクライアント起動)',
	'GeoLink'					=> 'この場所を表示（地図アプリの起動）',
	'JabberLink'				=> 'XMPP (Jabber クライアント起動) 経由でチャット',
	'TelLink'					=> 'この電話番号を呼び出します(端末アプリの起動)',
	'PermaLink'					=> 'パーマリンク',
	'PermaLinkTip'				=> 'このページのこの版への固定リンク',
	'PermaLink0Tip'				=> 'このページへのパーマネントリンク',

	'ShowTip'					=> '表示モードで戻る',
	'ShowText'					=> 'ビュー',
	'WikieditAutocomplete'		=> 'WikiリンクをCtrl+Spaceで完成させる',
	'WikiEditInactiveJs'		=> 'WikiEditを使用するには、ブラウザでJavaScriptを有効にしてください。',
	'NumerateLinks'				=> '印刷ビュー内のリンクを番号付け',
	'Comment'					=> 'コメント',
	'Comments0'					=> 'コメントを追加',
	'Comments1'					=> 'コメントを読む (1 コメント)',
	'CommentsN'					=> 'コメントを読む (%1 コメント)',
	'Comments'					=> 'コメント',
	'CommentHint'				=> '<a href="%1">ログイン</a>または<a href="%2">アカウント作成</a>して、コメントを投稿してください。',
	'CommentEdited'				=> '編集済み',
	'Links'						=> 'リンク',
	'Version'					=> 'バージョン',

	// details formatter
	'ShowHideDetails'			=> '詳細',

	'PrivacyPolicy'				=> 'プライバシーポリシー',
	'TermsOfUse'				=> '利用規約',
	'AcceptTermsOfUse'			=> '私はサイトの利用規約を読み、理解し、同意します。',

	'ShowComments'				=> 'コメント/フォームを表示',
	'HideComments'				=> 'コメント/フォームを非表示',
	'AddComment'				=> 'このページにコメントを添付する:',
	'AddCommentTitle'			=> 'コメントのタイトル：',
	'CommentTitleRe'			=> 'Re:',
	'AddCommentButton'			=> 'コメントを追加',
	'HereLink'					=> 'ここ',
	'PageHandlerMoreTip'		=> '続き',

	'ThemeCorrupt'				=> 'テーマが破損しています',
	'InvalidNamespace'			=> '無効な名前空間が指定されました。',
	'DoesNotExists'				=> 'このページは存在しません。',
	'PromptCreate'				=> '<strong><a href="%1"></a></strong> を作成しますか？',
	'RevisionHint'				=> 'This is an old revision of <a href="%1">%2</a> from %3 edited by %4.',
	'ReadAccessDenied'			=> 'このページを読む権限がありません。',
	'ReadAccessDeniedHintGuest'	=> 'このページを読むにはログインしてください。',
	'PageDeletedInfo'			=> 'このページは削除されました。',
	'RevisionDeletedInfo'		=> 'このリビジョンは削除されました。',
	'CommentDeletedInfo'		=> 'このコメントは削除されました。',

	'LastEditedBy'				=> '最終編集者:',
	'YouAreOwner'				=> 'あなたはこのページの所有者です。',
	'Owner'						=> '所有者：',
	'Nobody'					=> '誰もいません',
	'TakeOwnership'				=> '所有権を取得',
	'FilesTip'					=> '添付ファイルの管理',
	'FilesText'					=> '添付ファイル',
	'DeleteTip'					=> 'ページ、ファイル、コメントを削除',
	'DeleteCommentTip'			=> 'コメントの削除',
	'DeleteText'				=> '削除',
	'AclText'					=> '権限',
	'AclTip'					=> '権限を編集',

	'PropertiesText'			=> 'プロパティー',
	'PropertiesTip'				=> 'ページのプロパティを編集',
	'EditTip'					=> 'このページを編集',
	'EditText'					=> '編集',
	'EditSection'				=> '節を編集 %1',
	'EditSectionHint'			=> '%1 セクション %2',
	'SectionHeadline'			=> '節を',
	'EditCommentTip'			=> 'コメントを編集',
	'EditComment'				=> 'このコメントを編集',
	'ReplyComment'				=> '返信',
	'ReplyCommentTip'			=> 'このコメントに返信',
	'RevisionTip'				=> 'ページのリビジョンを表示',
	'RevisionText'				=> 'リビジョン',
	'ReferrersTip'				=> 'このページを参照しているURLの一覧を表示',
	'ReferrersText'				=> 'リファラ',
	'ModerateTip'				=> 'トピックとフォーラムの投稿のモデレーション',
	'ModerateText'				=> 'モデレート',
	'SearchText'				=> '検索： ',

	'AclUpdated'				=> 'アクセス制御リストが更新されました',
	'AclGaveOwnership'			=> ' そして %1に所有権を与えました',
	'AclNoNewOwner'				=> 'ユーザー %1 が見つからなかったため、ページの所有権は譲渡されません。',
	'NewPageOwnership'			=> 'ページ所有権移転',
	'YouAreNewOwner'			=> '元所有者 %1 が所有権を譲渡しました ' . "\n" . '次のページをご覧になれば',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> '閲覧：',
	'AclWrite'					=> '編集：',
	'AclComment'				=> 'コメント：',
	'AclCreate'					=> '作成：',
	'AclUpload'					=> 'アップロード：',
	'AclFor'					=> '%1のアクセス制御リスト',
	'SetOwner'					=> '所有者を設定:',
	'OwnerDontChange'			=> '変更しない',
	'AclAccessDenied'			=> 'あなたはこのページの所有者ではありません。',
	'AclSyntaxError'			=> 'アクセス制御リスト構文エラー',
	'AclHelp'					=> '<code>*</code> - everyone is allowed<br>' .
									'<code>$</code> - 登録ユーザーのみ<br>' .
									'<code>!</code> - a preceding exclamation mark denies the respective right<br>' .
									'<code>[UserName]</code> - 許可されているユーザーの名前<br>' .
									'<code>[GroupName]</code> - 許可されたユーザーグループ (別名)<br>' .
									'<code>(空のリスト)</code> - ページ所有者のみアクセス可能',

	'AccessMode'				=> '閲覧の制限',
	'AccessDenied'				=> '拒否されました',
	'AccessPublic'				=> '公開',
	'AccessRegistered'			=> '登録済み',
	'AccessPrivate'				=> '非公開',
	'AccessCustom'				=> 'カスタム',

	// purge handler
	'PurgePage'					=> 'Purge page',
	'NotOwnerAndCantPurge'		=> 'あなたはページの所有者ではなく、削除できません。',
	'ReallyPurge'				=> '注意: ページのパージは元に戻せません!',
	'SelectPurgeOptions'		=> '必要なパージオプションを選択してください:',
	'PurgeComments'				=> 'ページのすべてのコメントを消去',
	'CommentsPurged'			=> 'すべてのコメントが削除されました。',
	'PurgeFiles'				=> 'すべての添付ファイルを削除',
	'FilesPurged'				=> 'すべての添付ファイルが削除されました。',
	'PurgeRevisions'			=> 'ページのすべてのリビジョンを消去',
	'RevisionsPurged'			=> '修正は消去されました。',
	'PurgeButton'				=> 'Purge',

	// categories handler
	'Categories'				=> 'カテゴリー',
	'CategoriesAssign'			=> '割り当て',
	'CategoriesEdit'			=> '編集',
	'Category'					=> 'カテゴリー',
	'CategoriesFor'				=> 'カテゴリ：',
	'CategoriesTip'				=> 'カテゴリの編集',
	'CategoriesText'			=> 'カテゴリー',
	'CategoriesUpdated'			=> 'カテゴリが更新されました',
	'CategoriesAlreadyExists'	=> '%1 このカテゴリはすでに存在しています。',
	'CategoriesAdded'			=> 'カテゴリ %1 が正常に追加されました。',
	'CategoriesRenamed'			=> 'カテゴリの名前を変更しました。',
	'CategoriesUngrouped'		=> 'カテゴリが正常に削除されました。',
	'CategoriesGrouped'			=> 'カテゴリが新しいグループに入力されました。',
	'NoMultilevelGrouping'		=> '複数のカテゴリをグループ化できません。',
	'CategoriesDeleted'			=> 'カテゴリはデータベースとすべてのページから削除されました。',
	'CategoriesAdd'				=> '新しいカテゴリを追加',
	'CategoryDescription'		=> '説明',
	'CategoriesAddGrouped'		=> 'カテゴリでグループ化',
	'CategoriesAddGroupedNo'	=> 'グループがありません。',
	'CategoriesRename'			=> 'カテゴリ %1 の名前を変更',
	'CategoriesRenameInfo'		=> '* 注意: 変更は、そのカテゴリに割り当てられているすべてのページに影響します。',
	'CategoriesGroup'			=> '%1 のグループカテゴリ',
	'CategoriesGroupInfo'		=> '* カテゴリを削除するにはformat@@0を選択してください。',
	'CategoriesNoGroup'			=> '[グループなし]',
	'CategoriesDelete'			=> 'Are you sure you want to remove category %1?',
	'CategoriesDeleteInfo'		=> '* 注意: 変更は、そのカテゴリに割り当てられているすべてのページに影響します。 単語にサブカテゴリがある場合、それらは削除されませんが、唯一の債務。',
	'CategoriesStoreInfo'		=> 'ページにカテゴリを割り当てるには、チェックボックスを選択します。',
	'CategoriesStoreButton'		=> 'カテゴリを保存',
	'CategoriesGroupButton'		=> 'グループ',
	'CategoriesEditInfo'		=> 'カテゴリリストを編集するには、ラジオボタンを選択します。',
	'NoCategoriesForThisLang'	=> 'この言語のカテゴリが指定されていません。',
	'PagesCategory'				=> 'ページカテゴリ',
	'CategoryNotExists'			=> 'カテゴリが存在しません。',
	'CategoryEmpty'				=> 'カテゴリが空です。',
	'NoCategorySelected'		=> 'カテゴリが選択されていません。',
	'NoCategoriesAssigned'		=> 'この言語に割り当てられたカテゴリがありません。',
	'TagCloud'					=> 'タグクラウド',
	'PagesTaggedWith'			=> '%1 でタグ付けされた %2 ページ',
	'CategoriesOfCluster'		=> 'クラスターの',
	'TaggedWithTip'				=> '%1 とタグ付けされたページを表示',

	// source handler
	'SourceText'				=> '由来',
	'SourceTip'					=> 'ソースを表示',
	'SourceCopyToClipboard'		=> 'クリップボードにコピー',
	'SourceFor'					=> '%1のソースを表示',

	// Groups action
	'GroupsSearch'				=> 'グループを検索',
	'GroupsNoMatching'			=> '一致するグループが見つかりません。より厳密な検索条件をお試しください。',
	'GroupsOpenProfile'			=> 'プロフィールを表示',
	'GroupsName'				=> 'グループ',
	'GroupsMembers'				=> 'メンバー',
	'GroupsDescription'			=> '説明',
	'GroupsCreated'				=> '作成',
	'GroupsNotFound'			=> 'Group %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'GroupsProfile'				=> 'プロフィール',
	'GroupsList'				=> 'グループのリスト全体を表示',
	'GroupSpace'				=> 'グループスペース',

	'MetaUpdated'				=> 'メタデータを更新しました',

	'PreviewButton'				=> 'プレビュー',
	'Preview'					=> 'プレビュー',
	'Chars'						=> '文字',
	'PageBody'					=> 'ページ本文',
	'EditNote'					=> '概要を編集',
	'EditNoteMissing'			=> '編集サマリがありません',
	'EditMinor'					=> '小変更',
	'MinorEditHide'				=> 'マイナー編集を非表示',
	'MinorEditShow'				=> '小規模な編集を表示',
	'PostAnonymously'			=> '名前を付けずに匿名で投稿する',
	'NotifyMe'					=> '新しいコメントとページの変更について通知する',
	'OverwriteAlert'			=> 'OVERWRITE アラート: このページは、編集中に他のユーザーによって変更されました。<br>変更をコピーして、このページを再編集してください。',
	'TextDbOversize'			=> '注意：あなたのテキストは、長さの制限を%1文字超えています。適度な文字数になるよう短縮してください。ヒント：残りのテキストを別のページに配置することができます。',
	'EditingRevisionWarning'	=> 'このページの古いリビジョンを編集しています．公開すると，それ以降の変更はすべて削除されます． <br>代わりに現在のリビジョンを編集したい場合があります。',
	'WriteAccessDenied'			=> 'このページへの書き込み権限がありません。',
	'EmptyPage'					=> 'ページの本文が空でした - 保存されていません!',
	'EmptyComment'				=> 'コメントの本文は空です - 保存されていません！',
	'CommentAccessDenied'		=> '申し訳ありませんが、このページにコメントを投稿することはできません。',
	'CommentFlooded'			=> '投稿の公開間隔は %1 秒以内でなければなりません。',
	'CommentAdded'				=> 'コメントを追加しました。',
	'YouAreNowTheOwner'			=> 'このページの所有者になりました。',
	'PageSaved'					=> 'ページバージョン %1 を保存しました。',
	'CommentSaved'				=> 'コメントを保存しました。',

	'RevisionsFor'				=> '履歴 %1',
	'DefaultDiffMode'			=> 'デフォルトの差分モード',
	'DiffMode'		=> [
		'0'		=> '完全なディフ',
		'1'		=> 'Simple diff',
		'2'		=> 'ソース',
		'3'		=> '横に並べる',
		'4'		=> 'インライン',
		'5'		=> 'マージ済み',
		'6'		=> '統合された',
		'7'		=> 'コンテキスト',
	],

	'PreviousEdit'				=> '前のリビジョン',
	'NextEdit'					=> '次のリビジョン',

	'Diff'						=> '差分',
	'PreviousVersion'			=> '古い版',
	'LatestVersion'				=> '最新版',
	'NextVersion'				=> '新しい版',

	'ShowDifferencesButton'		=> '差分を表示',
	'CancelReturnButton'		=> 'キャンセルし、ページに戻ります',
	'Comparison'				=> '%1 のリビジョンの違い',
	'RevisionAsOf'				=> 'リビジョン %1:',
	'SimpleDiffAdditions'		=> '追加:',
	'SimpleDiffDeletions'		=> '削除:',
	'NoDifferences'				=> '違いはありません。',
	'ReEditOldRevision'			=> 'このリビジョンを再編集する',

	'ExternalPages'				=> 'External pages linking to %1 (%2) (<a href="%3">see list of domains</a>):',
	'ExternalPagesGlobal'		=> 'Sites linking to this WackoWiki (%2) (<a href="%1">see list of domains</a>):',
	'Last24Hours'				=> '直近24時間',
	'LastDays'					=> '直近の %1 日',
	'DomainsSitesPages'			=> 'Domains/sites pages linking to  %1 (%2)  (<a href="%3">see list of different URLs</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domains/sites linking to this WackoWiki (<a href="%1">see list of different URLs</a>):',
	'ViewReferrersPage'			=> 'ページへ',
	'ViewReferrersPerPage'		=> '/ ページ',
	'ViewReferrersByTime'		=> '時間別',
	'ViewReferrersGlobal'		=> 'グローバル',
	'NoneReferrers'				=> 'なし',
	'NotOwnerCantDelete'		=> 'このページの所有者ではないため削除できません',

	// remove
	'RemovePage'				=> 'ページを削除',
	'RemoveRevision'			=> 'リビジョンを削除',
	'RemoveComment'				=> 'コメントの削除',
	'RemoveCluster'				=> 'クラスターのすべてのページを削除',
	'RemoveDontKeep'			=> '削除されたページとコメントのコピーを保存しない',
	'RemoveDontKeepPurge'		=> '削除されたファイル、リビジョン、コメントのコピーを保存しない',
	'RemoveDontKeepRevision'	=> '削除されたリビジョンのコピーを保存しない',
	'RemoveDontKeepComment'		=> '削除されたコメントのコピーを保存しない',
	'RemoveDontKeepFile'		=> '削除されたファイルのコピーを保存しない',
	'ReferrersRemoved'			=> 'リファラーを削除しました。',
	'LinksRemoved'				=> 'リンクを削除しました。',
	'CategoriesRemoved'			=> 'ページカテゴリを削除しました。',
	'AclsRemoved'				=> 'ページaclsが削除されました。',
	'BookmarksRemoved'			=> 'ブックマークを削除しました。',
	'WatchesRemoved'			=> 'ウォッチを削除しました。',
	'CommentsRemoved'			=> '削除したページからのコメント。',
	'FilesRemoved'				=> 'ファイルが削除されました。',
	'PageRemoved'				=> 'ページを削除しました。',
	'PageCachePurged'			=> 'キャッシュを削除しました',
	'ClusterRemoved'			=> 'クラスターのすべてのページが削除されました。',
	'RevisionRemoved'			=> 'リビジョン %1 が削除されました。',
	'RevisionsRemoved'			=> 'リビジョンを削除しました。',
	'ActionHaveNoUndo'			=> 'この処理は取り消しできません。',

	// restore
	'PageRestored'				=> 'ページが復元されました。',
	'RevisionRestored'			=> 'リビジョンが復元されました。',
	'LocalFilesRestored'		=> 'ローカルファイルが復元されました。',

	'PrintVersion'				=> 'バージョンを印刷',
	'PrintText'					=> '印刷',
	'LinkedPages'				=> 'リンクされたページ:',
	'NoLinkedPages'				=> 'リンクされたページはありません',
	'ReferringPages'			=> '参照ページ:',
	'NoReferringPages'			=> '参照ページがありません',
	'Footnotes'					=> '脚注:',
	'Footnote'					=> '脚注:',
	'MostPopularPages'			=> '最も閲覧されているページ',
	'MostCommentedPages'		=> '最もコメントされたページ',
	'NoAccessToSourcePage'		=> 'アクションのソースページを読み取る権限がありません。',
	'SourcePageDoesntExist'		=> 'アクションのソースページがまだ存在しません',
	'NotLoggedInThusEdited'		=> 'ログインしていないため、編集したページを特定できませんでした。',
	'DidntEditAnyPage'			=> 'まだページを編集していません。',
	'NoPagesFound'				=> 'ページが見つかりません。',
	'MyChangesTitle1'			=> 'これはあなたが編集したページの一覧です。最後の変更によって順序付けされたページの一覧です',
	'MyChangesTitle2'			=> '最後の変更の時刻とともに、あなたが編集したページの一覧です',
	'OrderABC'					=> 'アルファベット順',
	'OrderCreation'				=> '日付順',
	'OrderChange'				=> '変化によって',
	'ListOwnedPages'			=> 'これはあなたが所有しているページの一覧です（アルファベット順に並べられています）',
	'ListOwnedPages2'			=> 'これはあなたが所有しているページの一覧です（日付順）',
	'ListOwnedPages3'			=> 'これはあなたが所有しているページの一覧です（変更順）',
	'NotLoggedInThusOwned'		=> 'ログインしていないため、ページを取得できませんでした。',
	'NoOrphaned'				=> '孤立したページはありません。',
	'NoRecentComments'			=> '最近のコメントはありません。',
	'LatestCommentBy'			=> '最新のコメント',
	'NoRecentlyCommented'		=> '最近コメントしたページはありません。',
	'NoDeletedPages'			=> '削除されたページは見つかりません。',
	'NoDeletedRevisions'		=> '削除されたリビジョンが見つかりません。',
	'NoDeletedFiles'			=> '削除されたファイルはありません。',
	'CommentsDisabled'			=> 'コメントは利用できません。',

	'SearchResults'				=> '検索結果： ',
	'NotFound'					=> '見つかりませんでした',
	'NoResultsFor'				=> '結果がありません： ',
	'SearchFor'					=> '検索：',
	'TopicSearchResults'		=> 'トピック検索結果 ',
	'NotFoundInTopics'			=> 'トピックに見つかりません',
	'FilterLangNotAvailable'	=> '選択した言語は利用できません！',

	'PostedBy'					=> '投稿者:',
	'ThisIsCommentOn'			=> 'これは以下のコメントです',
	'At'						=> 'に',
	'To'						=> '宛先',
	'By'						=> '作成者:',
	'From'						=> '送信元',
	'For'						=> '対象',
	'ReturnToCommented'			=> 'コメントされたページに戻る',
	'AbandonedComment'			=> 'このコメントが属するページは存在しません！',

	'PagesLinkingTo'			=> 'リンク先のページ',
	'NoPageLinkingTo'			=> 'リンクされているページがありません',
	'NoWantedPages'				=> '指定されたページはありません。よかった。',
	'RemoveWatch'				=> 'ウォッチをやめる',
	'SetWatch'					=> 'このページをウォッチする',
	'WatchText'					=> 'ウォッチ',
	'UnwatchText'				=> 'ウォッチ解除',
	'UserSettingsStored'		=> 'ユーザー設定を保存しました。',
	'LoggedOut'					=> 'あなたはログアウトしました。',
	'LoggedOutAuto'				=> 'セキュリティのため、お客様のセッションは終了しました。再度ログインしてください。',

	// user settings
	'EmailConfirmResent'		=> 'メール確認コードをあなたのアドレスに再送します。',
	'EmailConfirmNotSent'		=> '確認コードを送信できません。メールアドレスが指定されていません。',
	'Hello'						=> 'こんにちは',
	'UserName'					=> 'ユーザー名',
	'EmailAddress'				=> 'メールアドレス',
	'RealName'					=> 'フルネーム',
	'MenuItemsShown'			=> 'メニューアイテム表示',
	'RecordsPerPage'			=> 'ページごとのレコード',
	'DoShowComments'			=> 'デフォルトでコメントを表示',
	'DoubleclickEditing'		=> 'ダブルクリック編集',
	'UpdateSettingsButton'		=> 'アップデート設定',

	'AccountDisabled'			=> 'アカウントが無効またはブロックされている可能性があります。',
	'WrongPassword'				=> '間違ったパスワード！',
	'ConfirmPassword'			=> 'パスワードの確認',
	'Email'						=> 'メールアドレス',
	'MustBeWikiName'			=> 'ユーザー名は <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> でフォーマットする必要があります!',
	'SpecifyEmail'				=> 'メールアドレスを指定してください。',
	'NotAEmail'					=> '有効なメールアドレスではないようです。',
	'EmailTaken'				=> '入力されたメールアドレスは既に使用されています。',
	'EmailDomainNotAllowed'		=> '入力されたメールアドレス %1 は許可されたドメインリストにありません。',
	'PasswordsDidntMatch'		=> 'パスワードが一致しません。',
	'SpacesArentAllowed'		=> 'パスワードではスペースは使用できません。',
	'ListMyPages'				=> 'ページ一覧',
	'ListMyChanges'				=> '変更を一覧表示する',
	'ListMyWatches'				=> '閲覧ページの一覧',
	'ListMyChangesWatches'		=> '閲覧ページの変更',
	'SeeListOfPages'			=> '自分が所有しているページ(MyPages)と編集したページ(MyChanges)の一覧を表示します。',
	'AddBookmark'				=> '現在のページをブックマークに追加',
	'RemoveBookmark'			=> 'ブックマークから削除',

	'YourLanguage'				=> '言語を選択する',
	'ShowSpaces'				=> 'WikiNames にスペースを表示',
	'WrongPage4Redirect'		=> 'リダイレクトパラメータが間違っているためリダイレクトできません',
	'RedirectsToItself'			=> 'ページは自身にリダイレクトされます。',
	'ReallyDeletePage'			=> 'Do you really want to DELETE this page?<br>There is no undo for this action!<br><br>WARNING: Deleting this page will delete all page versions, comments, attachments, ACLs and referrers.',
	'CommentForWatchedPage'		=> 'ページの新しいコメント ',
	'SomeoneCommented'			=> ' あなたが見ているこのページにコメント: ',
	'AlertReferringPages'		=> 'このページはこれらのページで参照されています',

	'AccountDelete'				=> 'アカウントを削除',
	'AccountDeleteConfirm'		=> 'アカウントを削除してもよろしいですか？',
	'AccountDeleted'			=> 'アカウントが削除されました',
	'AccountDeleteHeader'		=> 'アカウント %1を削除',
	'AccountDeleteInfo'			=> '作成したデータ (電子メール、設定、添付ファイル、wikiエントリなど) のうち、できるだけ多くは削除されます。 ただし、添付ファイルやwikiエントリなどのデータは他のユーザーの作業を妨げることなく削除できないことに注意してください。 したがって、このようなデータは %1というアカウントに再割り当てられます。 削除されたすべてのアカウントのデータがこのアカウントに再割り当てられるため、別の削除されたアカウントのデータから作成したデータを区別することはできません。',
	'AccountDeleteWarning'		=> 'ユーザーアカウントの削除は元に戻すことができません。',
	'AccountDeleteHint'			=> 'あなたのアカウントはシステムから削除されます。したがって、現在の資格情報ではログインできなくなります。 再びこのアプリケーションのユーザーになることを選択した場合は、このアプリケーションの補助金を使用して行うことができます。',
	'AccountDeleteVerify'		=> '削除を確認するには、ログイン %1 を入力してください。送信すると、パスワードの確認が求められます。',

	'MarkRead'					=> '全て既読にする',
	'CurrentTime'				=> '現在',
	'Created'					=> '作成',
	'Modified'					=> '変更済み',

	'EditIcon'					=> '編集',
	'TreeClusterTitle'			=> 'クラスター %1の木',
	'TreeSiteTitle'				=> 'サイトツリー',
	'TreeEmpty'					=> '%1 にはサブページがありません',
	'TreeEmptyLevels'			=> '%1 には、指定された深さのレベルのサブページがありません。深さの値を増やしてください。',
	'TreeTooBig'				=> 'サブページが多すぎます',

	// clone handler
	'ClonePage'					=> 'ページを複製',
	'CloneText'					=> '複製',
	'CloneName'					=> 'このページのクローンの新しい名前を入力してください',
	'CloneButton'				=> '複製',
	'PageCloned'				=> 'ページ %1 はクローンされました。',
	'ClonedFrom'				=> '%1 からクローンされました。',
	'MassClone'					=> 'クラスター全体を複製',
	'MassCloning'				=> 'クローンクラスタ。',
	'CloneCannotRead'			=> '%1 ページを読み込めません。',
	'CloneCannotCreate'			=> '作成できないページ %1.',

	'CommentOffset'				=> 'コメントページ',
	'CommentOffsetFirst'		=> '最初のページ',
	'CommentOffsetLast'			=> '最後のページ',
	'SortComment'				=> 'コメントの並び替え',
	'SortCommentAsc'			=> '最下部に最近表示',
	'SortCommentDesc'			=> '最も新しい順',

	'RenamePage'				=> 'ページの名前を変更',
	'RenameText'				=> '名前を変更',
	'RenameTip'					=> 'ページの名前を変更',
	'NewName'					=> '新しいページ名を入力してください',
	'AlreadyExists'				=> 'ページ %1 は既に存在します。',
	'AlreadyNamed'				=> 'このページは既に %1と名付けられています。',
	'PageRenamed'				=> 'ページ名を変更しました。',
	'NewNameOfPage'				=> 'このページの新しい名前: ',
	'NotOwnerCantRename'		=> 'このページの所有者ではないため、名前を変更できません',
	'NeedRedirect'				=> '古いページの新しいページへのリダイレクトを作成',
	'RedirectCreated'			=> '%1 が作成されたページ内の新しいものへのリダイレクトを作成',

	'UserSettings'				=> 'ユーザーの設定',
	'UserSettingsGeneral'		=> '全般',
	'UserSettingsNotifications'	=> '通知',

	'NotifyMinorEdit'			=> '僅用於中文',
	'NotifyPageEdit'			=> '編集',
	'NotifyComment'				=> 'コメント',
	'NotifyOff'					=> 'オフ',
	'NotifyAlways'				=> '常に',
	'NotifyPending'				=> '保留中',
	'NotifyDigest'				=> 'ダイジェスト',
	'NotifyPendingPageTip'		=> '監視しているページの最初のページ変更に対して、通知は 1 つだけ送信されます。',
	'NotifyPendingCommentTip'	=> '最初のコメントに対してあなたが見ているページに1つの通知だけが送信されます。',
	'NotifyPendingTip'			=> '現在のバージョンのページにアクセスすると、通知が自動的に再び有効になります。',

	'FurtherPending'			=> 'このページにアクセスしない限り、その他の変更通知はありません。',

	'UserSettingsEmailMe'		=> '電子メールで通知する場合...',

	'UserSettingsExtended'		=> '拡張',
	'UserSettingsOther'			=> 'その他の設定',
	'UserSpace'					=> 'ユーザー スペース',
	'ChooseTheme'				=> 'テーマを選択',

	'CreatePage'				=> 'このページを作成',
	'CreateNewPage'				=> '新しいページを作成する',
	'CreateNewPageText'			=> '作成',
	'CreateNewPageTip'			=> '新しいページを作成する',

	'CreateRandomPage'			=> 'ランダムなページを作成:',
	'CreateSubPage'				=> 'クラスタ内にサブページを作成:',
	'CreatePageParentCluster'	=> '親クラスタにページを作成:',
	'CreatePageDenied'			=> '必要なアクセス権を持っていません。',
	'CreatePageDeniedAddress'	=> 'このアドレスにページを作成する権限がありません。',
	'PageAlreadyExists'			=> 'ページ %1 がすでに存在することを提供されたアドレスによる。',
	'PageAlreadyExistsEdit'		=> '%1 を使用しますか？',
	'PageAlreadyExistsEdit2'	=> '編集',
	'PageAlreadyExistsEditDenied'	=> '編集できません。',

	'SimilarPagesExists'		=> '%1 と同様のページは既に存在します:',
	'SimilarPagesHint'			=> '%1 と同様のページが存在します:',

	'PageReservedWord'			=> '%1 は予約語なので、住所の一部として使用できません。',
	'UserReservedWord'			=> 'ユーザー名は予約語なので %1 を含めることはできません。',

	'DontRedirect'				=> 'リダイレクトによる自動リダイレクトを許可しません。',
	'SendWatchEmail'			=> '閲覧中のページが誰か(あなたを除く)に変更されたときに通知メールを送信する',
	'AllowIntercom'				=> 'システムのユーザーからの個人的なメッセージを許可する',
	'AllowMassemail'			=> '管理者は情報をメールで送ることができる',
	'HideLastSession'			=> '最後のセッションを非表示',
	'ValidateIP'				=> 'IPへの接続セッション',
	'AnonymousPub'				=> '好ましくは匿名で公開 (名前を非表示にする)',
	'PageMoved'					=> 'このページは移動しました。次の場所で見つけることができます：',
	'RedirectedFrom'			=> '%1から転送',
	'RedirectedTo'				=> '転送先',
	'CurrentPassword'			=> '現在のパスワード',
	'NewPassword'				=> '新しいパスワード',
	'YouWantChangePassword'		=> 'パスワードを変更する',
	'ChangePasswordButton'		=> 'パスワードを変更する',
	'PasswordChanged'			=> 'パスワードを変更しました!',
	'EmailWelcome'				=> '登録日時 ',
	'EmailRegistered'			=> '%1 への登録に成功しました。' . "\n" . 'ユーザー名: %2' . "\n\n",
	'EmailVerify'				=> '通知を受け取りたい場合は、メールアドレスを確認する必要があります。次のリンクをクリックするか、Webブラウザにコピーしてください。 ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> '新しいユーザー名とパスワードでログインしてください。',
	'EmailRegisteredIgnore'		=> 'この登録をリクエストしていない場合は、このメッセージを無視して何も起こりません。',
	'EmailDoNotReply'			=> 'このメッセージに返信しないでください。',
	'EmailReverify'				=> '誰か（多分あなた）があなたのメールアドレスを %1に送信しました。' . "\n" . 'ユーザー名: %2'."\n\n" . '通知を受け取りたい場合は、メールを承認する必要があります。リンクに従ってください。' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'メールアドレスを確認してください',
	'EmailConfirmed'			=> 'メールを確認しました。',
	'EmailNotConfirmed'			=> 'メールを確認できません。確認コードが間違っているか、メールアドレスが確認されている可能性があります。 ログインし、 %1 ページでステータスを表示することで、メールアドレスが既に確認されているかどうかを確認できます。',
	'EmailNotVerified'			=> 'メールアドレスが確認されていません！',
	'EmailNotVerifiedDesc'		=> '閲覧中のページの変更やコメントの通知は受け取れません ' .
									'or messages from other users. Also, you <strong>will not be able to recover a forgotten password</strong>, ' .
									'送信されたメールのリンクに従ってメールアドレスが確認されるまで ' .
									'登録後数日以内にメールが届かない場合は、 ',

	'ForgotPasswordHint'		=> 'ログインとメールアドレスを入力してください' . "\n" . '指示が書かれたメールが届きます。',
	'ForgotPassword'			=> 'パスワードをお忘れですか?',
	'UserNotFound'				=> 'この名前またはメールアドレスのユーザーが見つかりませんでした。',
	'NotConfirmedEmail'			=> 'あなたのメールアドレスは確認されていません。<br>未確認のメールアドレスには送信できません。',
	'EmailForgotSubject'		=> 'パスワードの更新： ',
	'EmailForgotMessage'		=> '誰か（たぶんあなた）が %1のパスワードを忘れてしまいました。' . "\n" . 'あなたのログイン： %2'."\n\n" . 'リンクをクリックするか、ブラウザのアドレスにコピーしてパスワードを変更します。' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> 'パスワード復元の指示がメールで送信されました。',
	'WrongCode'					=> '間違ったコード',
	'ChangePasswordForUser'		=> '%1のパスワード変更',

	'Watchers'					=> '%1のウォッチャー一覧',
	'WatchersFor'				=> 'ウォッチャー:',
	'NoWatchers'				=> '%1 のウォッチャーはありません',
	'NotOwnerToViewWatchers'	=> 'あなたはこのページの所有者ではなく、ウォッチャーのリストを見ることができません。',

	// thumbnail
	'TbnError'					=> 'サムネイルの作成エラー: %1',
	'TbnImageAreaTooBig'		=> '%1よりも大きな寸法のファイル',
	'TbnImageMissing'			=> 'ファイルが見つかりません: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> '<code>recovery_password</code> のパスワードハッシュを生成します',

	// import action
	'ImportTo'					=> 'クラスタでインポート:',
	'ImportWhat'				=> 'インポートする XML ファイル：',
	'ImportButton'				=> 'インポート',
	'ImportSuccess'				=> 'インポートに成功しました。',
	'ImportFailed'				=> 'インポートに失敗しました',
	'ImportHint'				=> 'インポートしたいクラスターを指定してください。相対アドレスは指定されていません。',
	'ImportAttention'			=> '注意:クラスタ内の同じページを上書きします。',
	'ImportNote'				=> 'インポートされたページ',

	// mywatches action
	'WatchedPages'				=> '変更のためにフォローしているすべてのページの一覧 ',
	'UnwatchedPages'			=> '表示しないすべてのページのリスト',
	'NoWatchedPages'			=> '閲覧ページがありません。',
	'NoUnwatchedPages'			=> 'すべてのページで変更を確認します。',
	'ViewWatchedPages'			=> 'ウォッチしたページを表示',
	'ViewUnwatchedPages'		=> '未視聴のページを表示',
	'NotLoggedInWatches'		=> 'ログインしていないため、ウォッチのリストを特定できませんでした。',

	// mychangeswatches action
	'MyChangesWatches'			=> '前回の編集以降に編集されたすべてのページ一覧',
	'ResetChangesWatches'		=> '変更のリストをリセットする',
	'NoChangesWatches'			=> '閲覧中のページには変更はありません...',

	// whatsnew action
	'NewCommentAdded'			=> '新しいコメントを追加しました',
	'NewFileAdded'				=> '新しいファイルを追加しました',
	'NewPageCreated'			=> '新しいページを作成しました',
	'NewRevisionAdded'			=> '変更されたページ',
	'Cluster'					=> 'cluster',
	'PageDeleted'				=> 'ページが削除されました',
	'CommentDeleted'			=> 'コメントが削除されました',
	'FileDeleted'				=> 'ファイルを削除しました',

	// users action
	'UsersSearch'				=> 'ユーザーを検索',
	'UsersOpenProfile'			=> 'プロフィールを表示',
	'UsersNoMatching'			=> '一致するユーザーが見つかりません。より厳密な検索条件をお試しください。',
	'UsersName'					=> '名前',
	'UsersPages'				=> 'ページ',
	'UsersChanges'				=> '変化',
	'UsersSubscription'			=> '購読',
	'UsersWatches'				=> 'ウォッチ',
	'UsersComments'				=> 'コメント',
	'UsersUploads'				=> 'アップロード',
	'UploadQuota'				=> '使用スペース',
	'UploadQuotaTip'			=> '空き容量をアップロード',
	'UsersLogins'				=> 'ログイン',
	'UsersRevisions'			=> 'リビジョン',
	'UsersSignup'				=> '登録',
	'UsersLastSession'			=> '最後のセッション',
	'UsersNotFound'				=> 'User %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'UsersProfile'				=> 'プロフィール',
	'UsersContact'				=> 'コンタクト',
	'UsersList'					=> 'ユーザーのリスト全体を表示',
	'UsersNA'					=> '[セットされていません]',
	'UsersNA2'					=> '[いいえ]',
	'UsersSignupDate'			=> '登録日',
	'UsersGroupMembership'		=> 'グループメンバシップ',
	'UsersPersonalInfo'			=> '個人情報',
	'UsersOwnedPages'			=> '所有ページ:',
	'UsersCommentsPosted'		=> '投稿されたコメント:',
	'UsersFilesUploaded'		=> 'アップロードされたファイル:',
	'UsersRevisionsMade'		=> '変更内容:',
	'UsersDocsSortName'			=> 'format@@0',
	'UsersDocsSortCreation'		=> 'format@@0',
	'UsersChangesSortAsc'		=> '[昇順に並べ替え]',
	'UsersChangesSortDesc'		=> '[降順に並べ替え]',
	'UsersSessionNA'			=> 'format@@0',
	'UsersSessionHidden'		=> '[非表示]',
	'IntercomSubject'			=> '件名：',
	'IntercomMessage'			=> '本文：',
	'IntercomCopy'				=> '送信する',
	'IntercomSubjectN'			=> '[新しいトピックを始める]',
	'IntercomDisabled'			=> '申し訳ありませんが、個人的なメッセージを受け取ることはできません。',
	'IntercomHint'				=> '受信した個人的なメッセージに回答したい場合は、最初にログインし、再度リンクに従ってください。',
	'IntercomDesc'				=> '注：自分のアドレスを公開せずに、相手のメールアドレスに個人的なメッセージを送信すること。受信者は、あなたのプロフィールページの同じフォームを使って、あなたに返信することができます。 ',
	'PMOversized'				=> 'The length of the message exceeds the maximum allowed size by %1. Please short your message and submit again.',
	'PMFlooded'					=> '個人メッセージの送信間隔は %1 秒以下にしてください。',
	'PMSent'					=> 'パーソナルメッセージは正常にユーザーに送信されました。',
	'PMBody'					=> 'このメッセージはユーザー %1から送信されました。',
	'PMBodyCopy'				=> 'あなたはユーザー%1に以下のメッセージを送信しました。',
	'PMReply'					=> 'このメールに答えるには、次のリンクをクリックしてください（メールでの返信ボタン/返信を使用しないでください）：',
	'PMNotLoggedIn'				=> 'システムに登録されていないため、ユーザーに個人的なメッセージを送信できません。',

	// admin_replace action
	'ReplaceText'				=> '文字列の置換',
	'TextOriginal'				=> '置換前の文字列:',
	'TextReplacement'			=> '置換後の文字列:',
	'ReplaceTextRegex'			=> '正規表現を使用',
	'Namespace'					=> '名前空間:',
	'ReplaceTextCluster'		=> 'このクラスタ内でのみ検索と置換を行います：',
	'ReplaceTextEditPages'		=> 'ページ本文中の文字列を置換',
	'ReplaceTextEditComments'	=> 'コメント内のテキストを置換する',
	'ReplaceTextEditTitles'		=> 'ページ名中の文字列を置換する',
	'ReplaceTextGiveTarget'		=> '置換される対象となる文字列を指定する必要があります。',
	'ReplaceTextNoNamespace'	=> '名前空間を少なくとも1つ選択する必要があります。',
	'ReplaceTextNoDifference'	=> 'テキストとターゲットテキストの置き換えに違いはありません。',
	'ReplaceTextNoOption'		=> '置換オプションから少なくとも1つ選択する必要があります。',
	'ReplaceTextPagesEdit'		=> '以下の%3ページの本文中の「%1」を「%2」に置換する:',
	'ReplaceTextTitlesEdit'		=> '次の %3 ページのタイトルの %1 を %2 に置き換える：',
	'ReplaceTextReplace'		=> '置換',
	'ReplaceTextSuccess'		=> '%3ページで「%1」が「%2」に置換されます。',
	'ReplaceTextNoMatch'		=> '文字列「%1」を含むページは見つかりませんでした。',
	'ReplaceTextNoTitleMatch'	=> '「%1」を名前に含むページは見つかりませんでした。',
	'ReplaceTextEditFailed'		=> 'テキストの置換に失敗しました',
	'ReplaceTextTitleTooBig'	=> '原文または置換後の文字がタイトルに対して大きすぎる。',
	'ReplaceTextReturn'			=> 'フォームに戻る',
	'ReplaceTextWarning'		=> '警告: 置換後の文字列「%2」を含むページが既に %1 件あります。この置換を実行すると、これらの文字列と実際に置換された箇所を区別できなくなります。',
	'ReplaceTextBlankWarning'	=> '警告: 置換後文字列が空であるため、この操作は取り消せません。',
	'ReplaceTextEditSummary'	=> '文字列「%1」を「%2」に置換',
	'InvertSelection'			=> '選択を反転',

	// Properties
	'PropertiesFor'				=> '%1 のページプロパティ',
	'MetaTag'					=> 'タグ',
	'MetaTitle'					=> 'タイトル',
	'MetaKeywords'				=> 'キーワード',
	'MetaDescription'			=> '説明',
	'On'						=> 'オン',
	'Off'						=> 'オフ',
	'Registered'				=> '登録済み',
	'MetaComments'				=> 'コメントを表示',
	'MetaFiles'					=> 'ファイルパネルを表示',
	'MetaToc'					=> '目次を表示',
	'MetaIndex'					=> 'クラスターセクションパネルを表示',
	'MetaIndexMode'				=> 'レベルモードを表示',
	'MetaIndexFull'				=> '木',
	'MetaIndexUpper'			=> '上',
	'MetaIndexLower'			=> '下',
	'MetaHtml'					=> 'ページの HTML サポート',
	'MetaSafeHtml'				=> '安全でないHTMLのフィルタリング',
	'MetaTypografica'			=> '組版校正ツール',
	'MetaNoIndex'				=> '検索エンジンをブロック',
	'SettingsID'				=> 'ページ ID',
	'SettingsSize'				=> 'サイズ',
	'SettingsSizeTip'			=> 'ソース / コンパイル',
	'SettingsCreated'			=> '作成',
	'SettingsCurrent'			=> '変更済み',
	'SettingsTotalRevs'			=> 'リビジョン',
	'SettingsTotalComs'			=> 'コメント',
	'SettingsWatchers'			=> 'Watchers',
	'SettingsHits'				=> '表示',
	'SettingsText'				=> '設定',
	'SettingsEdit'				=> '編集',
	'SettingsRevisions'			=> 'リビジョン',
	'SettingsClone'				=> '複製',
	'SettingsRename'			=> '名前を変更',
	'MassRename'				=> 'クラスター全体で',
	'SettingsRemove'			=> '削除',
	'SettingsPurge'				=> 'Purge',
	'SettingsModerate'			=> 'モデレート',
	'SettingsPermissions'		=> '権限',
	'AclForEntireCluster'		=> 'クラスター全体で',
	'SettingsAttachments'		=> '添付ファイル',
	'SettingsUpload'			=> 'アップロード',
	'SettingsCategories'		=> 'カテゴリー',
	'SettingsLanguages'			=> '言語',
	'SettingsReferrers'			=> 'リファラ',
	'SettingsWatch'				=> 'ウォッチ',
	'SettingsLatex'				=> 'LaTeX バージョン',
	'SettingsXML'				=> 'XMLへのエクスポート',
	'NeedToChangeLang'			=> 'サポートされていないページ言語 %1 を変更する必要があります。',
	'SetLang'					=> 'このページの言語',
	'SetMenuLabel'				=> 'メニューラベル',
	'SetShowMenuLabel'			=> 'ナビゲーションに表示',

	// upload
	'UploadFiles'				=> 'ファイルをアップロード',
	'UploadFor'					=> 'ファイルアップロード：',
	'UploadButton'				=> 'アップロード',
	'UploadGlobalText'			=> '公開アクセス用',
	'UploadGlobal'				=> 'グローバル',
	'UploadLocalText'			=> '現在のページの閲覧を許可されたユーザーのみ',
	'UploadAsName'				=> '名前：',
	'UploadOverwrite'			=> '既存のファイルを上書き',
	'FileDesc'					=> '説明：',
	'UploadForbidden'			=> 'ここにファイルをアップロードすることはできません。',
	'UploadOverwriteDenied'		=> 'ファイルの所有者または管理者のみが %1 ファイルを上書きできます。',
	'UploadNoFile'				=> '何らかの理由で形式のファイルがありませんでした。',
	'UploadMaxSizeReached'		=> 'ファイルサイズが制限を超えています！',
	'UploadDirNotWritable'		=> 'ファイルディレクトリが書き込み可能ではありません！',
	'UploadNotAPicture'			=> 'There is allowed to upload pictures only, and what do you trying to upload?',
	'UploadEmptyExtension'		=> 'ファイル名と拡張子は空白にできません。',
	'FilenameTooLong'			=> '240バイトを超えるファイル名は禁止されています。',
	'BannedFiletype'			=> '%1 は許可されていないファイル形式です。',
	'PermittedFiletype'			=> '許可されているファイル形式:',
	'UploadMimeMismatch'		=> 'ファイルの拡張子「%1」がMIMEタイプ「%2」と一致しません。',
	'UploadBadMime'				=> 'MIMEタイプ「%1」のファイルのアップロードは許可されていません。',
	'FileIsDuplicate'			=> 'アップロードされたものはの現在のバージョンのものと全く同じです。',
	'FileHasDuplicate'			=> 'このファイルは以下のファイル群と重複しています:',

	'UploadMaxFileQuota'		=> 'アップロード上限に達しました。このファイルはアップロードできません。',
	'UploadDone'				=> 'ファイルのアップロードに成功しました',
	'UploadFileForbidden'		=> 'ファイルへのアクセスが禁止',
	'UploadTitle'				=> 'このページからアクセス可能なファイル',
	'UploadTitleGlobal'			=> 'どこからでもアクセス可能なファイル',

	'UploadFile'				=> 'アップロード',
	'UploadMax'					=> 'これ以上はありません ',
	'UploadUsedStorage'			=> '使用中のストレージ ',

	// attachments
	'Attachments'				=> '添付',
	'Attachment'				=> '添付',
	'AttachmentsToPage'			=> 'ページへ',
	'AttachmentsToCluster'		=> 'cluster',
	'AttachmentsByTime'			=> '時間別',
	'AttachmentsGlobal'			=> 'グローバル',
	'AttachmentsAll'			=> 'すべて',
	'AttachmentsLinked'			=> '使用中',

	'FileViewProperties'		=> 'ビュー',
	'FileViewPropertiesTip'		=> 'このファイルのメタデータを表示',
	'FileEditProperties'		=> '編集',
	'FileEditPropertiesTip'		=> 'このファイルのメタデータを編集',
	'FileEditedMeta'			=> 'このファイルのメタデータを更新しました',
	'FileEditDenied'			=> 'このファイルを編集する権限がありません',
	'FileLabel'					=> 'ラベル',
	'FileLabelTip'				=> 'このファイルにラベル付け',
	'FileRemove'				=> '削除',
	'FileRemovedFromDB'			=> 'ファイルをデータベースから削除しました',
	'FileRemovedFromFS'			=> '物理ホスティングから消去されたファイル',
	'FileRemovedFromFSError'	=> 'ファイルを消去することは不可能だと思われます!',
	'FileRemoveConfirm'			=> 'このファイルを削除しますか？',
	'FileRemoveDenied'			=> 'このファイルを削除する権限がありません',
	'FileNotFound'				=> 'ファイルが見つかりません。',

	'FileSearch'				=> 'ファイルを検索',
	'UploadBy'					=> 'アップロード者：',
	'FileAdded'					=> '追加:',
	'FileModified'				=> '変更済み：',
	'FileSize'					=> 'サイズ：',
	'FileDimension'				=> '寸法：',
	'MimeType'					=> 'MIMEタイプ：',
	'FileName'					=> '名前：',
	'FileCaption'				=> 'キャプション：',
	'FileAuthor'				=> '投稿者：',
	'FileSource'				=> 'ソース：',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> '添付先:',
	'FileSyntax'				=> '統語論：',
	'FileAbsolutePath'			=> '絶対パス',
	'FileRelativePath'			=> '相対パス',
	'FileUsage'					=> 'ファイルの使用状況:',
	'FileUsageText'				=> '以下の​ ページがこのファイルを使用しています：',
	'NoFileUsage'				=> 'このファイルへのリンクはありません。',

	'FileSortExt'				=> '拡張',
	'FileSortName'				=> '名前',
	'FileSortSize'				=> 'サイズ',
	'FileSortTime'				=> '作成しました',

	'SortBy'					=> '並び替え',
	'Ascending'					=> '昇順',
	'Decending'					=> 'decending',

	'Files0'					=> 'ファイルを添付',
	'Files1'					=> 'ファイルを表示 (1 ファイル)',
	'FilesN'					=> 'ファイルを表示 (%1 ファイル)',
	'Files'						=> 'ファイル',
	'File'						=> 'ファイル',
	'ShowFiles'					=> 'ファイル/フォームを表示',
	'HideFiles'					=> 'ファイル/フォームを隠す',
	'DoShowFiles'				=> 'デフォルトでファイルリストを表示',
	'NoAttachments'				=> '表示する添付ファイルはありません。',

	'RegistrationLang'			=> 'あなたの言語',
	'InvalidWikiName'			=> '選択された名前が無効です',
	'InvalidUserName'			=> '選択されたユーザー名が無効です',
	'Bookmarks'					=> 'ブックマーク',
	'ReallyDeleteComment'		=> 'このコメントを削除してもよろしいですか？<br>このアクションには元に戻すことはできません！',
	'ReallyDeleteRevision'		=> '本当にこのリビジョンを削除しますか？<br>このアクションの取り消しはありません！',

	'RegistrationClosed'		=> 'ユーザー登録は無効化されました。 Try to contact site administrator.',
	'AclAreYouSure'				=> 'このページとそのサブページのすべての ACL を変更します。続行しますか？',

	'BookmarkDeleteSelected'	=> '選択したものを削除',
	'BookmarkMark'				=> 'マーク',
	'BookmarkNumber'			=> '番号。',
	'BookmarkNone'				=> 'ブックマークがありません。',
	'BookmarkTitle'				=> 'ブックマークのタイトル',
	'BookmarkPage'				=> 'ページ',
	'BookmarkSaveChanges'		=> '変更を保存',
	'BookmarksAddPage'			=> '次のページのブックマークを設定',
	'BookmarkAlreadyExists'		=> 'ブックマークは既に存在します。',

	'PoweredBy'					=> 'Powered by',

	'MassRenaming'				=> 'クラスター全体の名前を変更',
	'MassNewName'				=> 'このクラスターの新しい名前を入力してください',
	'MassNeedRedirect'			=> '古いページの新しいページへのリダイレクトを作成',

	// pagination
	'ToOverview'				=> '概要に戻る',
	'Overview'					=> '概要',
	'ToThePage'					=> 'ページへ:',
	'Next'						=> '次へ',
	'Prev'						=> '前へ',
	'NextAcr'					=> '次へ',
	'PrevAcr'					=> '前へ',
	'Back'						=> '戻る',

	// filter
	'Filter'					=> '絞り込み',
	'OptionalFilters'			=> 'オプションのフィルターです：',
	'Any'						=> 'すべて',

	// My Groups
	'UserGroups'				=> 'Groups of users',
	'MyGroups'					=> 'グループの関連',
	'Group'						=> 'グループ',
	'Groups'					=> 'グループ',

	// license action
	'DistributedUnder'			=> '材料は以下で配布されています',
	'AuthorsDisplayHint'		=> 'ページを保存すると著者のリストが表示されます。',
	'AnonymousUsers'			=> '匿名ユーザー',
	'License'					=> 'ライセンス',
	'LicenseArray'				=> [
		'1'		=> '表示-表示-表示順',
		'2'		=> '表示-非営利-継承のような',
		'3'		=> '表示-非営利-派生的',
		'4'		=> '表示-継承のような',
		'5'		=> '表示-<unk>',
		'6'		=> '表示',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU フリードキュメンテーションライセンス',
		'9'		=> 'パブリックドメイン / 無料利用',
		'10'	=> 'All Rights Reserved.',
	],
	'LicenseMeta'				=> [
		'1'		=> 'パブリックドメイン',
		'2'		=> 'いくつかの権利が予約されました',
		'3'		=> 'All Rights Reserved.',
	],

	// Cache
	'ClearCache'				=> 'キャッシュをクリア',
	'CacheCleared'				=> 'キャッシュをクリアしました。',
	'ConfigCache'				=> '設定キャッシュ',
	'FeedCache'					=> 'フィードキャッシュ',
	'PageCache'					=> 'ページキャッシュ',
	'SQLCache'					=> 'SQL キャッシュ',
	'TemplateCache'				=> 'テンプレートキャッシュ',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'パラメータURLでリソースのアドレスを指定してください。(例: {{embed url="https://example.com/embed/video.mp4}} )',

	// Feed
	'FeedTitle'					=> 'フィードタイトル',
	'FeedMulti'					=> 'マルチフィード',
	'FeedNoURL'					=> 'パラメータURLでフィードを指定してください。（例：{{feed url="https://example.com/feed.xml"}}',
	'FeedError'					=> 'フィードを読み込むことができませんでした',
	'FeedSource'				=> 'ソース：',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - 最近の変化',
	'ChangesXML'				=> '最近の変更 ',
	'CommentsXMLTitle'			=> ' - 最近のコメント',
	'CommentsXML'				=> '最近のコメント ',
	'NewsXMLTitle'				=> ' - 最近のニュース',
	'NewsXML'					=> '最近のニュース ',
	'RevisionXMLTip'			=> 'クリックして XML 形式の最近のページリビジョンを表示します。',
	'CommentsXMLTip'			=> 'クリックすると、最近のコメントを XML 形式で表示できます。',
	'ChangesXMLTip'				=> 'クリックすると XML 形式の最近の変更が表示されます。',
	'NewsXMLTip'				=> 'クリックして XML 形式の最近のニュースを表示します。',
	'RevisionsXML'				=> '変更点 ',
	'ExportClusterXML'			=> 'クラスター全体のエクスポート ',
	'AccessDeniedXML'			=> 'この情報へのアクセスは許可されていません。',

	'ChangesFeed'				=> '変化',
	'CommentsFeed'				=> 'コメント',
	'NewsFeed'					=> 'ニュース',
	'RevisionsFeed'				=> '変更点 ',

	'LastModification'			=> '最終変更',

	// Captcha
	'Captcha'					=> '上の画像に表示されている文字列を入力',
	'CaptchaFailed'				=> 'CAPTCHAの単語が正しく入力されていません。もう一度やり直してください。',
	'CaptchaReload'				=> '新しいCaptcha',
	'CaptchaReloadWarning'		=> '申し訳ありませんが、Captcha画像をリロードできません。ページを再読み込みする必要があります。',

	// news
	'News'						=> 'ニュース',
	'NewsName'					=> 'タイトル：',
	'NewsNoName'				=> 'ニュースの見出しを追加するのを忘れました。',
	'NewsNotAvailable'			=> 'ニュースはありません。',
	'NewsNoClusterDefined'		=> 'ニュースクラスターが定義されていません。',
	'NewsDiscuss'				=> 'この記事について話し合いましょう...',

	// blog
	'BlogNewTopic'				=> '新しい投稿を作成',
	'NoPostAvailable'			=> '投稿はまだありません。',

	// Review
	'Reviewer'					=> '査読者',
	'Reviewed'					=> 'reviewed',
	'Review'					=> 'レビュー',
	'ReviewedBy'				=> 'レビュー者',
	'RemoveReview'				=> 'このページのレビューを削除',
	'SetReview'					=> 'Reviewed this page',
	'SetAsReviewed'				=> 'レビュー済みとしてページを設定',
	'SetAsUnreviewed'			=> '未レビューとしてページを設定',

	// word filter
	'PotentialSpam'				=> '特定された潜在的なスパム',

	// moderation handler
	'Moderation'				=> 'モデレート',
	'Topics'					=> 'トピック',
	'ModerateSection'			=> 'セクション / ページ ',

	'NotModerator'				=> 'このページ/章を管理する権限がありません',
	'ModerateDeleteTopic'		=> 'トピック/ページを削除',
	'ModerateDeletePosts'		=> 'コメントを削除',
	'ModerateMove'				=> '移動',
	'ModerateSplit'				=> 'コメントを分割 / 移動',
	'ModerateMerge'				=> '統合',
	'ModerateLock'				=> 'ロック',
	'ModerateUnlock'			=> 'ロック解除',
	'ModerateAccept'			=> '同意する',
	'ModerateDeleteConfirm'		=> 'Are you sure you want to <strong>remove</strong> the following topics?',
	'ModerateRenameConfirm'		=> '選択したページの新しいタイトルを入力してください',
	'ModerateRenameExists'		=> '同じ名前のページがすでに存在します 別の名前を選んでください。',
	'ModerateRename1Only'		=> '注意: 最初に選択したページのみが名前が変更されます!',
	'ModerateMovesConfirm'		=> 'フォーラムを移動する対象パーティションを選択してください',
	'ModerateMoveConfirm'		=> 'フォーラムを選択するか、これらのトピックを移動するクラスターを指定してください。サイトのルートにページを移動するには、 &quot;/&quot; と入力してください',
	'ModeratePgMoveConfirm'		=> 'ページを配置するクラスターの名前を指定します。 サイトのルートにページを移動するには、 &quot;/&quot; と入力してください',
	'ModerateMoveExists'		=> '操作は中止されました: このセクションではすでに同じ名前のトピック %1が存在します。 それでも上記のトピックを転送する必要がある場合は、まず名前を変更してください。',
	'ModerateMoveNotExists'		=> 'ページ / クラスターが存在しません。名前を確認して、もう一度やり直してください。',
	'ModerateMergeConfirm'		=> '残りを組み合わせるトピックを選択してください',
	'ModerateMerge2Min'			=> '参加するには少なくとも2つのトピックを選択する必要があります！',
	'ModerateComDelConfirm'		=> 'Are you sure you want to <strong>remove</strong> %1 %2?',
	'ModerateComment'			=> 'コメント',
	'ModerateComments'			=> 'コメント',
	'ModerateSplitNewName'		=> '分離可能なトピックの名前を指定し、分離スキーマを選択します',
	'ModerateSplitPageName'		=> 'ページ/トピックの名前を入力し、削除可能なコメントを移動し、分離スキーマを選択します。',
	'ModerateSplitAllAfter'		=> '最初に選択した（および含む）後にすべてのコメントを切り離します',
	'ModerateSplitSelected'		=> '選択したコメントのみ分離されました（ %1合計）',
	'ModerateUserProfile'		=> 'プロフィール',
	'ModerateNoItemChosen'		=> 'セットボタンから少なくとも1つのアイテムを選択してください。',

	'ModerateSection2'			=> '適度なセクション',
	'ModerateTopicsDeleted'		=> '選択したトピックを削除しました。',
	'ModerateTopicsRelocated'	=> '選択したトピックが正常に移行されました。',
	'ModerateTopicsRenamed'		=> 'トピックの名前を変更しました。',
	'ModerateTopicsMerged'		=> '選択したトピックをマージしました。',
	'ModerateTopicsBlocked'		=> '選択したトピックは正常にブロックされました',
	'ModerateTopicsUnlocked'	=> '選択したトピックのロックを解除しました。',
	'ModerateTopicDeleted'		=> 'トピックを削除しました。',
	'ModeratePageMoved'			=> 'ページを移動しました。',
	'ModerateTopicRenamed'		=> 'トピックの名前を変更しました。',
	'ModerateTopicBlocked'		=> 'トピックをブロックしました',
	'ModerateTopicUnlocked'		=> 'トピックのロックを解除しました。',
	'ModerateCommentsDeleted'	=> '選択したコメントは正常に削除されました。',
	'ModerateCommentsSplit'		=> '選択したコメントは新しいトピックで正常に区切られました。',
	'ModerateCommentsSplitFailed'	=> 'Note: For some reason separating the selected comments to a new topic failed.<br>Usually this should not happen, so please notify the site administrator.<br>As a precaution, the issue has been preserved in its original form.',
	'ModerateCommentsMoved'		=> '選択したコメントは、指定されたページに正常に移行されました。',

	// forum
	'ForumSubforums'			=> 'フォーラム',
	'ForumTopic'				=> 'トピック',
	'ForumTopics'				=> 'トピック',
	'ForumPosts'				=> '投稿',
	'ForumReplies'				=> '返信',
	'ForumAuthor'				=> '投稿者',
	'ForumViews'				=> 'ビューズ',
	'ForumCreated'				=> '作成',
	'ForumComments'				=> 'コメント',
	'ForumLastComment'			=> '最新のコメント',
	'ForumNoComments'			=> 'コメントはありません。',
	'ForumNoTopics'				=> 'フォーラムに投稿されたトピックはありません',
	'ForumNewTopic'				=> '新しいディスカッションを開始',
	'ForumTopicName'			=> 'トピック名：',
	'ForumTopicSubmit'			=> 'トピックを送信',
	'ForumNoTopicName'			=> '新しいページの名前を指定します。',
	'ForumNewPosts'				=> '新しい記事',
	'ForumLocked'				=> 'セクションがロックされました',
	'ForumUpdated'				=> '更新',
	'ForumNoClusterDefined'		=> 'フォーラムクラスターが定義されていません。',
	'ForumOutsideCluster'		=> '%1 アクションがフォーラムクラスタ内にあることを確認します。',

	// password complexity
	'PwdCplxShort'				=> 'パスワードが短すぎます。',
	'PwdCplxEquals'				=> 'パスワードにユーザー名が含まれています。',
	'PwdCplxWeak'				=> 'パスワードが複雑な要件を満たしていません。',
	'PwdCplxDesc1'				=> 'パスワードの要件： ',
	'PwdCplxDesc2'				=> 'パスワードは %1 文字未満にすることはできません',
	'PwdCplxDesc3'				=> 'あなたのユーザー名を含めてはいけません',
	'PwdCplxDesc4'				=> 'で構成されるべきです ',
	'PwdCplxDesc41'				=> '文字と数字',
	'PwdCplxDesc42'				=> '大文字小文字と数字',
	'PwdCplxDesc43'				=> '大文字、小文字、数字、英数字以外の文字',
	'PwdCplxDesc5'				=> 'スペース以外の任意の文字、数字、特殊文字を使用できます。',

	'PasswordTooShort'			=> 'パスワードが短すぎます。',
	'PasswordTooCommon'			=> 'そのパスワードはあまりにも一般的です。',
	'PasswordSameAsUsername'	=> 'パスワードはユーザー名と同じです。',
	'PasswordSameAsEmail'		=> 'パスワードはメールアドレスと同じです。',

	'Timezone'					=> 'タイムゾーン',
	'DateFormat'				=> '日付の形式',

	'LanguageArray'	=> [
		'ar' => 'アラビア文字',
		'bg' => 'ブルガリア語',
		'cs' => 'チェコ語',
		'da' => 'デンマーク語',
		'de' => 'ドイツ語',
		'el' => 'ギリシャ語',
		'en' => '英語',
		'es' => 'スペイン語',
		'et' => 'エストニア語',
		'fa' => 'ペルシャ語',
		'fi' => 'フィンランド語',
		'fr' => 'フランス語',
		'hi' => 'ヒンディー語',
		'hu' => 'ハンガリー語',
		'id' => 'インドネシア語',
		'it' => 'イタリア語',
		'ja' => '日本語',
		'ko' => '韓国語',
		'nl' => 'オランダ語',
		'no' => 'ノルウェー語',
		'pl' => 'ポーランド語',
		'pt' => 'ポルトガル語',
		'pt-br' => 'ポルトガル語-ブラジル',
		'ro' => 'Romainian',
		'ru' => 'ロシア語',
		'sv' => 'スウェーデン語',
		'ta' => 'Tamil',
		'uk' => 'ウクライナ語',
		'zh' => '中国語',
		'zh-tw' => '中国語',
	],

	'AccountStatus'				=> 'アカウントの状態',
	'AccountStatusArray' => [
		'0' => 'アクティブ',
		'1' => '保留中',
		'2' => 'ブロック',
		'3' => '非アクティブ',
	],

	'JustNow'		=> 'ちょうど今',
	'MinuteAgo'		=> '1分前',
	'MinutesAgo'	=> '%1 分前',
	'HourAgo'		=> '1 時間前',
	'HoursAgo'		=> '%1 hours ago',
	'DayAgo'		=> '昨日',
	'DaysAgo'		=> '%1 days ago',
	'WeekAgo'		=> '1週間前',
	'WeeksAgo'		=> '%1 週間前',
	'MonthAgo'		=> '1ヶ月前',
	'MonthsAgo'		=> '%1 ヶ月前',
	'YearAgo'		=> '一年前',
	'YearsAgo'		=> '%1 年前',

	'InAMoment'		=> '一瞬で',
	'InAMinute'		=> '1分以内',
	'InMinutes'		=> 'in %1 minutes',
	'InAnHour'		=> '1時間以内',
	'InHours'		=> 'in %1 hours',
	'Tomorrow'		=> '明日',
	'InDays'		=> '%1 日以内',
	'InAWeek'		=> '一週間以内',
	'InWeeks'		=> 'in %1 weeks',
	'InAMonth'		=> '1ヶ月以内',
	'InMonths'		=> 'in %1 months',
	'InAYear'		=> '一年で',
	'InYears'		=> 'in %1 years',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['バイト', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['バイト', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'GP', 'TP', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['ピクセル', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> '不明なアクション',
	'UnknownMethod'				=> '不明な方法',
	'FormatterNotFound'			=> 'Formatter %1 が見つかりません',

	// log
	'LogAdminLoginSuccess'		=> '管理画面にログインしました',
	'LogAdminLogout'			=> '管理パネルからログアウト',
	'LogAdminLoginFailed'		=> '!!管理者パネルへのアクセスを承認できませんでした!!',
	'LogAdminLoginLocked'		=> 'ロックされた管理者パネルへのログイン',
	'LogUserCookieForged'		=> '!!**ログインする ##%1##**!!',
	'LogInvalidFormToken'		=> '潜在的なCSRF攻撃が検出されました: %1',
	'LogRemovedPage'			=> '!!削除されたページ ##%1## (ユーザー %2)!!',
	'LogRemovedCluster'			=> '!!Removed **cluster** ##%1## (user %2)!!',
	'LogRemovedRevision'		=> '!!削除されたリビジョン ##%3## of page [[/%1]] (user %2)!!',
	'LogRemovedComment'			=> '!!Removed comment from %3 on page [[/%1]] (user %2)!!',
	'LogRemovedFile'			=> '!!Removed file ##%2## from page [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!ページのコメントをすべて削除しました [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!ページのすべてのリビジョンを削除しました [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!![[/%1] ]!! に添付されているすべてのファイルを削除しました。',
	'LogTopicLocked'			=> 'フォーラムトピックがロックされています [[/%1]]',
	'LogTopicUnlocked'			=> 'アンロックされたフォーラムトピック [[/%1]]',
	'LogAclUpdated'				=> 'ACLページを更新しました [[/%1]]',
	'LogOwnershipChanged'		=> 'ページ [[/%1]] の所有権がユーザー ##%2 ## に転送されました',
	'LogUserLoginFailed'		=> '##~%1 ##でログインできませんでした!!',
	'LogClonedPage'				=> 'ページ ##%1## ## # cloned to [[/%2]]',
	'LogRenamedPage'			=> 'ページ ##%1## が [[/%2] ] に名前を変更しました',
	'LogRenamedPage2'			=> 'をクリックします。古いページを新しいページへのリンクとして設定します。',
	'LogSplittedPage'			=> 'ページへのコメント [[/%1]] ページへの分割 [[/%2]]',
	'LogMergedPages'			=> 'ページ %1 がページ [[/%2] ] にマージされました',
	'LogUserPasswordReminded'	=> 'ユーザー ##%1## # がアドレス ##%2##',
	'LogUserPasswordRecovered'	=> 'ユーザ ##%1## が正常にパスワードを回復しました',
	'LogUserPasswordChanged'	=> 'ユーザー ##%1## successfully updated (changed) the password',
	'LogUserPasswordMismatch'	=> '!!User ##%1## はパスワードの変更に失敗しました: 現在のパスワードの不一致!!',
	'LogUserIPSwitched'			=> 'ユーザー %1 の認証されていないIPアドレスが %2 から %3に変更されました',
	'LogPageImported'			=> 'インポートされたページ [[/%1]]',
	'LogSaveNoRights'			=> 'ページを保存する適切な権限がありません [[/%1]]',
	'LogPageCreated'			=> '新しいページ [[/%1] ] を作成しました',
	'LogPagePropertiesUpdated'	=> '更新されたページプロパティ [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'ユーザーがページの所有権を取得しました [[/%1]]',
	'LogFileUploadedLocal'		=> 'New file ##%2## uploaded to the page [[/%1]] (size %3)',
	'LogFileUploadedGlobal'		=> '新しいファイル ##%2## がグローバルフォルダにアップロードされました (サイズ %3)',
	'LogPMSent'					=> '個人メッセージ ##%1## -> ##%2## # 正常に送信されました',
	'LogUserSimilarName'		=> '同じユーザー名で登録しようとしました: ##%1##',
	'LogUserEmailNotAllowed'	=> 'Email ##%1## ## は許可されたドメインリストにありません',
	'LogRegisterTiming'			=> '登録に失敗しました。フォームの時間閾値は ##%1## 秒です (以前は ##%2##)',
	'LogUserRegistered'			=> '新しいユーザー ##%1## (##%2 ##) を正常に登録しました',
	'LogUserEmailActivated'		=> 'メール ##%1## ユーザー ##%2##',
	'LogCommentPosted'			=> 'ページに[[/%1 新しいコメント]]を追加しました [[/%2]]',
	'LogUserLoginOK'			=> 'ユーザー ##%1## が正常にシステムにログインしました',
	'LogUserLoggedOut'			=> 'ユーザー ##%1## が正常にシステムからログアウトしました',
	'LogUserSessionContinued'	=> 'ユーザー ##%1## のセッションが一時停止されました',
	'LogUserSettingsUpdate'		=> 'ユーザー ##%1## が個人設定を更新しました',
	'LogPageEdited'				=> '編集 [[/%1]]',
	'LogCommentEdited'			=> '編集 [[/%1]]',
	'LogUpdatedFileMeta'		=> 'ページから#%2#のファイルメタデータを更新しました [[/%1]]',
	'LogUpdatedFileCategories'	=> 'ページから#%2#のファイルカテゴリを更新しました [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'XMLサイトマップが生成されました',
	'LogReferrersPurged'		=> 'メンテナンス: 紹介者が削除されました',
	'LogRevisionsPurged'		=> 'メンテナンス: 古いページ改訂が削除されました',
	'LogDeletedPagesPurged'		=> 'メンテナンス: 削除されたページが削除されました',
	'LogSystemLogPurged'		=> 'メンテナンス: システムログが削除されました',
	'LogCachedPagesPurged'		=> 'メンテナンス: キャッシュされたページが削除されました',
	'LogSqlCachePurged'			=> 'メンテナンス: キャッシュされた sql 結果が削除されました',
	'LogExpiredTokensPurged'	=> 'メンテナンス: 期限切れのクッキー_トークンが削除されました',
	'LogErrorSplitComments'		=> 'トピック[[/%1]] から新しいトピックを分離するときにエラーが発生しました ##%2##: ページが作成されませんでした',
	'LogCategoriesUpdated'		=> '更新されたページカテゴリ [[/%1]]',
	'LogCategoryCreated'		=> '作成された新しいカテゴリ /%1//',
	'LogCategoryRenamed'		=> 'カテゴリー ##%1## の名前を ##%2 ## に変更しました ##',
	'LogCategoryDebundled'		=> 'Category ##%1## ## debundled',
	'LogCategoryGrouped'		=> 'カテゴリ ##%1## 単語 ##%2##',
	'LogCategoryRemoved'		=> 'カテゴリ ##%1## がデータベースから削除されました',
	'LogThumbnailGeneration'	=> 'サムネイル生成 %1 秒。',

	'ErrorMinPHPVersion'		=> 'PHPのバージョンは<strong>' . PHP_MIN_VERSION . '</strong>より大きい必要があります,' .
									' あなたのサーバーでは、<strong>' . PHP_VERSION . '</strong>が使用されているようです。' .
									'  WackoWiki を正しく動作させるには、PHP を最新のバージョンにアップグレードする必要があります。',

];
