<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Portuguese-Brazil',
		'code'		=> 'pt-br',
		'dir'		=> 'ltr',
		'locale'	=> 'pt_BR',
	],

	'date_formats'	 => [
		'default'	=> 'dd/MM/y',
	],

	// common
	'AddButton'					=> 'Adicionar',
	'ArchiveButton'				=> 'Arquivo',
	'CancelButton'				=> 'Cancelar',
	'ContinueButton'			=> 'Continuar',
	'ConvertButton'				=> 'Converter',
	'CreateButton'				=> 'Crio',
	'DeleteButton'				=> 'Excluir',
	'RemoveButton'				=> 'Remover',
	'RenameButton'				=> 'Renomear',
	'ResetButton'				=> 'Reset',
	'RestoreButton'				=> 'Restaurar',
	'SaveButton'				=> 'Guardar',
	'SearchButton'				=> 'Pesquisa',
	'SendButton'				=> 'Mandar',
	'SetButton'					=> 'Definir',
	'SubmitButton'				=> 'Enviar',
	'UpdateButton'				=> 'Atualização',

	'FormInvalid'				=> 'O formulário enviado era inválido. Tente enviar novamente.',
	'UnitPixel'					=> 'px',
	'Number'					=> 'numero',

	// logged in panel
	'AccountText'				=> 'Conta',
	'AccountTip'				=> 'Configurações da conta',
	'AdminText'					=> 'Administrador',
	'AdminTip'					=> 'Painel Administrativo',
	'LogoutLink'				=> 'Desconectar',
	'LogoutButton'				=> 'Efetuar logout',
	'LogoutAreYouSure'			=> 'Você realmente deseja sair?',

	// registration panel
	'RegistrationWelcome'		=> 'Registro de novo usuário:',
	'RegistrationButton'		=> 'Me registre',
	'UserNameOwned'				=> 'Este nome de usuário já está registrado. Por favor, escolha outro.',
	'SiteRegistered'			=> 'Você se registrou no site %1 com sucesso.',
	'RegistrationEmailInfo'		=> 'Um endereço de e-mail válido. Todos os e-mails do sistema serão enviados para este endereço. O endereço de e-mail não é tornado público e só será utilizado se desejar receber uma nova senha ou desejar receber certas notícias ou notificações por e-mail.',
	'EmailConfirmHint'			=> 'Por favor, confirme seu endereço de e-mail clicando no link nas instruções enviadas a você. <br>Se você não verificar seu endereço de e-mail, não poderá recuperar uma possível senha perdida. <br>Além disso, você não será notificado sobre alterações recentes na página e comentários.',
	'EmailConfirmRequired'		=> 'Sem o endereço de e-mail confirmado, você não terá permissão para entrar.',
	'NameTooShort'				=> 'Nome de usuário é muito curto, um mínimo de %2 caracteres é necessário.',
	'NameTooLong'				=> 'O nome de usuário é muito longo, um máximo de caracteres %2 é permitido.',
	'NameAlphanumOnly'			=> 'O nome de usuário deve ter entre %1 e %2 caracteres e usar apenas caracteres alfanuméricos. Caracteres maiúsculos são válidos.',
	'NameCamelCaseOnly'			=> 'Nome de usuário deve ter entre %1 e %2 caracteres e formatado WikiName.',
	'NewUserAccount'			=> 'nova conta de usuário',

	'NewAccountSubject'			=> 'Registro de conta',
	'NewAccountAdminCreated'	=> 'O usuário %1 criou uma conta para você com o nome de usuário "%2". Para completar o seu registro, visite o seguinte URL (certifique-se de que é inserida como a única linha) e defina sua própria senha de acesso:',
	'NewAccountUsername'		=> 'Usuário:',
	'AccountLanguage'			=> 'Idioma:',
	'NewAccountEmail'			=> 'Email:',
	'NewAccountIP'				=> 'Endereço IP remoto:',
	'NewAccountSignupInfo'		=> 'A seguinte conta foi criada:',

	'UserWaitingApproval'		=> 'Um e-mail foi enviado ao administrador do site. O administrador analisará as informações que foram enviadas e aprovará ou recusará sua solicitação.',
	'UserRequiresApproval'		=> 'Para aprovar ou negar o acesso deste usuário à %1 acesse o painel de administração.',
	'UserApprovalInfo'			=> 'Depois de se registrar, sua solicitação será enviada ao administrador do site para aprovação. Em seguida, você receberá um e-mail com mais instruções.',
	'UserApprovalHint'			=> 'A ativação bem-sucedida de sua conta será anunciada em um e-mail específico. Até lá, o login não será possível.',

	'UserApprovalPending'		=> 'Sua conta ainda está pendente de aprovação.',
	'UserApprovalDenied'		=> 'Sua conta não permitiu o acesso a este site.',

	'RegistrationApproved'		=> 'Registro aprovado',
	'RegistrationDenied'		=> 'Registro negado',
	'PendingApproval'			=> 'Aprovação pendente',

	'UserApprovedInfo'			=> 'Você foi aprovado para acessar %1.',
	'UserDeniedInfo'			=> 'Foi negado o acesso a %1.',

	'RegistrationThreshold'		=> 'O tempo de preencher o formulário não deve ser inferior a %1 segundos.',
	'Language'					=> 'Idioma',

	// login panel
	'LoginWelcome'				=> 'Conectar-se',
	'CreateAccount'				=> 'Criar nova conta',
	'RegistrationLink'			=> 'Cadastro',
	'LoginName'					=> 'Usuário:',
	'Password'					=> 'Palavra-passe',
	'LoginButton'				=> 'Conectar-se',
	'LoginLink'					=> 'Conectar-se',
	'PersistentCookie'			=> 'Permanecer conectado',
	'Session'					=> 'Sessão',
	'SessionTip'				=> 'parâmetros da sessão atual',
	'SessionDuration'			=> 'Duração da sessão',
	'SessionDurationSession'	=> 'Sessão do navegador',
	'SessionDurationDay'		=> '1 dia',
	'SessionDurationWeek'		=> '1 semana',
	'SessionDurationMonth'		=> '1 mês',
	'LoggedInAs'				=> 'Você está logado como',

	'ClearCookies'				=> 'Excluir todos os cookies',
	'BindSessionIp'				=> 'Vincular sessão ao endereço IP',
	'BindSessionIpOn'			=> 'ativado (o atual IP %1)',
	'TrafficProtection'			=> 'Proteção de tráfego',
	'SessionEnds'				=> 'A sessão atual termina',
	'LastVisit'					=> 'A última visita foi registrada',

	'LoginIncorrect'			=> 'O nome de usuário ou senha inseridos estão incorretos.',
	'WelcomeBack'				=> 'Bem-vindo de volta, %1',
	'LoginAttemptsExceeded'		=> 'Você excedeu o número máximo permitido de tentativas de login.<br>Além do seu nome de usuário e senha, agora você também precisa resolver o CAPTCHA abaixo.',

	// session notice
	'IPAddressChanged'			=> 'Endereço IP alterado para %1 (era %2)',

	'SessionReplay'				=> 'Sessão encerrada devido ao replay.',
	'SessionObsolete'			=> 'Sessão está desatualizada.',
	'SessionExpired'			=> 'Sessão expirou.',
	'SessionTimeout'			=> 'Sessão terminada devido ao tempo limite.',
	'SessionInactivity'			=> 'Sessão terminada por inatividade.',
	'SessionUaChange'			=> 'Sessão encerrada devido a alteração do agente de usuário.',
	'SessionTLSChange'			=> 'Sessão encerrada devido a alteração TLS.',
	'SessionIPChange'			=> 'Sessão encerrada devido a alteração de IP.',

	// other
	'Guest'						=> 'Visitante',
	'Everybody'					=> 'Todos',
	'Help'						=> 'Socorro',
	'TopicSearchText'			=> 'Pesquisar somente em títulos',
	'WordprocessorVersion'		=> 'Versão do processador de palavras',

	// notifications
	'EmailHello'				=> 'Olá! ',
	'EmailModerator'			=> 'Moderador(a)',
	'WatchedPageChanged'		=> 'Página alterada ',
	'SomeoneChangedThisPage'	=> ' alterou uma página que você está assistindo: ',
	'NewPageCreatedSubj'		=> 'Uma nova página',
	'NewPageCreatedBody'		=> 'Usuário %1 criou uma nova página: ',
	'FileUploadedSubj'			=> 'Um novo arquivo',
	'FileUploadedBody'			=> 'Usuário %1 carregou um novo arquivo: ',
	'FileReplacedBody'			=> 'Usuário %1 substituiu o arquivo: ',

	'ActionDenied'				=> 'A acção é negada aqui.',
	'TocTitle'					=> 'Conteúdo ',
	'OuterLink2'				=> 'Link de saída',
	'FileLink'					=> '',
	'PDFLink'					=> 'Documento PDF',
	'RDFLink'					=> 'Documento RDF',
	'EmailLink'					=> 'Escreva um e-mail (lançamento do cliente de e-mail)',
	'GeoLink'					=> 'Mostrar esta localização (início do aplicativo)',
	'JabberLink'				=> 'Bate-papo via XMPP (Jabber client launch)',
	'TelLink'					=> 'Ligar para este número (lançamento do aplicativo de telefone)',
	'PermaLink'					=> 'Link permanente',
	'PermaLinkTip'				=> 'Link permanente para esta revisão da página',
	'PermaLink0Tip'				=> 'Link permanente para esta página',

	'ShowTip'					=> 'Retornar no modo de exibição',
	'ShowText'					=> 'Visualizar',
	'WikieditAutocomplete'		=> 'Complete wikilinks através de Ctrl+Space',
	'WikiEditInactiveJs'		=> 'Para poder utilizar o WikiEdit, por favor, habilite o JavaScript no seu navegador.',
	'NumerateLinks'				=> 'Numerar links na visualização da impressão',
	'Comment'					=> 'Comentar',
	'Comments0'					=> 'Adicione seu comentário',
	'Comments1'					=> 'Ler comentário (1 comentário)',
	'CommentsN'					=> 'Ler comentários (%1 comentários)',
	'Comments'					=> 'Comentários',
	'CommentHint'				=> '<a href="%1">Inicie sessão</a> ou <a href="%2">crie uma conta</a> para publicar um comentário.',
	'CommentEdited'				=> 'editado',
	'Links'						=> 'Links',
	'Version'					=> 'Versão',

	// details formatter
	'ShowHideDetails'			=> 'detalhes',

	'PrivacyPolicy'				=> 'Política de Privacidade',
	'TermsOfUse'				=> 'Termos de Utilização',
	'AcceptTermsOfUse'			=> 'Eu li, entendi e concordo com os Termos de Serviço do site.',

	'ShowComments'				=> 'Exibir comentários / formulário',
	'HideComments'				=> 'Ocultar comentários / formulário',
	'AddComment'				=> 'Anexar um comentário a esta página:',
	'AddCommentTitle'			=> 'Título do comentário:',
	'CommentTitleRe'			=> 'Res:',
	'AddCommentButton'			=> 'Anexar comentário',
	'HereLink'					=> 'Aqui',
	'PageHandlerMoreTip'		=> 'Mais',

	'ThemeCorrupt'				=> 'O tema está corrompido',
	'InvalidNamespace'			=> 'Dado um namespace inválido.',
	'DoesNotExists'				=> 'Esta página não existe.',
	'PromptCreate'				=> 'Talvez você queira criar <strong><a href="%1"></a></strong>?',
	'RevisionHint'				=> 'Esta é uma revisão antiga de <a href="%1">%2</a> de %3 editada por %4.',
	'ReadAccessDenied'			=> 'Você não tem permissão para ler esta página.',
	'ReadAccessDeniedHintGuest'	=> 'Para ler esta página, você deve fazer login.',
	'PageDeletedInfo'			=> 'Esta página foi excluída.',
	'RevisionDeletedInfo'		=> 'Esta revisão foi excluída.',
	'CommentDeletedInfo'		=> 'Este comentário foi excluído.',

	'LastEditedBy'				=> 'Última edição por',
	'YouAreOwner'				=> 'Você é o proprietário desta página.',
	'Owner'						=> 'Proprietário',
	'OwnerColon'				=> 'Proprietário:',
	'Nobody'					=> 'Nenhum',
	'TakeOwnership'				=> 'Assumir o controle',
	'FilesTip'					=> 'Gerenciar arquivos anexados',
	'FilesText'					=> 'Anexos',
	'DeleteTip'					=> 'Excluir página, seus arquivos e comentários',
	'DeleteCommentTip'			=> 'Excluir comentário',
	'DeleteText'				=> 'Excluir',
	'AclText'					=> 'Permissões',
	'AclTip'					=> 'Editar Permissões',

	'PropertiesText'			=> 'propriedades',
	'PropertiesTip'				=> 'Editar Propriedades da Página',
	'EditTip'					=> 'Editar esta página.',
	'EditText'					=> 'Alterar',
	'EditSection'				=> 'Editar seção %1',
	'EditSectionHint'			=> 'Seção %1 de %2',
	'SectionHeadline'			=> 'Turma',
	'EditCommentTip'			=> 'Editar comentário',
	'EditComment'				=> 'Editar comentário',
	'ReplyComment'				=> 'Responder',
	'ReplyCommentTip'			=> 'Responder este comentário',
	'RevisionTip'				=> 'Visualizar revisões de página',
	'RevisionText'				=> 'Revisões',
	'ReferrersTip'				=> 'Visualizar uma lista de URLs que se referem a esta página',
	'ReferrersText'				=> 'Referências',
	'ModerateTip'				=> 'Moderação de tópicos e postagens no fórum',
	'ModerateText'				=> 'Moderado',
	'SearchText'				=> 'Buscar: ',

	'AclUpdated'				=> 'Listas de controle de acesso atualizadas',
	'AclGaveOwnership'			=> ' and gave ownership to %1.',
	'AclNoNewOwner'				=> 'A propriedade da página não foi transferida porque o usuário %1 não foi encontrado.',
	'NewPageOwnership'			=> 'Propriedade da página transferida',
	'YouAreNewOwner'			=> 'antigo proprietário %1 transferiu propriedade ' . "\n" . 'da seguinte página para você',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Leitura:',
	'AclWrite'					=> 'Escrever:',
	'AclComment'				=> 'Comentários:',
	'AclCreate'					=> 'Criar:',
	'AclUpload'					=> 'Enviar:',
	'AclFor'					=> 'Listas de Controle de Acesso para %1',
	'SetOwner'					=> 'Definir Proprietário:',
	'OwnerDontChange'			=> 'Não mudar',
	'AclAccessDenied'			=> 'Você não é o proprietário desta página.',
	'AclSyntaxError'			=> 'Erro de sintaxe da lista de controle de acesso',
	'AclHelp'					=> '<code>*</code> - todos são permitidos<br>' .
									'<code>$</code> - apenas usuários registrados<br>' .
									'<code>!</code> - um ponto de exclamação anterior nega a respectiva direita<br>' .
									'<code>[UserName]</code> - nomes dos usuários permitidos<br>' .
									'<code>[GroupName]</code> - nomes do grupo de usuários permitido (alias)<br>' .
									'<code>(uma lista vazia)</code> - apenas o proprietário da página tem acesso',

	'AccessMode'				=> 'Visibilidade',
	'AccessDenied'				=> 'rejeitado',
	'AccessPublic'				=> 'público',
	'AccessRegistered'			=> 'registrado',
	'AccessPrivate'				=> 'privada',
	'AccessCustom'				=> 'personalizado',

	// purge handler
	'PurgePage'					=> 'Purge page',
	'NotOwnerAndCantPurge'		=> 'Você não é o proprietário da página e não pode limpá-la.',
	'ReallyPurge'				=> 'ATENÇÃO: Limpar a página é irreversível!',
	'SelectPurgeOptions'		=> 'Selecione as opções de purge necessárias:',
	'PurgeComments'				=> 'Limpar todos os comentários da página',
	'CommentsPurged'			=> 'Todos os comentários foram excluídos.',
	'PurgeFiles'				=> 'Remover todos os arquivos anexados',
	'FilesPurged'				=> 'Todos os arquivos anexados foram removidos.',
	'PurgeRevisions'			=> 'Limpar todas as revisões da página',
	'RevisionsPurged'			=> 'As revisões foram purgadas.',
	'PurgeButton'				=> 'Purge',

	// categories handler
	'Categories'				=> 'Categorias',
	'CategoriesAssign'			=> 'Designar',
	'CategoriesEdit'			=> 'Editar',
	'Category'					=> 'categoria',
	'CategoriesFor'				=> 'Categorias para',
	'CategoriesTip'				=> 'Editar categorias',
	'CategoriesText'			=> 'Categorias',
	'CategoriesUpdated'			=> 'Categorias atualizadas',
	'CategoriesAlreadyExists'	=> 'A categoria %1 já existe.',
	'CategoriesAdded'			=> 'Categoria %1 adicionada com sucesso.',
	'CategoriesRenamed'			=> 'Categoria renomeada com sucesso.',
	'CategoriesUngrouped'		=> 'Categoria debilitada com sucesso.',
	'CategoriesGrouped'			=> 'A categoria entrou no novo grupo.',
	'NoMultilevelGrouping'		=> 'Não é possível agrupar vários níveis.',
	'CategoriesDeleted'			=> 'A categoria foi excluída do banco de dados e todas as páginas.',
	'CategoriesAdd'				=> 'Adicionar uma nova categoria',
	'CategoryDescription'		=> 'Descrição:',
	'CategoriesAddGrouped'		=> 'Agrupados com a categoria',
	'CategoriesAddGroupedNo'	=> 'Nenhum grupo.',
	'CategoriesRename'			=> 'Renomear a categoria %1 para',
	'CategoriesRenameInfo'		=> '* Nota: A mudança afetará todas as páginas que são atribuídas a essa categoria.',
	'CategoriesGroup'			=> 'Agrupar categorias %1 com',
	'CategoriesGroupInfo'		=> '* Selecione [no group] para desvendar a categoria.',
	'CategoriesNoGroup'			=> '[sem grupo]',
	'CategoriesDelete'			=> 'Tem certeza que deseja remover a categoria %1?',
	'CategoriesDeleteInfo'		=> '* Nota: A mudança afetará todas as páginas que são atribuídas a essa categoria. Se a palavra tiver uma subcategoria, não será eliminada, mas apenas debilitada.',
	'CategoriesStoreInfo'		=> 'Para atribuir categorias a uma página, selecione as caixas de seleção.',
	'CategoriesStoreButton'		=> 'Salvar Categorias',
	'CategoriesGroupButton'		=> 'Grupo',
	'CategoriesEditInfo'		=> 'Para editar a lista de categorias, selecione o botão de rádio.',
	'NoCategoriesForThisLang'	=> 'Categorias para este idioma não foram especificadas.',
	'PagesCategory'				=> 'Categoria de páginas',
	'CategoryNotExists'			=> 'A categoria não existe.',
	'CategoryEmpty'				=> 'Categoria vazia.',
	'NoCategorySelected'		=> 'Nenhuma categoria selecionada',
	'NoCategoriesAssigned'		=> 'Nenhuma categoria atribuída para este idioma',
	'TagCloud'					=> 'Nuvem de Tags',
	'PagesTaggedWith'			=> 'Páginas %1 etiquetadas com %2',
	'CategoriesOfCluster'		=> 'de agrupamento',
	'TaggedWithTip'				=> 'mostrar páginas marcadas com %1',

	// source handler
	'SourceText'				=> 'fonte',
	'SourceTip'					=> 'Ver fonte do wiki',
	'SourceCopyToClipboard'		=> 'copiar para o clipboard',
	'SourceFor'					=> 'Ver fonte para %1',

	// Groups action
	'GroupsSearch'				=> 'Encontrar grupos',
	'GroupsNoMatching'			=> 'Grupos correspondentes não foram encontrados. Tente um critério de pesquisa menos rigoroso.',
	'GroupsOpenProfile'			=> 'Ver Perfil',
	'GroupsName'				=> 'Grupo',
	'GroupsMembers'				=> 'Membros',
	'GroupsDescription'			=> 'Descrição:',
	'GroupsCreated'				=> 'Criado',
	'GroupsNotFound'			=> 'Grupo %2 não encontrado. Clique <a href="%1">aqui</a>, para ir para a lista principal.',
	'GroupsProfile'				=> 'Perfil',
	'GroupsList'				=> 'Ver a lista completa dos grupos',
	'GroupSpace'				=> 'Espaço em grupo',

	'MetaUpdated'				=> 'Meta data atualizada',

	'PreviewButton'				=> 'Pré-visualizar',
	'Preview'					=> 'Pré-visualizar',
	'Chars'						=> 'caracteres',
	'PageBody'					=> 'Corpo da página',
	'EditNote'					=> 'Resumo da edição',
	'EditNoteMissing'			=> 'Resumo da edição faltando',
	'EditMinor'					=> 'Edição menor',
	'MinorEditHide'				=> 'Ocultar edição menor',
	'MinorEditShow'				=> 'Mostrar pequenas edições',
	'PostAnonymously'			=> 'Publique anonimamente sem dar seu nome',
	'NotifyMe'					=> 'Notifique-me sobre novos comentários e alterações da página',
	'OverwriteAlert'			=> 'ALERTA DE SUBSTITUIÇÃO: Esta página foi modificada por outra pessoa enquanto você a editava.<br>Copie suas alterações e reedite esta página.',
	'TextDbOversize'			=> 'Aviso: O seu texto excede o limite de tamanho por %1 caracteres. Encurte seu texto para um número aceitável de caracteres. Dica: você pode colocar o texto restante em uma página separada.',
	'EditingRevisionWarning'	=> 'Você está editando uma revisão antiga desta página. Se você publicá-la, quaisquer alterações feitas desde então serão removidas. <br>Você pode querer editar a revisão atual em vez disso.',
	'WriteAccessDenied'			=> 'Você não tem acesso de escrita a esta página.',
	'EmptyPage'					=> 'Corpo da página estava vazio - não salvo!',
	'EmptyComment'				=> 'Corpo do comentário estava vazio - não salvo!',
	'CommentAccessDenied'		=> 'Desculpe, você não tem permissão para postar comentários nesta página.',
	'CommentFlooded'			=> 'O intervalo entre a publicação das postagens não deve ser menor que %1 segundos.',
	'CommentAdded'				=> 'Comentário adicionado.',
	'YouAreNowTheOwner'			=> 'Você agora é o proprietário desta página.',
	'PageSaved'					=> 'Versão da página %1 salva.',
	'CommentSaved'				=> 'Comentário salvo.',

	'RevisionsFor'				=> 'Revisões de %1',
	'DefaultDiffMode'			=> 'Modo padrão de diff',
	'DiffMode'		=> [
		'0'		=> 'Diff completo',
		'1'		=> 'Diff simples',
		'2'		=> 'fonte',
		'3'		=> 'Lado a lado',
		'4'		=> 'Embutido',
		'5'		=> 'Mesclado',
		'6'		=> 'Unificado',
		'7'		=> 'Contexto',
	],

	'PreviousEdit'				=> 'Edição anterior',
	'NextEdit'					=> 'Próxima edição',

	'Diff'						=> 'SG',
	'PreviousVersion'			=> 'Revisão anterior',
	'LatestVersion'				=> 'Última revisão',
	'NextVersion'				=> 'Próxima revisão',

	'ShowDifferencesButton'		=> 'Mostrar Diferenças',
	'CancelReturnButton'		=> 'Cancelar e retornar à página',
	'Comparison'				=> 'Diferença entre revisões de %1',
	'RevisionAsOf'				=> 'Revisão %1 a partir de',
	'SimpleDiffAdditions'		=> 'Adições:',
	'SimpleDiffDeletions'		=> 'Exclusões:',
	'NoDifferences'				=> 'Não há diferenças.',
	'ReEditOldRevision'			=> 'Reeditar esta revisão antiga',

	'ExternalPages'				=> 'Páginas externas vinculadas a %1 (%2) (<a href="%3">veja a lista de domínios</a>):',
	'ExternalPagesGlobal'		=> 'Sites vinculados a esta WackoWiki (%2) (<a href="%1">ver lista de domínios</a>):',
	'Last24Hours'				=> 'últimas 24 horas',
	'LastDays'					=> 'últimos %1 dias',
	'DomainsSitesPages'			=> 'Páginas de domínios/sites ligadas a  %1 (%2) (<a href="%3">ver a lista de URLs diferentes</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domains/sites linking to this WackoWiki (<a href="%1">see list of different URLs</a>):',
	'ViewReferrersPage'			=> 'para a página',
	'ViewReferrersPerPage'		=> 'Por página',
	'ViewReferrersByTime'		=> 'por horário',
	'ViewReferrersGlobal'		=> 'Global',
	'NoneReferrers'				=> 'Nenhuma',
	'NotOwnerCantDelete'		=> 'Você não é o proprietário desta página e não pode excluí-la',

	// remove
	'RemovePage'				=> 'Remover página',
	'RemoveRevision'			=> 'Remover revisão',
	'RemoveComment'				=> 'Excluir comentário',
	'RemoveCluster'				=> 'Remover todas as páginas do grupo',
	'RemoveDontKeep'			=> 'Não salvar uma cópia de uma página e comentários removidos',
	'RemoveDontKeepPurge'		=> 'Não salvar uma cópia dos arquivos removidos, revisões e comentários',
	'RemoveDontKeepRevision'	=> 'Não salvar uma cópia da revisão removida',
	'RemoveDontKeepComment'		=> 'Não salvar uma cópia do comentário removido',
	'RemoveDontKeepFile'		=> 'Não salvar uma cópia do arquivo removido',
	'ReferrersRemoved'			=> 'Referenciadores removidos.',
	'LinksRemoved'				=> 'Links removidos.',
	'CategoriesRemoved'			=> 'Categorias de páginas excluídas.',
	'AclsRemoved'				=> 'Os efeitos da página foram removidos.',
	'BookmarksRemoved'			=> 'Favoritos removidos.',
	'WatchesRemoved'			=> 'Acompanhamentos removidos.',
	'CommentsRemoved'			=> 'Comentários da página removidos.',
	'FilesRemoved'				=> 'Arquivos da página removidos.',
	'PageRemoved'				=> 'Página removida.',
	'PageCachePurged'			=> 'Cache limpo.',
	'ClusterRemoved'			=> 'Todas as páginas do cluster removidas.',
	'RevisionRemoved'			=> 'Revisão %1 removida.',
	'RevisionsRemoved'			=> 'Revisões removidas.',
	'ActionHaveNoUndo'			=> 'Esta ação não pode ser desfeita.',

	// restore
	'PageRestored'				=> 'Página restaurada.',
	'RevisionRestored'			=> 'Revisão restaurada.',
	'LocalFilesRestored'		=> 'Arquivos locais restaurados.',

	'PrintVersion'				=> 'Versão de impressão',
	'PrintText'					=> 'Impressão',
	'LinkedPages'				=> 'Páginas vinculadas:',
	'NoLinkedPages'				=> 'Não há páginas vinculadas',
	'ReferringPages'			=> 'Páginas de referência:',
	'NoReferringPages'			=> 'Não há nenhuma página de referência',
	'Footnotes'					=> 'Notas de rodapé:',
	'Footnote'					=> 'Nota de rodapé',
	'MostPopularPages'			=> 'Páginas mais populares',
	'MostCommentedPages'		=> 'Páginas mais comentadas',
	'NoAccessToSourcePage'		=> 'Você não tem permissão para ler a página fonte de ação.',
	'SourcePageDoesntExist'		=> 'A página de origem da ação ainda não existe',
	'NotLoggedInThusEdited'		=> 'Você não está conectado, portanto não pudemos identificar as páginas que você editou.',
	'DidntEditAnyPage'			=> 'Você ainda não editou nenhuma página.',
	'NoPagesFound'				=> 'Nenhuma página encontrada.',
	'MyChangesTitle1'			=> 'Esta é a lista de páginas que você editou, ordenados pelo momento da sua última alteração',
	'MyChangesTitle2'			=> 'Esta é a lista de páginas que você editou, junto com o tempo da sua última alteração',
	'OrderABC'					=> 'alfabeticamente',
	'OrderCreation'				=> 'por criação',
	'OrderChange'				=> 'por alteração',
	'ListOwnedPages'			=> 'Esta é a lista de páginas que você possui (ordem alfabética)',
	'ListOwnedPages2'			=> 'Esta é a lista de páginas que você possui (ordenado por data)',
	'ListOwnedPages3'			=> 'Esta é a lista de páginas que você tem (ordenado por alteração)',
	'NotLoggedInThusOwned'		=> 'Você não está logado, portanto não pudemos recuperar as suas páginas.',
	'NoOrphaned'				=> 'Sem páginas órfãs. Bom.',
	'NoRecentComments'			=> 'Não há comentários recentes.',
	'LatestCommentBy'			=> 'último comentário de',
	'NoRecentlyCommented'		=> 'Nenhuma página comentada recentemente.',
	'NoDeletedPages'			=> 'Nenhuma página excluída encontrada.',
	'NoDeletedRevisions'		=> 'Nenhuma revisão excluída encontrada.',
	'NoDeletedFiles'			=> 'Nenhum arquivo excluído encontrado.',
	'CommentsDisabled'			=> 'Comentários não estão disponíveis.',

	'SearchResults'				=> 'Resultados da pesquisa para ',
	'NotFound'					=> 'não encontrado',
	'NoResultsFor'				=> 'Não há resultados para ',
	'SearchFor'					=> 'Pesquisar por:',
	'TopicSearchResults'		=> 'Resultados da pesquisa de tópicos para ',
	'NotFoundInTopics'			=> 'não encontrado nos tópicos',
	'FilterLangNotAvailable'	=> 'O idioma selecionado não está disponível!',
	'SearchInPages'				=> 'Pesquisar no conteúdo da página',
	'SearchInComments'			=> 'Pesquisar nos comentários',
	'SearchInPageTitles'		=> 'Pesquisar nos títulos da página',
	'SearchInNoOption'			=> 'Você deve selecionar pelo menos uma das opções de pesquisa.',

	'PostedBy'					=> 'postado por',
	'ThisIsCommentOn'			=> 'Este é um comentário sobre',
	'At'						=> 'em',
	'To'						=> 'para',
	'By'						=> 'Por',
	'From'						=> 'De',
	'For'						=> 'para',
	'ReturnToCommented'			=> 'Retornar à página comentada',
	'AbandonedComment'			=> 'A página à qual este comentário pertence não existe mais!',

	'PagesLinkingTo'			=> 'Páginas vinculadas a',
	'NoPageLinkingTo'			=> 'Nenhuma página está vinculada a',
	'NoWantedPages'				=> 'Nenhuma página desejada. Bom.',
	'RemoveWatch'				=> 'Remover relógio para esta página',
	'SetWatch'					=> 'Acompanhar esta página',
	'WatchText'					=> 'Acompanhar',
	'UnwatchText'				=> 'Não seguir',
	'UserSettingsStored'		=> 'Configurações do usuário salvas.',
	'LoggedOut'					=> 'Agora você está desconectado.',
	'LoggedOutAuto'				=> 'Por segurança, sua sessão terminou. Por favor, faça o login novamente.',

	// user settings
	'EmailConfirmResent'		=> 'Código de confirmação de e-mail reenviado para seu endereço.',
	'EmailConfirmNotSent'		=> 'Não foi possível enviar o código de confirmação: e-mail não foi especificado!',
	'Hello'						=> 'Olá!',
	'UserName'					=> 'Nome de usuário',
	'EmailAddress'				=> 'Endereço de e-mail',
	'RealName'					=> 'Nome real',
	'MenuItemsShown'			=> 'Itens de menu exibidos',
	'RecordsPerPage'			=> 'Registros por página',
	'DoShowComments'			=> 'Mostrar comentários por padrão',
	'DoubleclickEditing'		=> 'Duplo clique para Editar',
	'UpdateSettingsButton'		=> 'Configurações de atualização',

	'AccountDisabled'			=> 'Sua conta pode estar desativada ou bloqueada.',
	'WrongPassword'				=> 'Senha errada!',
	'ConfirmPassword'			=> 'Confirmar a senha',
	'Email'						=> 'Endereço de e-mail',
	'MustBeWikiName'			=> 'Nome de usuário deve ser <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> formatado!',
	'SpecifyEmail'				=> 'Você deve especificar um endereço de e-mail.',
	'NotAEmail'					=> 'Isso não parece ser um endereço de email válido.',
	'EmailTaken'				=> 'O endereço de e-mail inserido já está em uso.',
	'EmailDomainNotAllowed'		=> 'O endereço de e-mail informado %1 não está na lista de domínios permitidos.',
	'PasswordsDidntMatch'		=> 'As senhas não correspondem.',
	'SpacesArentAllowed'		=> 'Espaços não são permitidos nas senhas.',
	'ListMyPages'				=> 'Liste suas páginas',
	'ListMyChanges'				=> 'Liste suas alterações',
	'ListMyWatches'				=> 'Lista de páginas assistidas',
	'ListMyChangesWatches'		=> 'Alterações entre as páginas assistidas',
	'SeeListOfPages'			=> 'Veja uma lista de páginas que você possui (Minhas Páginas) e páginas que você editou (MyChanges).',
	'AddBookmark'				=> 'Adicionar página atual aos favoritos',
	'RemoveBookmark'			=> 'Remover dos favoritos',

	'YourLanguage'				=> 'Selecione o idioma',
	'ShowSpaces'				=> 'Mostrar espaços em WikiNames',
	'WrongPage4Redirect'		=> 'Não é possível redirecionar devido ao parâmetro de redirecionamento errado',
	'RedirectsToItself'			=> 'A página redireciona para si mesma.',
	'ReallyDeletePage'			=> 'Você realmente deseja EXCLUIR esta página?<br>Não há como desfazer esta ação!<br><br>AVISO: Excluir esta página excluirá todas as versões da página, comentários, anexos, ACLs e referenciadores.',
	'CommentForWatchedPage'		=> 'Novo comentário para a página ',
	'SomeoneCommented'			=> ' comentou esta página que você está assistindo: ',
	'AlertReferringPages'		=> 'Esta página é referenciada por estas páginas',

	'AccountDelete'				=> 'Apagar conta',
	'AccountDeleteConfirm'		=> 'Tem certeza que deseja excluir a conta?',
	'AccountDeleted'			=> 'Conta excluída com sucesso',
	'AccountDeleteHeader'		=> 'Excluir conta %1',
	'AccountDeleteInfo'			=> 'Os dados que você criou (ex.: e-mail, preferências, anexos, páginas wiki) serão excluídos na medida do possível. No entanto, observe que dados como anexos e páginas wiki não podem ser excluídos sem impedir o trabalho dos outros usuários. Os dados são reatribuidos a uma conta chamada %1. Como os dados de cada conta excluída são reatribuídos a esta conta, não será possível distinguir os dados que você criou dos dados de outra conta excluída.',
	'AccountDeleteWarning'		=> 'Excluir a conta do usuário é uma ação irreversível.',
	'AccountDeleteHint'			=> 'Sua conta será excluída do sistema. Portanto, você não poderá mais fazer login com suas credenciais atuais. Se você optar por se tornar um usuário deste aplicativo de novo, você pode fazê-lo usando os meios que este aplicativo concede.',
	'AccountDeleteVerify'		=> 'Digite seu nome de usuário %1 para verificar a exclusão. Depois de enviado, você receberá uma solicitação de confirmação da sua senha.',

	'MarkRead'					=> 'Marcar todos como lidos',
	'CurrentTime'				=> 'É atualmente',
	'Created'					=> 'Criado',
	'Modified'					=> 'Modificado',

	'EditIcon'					=> 'Editar',
	'TreeClusterTitle'			=> 'Árvore de aglomeração %1',
	'TreeSiteTitle'				=> 'Árvore do site',
	'TreeEmpty'					=> '%1 não tem subpáginas',
	'TreeEmptyLevels'			=> '%1 não tem subpáginas para determinados níveis de profundidade. Aumentar o valor para a profundidade.',
	'TreeTooBig'				=> 'muitas subpáginas',

	// clone handler
	'ClonePage'					=> 'Clonar página',
	'CloneText'					=> 'Clonar',
	'CloneName'					=> 'Digite o novo nome para um clone desta página',
	'CloneButton'				=> 'Clonar',
	'PageCloned'				=> 'Página %1 clonada.',
	'ClonedFrom'				=> 'Clonado de %1.',
	'MassClone'					=> 'Clonar todo o cluster',
	'MassCloning'				=> 'Clonando cluster.',
	'CloneCannotRead'			=> 'Página %1 ilegível.',
	'CloneCannotCreate'			=> 'Página %1 não criável.',

	'CommentOffset'				=> 'Página do comentário',
	'CommentOffsetFirst'		=> 'primeira página',
	'CommentOffsetLast'			=> 'última página',
	'SortComment'				=> 'Classificar comentários por',
	'SortCommentAsc'			=> 'Mais recente no fundo',
	'SortCommentDesc'			=> 'Mais recentes no topo',

	'RenamePage'				=> 'Renomear a página',
	'RenameText'				=> 'Renomear',
	'RenameTip'					=> 'Renomear a página',
	'NewName'					=> 'Digite um novo nome para esta página',
	'AlreadyExists'				=> 'A página %1 já existe.',
	'AlreadyNamed'				=> 'Esta página já foi chamada %1.',
	'PageRenamed'				=> 'Página renomeada.',
	'NewNameOfPage'				=> 'Novo nome desta página: ',
	'NotOwnerCantRename'		=> 'Você não é o proprietário desta página e, portanto, não pode renomeá-la',
	'NeedRedirect'				=> 'Criar redirecionamento para a nova página na página antiga',
	'RedirectCreated'			=> 'Na página %1 foi criado o redirecionamento para a nova',

	'UserSettings'				=> 'Configurações do usuário',
	'UserSettingsGeneral'		=> 'Gerais',
	'UserSettingsNotifications'	=> 'Notificações',

	'NotifyMinorEdit'			=> 'Notificar também uma pequena edição',
	'NotifyPageEdit'			=> 'Alterar',
	'NotifyComment'				=> 'Comentar',
	'NotifyOff'					=> 'Desligado',
	'NotifyAlways'				=> 'Sempre',
	'NotifyPending'				=> 'Pendente',
	'NotifyDigest'				=> 'Resumo',
	'NotifyPendingPageTip'		=> 'Apenas uma notificação é enviada para a primeira alteração de página de uma página que você está assistindo.',
	'NotifyPendingCommentTip'	=> 'Apenas uma notificação é enviada para o primeiro comentário para uma página que você está assistindo.',
	'NotifyPendingTip'			=> 'A notificação é automaticamente reativada quando você visita a versão atual da página.',

	'FurtherPending'			=> 'Não haverá outras notificações em caso de novas alterações, a menos que você visite esta página.',

	'UserSettingsEmailMe'		=> 'Envie-me um e-mail quando...',

	'UserSettingsExtended'		=> 'Estendida',
	'UserSettingsOther'			=> 'Outras configurações',
	'UserSpace'					=> 'Espaço do usuário',
	'ChooseTheme'				=> 'Escolher tema',

	'CreatePage'				=> 'Criar esta página',
	'CreateNewPage'				=> 'Criar uma nova página',
	'CreateNewPageText'			=> 'Crio',
	'CreateNewPageTip'			=> 'Criar uma nova página',

	'CreateRandomPage'			=> 'Crie uma página aleatória:',
	'CreateSubPage'				=> 'Criar uma sub página no cluster:',
	'CreatePageParentCluster'	=> 'Criar uma página no grupo pai:',
	'CreatePageDenied'			=> 'Você não tem os direitos de acesso necessários.',
	'CreatePageDeniedAddress'	=> 'Você não tem o direito de criar a página neste endereço.',
	'PageAlreadyExists'			=> 'De acordo com o endereço fornecido, a página %1 já existe.',
	'PageAlreadyExistsEdit'		=> 'Você quer %1 isso?',
	'PageAlreadyExistsEdit2'	=> 'Editar',
	'PageAlreadyExistsEditDenied'	=> 'Você não pode editá-lo.',

	'SimilarPagesExists'		=> 'Páginas similares a %1 já existe:',
	'SimilarPagesHint'			=> 'Existem páginas similares a %1:',

	'PageReservedWord'			=> 'Você não pode usar %1 como parte do endereço, pois é uma palavra reservada.',
	'PageReservedNamespace'		=> 'Você não pode usar %1 como início do endereço, pois é um namespace reservado.',
	'UserReservedWord'			=> 'Nomes de usuário não podem conter %1 , pois é uma palavra reservada.',

	'DontRedirect'				=> 'Não permitir o redirecionamento automático pelo redirecionamento de ação.',
	'SendWatchEmail'			=> 'Enviar notificação por e-mail quando alguém (exceto você) mudar qualquer página que você estiver assistindo',
	'AllowIntercom'				=> 'Permitir mensagens pessoais de usuários do sistema',
	'AllowMassemail'			=> 'Os administradores podem me enviar informações por e-mail',
	'HideLastSession'			=> 'Ocultar a última sessão',
	'ValidateIP'				=> 'Ligando sessão ao IP',
	'AnonymousPub'				=> 'Preferencialmente, publicado anonimamente (para ocultar o nome)',
	'PageMoved'					=> 'Esta página foi movida. Você pode encontrá-la em',
	'RedirectedFrom'			=> 'Redirecionado de %1',
	'RedirectedTo'				=> 'Redirecionado para',
	'CurrentPassword'			=> 'Senha atual',
	'NewPassword'				=> 'Nova senha',
	'YouWantChangePassword'		=> 'Mudar Senha',
	'ChangePasswordButton'		=> 'Mudar Senha',
	'PasswordChanged'			=> 'Senha alterada',
	'EmailWelcome'				=> 'Você se registrou em ',
	'EmailRegistered'			=> 'Você se registrou com sucesso em %1.' . "\n" . 'Seu nome de usuário: %2' . "\n\n",
	'EmailVerify'				=> 'Se você deseja receber notificações, você deve verificar seu endereço de e-mail. Por favor, clique ou copie o seguinte link para um navegador da web: ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Por favor, retorne à Wiki e faça o login com seu novo nome de usuário e senha.',
	'EmailRegisteredIgnore'		=> 'Se você não solicitou este registro, ignore esta mensagem e nada acontecerá.',
	'EmailDoNotReply'			=> 'Não responda esta mensagem.',
	'EmailReverify'				=> 'Alguém (talvez você) enviou seu email como endereço de notificação em %1.' . "\n" . 'Seu nome de usuário: %2'."\n\n" . 'Se você deseja receber notificações, você precisa aprovar seu e-mail. Por favor, siga o link para fazer isso.' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'Por favor, verifique seu e-mail',
	'EmailConfirmed'			=> 'E-mail confirmado com sucesso.',
	'EmailNotConfirmed'			=> 'O e-mail não pode ser confirmado. Isso pode ser devido a um código de confirmação incorreto ou o endereço de e-mail já pode ser confirmado. Você pode verificar se o endereço de e-mail já foi confirmado fazendo login e visualizando o status na sua página %1.',
	'EmailNotVerified'			=> 'E-mail não verificado!',
	'EmailNotVerifiedDesc'		=> 'Você não receberá notificação de alterações ou comentários de páginas assistidas, ' .
									'ou mensagens de outros usuários. Além disso, você <strong>não poderá recuperar uma senha esquecida</strong>, ' .
									'até que seu endereço de e-mail seja confirmado, seguindo o link no e-mail enviado para você. ' .
									'Se, dentro de dias após o registro, você não receber um e-mail, pergunte novamente clicando clicando ',

	'ForgotPasswordHint'		=> 'Insira seu nome de usuário e endereço de e-mail' . "\n" . 'então um email com instruções será enviado para você.',
	'ForgotPassword'			=> 'Esqueceu a senha?',
	'UserNotFound'				=> 'Usuário com esse nome ou endereço de e-mail não encontrado.',
	'NotConfirmedEmail'			=> 'Seu endereço de e-mail não está confirmado.<br>O e-mail não pode ser enviado para um endereço não confirmado.',
	'EmailForgotSubject'		=> 'Renovação de senha para ',
	'EmailForgotMessage'		=> 'Alguém (talvez você) esqueceu a sua senha para %1.' . "\n" . 'Seu login: %2'."\n\n" . 'Clique no link ou copie-o na linha de endereço do navegador para alterar sua senha.' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> 'Instruções de recuperação de senha foram enviadas para você por e-mail.',
	'WrongCode'					=> 'Código incorreto',
	'ChangePasswordForUser'		=> 'Alteração de senha %1',

	'Watchers'					=> 'Lista de observadores para %1',
	'WatchersFor'				=> 'Observadores por',
	'NoWatchers'				=> 'Não há observadores para %1',
	'NotOwnerToViewWatchers'	=> 'Você não é o proprietário desta página e você não pode ver a lista de observadores para ela.',

	// thumbnail
	'TbnError'					=> 'Erro ao criar miniatura: %1',
	'TbnImageAreaTooBig'		=> 'Arquivo com dimensões maiores que %1',
	'TbnImageMissing'			=> 'O arquivo parece estar faltando: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Gerar o hash de senha da sua <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Importar no cluster:',
	'ImportWhat'				=> 'Arquivo XML para importar:',
	'ImportButton'				=> 'Importação',
	'ImportSuccess'				=> 'Importado com sucesso.',
	'ImportFailed'				=> 'IMPORT falhou.',
	'ImportHint'				=> 'Por favor, forneça um cluster para o qual você deseja importar, não há endereços.',
	'ImportAttention'			=> 'Atenção: Sobrescreve as mesmas páginas no grupo.',
	'ImportNote'				=> 'Página importada',

	// mywatches action
	'WatchedPages'				=> 'Lista de todas as páginas que segue para alterações ',
	'UnwatchedPages'			=> 'Lista de todas as páginas que você não assiste',
	'NoWatchedPages'			=> 'Você não tem páginas assistidas.',
	'NoUnwatchedPages'			=> 'Você assiste às mudanças em todas as páginas.',
	'ViewWatchedPages'			=> 'Mostrar páginas assistidas',
	'ViewUnwatchedPages'		=> 'Mostrar página não assistida',
	'NotLoggedInWatches'		=> 'Você não está conectado, portanto não pudemos identificar sua lista de relógios.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'Lista de todas as páginas que você assistiu e que foram editadas por outros desde a sua última edição',
	'ResetChangesWatches'		=> 'redefinir a lista de alterações',
	'NoChangesWatches'			=> 'Entre as suas páginas assistidas não há alterações...',

	// whatsnew action
	'NewCommentAdded'			=> 'Adicionado novo comentário',
	'NewFileAdded'				=> 'Adicionado novo arquivo',
	'NewPageCreated'			=> 'Criou uma nova página',
	'NewRevisionAdded'			=> 'Página alterada',
	'Cluster'					=> 'aglomerado',
	'PageDeleted'				=> 'Página excluída',
	'CommentDeleted'			=> 'Comentário excluído',
	'FileDeleted'				=> 'Arquivo excluído',

	// users action
	'UsersSearch'				=> 'Localizar Usuários',
	'UsersOpenProfile'			=> 'Ver Perfil',
	'UsersNoMatching'			=> 'Usuários correspondentes não foram encontrados. Tente um critério de pesquisa menos rigoroso.',
	'UsersName'					=> 'Nome:',
	'UsersPages'				=> 'Páginas',
	'UsersChanges'				=> 'Mudanças',
	'UsersSubscription'			=> 'Subscrições',
	'UsersWatches'				=> 'Acompanhando',
	'UsersComments'				=> 'Comentários',
	'UsersUploads'				=> 'Carregamentos',
	'UploadQuota'				=> 'Espaço usado',
	'UploadQuotaTip'			=> 'Cota de Espaço Upload',
	'UsersLogins'				=> 'Credenciais',
	'UsersRevisions'			=> 'Revisões',
	'UsersSignup'				=> 'Registrar-se',
	'UsersLastSession'			=> 'Última sessão',
	'UsersNotFound'				=> 'Usuário %2 não encontrado. Clique <a href="%1">aqui</a>, para ir para a lista principal.',
	'UsersProfile'				=> 'Perfil',
	'UsersContact'				=> 'Contato',
	'UsersList'					=> 'Ver a lista completa de usuários',
	'UsersNA'					=> '[não definido]',
	'UsersNA2'					=> '[No]',
	'UsersSignupDate'			=> 'Data de inscrição',
	'UsersGroupMembership'		=> 'Membros do grupo',
	'UsersPersonalInfo'			=> 'Informações pessoais',
	'UsersOwnedPages'			=> 'Páginas próprias:',
	'UsersCommentsPosted'		=> 'Comentários postados:',
	'UsersFilesUploaded'		=> 'Arquivos carregados:',
	'UsersRevisionsMade'		=> 'Revisões feitas:',
	'UsersDocsSortName'			=> '[Classificar por nome]',
	'UsersDocsSortCreation'		=> '[Ordenar por data de criação]',
	'UsersChangesSortAsc'		=> '[Ordenar ascendente]',
	'UsersChangesSortDesc'		=> '[Ordenar decrescente]',
	'UsersSessionNA'			=> '[não gravado]',
	'UsersSessionHidden'		=> '[hidden]',
	'IntercomSubject'			=> 'Assunto:',
	'IntercomMessage'			=> 'Mensagem:',
	'IntercomCopy'				=> 'Envie-me uma cópia',
	'IntercomSubjectN'			=> '[criar um novo tópico]',
	'IntercomDisabled'			=> 'Desculpe, você não quer ou não pode receber mensagens pessoais.',
	'IntercomHint'				=> 'Por favor, faça o login primeiro e siga o link novamente, se você deseja responder à mensagem pessoal que recebeu.',
	'IntercomDesc'				=> 'Nota: O envio de mensagens pessoais enviadas ao destinatário sem divulgar o seu endereço. O destinatário poderá responder a você, usando um formulário semelhante na sua página de perfil. ',
	'PMOversized'				=> 'O comprimento da mensagem excede o tamanho máximo permitido por %1. Por favor, encurte sua mensagem e envie novamente.',
	'PMFlooded'					=> 'O intervalo entre o envio de mensagens pessoais não deve ser menor que %1 segundos.',
	'PMSent'					=> 'Mensagem pessoal enviada com sucesso para o usuário.',
	'PMBody'					=> 'Esta mensagem foi enviada a você pelo usuário %1.',
	'PMBodyCopy'				=> 'Você enviou a seguinte mensagem para o usuário %1.',
	'PMReply'					=> 'Para responder este e-mail, clique no link a seguir (não use o botão Responder / Responder no e-mail):',
	'PMNotLoggedIn'				=> 'Você não está registrado no sistema e não pode enviar mensagens pessoais para os usuários.',

	// admin_replace action
	'ReplaceText'				=> 'Substituir texto',
	'TextOriginal'				=> 'Texto original:',
	'TextReplacement'			=> 'Texto de substituição:',
	'ReplaceTextRegex'			=> 'Usar expressões regulares',
	'Namespace'					=> 'Namespace',
	'ReplaceTextCluster'		=> 'Pesquisar e substituir somente dentro deste cluster:',
	'ReplaceTextEditPages'		=> 'Substituir texto no conteúdo da página',
	'ReplaceTextEditComments'	=> 'Substituir texto nos comentários',
	'ReplaceTextEditTitles'		=> 'Substituir texto nos títulos da página',
	'ReplaceTextGiveTarget'		=> 'Você deve especificar a sequência de caracteres para ser substituída.',
	'ReplaceTextNoNamespace'	=> 'Você deve selecionar pelo menos um espaço de nomes.',
	'ReplaceTextNoDifference'	=> 'Não há diferença entre substituir texto e texto alvo.',
	'ReplaceTextNoOption'		=> 'Você deve selecionar pelo menos uma das opções de substituição.',
	'ReplaceTextPagesEdit'		=> 'Substituir %1 por %2 no texto das seguintes páginas %3:',
	'ReplaceTextTitlesEdit'		=> 'Substituir %1 com %2 nos títulos das seguintes páginas %3:',
	'ReplaceTextReplace'		=> 'Substituir',
	'ReplaceTextSuccess'		=> '%1 foi substituído por %2 em páginas %3.',
	'ReplaceTextNoMatch'		=> 'Nenhuma página foi encontrada contendo a seqüência de caracteres %1.',
	'ReplaceTextNoTitleMatch'	=> 'Nenhuma página foi encontrada com %1.',
	'ReplaceTextEditFailed'		=> 'Falha ao substituir texto',
	'ReplaceTextTitleTooBig'	=> 'Texto original ou substituição é muito grande para o título.',
	'ReplaceTextReturn'			=> 'Retornar ao formulário',
	'ReplaceTextWarning'		=> 'Aviso: Existem páginas %1 que já contêm a string de substituição, %2. Se você fizer essa substituição, você não poderá separar suas substituições dessas frases.',
	'ReplaceTextBlankWarning'	=> 'Aviso: Como a string de substituição está em branco, esta operação não será reversível.',
	'ReplaceTextEditSummary'	=> 'Substituição de texto: %1 → %2',
	'InvertSelection'			=> 'Inverter seleção',

	// Properties
	'PropertiesFor'				=> 'Propriedades de página para %1',
	'MetaTag'					=> 'Etiqueta',
	'MetaTitle'					=> 'Título',
	'MetaKeywords'				=> 'Palavras-chave',
	'MetaDescription'			=> 'Descrição:',
	'On'						=> 'Ligado',
	'Off'						=> 'Desligado',
	'Registered'				=> 'Registrado',
	'MetaComments'				=> 'Mostrar comentários',
	'MetaFiles'					=> 'Mostrar painel de arquivos',
	'MetaToc'					=> 'Mostrar tabela de conteúdos',
	'MetaIndex'					=> 'Mostrar painel de seções do cluster',
	'MetaIndexMode'				=> 'Mostrar Modo de Nível',
	'MetaIndexFull'				=> 'Árvore',
	'MetaIndexUpper'			=> 'Superior',
	'MetaIndexLower'			=> 'Baixo',
	'MetaHtml'					=> 'Suporte HTML para a página',
	'MetaSafeHtml'				=> 'Filtragem de HTML inseguro',
	'MetaTypografica'			=> 'Revisor Typográfico',
	'MetaNoIndex'				=> 'Bloquear motores de busca',
	'SettingsID'				=> 'ID da Página',
	'SettingsSize'				=> 'Tamanho',
	'SettingsSizeTip'			=> 'fonte / compilada',
	'SettingsCreated'			=> 'Criado',
	'SettingsCurrent'			=> 'Modificado',
	'SettingsTotalRevs'			=> 'Revisões',
	'SettingsTotalComs'			=> 'Comentários',
	'SettingsWatchers'			=> 'Observadores',
	'SettingsHits'				=> 'Visualizações',
	'SettingsText'				=> 'Confirgurações',
	'SettingsEdit'				=> 'Alterar',
	'SettingsRevisions'			=> 'Revisões',
	'SettingsClone'				=> 'Clonar',
	'SettingsRename'			=> 'Renomear',
	'MassRename'				=> 'para todo o cluster',
	'SettingsRemove'			=> 'Excluir',
	'SettingsPurge'				=> 'Purge',
	'SettingsModerate'			=> 'Moderado',
	'SettingsPermissions'		=> 'Permissões',
	'AclForEntireCluster'		=> 'para todo o cluster',
	'SettingsAttachments'		=> 'Anexos',
	'SettingsUpload'			=> 'Transferir',
	'SettingsCategories'		=> 'Categorias',
	'SettingsLanguages'			=> 'Idiomas',
	'SettingsReferrers'			=> 'Referências',
	'SettingsWatch'				=> 'Acompanhar',
	'SettingsLatex'				=> 'Versão LaTeX',
	'SettingsXML'				=> 'Exportar em formato XML',
	'NeedToChangeLang'			=> 'O idioma da página %1 não suportado precisa ser alterado.',
	'SetLang'					=> 'Idioma desta página',
	'SetMenuLabel'				=> 'Rótulo do menu',
	'SetShowMenuLabel'			=> 'Mostrar na navegação',

	// upload
	'UploadFiles'				=> 'Upload de arquivos',
	'UploadFor'					=> 'Envio de arquivo:',
	'UploadButton'				=> 'Transferir',
	'UploadGlobalText'			=> 'para acesso público',
	'UploadGlobal'				=> 'Global',
	'UploadLocalText'			=> 'somente para usuários autorizados a ver a página atual',
	'UploadAsName'				=> 'Nome:',
	'UploadOverwrite'			=> 'Sobrescrever arquivos existentes',
	'FileDesc'					=> 'Descrição:',
	'UploadForbidden'			=> 'Você não tem permissão para enviar arquivos aqui.',
	'UploadOverwriteDenied'		=> 'Apenas o proprietário do arquivo ou administrador pode substituir o arquivo %1.',
	'UploadNoFile'				=> 'Não havia nenhum arquivo na forma, por alguma razão.',
	'UploadMaxSizeReached'		=> 'Tamanho do arquivo excede o limite permitido!',
	'UploadDirNotWritable'		=> 'O diretório do arquivo não tem permissões de escrita!',
	'UploadNotAPicture'			=> 'Só são permitidos uploads de imagens. O que você está tentando enviar?',
	'UploadEmptyExtension'		=> 'O nome do arquivo e a extensão não podem estar vazios.',
	'FilenameTooLong'			=> 'Os nomes dos arquivos não podem ser maiores que 240 bytes.',
	'BannedFiletype'			=> '%1 não é um tipo de arquivo permitido.',
	'PermittedFiletype'			=> 'Tipos de arquivo permitidos:',
	'UploadMimeMismatch'		=> 'A extensão do arquivo %1 não corresponde ao tipo MIME detectado (%2).',
	'UploadBadMime'				=> 'Arquivos do tipo MIME %1 não são permitidos para upload.',
	'FileIsDuplicate'			=> 'O upload é uma duplicata exata da versão atual.',
	'FileHasDuplicate'			=> 'Este arquivo é uma duplicata dos seguintes arquivos:',

	'UploadMaxFileQuota'		=> 'Você atingiu seu limite de upload. Este arquivo não pode ser carregado',
	'UploadDone'				=> 'Arquivo enviado com sucesso',
	'UploadFileForbidden'		=> 'Acesso ao arquivo proibido',
	'UploadTitle'				=> 'Arquivos acessíveis a partir desta página',
	'UploadTitleGlobal'			=> 'Arquivos acessíveis de qualquer lugar',

	'UploadFile'				=> 'Transferir',
	'UploadMax'					=> 'Não mais do que ',
	'UploadUsedStorage'			=> 'Armazenamento em uso ',

	// attachments
	'Attachments'				=> 'Anexos',
	'Attachment'				=> 'Anexo',
	'AttachmentsToPage'			=> 'para a página',
	'AttachmentsToCluster'		=> 'aglomerado',
	'AttachmentsByTime'			=> 'por horário',
	'AttachmentsGlobal'			=> 'Global',
	'AttachmentsAll'			=> 'Todos',
	'AttachmentsLinked'			=> 'Utilizado',

	'FileViewProperties'		=> 'Visualizar',
	'FileViewPropertiesTip'		=> 'Ver os metadados deste arquivo',
	'FileEditProperties'		=> 'Alterar',
	'FileEditPropertiesTip'		=> 'Editar os metadados deste arquivo',
	'FileEditedMeta'			=> 'Metadados atualizados deste arquivo',
	'FileEditDenied'			=> 'Você não tem permissão para editar este arquivo',
	'FileLabel'					=> 'Descrição',
	'FileLabelTip'				=> 'Rotular este arquivo',
	'FileRemove'				=> 'Excluir',
	'FileRemovedFromDB'			=> 'Arquivo removido da base de dados',
	'FileRemovedFromFS'			=> 'Arquivo apagado da hospedagem física',
	'FileRemovedFromFSError'	=> 'Não é possível apagar o ficheiro!',
	'FileRemoveConfirm'			=> 'Tem certeza que deseja remover este arquivo?',
	'FileRemoveDenied'			=> 'Você não tem permissão para remover este arquivo',
	'FileNotFound'				=> 'Arquivo não encontrado',

	'FileSearch'				=> 'Localizar arquivo',
	'UploadBy'					=> 'Enviado por:',
	'FileAdded'					=> 'Adicionado:',
	'FileModified'				=> 'Modificado:',
	'FileSize'					=> 'Tamanho:',
	'FileDimension'				=> 'Dimensão:',
	'MimeType'					=> 'Mimetype:',
	'FileName'					=> 'Nome:',
	'FileCaption'				=> 'Título:',
	'FileAuthor'				=> 'Autor:',
	'FileSource'				=> 'Fonte:',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> 'Anexado a:',
	'FileSyntax'				=> 'Sintaxe:',
	'FileAbsolutePath'			=> 'caminho absoluto',
	'FileRelativePath'			=> 'caminho relativo',
	'FileUsage'					=> 'Uso de arquivo:',
	'FileUsageText'				=> 'As seguintes páginas link para este arquivo:',
	'NoFileUsage'				=> 'Nenhum link de página para este arquivo.',

	'FileSortExt'				=> 'extensão',
	'FileSortName'				=> 'Nome',
	'FileSortSize'				=> 'tamanho',
	'FileSortTime'				=> 'Criado',

	'SortBy'					=> 'Classificar por',
	'Ascending'					=> 'crescente',
	'Decending'					=> 'decrescente',

	'Files0'					=> 'Anexar arquivos',
	'Files1'					=> 'Mostrar Arquivos (1 Arquivo)',
	'FilesN'					=> 'Mostrar Arquivos (%1 Arquivos)',
	'Files'						=> 'Arquivos',
	'File'						=> 'Arquivo',
	'ShowFiles'					=> 'Exibir arquivos / formulário',
	'HideFiles'					=> 'Ocultar arquivos / formulário',
	'DoShowFiles'				=> 'Mostrar listas de arquivos por padrão',
	'NoAttachments'				=> 'Não há arquivos anexados para exibir.',

	'RegistrationLang'			=> 'Seu idioma',
	'InvalidWikiName'			=> 'O nome escolhido é inválido',
	'InvalidUserName'			=> 'O nome de usuário escolhido é inválido',
	'Bookmarks'					=> 'Favoritos',
	'ReallyDeleteComment'		=> 'Você realmente deseja EXCLUIR este comentário?<br>Não há como desfazer esta ação!',
	'ReallyDeleteRevision'		=> 'Você realmente deseja EXCLUIR esta revisão?<br>Não há nenhum desfazer para esta ação!',

	'RegistrationClosed'		=> 'Cadastro não está disponível aqui. Tente entrar em contato com o administrador do site.',
	'AclAreYouSure'				=> 'Você vai alterar ACLs desta página e de todas as suas subpáginas. Continuar?',

	'BookmarkDeleteSelected'	=> 'Excluir Selecionados',
	'BookmarkMark'				=> 'Nota',
	'BookmarkNumber'			=> 'Não.',
	'BookmarkNone'				=> 'Você não tem nenhum favorito.',
	'BookmarkTitle'				=> 'Título do favorito',
	'BookmarkPage'				=> 'Página',
	'BookmarkSaveChanges'		=> 'Salvar as alterações',
	'BookmarksAddPage'			=> 'Definir um favorito para a seguinte página',
	'BookmarkAlreadyExists'		=> 'O favorito já existe.',

	'PoweredBy'					=> 'Desenvolvido por',

	'MassRenaming'				=> 'Renomear o cluster inteiro',
	'MassNewName'				=> 'Digite um novo nome para este grupo',
	'MassNeedRedirect'			=> 'Criar redirecionamento para as novas páginas nas páginas antigas',

	// pagination
	'ToOverview'				=> 'Voltar para visão geral',
	'Overview'					=> 'Geral',
	'ToThePage'					=> 'Para a página:',
	'Next'						=> 'Próximo',
	'Prev'						=> 'Anterior',
	'NextAcr'					=> 'Próximo',
	'PrevAcr'					=> 'Anterior',
	'Back'						=> 'Anterior',

	// filter
	'Filter'					=> 'filtro',
	'OptionalFilters'			=> 'Filtros opcionais:',
	'Any'						=> 'qualquer',

	// My Groups
	'UserGroups'				=> 'Grupos de usuários',
	'MyGroups'					=> 'Associações de Grupos',
	'Group'						=> 'grupo',
	'Groups'					=> 'grupos',

	// license action
	'DistributedUnder'			=> 'Material é distribuído sob',
	'AuthorsDisplayHint'		=> 'A lista de autores será exibida quando salvar a página.',
	'AnonymousUsers'			=> 'Usuários anônimos',
	'License'					=> 'Tipo:',
	'LicenseArray'				=> [
		'1'		=> 'Atribuição-NoDerivadas',
		'2'		=> 'Atribuição-Não Comercial-Partilha de Ativos',
		'3'		=> 'Atribuição-NãoComercial-NoDerivadas',
		'4'		=> 'Atribuição-CompartilhaIgual',
		'5'		=> 'Atribuição-Não Comercial',
		'6'		=> 'Atribuição',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'Licença de Documentação Gratuita GNU',
		'9'		=> 'Domínio Público / Uso Gratuito',
		'10'	=> 'Todos os Direitos Reservados',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Domínio público',
		'2'		=> 'Alguns direitos reservados',
		'3'		=> 'Todos os Direitos Reservados',
	],

	// Cache
	'ClearCache'				=> 'Limpar cache',
	'CacheCleared'				=> 'Cache limpo.',
	'ConfigCache'				=> 'Configurar cache',
	'FeedCache'					=> 'Cache de feed',
	'PageCache'					=> 'Cache de página',
	'SQLCache'					=> 'Cache de SQL',
	'TemplateCache'				=> 'Cache de modelos',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Por favor, especifique um endereço do recurso com o URL do parâmetro. (por exemplo, {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Título do Feed',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Por favor, especifique um Feed com o URL de parâmetro. (por exemplo, {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Não foi possível carregar ou analisar feed',
	'FeedSource'				=> 'Fonte:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Alterações recentes',
	'ChangesXML'				=> 'Alterações recentes para o ',
	'CommentsXMLTitle'			=> ' - Comentários recentes',
	'CommentsXML'				=> 'Comentários recentes para ',
	'NewsXMLTitle'				=> ' - Notícias recentes',
	'NewsXML'					=> 'Notícias recentes para ',
	'RevisionXMLTip'			=> 'Clique para ver as revisões de página recentes no formato XML.',
	'CommentsXMLTip'			=> 'Clique para ver os comentários recentes no formato XML.',
	'ChangesXMLTip'				=> 'Clique para ver as alterações recentes no formato XML.',
	'NewsXMLTip'				=> 'Clique para ver as notícias recentes no formato XML.',
	'RevisionsXML'				=> 'Revisões de ',
	'ExportClusterXML'			=> 'Exportação completa de ',
	'AccessDeniedXML'			=> 'Você não tem permissão para acessar esta informação.',

	'ChangesFeed'				=> 'Mudanças',
	'CommentsFeed'				=> 'Comentários',
	'NewsFeed'					=> 'Notícias',
	'RevisionsFeed'				=> 'Revisões de ',

	'LastModification'			=> 'Última modificação',

	// Captcha
	'Captcha'					=> 'Por favor, digite a palavra que você leu na imagem',
	'CaptchaFailed'				=> 'Você digitou a palavra captcha incorretamente. Por favor, tente novamente.',
	'CaptchaReload'				=> 'Novo Captcha',
	'CaptchaReloadWarning'		=> 'Desculpe, não foi possível recarregar a imagem captcha, você terá que recarregar a página para fazer isso',

	// news
	'News'						=> 'Notícias',
	'NewsName'					=> 'Titulo:',
	'NewsNoName'				=> 'Você esqueceu de adicionar título de notícias.',
	'NewsNotAvailable'			=> 'Nenhuma notícia disponível.',
	'NewsNoClusterDefined'		=> 'Nenhum cluster de notícias definido.',
	'NewsDiscuss'				=> 'Discutir este artigo...',

	// blog
	'BlogNewTopic'				=> 'Criar uma nova postagem',
	'NoPostAvailable'			=> 'Nenhuma publicação disponível ainda.',

	// Review
	'Reviewer'					=> 'Revisor',
	'Reviewed'					=> 'revisado',
	'Review'					=> 'análise',
	'ReviewedBy'				=> 'revisado por',
	'RemoveReview'				=> 'Remover revisão desta página',
	'SetReview'					=> 'Revisado nesta página',
	'SetAsReviewed'				=> 'Definir página como revisada',
	'SetAsUnreviewed'			=> 'Definir página como não revisada',

	// word filter
	'PotentialSpam'				=> 'Spam Potencial Identificado',

	// moderation handler
	'Moderation'				=> 'Moderação',
	'Topics'					=> 'tópicos',
	'ModerateSection'			=> 'seção / página ',

	'NotModerator'				=> 'Você não tem autoridade para moderar essa página / capítulo',
	'ModerateDeleteTopic'		=> 'Excluir tópico / página',
	'ModerateDeletePosts'		=> 'Excluir comentários',
	'ModerateMove'				=> 'Mover-se',
	'ModerateSplit'				=> 'Dividir / Mover comentários',
	'ModerateMerge'				=> 'Mesclar',
	'ModerateLock'				=> 'Bloquear',
	'ModerateUnlock'			=> 'Desbloquear',
	'ModerateAccept'			=> 'Aceitar',
	'ModerateDeleteConfirm'		=> 'Tem certeza de que deseja <strong>remover</strong> os seguintes tópicos?',
	'ModerateRenameConfirm'		=> 'Digite um novo título para a página selecionada',
	'ModerateRenameExists'		=> 'Página com o mesmo nome já existe! Escolha um nome diferente.',
	'ModerateRename1Only'		=> 'Nota: somente a primeira página que você selecionou será renomeada!',
	'ModerateMovesConfirm'		=> 'Selecione a partição de destino para mover o fórum para',
	'ModerateMoveConfirm'		=> 'Selecione o fórum ou especifique o cluster para mover estes tópicos. Para mover uma página para a raiz do site, digite &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Especifique o nome do cluster no qual colocar a página. Para mover uma página para a raiz do site, digite &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operação abortada: nesta seção já existem tópicos com o mesmo nome %1. Se você ainda precisa transferir os tópicos acima mencionados, por favor, renomee-os primeiro.',
	'ModerateMoveNotExists'		=> 'A página / cluster não existe. Por favor, verifique o nome e tente novamente.',
	'ModerateMergeConfirm'		=> 'Escolha um tópico, que deve combinar o restante',
	'ModerateMerge2Min'			=> 'Para se juntar você deve selecionar pelo menos dois tópicos!',
	'ModerateComDelConfirm'		=> 'Tem certeza que deseja remover <strong>remover</strong> %1 %2?',
	'ModerateComment'			=> 'Comentar',
	'ModerateComments'			=> 'Comentários',
	'ModerateSplitNewName'		=> 'Especifique um nome para um tópico separável e selecione um esquema de separação',
	'ModerateSplitPageName'		=> 'Digite o nome da página / tópico, onde mover comentários destacáveis e selecione um esquema de separação',
	'ModerateSplitAllAfter'		=> 'Desanexar todos os comentários após o primeiro selecionado (e incluindo)',
	'ModerateSplitSelected'		=> 'Separados apenas comentários selecionados (total %1)',
	'ModerateUserProfile'		=> 'perfil',
	'ModerateNoItemChosen'		=> 'Por favor, selecione pelo menos um item através do botão Configurar.',

	'ModerateSection2'			=> 'seção moderada',
	'ModerateTopicsDeleted'		=> 'Tópicos selecionados excluídos com sucesso.',
	'ModerateTopicsRelocated'	=> 'Tópicos selecionados relocalizados com sucesso.',
	'ModerateTopicsRenamed'		=> 'Tópico renomeado com sucesso.',
	'ModerateTopicsMerged'		=> 'Tópicos selecionados mesclados com sucesso.',
	'ModerateTopicsBlocked'		=> 'Tópicos selecionados bloqueados com sucesso',
	'ModerateTopicsUnlocked'	=> 'Tópicos selecionados desbloqueados com sucesso.',
	'ModerateTopicDeleted'		=> 'O tópico foi removido com sucesso.',
	'ModeratePageMoved'			=> 'Página movida com sucesso.',
	'ModerateTopicRenamed'		=> 'Tópico renomeado com sucesso.',
	'ModerateTopicBlocked'		=> 'Tópico bloqueado com sucesso',
	'ModerateTopicUnlocked'		=> 'Tópico desbloqueado com sucesso.',
	'ModerateCommentsDeleted'	=> 'Comentários selecionados removidos com sucesso.',
	'ModerateCommentsSplit'		=> 'Comentários selecionados separados com sucesso em um novo tópico.',
	'ModerateCommentsSplitFailed'	=> 'Nota: Por alguma razão a separação dos comentários selecionados para um novo tópico falhou. U<br>geralmente isso não deve acontecer, então por favor notifique o administrador do site.<br>Como precaução, a questão foi preservada na sua forma original.',
	'ModerateCommentsMoved'		=> 'Comentários selecionados migraram com sucesso para uma determinada página.',

	// forum
	'ForumSubforums'			=> 'Fórum',
	'ForumTopic'				=> 'Tópico',
	'ForumTopics'				=> 'Disciplinas',
	'ForumPosts'				=> 'Postagens',
	'ForumReplies'				=> 'Respostas',
	'ForumAuthor'				=> 'Autor',
	'ForumViews'				=> 'Visualizações',
	'ForumCreated'				=> 'Criado',
	'ForumComments'				=> 'Comentários',
	'ForumLastComment'			=> 'Último comentário',
	'ForumNoComments'			=> 'Sem Comentários',
	'ForumNoTopics'				=> 'Não há tópicos ou mensagens neste fórum.',
	'ForumNewTopic'				=> 'Iniciar uma nova discussão',
	'ForumTopicName'			=> 'Nome do tópico:',
	'ForumTopicSubmit'			=> 'Enviar tópico',
	'ForumNoTopicName'			=> 'Especifique um nome para a nova página.',
	'ForumNewPosts'				=> 'nova postagem',
	'ForumLocked'				=> 'seção bloqueada',
	'ForumUpdated'				=> 'Atualizado',
	'ForumNoClusterDefined'		=> 'Nenhum cluster de fórum definido.',
	'ForumOutsideCluster'		=> 'Certifique-se de que a ação %1 esteja localizada no cluster do fórum.',

	// password complexity
	'PwdCplxShort'				=> 'A senha é muito curta.',
	'PwdCplxEquals'				=> 'A senha contém o nome do usuário.',
	'PwdCplxWeak'				=> 'A senha não atende aos requisitos de complexidade.',
	'PwdCplxDesc1'				=> 'Requisitos para a senha: ',
	'PwdCplxDesc2'				=> 'a senha não deve ser inferior a %1 caracteres',
	'PwdCplxDesc3'				=> 'não deve conter seu nome de usuário',
	'PwdCplxDesc4'				=> 'deve consistir de ',
	'PwdCplxDesc41'				=> 'letras e números',
	'PwdCplxDesc42'				=> 'letras maiúsculas e minúsculas e números',
	'PwdCplxDesc43'				=> 'letras maiúsculas e minúsculas, caracteres alfanuméricos e não alfanuméricos',
	'PwdCplxDesc5'				=> 'Você pode usar quaisquer letras, números e caracteres especiais, exceto espaços.',

	'PasswordTooShort'			=> 'Senha muito curta.',
	'PasswordTooCommon'			=> 'Essa senha é muito comum.',
	'PasswordSameAsUsername'	=> 'Sua senha é igual ao seu nome de usuário.',
	'PasswordSameAsEmail'		=> 'Sua senha é igual ao seu e-mail.',

	'Timezone'					=> 'Timezone',
	'DateFormat'				=> 'Formato da Data',

	'LanguageArray'	=> [
		'ar' => 'Arábico',
		'bg' => 'Búlgaro',
		'cs' => 'Tcheco',
		'da' => 'Dinamarquês',
		'de' => 'Alemão',
		'el' => 'Grego',
		'en' => 'Inglês',
		'es' => 'Espanhol',
		'et' => 'Estônio',
		'fa' => 'Persa',
		'fi' => 'Finlandês',
		'fr' => 'Francês',
		'hi' => 'Hindi',
		'hu' => 'Húngaro',
		'id' => 'Indonésio',
		'it' => 'Italiano',
		'ja' => 'Japonês',
		'ko' => 'Coreano',
		'nl' => 'Neerlandês',
		'no' => 'Norueguês',
		'pl' => 'Polonês',
		'pt' => 'Português',
		'pt-br' => 'Português-Brasil',
		'ro' => 'Romanico',
		'ru' => 'Russo',
		'sv' => 'Sueco',
		'ta' => 'Tamil',
		'uk' => 'Ucraniano',
		'zh' => 'Chinês',
		'zh-tw' => 'Chinês',
	],

	'AccountStatus'				=> 'Status da conta',
	'AccountStatusArray' => [
		'0' => 'Ativo',
		'1' => 'Pendente',
		'2' => 'bloqueada',
		'3' => 'Inativo',
	],

	'JustNow'		=> 'neste momento',
	'MinuteAgo'		=> 'há um minuto atrás',
	'MinutesAgo'	=> '%1 minutes ago',
	'HourAgo'		=> 'uma hora atrás',
	'HoursAgo'		=> '%1 hours ago',
	'DayAgo'		=> 'Ontem',
	'DaysAgo'		=> '%1 dias atrás',
	'WeekAgo'		=> 'uma semana atrás',
	'WeeksAgo'		=> '%1 weeks ago',
	'MonthAgo'		=> 'há um mês',
	'MonthsAgo'		=> '%1 months ago',
	'YearAgo'		=> 'um ano atrás',
	'YearsAgo'		=> '%1 years ago',

	'InAMoment'		=> 'em um momento',
	'InAMinute'		=> 'em um minuto',
	'InMinutes'		=> 'em %1 minutos',
	'InAnHour'		=> 'em uma hora',
	'InHours'		=> 'em %1 horas',
	'Tomorrow'		=> 'Amanhã',
	'InDays'		=> 'em %1 dias',
	'InAWeek'		=> 'em uma semana',
	'InWeeks'		=> 'em %1 semanas',
	'InAMonth'		=> 'em um mês',
	'InMonths'		=> 'em %1 meses',
	'InAYear'		=> 'em um ano',
	'InYears'		=> 'em %1 anos',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'KB', 'MB', 'BR', 'Tb', 'PCP', 'FB', 'ZB', 'PB'],
	'ByteDecimalLong'			=> ['byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'PM', 'Guiné', 'PT', 'PP', 'PE', 'ZP', 'PI'],
	'PixelDecimalLong'			=> ['Píxel', 'Kpx', 'Mpx', 'JPX', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Ação desconhecida',
	'UnknownMethod'				=> 'Método desconhecido',
	'FormatterNotFound'			=> 'Formatter %1 não encontrado',

	// log
	'LogAdminLoginSuccess'		=> 'Login bem sucedido no painel administrativo',
	'LogAdminLogout'			=> 'Sair do painel administrativo',
	'LogAdminLoginFailed'		=> '!!Falha ao autorizar o acesso ao painel administrativo!!',
	'LogAdminLoginLocked'		=> 'Login bloqueado para o painel administrativo',
	'LogUserCookieForged'		=> '!!**Uma tentativa de se conectar em um cookie forjado com o login ##%1##**!!',
	'LogInvalidFormToken'		=> 'Ataque potencial do CSRF detectado em andamento: %1',
	'LogRemovedPage'			=> '!!Página removida ##%1## (Usuário %2)!!',
	'LogRemovedCluster'			=> '!!Removido **cluster** ##%1## (usuário %2)!!',
	'LogRemovedRevision'		=> '!!Revisão removida ##%3## da página [[/%1]] (usuário %2)!!',
	'LogRemovedComment'			=> '!!Comentário removido de %3 na página [[/%1]] (usuário %2)!!',
	'LogRemovedFile'			=> '!!Arquivo removido ##%2## da página [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!Removido todos os comentários da página [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Removido todas as revisões da página [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Removido todos os arquivos, anexados a [[/%1]]!!',
	'LogTopicLocked'			=> 'Tópico do fórum está bloqueado [[/%1]]',
	'LogTopicUnlocked'			=> 'Tópico do fórum desbloqueado [[/%1]]',
	'LogAclUpdated'				=> 'Página ACL Atualizada [[/%1]]',
	'LogOwnershipChanged'		=> 'O proprietário da página [[/%1]] foi transferido para o usuário ##%2##',
	'LogUserLoginFailed'		=> '!!Tentativas malsucedidas de login com ##~%1##!!',
	'LogClonedPage'				=> 'Página ##%1## clonado para [[/%2]]',
	'LogRenamedPage'			=> 'Página ## ##%1## renomeado para [[/%2]]',
	'LogRenamedPage2'			=> '. A página antiga definida como o link para a nova',
	'LogSplittedPage'			=> 'Comentários da página [[/%1]] dividir-se na página [[/%2]]',
	'LogMergedPages'			=> 'Páginas %1 fundidas à página [[/%2]]',
	'LogUserPasswordReminded'	=> 'Usuário ##%1## pediu o processo de recuperação de senha para abordar ##%2##',
	'LogUserPasswordRecovered'	=> 'Usuário ##%1## recuperou com sucesso a senha esquecida',
	'LogUserPasswordChanged'	=> 'Usuário ##%1## atualizado com sucesso (alterado) a senha',
	'LogUserPasswordMismatch'	=> '!!Usuário ##%1## Falha ao alterar a senha: senha atual não confe!!',
	'LogUserIPSwitched'			=> 'Alteração de endereço IP não autorizado do usuário %1 do %2 para %3',
	'LogPageImported'			=> 'Página importada [[/%1]]',
	'LogSaveNoRights'			=> 'Sem permissões para salvar a página [[/%1]]',
	'LogPageCreated'			=> 'Criada nova página [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Propriedades de página atualizadas [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'O usuário assumiu o controle da página [[/%1]]',
	'LogFileUploadedLocal'		=> 'Novo arquivo ##%2## enviado para a página [[/%1]] (tamanho %3)',
	'LogFileUploadedGlobal'		=> 'Novo arquivo ##%2## enviado para a pasta global (tamanho %3)',
	'LogPMSent'					=> 'Mensagem pessoal ##%1## -> ##%2## enviada com sucesso',
	'LogUserSimilarName'		=> 'Houve tentativas para se registrar sob o mesmo nome de usuário: ##%1##',
	'LogUserEmailNotAllowed'	=> 'E-mail ##%1## Não está na lista de domínios permitidos',
	'LogRegisterTiming'			=> 'Falha no cadastro, o limite da hora do formulário é ##%1## segundos (foi ##%2##)',
	'LogUserRegistered'			=> 'Registrou um novo usuário com sucesso ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'E-mail ##%1## do usuário ##%2## ativado com sucesso',
	'LogCommentPosted'			=> 'Adicionado [[/%1 novo(s) comentário(s)]] à página [[/%2]]',
	'LogUserLoginOK'			=> 'Usuário ##%1## logado com sucesso no sistema',
	'LogUserLoggedOut'			=> 'Usuário ##%1## desconectou do sistema com sucesso',
	'LogUserSessionContinued'	=> 'Usuário ##%1## continuou a sessão suspensa',
	'LogUserSettingsUpdate'		=> 'Usuário ##%1## atualizou configurações pessoais',
	'LogPageEdited'				=> 'Página editada [[/%1]]',
	'LogCommentEdited'			=> 'Comentário editado [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Metadados de arquivos atualizados para ##%2## da página [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Categorias de arquivos atualizadas para ##%2## da página [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'Sitemap XML gerado',
	'LogReferrersPurged'		=> 'Manutenção: referenciadores removidos',
	'LogRevisionsPurged'		=> 'Manutenção: revisões de páginas desatualizadas removidas',
	'LogDeletedPagesPurged'		=> 'Manutenção: páginas apagadas apagadas',
	'LogSystemLogPurged'		=> 'Manutenção: log do sistema limpo',
	'LogCachedPagesPurged'		=> 'Manutenção: páginas em cache removidas',
	'LogSqlCachePurged'			=> 'Manutenção: resultados do sql em cache purgado',
	'LogExpiredTokensPurged'	=> 'Manutenção: cookie_tokens excluídos expirados',
	'LogErrorSplitComments'		=> 'Erro ao separar comentários do tópico [[/%1]] um novo tópico ##%2##: página não foi criada',
	'LogCategoriesUpdated'		=> 'Categorias de página atualizadas [[/%1]]',
	'LogCategoryCreated'		=> 'Criado uma nova categoria //%1//',
	'LogCategoryRenamed'		=> 'Categoria ##%1## renomeada para ##%2##',
	'LogCategoryDebundled'		=> 'Categoria ##%1## debilitada',
	'LogCategoryGrouped'		=> 'Categoria ##%1## agrupada com a palavra ##%2##',
	'LogCategoryRemoved'		=> 'Categoria ##%1## removida do banco de dados',
	'LogThumbnailGeneration'	=> 'Miniaturas geram %1 seg.',

	'ErrorMinPHPVersion'		=> 'A versão do PHP deve ser maior do que <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' seu servidor parece estar executando <strong>' . PHP_VERSION . '</strong>.' .
									'  Você deve atualizar para uma versão mais recente do PHP para que o WackoWiki funcione corretamente.',

];
