<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Portuguese',
		'code'		=> 'pt',
		'dir'		=> 'ltr',
		'locale'	=> 'pt_PT',
	],

	'date_formats'	 => [
		'default'	=> 'dd/MM/y',
	],

	// common
	'AddButton'					=> 'Adicionar',
	'ArchiveButton'				=> 'Arquivo',
	'CancelButton'				=> 'Cancelar',
	'ContinueButton'			=> 'Prosseguir',
	'ConvertButton'				=> 'Converter',
	'CreateButton'				=> 'Criar',
	'DeleteButton'				=> 'Apague',
	'RemoveButton'				=> 'Remover',
	'RenameButton'				=> 'Renomear',
	'ResetButton'				=> 'Limpar',
	'RestoreButton'				=> 'Restaurar',
	'SaveButton'				=> 'Guardar',
	'SearchButton'				=> 'Pesquisa',
	'SendButton'				=> 'Enviar',
	'SetButton'					=> 'Definir',
	'SubmitButton'				=> 'Enviar',
	'UpdateButton'				=> 'Atualizar',

	'FormInvalid'				=> 'Campo inválido. Tente submeter novamente.',
	'UnitPixel'					=> 'px',
	'Number'					=> 'Número',

	// logged in panel
	'AccountText'				=> 'Conta Pessoal',
	'AccountTip'				=> 'Configurações da conta',
	'AdminText'					=> 'Administrador',
	'AdminTip'					=> 'Painel de Administração',
	'LogoutLink'				=> 'Desligar',
	'LogoutButton'				=> 'Desligar',
	'LogoutAreYouSure'			=> 'Quer mesmo desligar?',

	// registration panel
	'RegistrationWelcome'		=> 'Registo de Novo Utilizador:',
	'RegistrationButton'		=> 'Registe-me!',
	'UserNameOwned'				=> 'Este Nome de Utilizador já está registado. Por favor escolha outro.',
	'SiteRegistered'			=> 'Você se registrou com sucesso no site %1.',
	'RegistrationEmailInfo'		=> 'Um endereço de e-mail válido. Todos os e-mails do sistema serão enviados para este endereço. O endereço de e-mail não é tornado público e só será usado se você desejar receber uma nova senha ou desejar receber certas notícias ou notificações por e-mail.',
	'EmailConfirmHint'			=> 'Por favor, confirme o seu endereço de e-mail clicando no link das instruções que lhe foram enviadas. <br>Se você não verificar seu endereço de e-mail, você não poderá recuperar uma possível senha perdida. Além disso, você não será notificado de alterações recentes na página e comentários.',
	'EmailConfirmRequired'		=> 'Sem um endereço de correio eletrónico confirmado, não será autorizado a iniciar sessão.',
	'NameTooShort'				=> 'O Nome de Utilizador é muito curto. O mínimo de caracteres é de %2.',
	'NameTooLong'				=> 'O Nome de Utilizador é muito longo. O máximo de caracteres permitidos são %2.',
	'NameAlphanumOnly'			=> 'O Nome de Utilizador deve ser constituído por %1 a %2 caracteres e usar somente caracteres alfanuméricos.',
	'NameCamelCaseOnly'			=> 'O Nome de Utilizador deve ser constituído por %1 a %2 caracteres e WikiName formatted.',
	'NewUserAccount'			=> 'nova conta de usuário',

	'NewAccountSubject'			=> 'Registro de conta',
	'NewAccountAdminCreated'	=> 'O usuário  %1 criou uma conta para você com o nome de usuário "%2". Para completar seu registro, visite o endereço a seguir (certifique-se que ele seja digitado como uma única linha) e ajuste a sua própria senha de acesso:',
	'NewAccountUsername'		=> 'Nome de usuário:',
	'AccountLanguage'			=> 'Língua:',
	'NewAccountEmail'			=> 'E-mail:',
	'NewAccountIP'				=> 'Endereço IP remoto:',
	'NewAccountSignupInfo'		=> 'A seguinte conta foi criada:',

	'UserWaitingApproval'		=> 'Um e-mail foi enviado para o administrador do site. O administrador irá rever a informação que foi enviada e aprovar ou negar o seu pedido.',
	'UserRequiresApproval'		=> 'Para aprovar ou negar o acesso deste usuário a %1 vá para o painel de administração.',
	'UserApprovalInfo'			=> 'Após o seu registo, o seu pedido será enviado ao administrador do site para aprovação. Em seguida, você receberá um e-mail com instruções adicionais.',
	'UserApprovalHint'			=> 'A ativação bem-sucedida de sua conta será anunciada em um e-mail específico. Até lá, um login não é possível.',

	'UserApprovalPending'		=> 'A sua conta ainda está pendente de aprovação.',
	'UserApprovalDenied'		=> 'O acesso a este site foi negado à sua conta.',

	'RegistrationApproved'		=> 'Registro Aprovado',
	'RegistrationDenied'		=> 'Registro negado',
	'PendingApproval'			=> 'Aprovação pendente',

	'UserApprovedInfo'			=> 'Você foi aprovado para acessar %1.',
	'UserDeniedInfo'			=> 'Foi-lhe negado o acesso a %1.',

	'RegistrationThreshold'		=> 'O tempo de preenchimento do formulário não deve ser inferior a %1 segundos.',
	'Language'					=> 'Língua',

	// login panel
	'LoginWelcome'				=> 'Conecte-se',
	'CreateAccount'				=> 'Register',
	'RegistrationLink'			=> 'Criar conta',
	'LoginName'					=> 'Nome de utilizador',
	'Password'					=> 'Palavra-chave',
	'LoginButton'				=> 'Entrar',
	'LoginLink'					=> 'Entrar',
	'PersistentCookie'			=> 'Manter sessão iniciada',
	'Session'					=> 'Sessão',
	'SessionTip'				=> 'parâmetros da sessão atual',
	'SessionDuration'			=> 'Duração da sessão',
	'SessionDurationSession'	=> 'procurar sessão',
	'SessionDurationDay'		=> '1 dia',
	'SessionDurationWeek'		=> '1 semana',
	'SessionDurationMonth'		=> '1 mês',
	'LoggedInAs'				=> 'Está autenticado como',

	'ClearCookies'				=> 'Apagar todos os cookies',
	'BindSessionIp'				=> 'Ligar sessão ao endereço IP',
	'BindSessionIpOn'			=> 'activado (IP actual %1)',
	'TrafficProtection'			=> 'Proteção de tráfego',
	'SessionEnds'				=> 'A sessão atual terminou',
	'LastVisit'					=> 'A última visita foi registada',

	'LoginIncorrect'			=> 'O nome de usuário ou senha que você digitou é inválido.',
	'WelcomeBack'				=> 'Bem-vindo de volta, %1',
	'LoginAttemptsExceeded'		=> 'Excedeu o número máximo de tentativas de login.<br>Além do seu nome de Utilizador e Senha deverá confirmar adicionalmente o código indicado na imagem abaixo.',

	// session notice
	'IPAddressChanged'			=> 'O endereço IP mudou para %1 (foi %2)',

	'SessionReplay'				=> 'Sessão terminada devido ao tempo limite.',
	'SessionObsolete'			=> 'Sessão está desatualizada.',
	'SessionExpired'			=> 'A sua sessão expirou.',
	'SessionTimeout'			=> 'Sessão terminada devido ao tempo limite.',
	'SessionInactivity'			=> 'Sessão terminada por inatividade.',
	'SessionUaChange'			=> 'Sessão encerrada devido a alteração do agente do utilizador.',
	'SessionTLSChange'			=> 'Sessão encerrada devido a alteração do TLS.',
	'SessionIPChange'			=> 'Sessão terminada devido à alteração do IP.',

	// other
	'Guest'						=> 'Clientes',
	'Everybody'					=> 'Todos',
	'Help'						=> 'Ajuda',
	'TopicSearchText'			=> 'Procurar apenas nos títulos',
	'WordprocessorVersion'		=> 'versão processador de texto',

	// notifications
	'EmailHello'				=> 'Olá ',
	'EmailModerator'			=> 'Moderador',
	'WatchedPageChanged'		=> 'Página Alterada ',
	'SomeoneChangedThisPage'	=> ' alterou esta página que está a acompanhar: ',
	'NewPageCreatedSubj'		=> 'Uma nova página',
	'NewPageCreatedBody'		=> 'Usuário %1 criou uma nova página: ',
	'FileUploadedSubj'			=> 'Um novo ficheiro',
	'FileUploadedBody'			=> 'O usuário %1 carregou um novo arquivo: ',
	'FileReplacedBody'			=> 'Usuário %1 substituiu o arquivo: ',

	'ActionDenied'				=> 'Acção negada aqui.',
	'TocTitle'					=> 'Conteúdos ',
	'OuterLink2'				=> 'Link externo',
	'FileLink'					=> '',
	'PDFLink'					=> 'Documento PDF',
	'RDFLink'					=> 'Documento RDF',
	'EmailLink'					=> 'Escreva um e-mail (lançamento do cliente de e-mail)',
	'GeoLink'					=> 'Mostrar esta localização (início do aplicativo)',
	'JabberLink'				=> 'Chat via XMPP (lançamento do cliente Jabber)',
	'TelLink'					=> 'Ligar para este número (lançamento do aplicativo de telefone)',
	'PermaLink'					=> 'Hiperligação permanente',
	'PermaLinkTip'				=> 'Hiperligação permanente para esta revisão da página',
	'PermaLink0Tip'				=> 'Hiperligação permanente desta página',

	'ShowTip'					=> 'Clique para voltar ao modo ver',
	'ShowText'					=> 'Ver',
	'WikieditAutocomplete'		=> 'Complete wikilinks através de Ctrl+Space',
	'WikiEditInactiveJs'		=> 'Para poder usar o WikiEdit, por favor habilite o JavaScript no seu navegador.',
	'NumerateLinks'				=> 'Numerar links na visualização da impressão',
	'Comment'					=> 'Comentário',
	'Comments0'					=> 'Página sem Comentários.',
	'Comments1'					=> 'Ler comentário (1 comentário)',
	'CommentsN'					=> 'Ler comentários (%1 comentários)',
	'Comments'					=> 'Comentários',
	'CommentHint'				=> '<a href="%1">Inicie sessão</a> ou <a href="%2">crie uma conta</a> para publicar um comentário.',
	'CommentEdited'				=> 'editado',
	'Links'						=> 'Links',
	'Version'					=> 'Versão',

	// details formatter
	'ShowHideDetails'			=> 'Detalhes',

	'PrivacyPolicy'				=> 'Política de privacidade',
	'TermsOfUse'				=> 'Termos de uso',
	'AcceptTermsOfUse'			=> 'Eu li, entendi e concordo com os Termos de Serviço do site.',

	'ShowComments'				=> 'Mostrar comentários / formulário',
	'HideComments'				=> 'Fechar Comentários e Formulário',
	'AddComment'				=> 'Anexar comentário a esta página:',
	'AddCommentTitle'			=> 'Título do comentário:',
	'CommentTitleRe'			=> 'Res:',
	'AddCommentButton'			=> 'Anexar comentário',
	'HereLink'					=> 'aqui',
	'PageHandlerMoreTip'		=> 'mais',

	'ThemeCorrupt'				=> 'O tema está corrompido',
	'InvalidNamespace'			=> 'Espaço de nomes inválido dado.',
	'DoesNotExists'				=> 'Esta página ainda não existe.',
	'PromptCreate'				=> 'Talvez a queira <strong><a href="%1">criar</a></strong> agora?',
	'RevisionHint'				=> 'Esta é uma revisão antiga de <a href="%1">%2</a> de %3 editado por %4.',
	'ReadAccessDenied'			=> 'Não está autorizado a ver esta página.',
	'ReadAccessDeniedHintGuest'	=> 'Para ler esta página, deve iniciar sessão.',
	'PageDeletedInfo'			=> 'Esta página foi eliminada.',
	'RevisionDeletedInfo'		=> 'Esta revisão foi eliminada.',
	'CommentDeletedInfo'		=> 'Este comentário foi eliminado.',

	'LastEditedBy'				=> 'Última edição por',
	'YouAreOwner'				=> 'Voçê é o dono desta página.',
	'Owner'						=> 'Dono',
	'OwnerColon'				=> 'Dono:',
	'Nobody'					=> 'Ninguém',
	'TakeOwnership'				=> 'Tomar Posse',
	'FilesTip'					=> 'Gerenciar arquivos anexados',
	'FilesText'					=> 'Anexos',
	'DeleteTip'					=> 'Clique aqui para apagar.',
	'DeleteCommentTip'			=> 'Clique aqui para comentário.',
	'DeleteText'				=> 'Apagar',
	'AclText'					=> 'Permissões',
	'AclTip'					=> 'Editar permissões',

	'PropertiesText'			=> 'Propriedades',
	'PropertiesTip'				=> 'Editar propriedades de página.',
	'EditTip'					=> 'Clique para editar esta página.',
	'EditText'					=> 'Editar',
	'EditSection'				=> 'Editar secção %1',
	'EditSectionHint'			=> 'Secção %1 de %2',
	'SectionHeadline'			=> 'Secção',
	'EditCommentTip'			=> 'Editar comentário',
	'EditComment'				=> 'Editar este comentário',
	'ReplyComment'				=> 'Responder',
	'ReplyCommentTip'			=> 'Responder a este comentário',
	'RevisionTip'				=> 'Clique para ver revisões recentes',
	'RevisionText'				=> 'Revisões',
	'ReferrersTip'				=> 'Clique para ver uma lista de URLs que referenciam esta página',
	'ReferrersText'				=> 'Referenciadores',
	'ModerateTip'				=> 'Moderação de tópicos e postagens no fórum',
	'ModerateText'				=> 'Moderado',
	'SearchText'				=> 'Pesquisa: ',

	'AclUpdated'				=> 'Permissões (ACL) actualizadas',
	'AclGaveOwnership'			=> ' e deu posse a %1.',
	'AclNoNewOwner'				=> 'Propriedade de página não é transferida, porque o utilizador %1 não foi encontrado.',
	'NewPageOwnership'			=> 'Propriedade de página transferida',
	'YouAreNewOwner'			=> 'antigo proprietário %1 transferiu propriedade ' . "\n" . 'da seguinte página para você',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Leitura:',
	'AclWrite'					=> 'Escrita:',
	'AclComment'				=> 'Comentar:',
	'AclCreate'					=> 'Criar:',
	'AclUpload'					=> 'Enviar:',
	'AclFor'					=> 'Permissões (ACL) para %1',
	'SetOwner'					=> 'Definir Dono:',
	'OwnerDontChange'			=> 'Não altere',
	'AclAccessDenied'			=> 'Voçê não é o dono desta página.',
	'AclSyntaxError'			=> 'Erro de sintaxe da lista de controle de acesso',
	'AclHelp'					=> '<code>*</code> - todos são permitidos<br>' .
									'<code>$</code> - somente usuários registrados<br>' .
									'<code>!</code> - um ponto de exclamação anterior nega o respectivo direito<br>' .
									'<code>[UserName]</code> - nomes de usuários permitidos<br>' .
									'<code>[GroupName]</code> - nomes de grupos de usuários permitidos (alias)<br>' .
									'<code>(uma lista vazia)</code> - apenas o proprietário da página tem acesso',

	'AccessMode'				=> 'Visibilidade',
	'AccessDenied'				=> 'negado',
	'AccessPublic'				=> 'publico',
	'AccessRegistered'			=> 'registrado',
	'AccessPrivate'				=> 'privado',
	'AccessCustom'				=> 'personalizado',

	// purge handler
	'PurgePage'					=> 'Página de purga',
	'NotOwnerAndCantPurge'		=> 'Não é o proprietário da página e não a pode purgar.',
	'ReallyPurge'				=> 'ATENÇÃO: Purgar a página é irreversível!',
	'SelectPurgeOptions'		=> 'Seleccionar as opções de purga necessárias:',
	'PurgeComments'				=> 'Purgar todos os comentários da página',
	'CommentsPurged'			=> 'Todos os comentários foram apagados.',
	'PurgeFiles'				=> 'Remover todos os arquivos anexados',
	'FilesPurged'				=> 'Todos os arquivos anexados foram removidos.',
	'PurgeRevisions'			=> 'Purgar todas as revisões da página',
	'RevisionsPurged'			=> 'As revisões foram removidas.',
	'PurgeButton'				=> 'Purgar',

	// categories handler
	'Categories'				=> 'Categorias',
	'CategoriesAssign'			=> 'atribuir',
	'CategoriesEdit'			=> 'editar',
	'Category'					=> 'Categoria',
	'CategoriesFor'				=> 'Categorias para',
	'CategoriesTip'				=> 'Editar categorias',
	'CategoriesText'			=> 'Categorias',
	'CategoriesUpdated'			=> 'Categorias atualizadas',
	'CategoriesAlreadyExists'	=> 'Esta categoria %1 já está lá.',
	'CategoriesAdded'			=> 'Categoria %1 adicionada com sucesso.',
	'CategoriesRenamed'			=> 'Categoria renomeada com sucesso.',
	'CategoriesUngrouped'		=> 'Categoria desmembrada com sucesso.',
	'CategoriesGrouped'			=> 'A categoria entrou no novo grupo.',
	'NoMultilevelGrouping'		=> 'Não é possível agrupar vários níveis.',
	'CategoriesDeleted'			=> 'A categoria foi excluída do banco de dados e de todas as páginas.',
	'CategoriesAdd'				=> 'Adicione uma nova categoria',
	'CategoryDescription'		=> 'Descrição',
	'CategoriesAddGrouped'		=> 'Agrupados com a categoria',
	'CategoriesAddGroupedNo'	=> 'Nenhum grupo.',
	'CategoriesRename'			=> 'Renomear a categoria %1 para',
	'CategoriesRenameInfo'		=> '* Nota: A alteração afectará todas as páginas atribuídas a essa categoria.',
	'CategoriesGroup'			=> 'Categorias de grupos %1 com',
	'CategoriesGroupInfo'		=> '* Selecione [no group] para desvendar a categoria.',
	'CategoriesNoGroup'			=> '[nenhum grupo]',
	'CategoriesDelete'			=> 'Tens a certeza que queres remover a categoria %1?',
	'CategoriesDeleteInfo'		=> '* Nota: A alteração afectará todas as páginas que são atribuídas a essa categoria. Se a palavra tiver uma subcategoria, não serão eliminadas, mas apenas desagregadas.',
	'CategoriesStoreInfo'		=> 'Para atribuir categorias a uma página, selecione as caixas de seleção.',
	'CategoriesStoreButton'		=> 'Salvar Categorias',
	'CategoriesGroupButton'		=> 'Grupo',
	'CategoriesEditInfo'		=> 'Para editar a lista de categorias, selecione o botão de opção.',
	'NoCategoriesForThisLang'	=> 'Categorias para este idioma não são especificadas.',
	'PagesCategory'				=> 'Categoria de páginas',
	'CategoryNotExists'			=> 'Categoria não existe.',
	'CategoryEmpty'				=> 'Categoria vazia.',
	'NoCategorySelected'		=> 'Nenhuma categoria selecionada.',
	'NoCategoriesAssigned'		=> 'Nenhuma categoria atribuída para este idioma.',
	'TagCloud'					=> 'Nuvem de Tags',
	'PagesTaggedWith'			=> '%1 páginas com a etiqueta %2',
	'CategoriesOfCluster'		=> 'de agrupamento',
	'TaggedWithTip'				=> 'mostrar páginas marcadas %1',

	// source handler
	'SourceText'				=> 'Origem',
	'SourceTip'					=> 'Ver a wiki-source',
	'SourceCopyToClipboard'		=> 'copiar para prancheta',
	'SourceFor'					=> 'Mostrar código-fonte de %1',

	// Groups action
	'GroupsSearch'				=> 'Encontrar Grupos',
	'GroupsNoMatching'			=> 'Grupos correspondentes não foram encontrados. Tente um critério de pesquisa menos rigoroso.',
	'GroupsOpenProfile'			=> 'Ver perfil',
	'GroupsName'				=> 'Grupo',
	'GroupsMembers'				=> 'Membros',
	'GroupsDescription'			=> 'Descrição',
	'GroupsCreated'				=> 'Criado',
	'GroupsNotFound'			=> 'Grupo %2 não encontrado. Clique <a href="%1">aqui</a>, para ir para a lista principal.',
	'GroupsProfile'				=> 'Perfil',
	'GroupsList'				=> 'Ver a lista completa de grupos',
	'GroupSpace'				=> 'Espaço do grupo',

	'MetaUpdated'				=> 'Meta data actualizadas',

	'PreviewButton'				=> 'Pré-visão',
	'Preview'					=> 'Pré-visão',
	'Chars'						=> 'caracteres',
	'PageBody'					=> 'Corpo da página',
	'EditNote'					=> 'Sumário da edição',
	'EditNoteMissing'			=> 'Resumo da edição faltando',
	'EditMinor'					=> 'Alterações Menores',
	'MinorEditHide'				=> 'Ocultar edição menor',
	'MinorEditShow'				=> 'Mostrar pequenas edições',
	'PostAnonymously'			=> 'Publique anonimamente sem dar o seu nome',
	'NotifyMe'					=> 'Notifique-me sobre novos comentários e alterações da página',
	'OverwriteAlert'			=> 'ALERTA DE SOBREPOSIÇÃO: Esta página foi modificada por outra pessoa enquanto voçê estava a editá-la.<br>Por favor copie as suas alterações e re-edite esta página.',
	'TextDbOversize'			=> 'Atenção: O seu texto excede o limite de comprimento em %1 caracteres. Por favor encurte o seu texto para um número aceitável de caracteres. Dica: Pode colocar o texto restante numa página separada.',
	'EditingRevisionWarning'	=> 'Você está editando uma revisão antiga desta página. Se você a publicar, quaisquer alterações feitas desde então serão removidas. Você pode querer editar a revisão atual em vez disso.',
	'WriteAccessDenied'			=> 'Voçe não tem permissão de escrita nesta página.',
	'EmptyPage'					=> 'O corpo da página estava vazio - não guardado!',
	'EmptyComment'				=> 'O corpo do comentário estava vazio - não guardado!',
	'CommentAccessDenied'		=> 'Desculpe, não tem permissão para enviar comentários nesta página.',
	'CommentFlooded'			=> 'O intervalo entre a publicação das contribuições não deve ser inferior a %1 segundos.',
	'CommentAdded'				=> 'Comentário adicionado.',
	'YouAreNowTheOwner'			=> 'Voçê é agora o dono desta página.',
	'PageSaved'					=> 'Versão %1 da página guardada.',
	'CommentSaved'				=> 'Comentário salvo.',

	'RevisionsFor'				=> 'Histórico de %1',
	'DefaultDiffMode'			=> 'Modo de comparação padrão',
	'DiffMode'		=> [
		'0'		=> 'Diff completo',
		'1'		=> 'Diferenças simples',
		'2'		=> 'Origem',
		'3'		=> 'Lado a Lado',
		'4'		=> 'Na linha',
		'5'		=> 'Mesclado',
		'6'		=> 'Unificado',
		'7'		=> 'Contexto',
	],

	'PreviousEdit'				=> 'Ver a alteração anterior',
	'NextEdit'					=> 'Ver a alteração posterior',

	'Diff'						=> 'dif',
	'PreviousVersion'			=> 'Versão anterior',
	'LatestVersion'				=> 'Versão mais recente',
	'NextVersion'				=> 'Seguinte versão',

	'ShowDifferencesButton'		=> 'Mostrar Diferenças',
	'CancelReturnButton'		=> 'Voltar ao Nó (Node) / Cancelar',
	'Comparison'				=> 'Diferenças entre edições de %1',
	'RevisionAsOf'				=> 'Versão %1 de',
	'SimpleDiffAdditions'		=> 'Adições:',
	'SimpleDiffDeletions'		=> 'Eliminações:',
	'NoDifferences'				=> 'Sem diferenças.',
	'ReEditOldRevision'			=> 'Re-editar esta revisão antiga',

	'ExternalPages'				=> 'Páginas externas com ligação a  %1 (%2) (<a href="%3">ver lista de domínios</a>):',
	'ExternalPagesGlobal'		=> 'Sites com links para nós (%2) (<a href="%1">veja lista de domínios</a>):',
	'Last24Hours'				=> 'Últimas 24 horas',
	'LastDays'					=> 'Últimos %1 dias',
	'DomainsSitesPages'			=> 'Domínios/páginas com ligações a   %1 (%2)  (<a href="%3">ver lista de URLs diferentes</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domínios/páginas com ligações a nós(<a href="%1">ver lista de URLs diferentes</a>):',
	'ViewReferrersPage'			=> 'para a página',
	'ViewReferrersPerPage'		=> 'por página',
	'ViewReferrersByTime'		=> 'por hora',
	'ViewReferrersGlobal'		=> 'globais',
	'NoneReferrers'				=> 'Nenhum',
	'NotOwnerCantDelete'		=> 'Se não é o dono desta página não pode apagá-la',

	// remove
	'RemovePage'				=> 'Remover página',
	'RemoveRevision'			=> 'Remover revisão',
	'RemoveComment'				=> 'Excluir comentário',
	'RemoveCluster'				=> 'Remover todas as páginas do cluster',
	'RemoveDontKeep'			=> 'Não guarde uma cópia de uma página removida e comentários',
	'RemoveDontKeepPurge'		=> 'Não salvar uma cópia dos arquivos removidos, revisões e comentários',
	'RemoveDontKeepRevision'	=> 'Não guardar uma cópia da revisão removida',
	'RemoveDontKeepComment'		=> 'Não guarde uma cópia do comentário removido',
	'RemoveDontKeepFile'		=> 'Não guardar uma cópia do ficheiro removido',
	'ReferrersRemoved'			=> 'Referenciadores para a página removidos.',
	'LinksRemoved'				=> 'Ligações da página removidas.',
	'CategoriesRemoved'			=> 'Categorias de páginas eliminadas.',
	'AclsRemoved'				=> 'Permissões da página removidas.',
	'BookmarksRemoved'			=> 'Favoritos removidos.',
	'WatchesRemoved'			=> 'Observadores removidos.',
	'CommentsRemoved'			=> 'Comentários da página removidos.',
	'FilesRemoved'				=> 'Ficheiros da página removidos.',
	'PageRemoved'				=> 'Página removida.',
	'PageCachePurged'			=> 'Cache limpo.',
	'ClusterRemoved'			=> 'Todas as páginas do cluster removidas.',
	'RevisionRemoved'			=> 'Revisão %1 removida.',
	'RevisionsRemoved'			=> 'Revisões removidas.',
	'ActionHaveNoUndo'			=> 'Esta acção não pode ser anulada.',

	// restore
	'PageRestored'				=> 'Página restaurada.',
	'RevisionRestored'			=> 'Revisão restaurada.',
	'LocalFilesRestored'		=> 'Arquivos locais restaurados.',

	'PrintVersion'				=> 'Versão Impressora',
	'PrintText'					=> 'Imprimir',
	'LinkedPages'				=> 'Páginas ligadas:',
	'NoLinkedPages'				=> 'Não existem páginas ligadas',
	'ReferringPages'			=> 'Páginas Referenciadoras:',
	'NoReferringPages'			=> 'Não existem páginas referenciadoras',
	'Footnotes'					=> 'Notas de rodapé:',
	'Footnote'					=> 'Nota de rodapé',
	'MostPopularPages'			=> 'Páginas mais populares',
	'MostCommentedPages'		=> 'Páginas mais comentadas',
	'NoAccessToSourcePage'		=> 'Não está autorizado a ler código da página.',
	'SourcePageDoesntExist'		=> 'Página de código ainda não existe',
	'NotLoggedInThusEdited'		=> 'Voçê não efectuou login, por isso não podemos identificar as páginas que editou.',
	'DidntEditAnyPage'			=> 'Ainda não editou nenhuma página.',
	'NoPagesFound'				=> 'Nenhuma página encontrada.',
	'MyChangesTitle1'			=> 'Esta é a lista de páginas que já editou, ordenadas pela data da alteração mais recente',
	'MyChangesTitle2'			=> 'Esta é a lista de páginas que já editou, junto com a data da sua última alteração',
	'OrderABC'					=> 'Ordem alfabética',
	'OrderCreation'				=> 'Ordem por criação',
	'OrderChange'				=> 'Ordem por alteração',
	'ListOwnedPages'			=> 'Esta é a lista de páginas das quais é dono (por ordem alfabética)',
	'ListOwnedPages2'			=> 'Esta é a lista de páginas das quais é dono (por datas)',
	'ListOwnedPages3'			=> 'Esta é a lista de páginas das quais é dono (por ordem de alterações)',
	'NotLoggedInThusOwned'		=> 'Não efectuou o login, por isso não podemos recolher as suas páginas!.',
	'NoOrphaned'				=> 'Nenhuma página órfã.',
	'NoRecentComments'			=> 'Nenhum comentário recente.',
	'LatestCommentBy'			=> 'último comentário por',
	'NoRecentlyCommented'		=> 'Nenhuma página comentada recentemente.',
	'NoDeletedPages'			=> 'Nenhuma página excluída encontrada.',
	'NoDeletedRevisions'		=> 'Não foram encontradas revisões apagadas.',
	'NoDeletedFiles'			=> 'Nenhum arquivo excluído foi encontrado.',
	'CommentsDisabled'			=> 'Comentários não estão disponíveis.',

	'SearchResults'				=> 'Resultados da pesquisa de ',
	'NotFound'					=> 'não encontrado',
	'NoResultsFor'				=> 'Nenhum resultado para ',
	'SearchFor'					=> 'Pesquisa de:',
	'TopicSearchResults'		=> 'Tópicos dos resultados da pesquisa de ',
	'NotFoundInTopics'			=> 'nada encontrado nos tópicos',
	'FilterLangNotAvailable'	=> 'O idioma selecionado não está disponível!',
	'SearchInPages'				=> 'Pesquisar no conteúdo da página',
	'SearchInComments'			=> 'Pesquisar nos comentários',
	'SearchInPageTitles'		=> 'Pesquisar nos títulos da página',
	'SearchInNoOption'			=> 'Você deve selecionar pelo menos uma das opções de pesquisa.',

	'PostedBy'					=> 'publicado por ',
	'ThisIsCommentOn'			=> 'Este é um comentário em',
	'At'						=> 'em',
	'To'						=> 'para',
	'By'						=> 'por',
	'From'						=> 'de',
	'For'						=> 'para',
	'ReturnToCommented'			=> 'Retornar para a página comentada',
	'AbandonedComment'			=> 'A página a que este comentário pertence já não existe!',

	'PagesLinkingTo'			=> 'Páginas ligando a ',
	'NoPageLinkingTo'			=> 'Nenhuma página ligando a ',
	'NoWantedPages'				=> 'Nenhuma página pretendida',
	'RemoveWatch'				=> 'Remover acompanhamento desta página',
	'SetWatch'					=> 'Acompanhar esta página',
	'WatchText'					=> 'Observar',
	'UnwatchText'				=> 'Não observar',
	'UserSettingsStored'		=> 'Parâmetros do Utilizador guardados!',
	'LoggedOut'					=> 'Está desligado.',
	'LoggedOutAuto'				=> 'Por segurança, sua sessão terminou. Por favor faça login novamente.',

	// user settings
	'EmailConfirmResent'		=> 'Código de confirmação de e-mail reenviado para seu endereço.',
	'EmailConfirmNotSent'		=> 'Não foi possível enviar o código de confirmação: e-mail não foi especificado!',
	'Hello'						=> 'Olá',
	'UserName'					=> 'Nome de utilizador',
	'EmailAddress'				=> 'O seu endereço email',
	'RealName'					=> 'Nome Real',
	'MenuItemsShown'			=> 'Itens de menu exibidos',
	'RecordsPerPage'			=> 'Registros por página',
	'DoShowComments'			=> 'Por defeito mostra comentários',
	'DoubleclickEditing'		=> 'Edição por duplo clique',
	'UpdateSettingsButton'		=> 'Actualizar Parâmetros',

	'AccountDisabled'			=> 'Sua conta pode ser desativada ou bloqueada.',
	'WrongPassword'				=> 'Senha errada!',
	'ConfirmPassword'			=> 'Confirmar palavra-passe',
	'Email'						=> 'Email',
	'MustBeWikiName'			=> 'O Username deve ser do formato <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> !',
	'SpecifyEmail'				=> 'Deve inserir endereço email.',
	'NotAEmail'					=> 'Esse não nos parece um endereço válido.',
	'EmailTaken'				=> 'Este endereço de email já está em uso.',
	'EmailDomainNotAllowed'		=> 'O endereço de e-mail informado %1 não está na lista de domínios permitidos.',
	'PasswordsDidntMatch'		=> 'As Passwords não coincidiram.',
	'SpacesArentAllowed'		=> 'Não são permitidos espaços nas passwords.',
	'ListMyPages'				=> 'Listar suas páginas',
	'ListMyChanges'				=> 'Listar suas alterações',
	'ListMyWatches'				=> 'Lista de páginas assistidas',
	'ListMyChangesWatches'		=> 'Alterações entre as páginas assistidas',
	'SeeListOfPages'			=> 'Veja uma lista das páginas que possui(MyPages) e das páginas que editou (MyChanges).',
	'AddBookmark'				=> 'Adicionar página actual aos QuickLinks',
	'RemoveBookmark'			=> 'Remover dos favoritos',

	'YourLanguage'				=> 'Seleccione Idioma',
	'ShowSpaces'				=> 'Mostrar espaço em WikiNames',
	'WrongPage4Redirect'		=> 'Impossível redirecionar por causa de parâmetro errado',
	'RedirectsToItself'			=> 'A página redireciona para si mesma. ',
	'ReallyDeletePage'			=> 'Quer mesmo apagar a página?<br>Não poderá deppois anular esta acção!<br><br>AVISO: ao Apagar esta página irá eliminar todas as suas revisões, comentários, anexos, permissões e referenciadores.',
	'CommentForWatchedPage'		=> 'Novo comentário para página ',
	'SomeoneCommented'			=> ' comentou esta página que está a acompanhar: ',
	'AlertReferringPages'		=> 'Esta página é referenciada por estas páginas',

	'AccountDelete'				=> 'Eliminar conta',
	'AccountDeleteConfirm'		=> 'Tem certeza que deseja eliminar a conta?',
	'AccountDeleted'			=> 'Conta eliminada com sucesso',
	'AccountDeleteHeader'		=> 'Ecluir a conta %1',
	'AccountDeleteInfo'			=> 'Dos dados que o utilizador criou (ex: email, preferências, anexos, entradas wiki), será apagado o máximo possível. No entanto note que esses dados, como anexos e entradas wiki, não podem ser apagados sem impedir o trabalho de outros utilizadores. Esses dados serão então reatribuídos para uma conta chamada %1. Uma vez que todas as contas apagadas são reatribuídas para esta conta, não será possível distinguir os dados que o utilizador criou dos dados de outra conta apagada.',
	'AccountDeleteWarning'		=> 'Excluir a conta do usuário é uma ação irreversível.',
	'AccountDeleteHint'			=> 'A sua conta será apagada do sistema. Em consequência,  não poderá mais entrar com as suas credenciais atuais. Poderá escolher ser utilizador desta aplicação outra vez nos termos permitidos pela aplicação.',
	'AccountDeleteVerify'		=> 'Introduza o login %1 para verificar a eliminação. Depois de enviar irá receber uma solicitação de confirmação da sua palavra passe.',

	'MarkRead'					=> 'Marcar tudo como lido',
	'CurrentTime'				=> 'current time',
	'Created'					=> 'criada',
	'Modified'					=> 'modificadas',

	'EditIcon'					=> 'editar',
	'TreeClusterTitle'			=> 'Árvore do cluster %1',
	'TreeSiteTitle'				=> 'Árvore do Site',
	'TreeEmpty'					=> '%1 não tem sub-páginas',
	'TreeEmptyLevels'			=> '%1 não tem subpáginas para determinados níveis de profundidade. Aumentar o valor para a profundidade.',
	'TreeTooBig'				=> 'demasiadas subpáginas',

	// clone handler
	'ClonePage'					=> 'Clonar página',
	'CloneText'					=> 'Clonar',
	'CloneName'					=> 'Digite o novo nome para um clone desta página',
	'CloneButton'				=> 'Clonar',
	'PageCloned'				=> 'Página %1 clonada.',
	'ClonedFrom'				=> 'Clonado de %1.',
	'MassClone'					=> 'Clonar todo o cluster',
	'MassCloning'				=> 'Clonando cluster.',
	'CloneCannotRead'			=> 'Página %1 ilegível.',
	'CloneCannotCreate'			=> 'Página %1 ilegível.',

	'CommentOffset'				=> 'Página do comentário',
	'CommentOffsetFirst'		=> 'primeira página',
	'CommentOffsetLast'			=> 'última página',
	'SortComment'				=> 'Ordenar comentário por',
	'SortCommentAsc'			=> 'Mais recente no fundo',
	'SortCommentDesc'			=> 'Mais recente no topo',

	'RenamePage'				=> 'Página renomear',
	'RenameText'				=> 'Renomear',
	'RenameTip'					=> 'Página renomear',
	'NewName'					=> 'Insira um novo nome para esta página',
	'AlreadyExists'				=> 'Página %1 já existente.',
	'AlreadyNamed'				=> 'Página tem o nome %1.',
	'PageRenamed'				=> 'Página renomeada.',
	'NewNameOfPage'				=> 'Novo nome desta página: ',
	'NotOwnerCantRename'		=> 'Não sendo dono desta página não pode renomeá-la',
	'NeedRedirect'				=> 'Criar redirecionamento para nova página na página antiga',
	'RedirectCreated'			=> 'Na página %1 criado redirecionamento para a nova página',

	'UserSettings'				=> 'Configurações do usuário',
	'UserSettingsGeneral'		=> 'Geral',
	'UserSettingsNotifications'	=> 'Notificações',

	'NotifyMinorEdit'			=> 'Notificar também uma pequena edição',
	'NotifyPageEdit'			=> 'Editar',
	'NotifyComment'				=> 'Comentário',
	'NotifyOff'					=> 'Desligado',
	'NotifyAlways'				=> 'Sempre',
	'NotifyPending'				=> 'Pendente',
	'NotifyDigest'				=> 'Resumo',
	'NotifyPendingPageTip'		=> 'Apenas uma notificação é enviada para a primeira alteração de página de uma página que você está assistindo.',
	'NotifyPendingCommentTip'	=> 'Apenas uma notificação é enviada para o primeiro comentário de uma página que você está assistindo.',
	'NotifyPendingTip'			=> 'A notificação é automaticamente reativada quando você visita a versão atual da página.',

	'FurtherPending'			=> 'Não haverá outras notificações em caso de alterações adicionais, a menos que você visite esta página.',

	'UserSettingsEmailMe'		=> 'Envie-me um e-mail quando...',

	'UserSettingsExtended'		=> 'Estendido',
	'UserSettingsOther'			=> 'Outros ajustes',
	'UserSpace'					=> 'Espaço do usuário',
	'ChooseTheme'				=> 'Escolha Visual',

	'CreatePage'				=> 'Criar esta página',
	'CreateNewPage'				=> 'Criar uma nova página',
	'CreateNewPageText'			=> 'Criar',
	'CreateNewPageTip'			=> 'Criar uma nova página.',

	'CreateRandomPage'			=> 'Criar uma página aleatória:',
	'CreateSubPage'				=> 'Criar uma sub página no cluster:',
	'CreatePageParentCluster'	=> 'Criar uma página no grupo pai:',
	'CreatePageDenied'			=> 'Você não tem os direitos de acesso necessários.',
	'CreatePageDeniedAddress'	=> 'Não tem o direito de criar a página neste endereço.',
	'PageAlreadyExists'			=> 'De acordo com a morada fornecida, a página %1 já existe.',
	'PageAlreadyExistsEdit'		=> 'Você quer %1 isso?',
	'PageAlreadyExistsEdit2'	=> 'editar',
	'PageAlreadyExistsEditDenied'	=> 'Não se pode editá-lo.',

	'SimilarPagesExists'		=> 'Já existem páginas semelhantes a %1:',
	'SimilarPagesHint'			=> 'Existem páginas semelhantes a %1:',

	'PageReservedWord'			=> 'Não se pode usar %1 como parte do endereço, pois é uma palavra reservada.',
	'PageReservedNamespace'		=> 'Você não pode usar %1 como início do endereço, pois é um namespace reservado.',
	'UserReservedWord'			=> 'Os nomes dos utilizadores não podem conter %1 pois é uma palavra reservada.',

	'DontRedirect'				=> 'Não permitir redireccionamento automático por acção de redirecionamento.',
	'SendWatchEmail'			=> 'Enviar notificação por email quando alguém (excepto voçê) alterar a página que estiver a acompanhar',
	'AllowIntercom'				=> 'Permitir mensagens pessoais dos usuários do sistema',
	'AllowMassemail'			=> 'Autorizar os Administradores a enviarem-me emails',
	'HideLastSession'			=> 'Ocultar última sessão',
	'ValidateIP'				=> 'Ligando a sessão ao IP',
	'AnonymousPub'				=> 'Preferencialmente, publicado anonimamente (para ocultar o nome do usuário)',
	'PageMoved'					=> 'Esta página mudou de localização. Pode encontrá-la em',
	'RedirectedFrom'			=> 'Redirecionado de %1',
	'RedirectedTo'				=> 'Redirecionado para',
	'CurrentPassword'			=> 'Senha atual',
	'NewPassword'				=> 'Nova senha',
	'YouWantChangePassword'		=> 'Alterar senha',
	'ChangePasswordButton'		=> 'Alterar senha',
	'PasswordChanged'			=> 'Senha alterada',
	'EmailWelcome'				=> 'Registou-se em ',
	'EmailRegistered'			=> 'Registou-se com sucesso em %1.' . "\n" . 'O seu username: %2' . "\n\n",
	'EmailVerify'				=> 'Se quiser receber notificações , é necessário aprovar o seu email. Siga este ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Por favor, volte ao Wiki e inicie sessão com o seu novo nome de utilizador e palavra-passe.',
	'EmailRegisteredIgnore'		=> 'Caso você não tenha pedido nenhum registo, ignore esta mensagem e nada irá acontecer.',
	'EmailDoNotReply'			=> 'NÃO RESPONDA A ESTA MENSAGEM',
	'EmailReverify'				=> 'Alguém (talvez voçê) submeteu o seu email como alvo de notificação no site  %1.' . "\n" . 'O seu username: %2'."\n\n" . 'Se quiser receber notificações , é necessário aprovar o seu email. Siga este ' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'Por favor verifique o seu email',
	'EmailConfirmed'			=> 'Email confirmado com sucesso.',
	'EmailNotConfirmed'			=> 'Email não confirmado. Isto pode dever-se a um código de confirmação incorrecto ou o endereço de correio electrónico pode já estar confirmado. Pode verificar se o endereço de correio electrónico já está confirmado fazendo o login e vendo o seu estado na sua página %1.',
	'EmailNotVerified'			=> 'E-mail não confirmado!',
	'EmailNotVerifiedDesc'		=> 'Você não receberá notificação de alterações ou comentários de páginas assistidas, ' .
									'ou mensagens de outros utilizadores. Além disso, <strong>não poderá recuperar uma palavra-passe esquecida</strong>, ' .
									'até que seu endereço de e-mail seja confirmado, seguindo o link no e-mail enviado para você. ' .
									'Se, dentro de dias após o registro, você não receber um e-mail, pergunte novamente clicando clicando ',

	'ForgotPasswordHint'		=> 'Insira o seu login e endereço e-mail,' . "\n" . 'Depois ser-lhe-á enviado e-mail com instruções.',
	'ForgotPassword'			=> 'Esqueceu a senha?',
	'UserNotFound'				=> 'Não foi encontrado utilizador com este nome ou e-mail.',
	'NotConfirmedEmail'			=> 'O seu e-mail não foi confirmado.<br>Mail não pode ser enviado para endereços não confirmados.',
	'EmailForgotSubject'		=> 'Renovação de senha para ',
	'EmailForgotMessage'		=> 'Alguém (talvez voçê) esqueceu-se da password para  %1.' . "\n" . 'O seu login: %2'."\n\n" . 'Clique no link ou copie para a linha de endereço do seu browser para mudar a sua password.' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> 'Instruções para recuperação de Password foram-lhe enviadas por e-mail.',
	'WrongCode'					=> 'Código errado',
	'ChangePasswordForUser'		=> '%1 viu a sua password alterada',

	'Watchers'					=> 'Lista de quem acompanha %1',
	'WatchersFor'				=> 'Vigilantes para',
	'NoWatchers'				=> 'Não ninguém a acompanhar %1',
	'NotOwnerToViewWatchers'	=> 'Não sendo o dono desta página não pode ver a lista de que a acompanha.',

	// thumbnail
	'TbnError'					=> 'Erro ao criar miniatura: %1',
	'TbnImageAreaTooBig'		=> 'Ficheiro com dimensões superiores a %1',
	'TbnImageMissing'			=> 'Ficheiro em falta: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Gere o hash de senha para sua <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Importar no cluster:',
	'ImportWhat'				=> 'Ficheiro XML para importação:',
	'ImportButton'				=> 'Importação',
	'ImportSuccess'				=> 'Importado com sucesso.',
	'ImportFailed'				=> 'A importação falhou.',
	'ImportHint'				=> 'Por favor, forneça um cluster para o qual pretende importar, sem endereçamento relativo.',
	'ImportAttention'			=> 'Atenção: Sobrescreve as mesmas páginas do cluster.',
	'ImportNote'				=> 'Página importada',

	// mywatches action
	'WatchedPages'				=> 'Lista de todas as páginas que segue para alterações ',
	'UnwatchedPages'			=> 'Lista de todas as páginas que você não assiste',
	'NoWatchedPages'			=> 'Você não tem páginas assistidas.',
	'NoUnwatchedPages'			=> 'Você assiste às mudanças em todas as páginas.',
	'ViewWatchedPages'			=> 'Mostrar páginas assistidas',
	'ViewUnwatchedPages'		=> 'Mostrar página não assistida',
	'NotLoggedInWatches'		=> 'Você não está conectado, portanto não pudemos identificar sua lista de observadores.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'Lista de todas as páginas que você assistiu e que foram editadas por outros desde a sua última edição',
	'ResetChangesWatches'		=> 'redefinir a lista de alterações',
	'NoChangesWatches'			=> 'Entre as suas páginas assistidas não há alterações...',

	// whatsnew action
	'NewCommentAdded'			=> 'Adicionado novo comentário',
	'NewFileAdded'				=> 'Adicionado novo arquivo',
	'NewPageCreated'			=> 'Criado uma nova página',
	'NewRevisionAdded'			=> 'Página alterada',
	'Cluster'					=> 'aglomerado',
	'PageDeleted'				=> 'Página excluída',
	'CommentDeleted'			=> 'Comentário eliminado',
	'FileDeleted'				=> 'Ficheiro eliminado',

	// users action
	'UsersSearch'				=> 'Encontre usuários',
	'UsersOpenProfile'			=> 'Ver perfil',
	'UsersNoMatching'			=> 'Usuários correspondentes não foram encontrados. Tente um critério de pesquisa menos rigoroso.',
	'UsersName'					=> 'Nome',
	'UsersPages'				=> 'Páginas',
	'UsersChanges'				=> 'Alterações',
	'UsersSubscription'			=> 'Inscrição',
	'UsersWatches'				=> 'Acompanhando',
	'UsersComments'				=> 'Comentários',
	'UsersUploads'				=> 'Carregamentos',
	'UploadQuota'				=> 'Espaço usado',
	'UploadQuotaTip'			=> 'Cota de Espaço Upload',
	'UsersLogins'				=> 'Credenciais',
	'UsersRevisions'			=> 'Revisões',
	'UsersSignup'				=> 'Registrar-se',
	'UsersLastSession'			=> 'Última sessão',
	'UsersNotFound'				=> 'Usuário %2 não encontrado. Clique <a href="%1">aqui</a>, para ir para a lista principal.',
	'UsersProfile'				=> 'Perfil',
	'UsersContact'				=> 'Contato',
	'UsersList'					=> 'Ver a lista completa de usuários',
	'UsersNA'					=> '[não definido]',
	'UsersNA2'					=> '[No]',
	'UsersSignupDate'			=> 'Data de inscrição',
	'UsersGroupMembership'		=> 'Membro do grupo',
	'UsersPersonalInfo'			=> 'Informação pessoal',
	'UsersOwnedPages'			=> 'Páginas próprias:',
	'UsersCommentsPosted'		=> 'Comentários postados:',
	'UsersFilesUploaded'		=> 'Ficheiros carregados:',
	'UsersRevisionsMade'		=> 'Revisões feitas:',
	'UsersDocsSortName'			=> '[Ordenar por nome]',
	'UsersDocsSortCreation'		=> '[Ordenar por data de criação]',
	'UsersChangesSortAsc'		=> '[Ordenar por ordem ascendente]',
	'UsersChangesSortDesc'		=> '[Ordenar por ordem descendente]',
	'UsersSessionNA'			=> '[não gravado]',
	'UsersSessionHidden'		=> '[oculto]',
	'IntercomSubject'			=> 'Sujeito:',
	'IntercomMessage'			=> 'Mensagem:',
	'IntercomCopy'				=> 'Enviem-me uma cópia',
	'IntercomSubjectN'			=> '[iniciar um novo tópico]',
	'IntercomDisabled'			=> 'Desculpe, você não quer ou não pode receber mensagens pessoais.',
	'IntercomHint'				=> 'Faça login primeiro e siga o link novamente, se quiser responder à mensagem pessoal que recebeu.',
	'IntercomDesc'				=> 'Nota: Enviar mensagens pessoais para o endereço de correio electrónico do destinatário sem revelar o seu endereço. O destinatário tem a opção de lhe responder utilizando o mesmo formulário na sua página de perfil. ',
	'PMOversized'				=> 'O comprimento da mensagem excede em %1 o tamanho máximo permitido. Por favor, encurte a sua mensagem e envie-a novamente.',
	'PMFlooded'					=> 'O intervalo entre o envio de mensagens pessoais não deve ser inferior a %1 segundos.',
	'PMSent'					=> 'A mensagem pessoal foi enviada com sucesso para o usuário.',
	'PMBody'					=> 'Esta mensagem foi-lhe enviada pelo utilizador %1.',
	'PMBodyCopy'				=> 'Enviou a seguinte mensagem ao utilizador %1.',
	'PMReply'					=> 'Para responder a este e-mail, clique no seguinte link (não use o botão Responder / Responder no mailer):',
	'PMNotLoggedIn'				=> 'Você não está registrado no sistema e não pode enviar mensagens pessoais aos usuários.',

	// admin_replace action
	'ReplaceText'				=> 'Substituir texto',
	'TextOriginal'				=> 'Texto original:',
	'TextReplacement'			=> 'Texto de substituição:',
	'ReplaceTextRegex'			=> 'Usar expressões regulares',
	'Namespace'					=> 'Espaço nominal:',
	'ReplaceTextCluster'		=> 'Procurar e substituir apenas dentro deste agrupamento:',
	'ReplaceTextEditPages'		=> 'Substituir texto no conteúdo da página',
	'ReplaceTextEditComments'	=> 'Substituir texto nos comentários',
	'ReplaceTextEditTitles'		=> 'Substituir texto nos títulos das páginas',
	'ReplaceTextGiveTarget'		=> 'Deve especificar o texto que será substituído.',
	'ReplaceTextNoNamespace'	=> 'Deverá selecionar pelo menos um espaço nominal.',
	'ReplaceTextNoDifference'	=> 'Não há diferença entre o texto de substituição e o texto de destino.',
	'ReplaceTextNoOption'		=> 'Deve selecionar pelo menos uma das opções de substituição.',
	'ReplaceTextPagesEdit'		=> 'Substituir %1 por %2 no texto das seguintes $3 páginas:',
	'ReplaceTextTitlesEdit'		=> 'Substituir %1 por %2 nos títulos das seguintes %3 páginas:',
	'ReplaceTextReplace'		=> 'Substituir',
	'ReplaceTextSuccess'		=> '%1 foi substituído por %2 em %3 páginas.',
	'ReplaceTextNoMatch'		=> 'Não foram encontradas páginas que contenham o texto %1.',
	'ReplaceTextNoTitleMatch'	=> 'Não foram encontradas páginas cujo título contenha %1.',
	'ReplaceTextEditFailed'		=> 'A substituição de texto falhou',
	'ReplaceTextTitleTooBig'	=> 'O texto original ou de substituição é demasiado grande para o título.',
	'ReplaceTextReturn'			=> 'Voltar ao formulário',
	'ReplaceTextWarning'		=> 'Aviso: Há %1 páginas que já contêm o texto de substituição, %2. Se fizer esta substituição não poderá distingui-las das suas substituições, nem desfazer a operação com uma simples substituição em ordem inversa.',
	'ReplaceTextBlankWarning'	=> 'Aviso: Como o texto de substituição foi deixado em branco, esta operação não será reversível.',
	'ReplaceTextEditSummary'	=> 'Substituição de texto: %1 → %2',
	'InvertSelection'			=> 'Inverter seleções',

	// Properties
	'PropertiesFor'				=> 'Parâmetros de  %1',
	'MetaTag'					=> 'Etiqueta',
	'MetaTitle'					=> 'Título',
	'MetaKeywords'				=> 'Palavras-chave',
	'MetaDescription'			=> 'Descrição',
	'On'						=> 'Ligado',
	'Off'						=> 'Desligado',
	'Registered'				=> 'Registrado',
	'MetaComments'				=> 'Mostrar comentários',
	'MetaFiles'					=> 'Mostrar painel de ficheiros',
	'MetaToc'					=> 'Mostrar tabela de conteúdos',
	'MetaIndex'					=> 'Mostrar painel de seções do cluster',
	'MetaIndexMode'				=> 'Mostrar Modo de Nível',
	'MetaIndexFull'				=> 'Árvore',
	'MetaIndexUpper'			=> 'Superior',
	'MetaIndexLower'			=> 'Baixo',
	'MetaHtml'					=> 'Suporte HTML para página',
	'MetaSafeHtml'				=> 'Filtragem de HTML inseguro',
	'MetaTypografica'			=> 'Revisor Typográfico',
	'MetaNoIndex'				=> 'Bloquear motores de busca',
	'SettingsID'				=> 'ID da página',
	'SettingsSize'				=> 'Tamanho',
	'SettingsSizeTip'			=> 'fonte / compilada',
	'SettingsCreated'			=> 'Criado',
	'SettingsCurrent'			=> 'Modificado',
	'SettingsTotalRevs'			=> 'Revisões',
	'SettingsTotalComs'			=> 'Comentários',
	'SettingsWatchers'			=> 'Observadores',
	'SettingsHits'				=> 'Vistas',
	'SettingsText'				=> 'Parâmetros',
	'SettingsEdit'				=> 'Editar',
	'SettingsRevisions'			=> 'Revisões',
	'SettingsClone'				=> 'Clonar',
	'SettingsRename'			=> 'Renomear',
	'MassRename'				=> 'para todo o cluster',
	'SettingsRemove'			=> 'Remover',
	'SettingsPurge'				=> 'Purgar',
	'SettingsModerate'			=> 'Moderado',
	'SettingsPermissions'		=> 'ACLs',
	'AclForEntireCluster'		=> 'ACLs para todo cluster',
	'SettingsAttachments'		=> 'Anexos',
	'SettingsUpload'			=> 'Enviar',
	'SettingsCategories'		=> 'Categorias',
	'SettingsLanguages'			=> 'Idiomas',
	'SettingsReferrers'			=> 'Referências',
	'SettingsWatch'				=> 'Acompanhe',
	'SettingsLatex'				=> 'Versão LaTeX',
	'SettingsXML'				=> 'Exportar para XML',
	'NeedToChangeLang'			=> 'A linguagem de página não suportada %1 precisa ser alterada.',
	'SetLang'					=> 'Idioma para esta página',
	'SetMenuLabel'				=> 'Rótulo do menu',
	'SetShowMenuLabel'			=> 'Mostrar na navegação',

	// upload
	'UploadFiles'				=> 'Upload ficheiros',
	'UploadFor'					=> 'Upload do Ficheiro:',
	'UploadButton'				=> 'Prossiga',
	'UploadGlobalText'			=> 'para acesso público',
	'UploadGlobal'				=> 'globais',
	'UploadLocalText'			=> 'apenas para utilizadores autorizados a ver a página actual',
	'UploadAsName'				=> 'Carregar como (opcional):',
	'UploadOverwrite'			=> 'Escrever por cima de ficheiros existentes',
	'FileDesc'					=> 'Descrição:',
	'UploadForbidden'			=> 'Não está autorizado a fazer upload de ficheiros aqui.',
	'UploadOverwriteDenied'		=> 'Apenas o proprietário ou administrador do ficheiro pode sobrescrever o ficheiro %1.',
	'UploadNoFile'				=> 'Não existe nenhum ficheiro no formulário.',
	'UploadMaxSizeReached'		=> 'Ficheiro com tamanho excessivo!',
	'UploadDirNotWritable'		=> 'O directório de ficheiros não se pode escrever!',
	'UploadNotAPicture'			=> 'Só há permissões para upload de imagens.',
	'UploadEmptyExtension'		=> 'O nome do ficheiro e também a sua extensão não podem estar vazios.',
	'FilenameTooLong'			=> 'Os nomes de ficheiros não podem ter mais de 240 bytes.',
	'BannedFiletype'			=> '%1 não é um tipo de ficheiro permitido.',
	'PermittedFiletype'			=> 'Tipos de ficheiro permitidos:',
	'UploadMimeMismatch'		=> 'A extensão %1 não corresponde ao tipo MIME do ficheiro (%2).',
	'UploadBadMime'				=> 'Não é permitido carregar ficheiros do tipo MIME %1.',
	'FileIsDuplicate'			=> 'O ficheiro carregado é um duplicado exato da versão atual.',
	'FileHasDuplicate'			=> 'Este ficheiro é um duplicado dos seguintes:',

	'UploadMaxFileQuota'		=> 'Atinngiu o seu limite de upload.',
	'UploadDone'				=> 'Upload do Ficheiro com sucesso',
	'UploadFileForbidden'		=> 'Acesso ao ficheiro proibido',
	'UploadTitle'				=> 'Ficheiros acessíveis a partir desta página',
	'UploadTitleGlobal'			=> 'Ficheiros acessíveis a partir de qualquer lado',

	'UploadFile'				=> 'Prossiga',
	'UploadMax'					=> 'Não mais do que ',
	'UploadUsedStorage'			=> 'Armazenamento em uso ',

	// attachments
	'Attachments'				=> 'Anexos',
	'Attachment'				=> 'Anexo',
	'AttachmentsToPage'			=> 'para página',
	'AttachmentsToCluster'		=> 'aglomerado',
	'AttachmentsByTime'			=> 'por tempo',
	'AttachmentsGlobal'			=> 'globais',
	'AttachmentsAll'			=> 'todos',
	'AttachmentsLinked'			=> 'utilizado',

	'FileViewProperties'		=> 'mostrar',
	'FileViewPropertiesTip'		=> 'Ver os metadados deste ficheiro',
	'FileEditProperties'		=> 'editar',
	'FileEditPropertiesTip'		=> 'Editar os metadados deste ficheiro',
	'FileEditedMeta'			=> 'Metadados atualizados deste ficheiro',
	'FileEditDenied'			=> 'Você não tem permissão para editar este ficheiro.',
	'FileLabel'					=> 'Descrição',
	'FileLabelTip'				=> 'Rotular este arquivo',
	'FileRemove'				=> 'remover',
	'FileRemovedFromDB'			=> 'Ficheiro removido da base de dados',
	'FileRemovedFromFS'			=> 'Ficheiro apagado do servidor fisico de alojamento',
	'FileRemovedFromFSError'	=> 'Parece ser impossível apagar este ficheiro!',
	'FileRemoveConfirm'			=> 'Quer mesmo apagar este ficheiro?',
	'FileRemoveDenied'			=> 'Não está autorizado a remover este ficheiro',
	'FileNotFound'				=> 'File não encontrado',

	'FileSearch'				=> 'Achar arquivo:',
	'UploadBy'					=> 'Carregado por:',
	'FileAdded'					=> 'Adicionado:',
	'FileModified'				=> 'Modificado:',
	'FileSize'					=> 'Tamanho:',
	'FileDimension'				=> 'Dimensões:',
	'MimeType'					=> 'Tipo MIME:',
	'FileName'					=> 'Nome:',
	'FileCaption'				=> 'Legenda:',
	'FileAuthor'				=> 'Autor:',
	'FileSource'				=> 'Origem:',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> 'Anexado a:',
	'FileSyntax'				=> 'Sintaxe:',
	'FileAbsolutePath'			=> 'caminho absoluto',
	'FileRelativePath'			=> 'caminho relativo',
	'FileUsage'					=> 'Páginas em que este ficheiro é usado:',
	'FileUsageText'				=> 'A seguinte página aponta para este ficheiro:',
	'NoFileUsage'				=> 'Nenhuma página contém ligação para este ficheiro.',

	'FileSortExt'				=> 'extensão',
	'FileSortName'				=> 'nome',
	'FileSortSize'				=> 'tamanho',
	'FileSortTime'				=> 'criada',

	'SortBy'					=> 'Classificar por',
	'Ascending'					=> 'ascendente',
	'Decending'					=> 'decrescente',

	'Files0'					=> 'Não existem ficheiros neste página.',
	'Files1'					=> 'Mostrar Ficheiros (1 Ficheiro)',
	'FilesN'					=> 'Mostrar Ficheiros (%1 Ficheiros)',
	'Files'						=> 'Ficheiros',
	'File'						=> 'Ficheiro',
	'ShowFiles'					=> 'Mostrar Ficheiros',
	'HideFiles'					=> 'Esconder Ficheiros',
	'DoShowFiles'				=> 'Por defeito mostra lista de ficheiros',
	'NoAttachments'				=> 'Não existem Ficheiros a exibir.',

	'RegistrationLang'			=> 'O seu idioma',
	'InvalidWikiName'			=> 'Nome escolhido não é válido',
	'InvalidUserName'			=> 'Nome escolhido não é válido',
	'Bookmarks'					=> 'Favoritos',
	'ReallyDeleteComment'		=> 'Quer mesmo apagar comentário?<br>Depois não poderá voltar atrás!',
	'ReallyDeleteRevision'		=> 'Quer realmente APAGAR esta revisão?<br>Depois não poderá voltar atrás!',

	'RegistrationClosed'		=> 'O registo não está disponível. Tente contactar o administrador.',
	'AclAreYouSure'				=> 'Vai alterar aas permissões desta página e todas as suas subpáginas. Quer continuar?',

	'BookmarkDeleteSelected'	=> 'Excluir Selecionado(s)',
	'BookmarkMark'				=> 'nota',
	'BookmarkNumber'			=> 'Não.',
	'BookmarkNone'				=> 'Você não tem favoritos.',
	'BookmarkTitle'				=> 'Favoritos Título',
	'BookmarkPage'				=> 'Página',
	'BookmarkSaveChanges'		=> 'Guardar modificações',
	'BookmarksAddPage'			=> 'Defina um favorito para a seguinte página',
	'BookmarkAlreadyExists'		=> 'O favorito já existe.',

	'PoweredBy'					=> 'Desenvolvido por',

	'MassRenaming'				=> 'Renomear o cluster inteiro',
	'MassNewName'				=> 'Digite um novo nome para este grupo',
	'MassNeedRedirect'			=> 'Criar redirecionamento para as novas páginas nas páginas antigas',

	// pagination
	'ToOverview'				=> 'Voltar à visão geral',
	'Overview'					=> 'Visão geral',
	'ToThePage'					=> 'Para página:',
	'Next'						=> 'Seguinte',
	'Prev'						=> 'Anterior',
	'NextAcr'					=> 'seguinte',
	'PrevAcr'					=> 'anterior',
	'Back'						=> 'Costas',

	// filter
	'Filter'					=> 'Filtrar',
	'OptionalFilters'			=> 'Filtros opcionais:',
	'Any'						=> 'Qualquer',

	// My Groups
	'UserGroups'				=> 'Grupos de usuários',
	'MyGroups'					=> 'Associações de Grupos',
	'Group'						=> 'grupo',
	'Groups'					=> 'grupos',

	// license action
	'DistributedUnder'			=> 'Material é distribuído sob',
	'AuthorsDisplayHint'		=> 'A lista de autores será exibida quando salvar a página.',
	'AnonymousUsers'			=> 'Usuários anônimos',
	'License'					=> 'Licença',
	'LicenseArray'				=> [
		'1'		=> 'Attribution-NoDerivatives.',
		'2'		=> 'Atribuição-Não Comercial-Partilha de Ativos',
		'3'		=> 'Atribuição-NãoComercial-NoDerivadas',
		'4'		=> 'Atribuição-CompartilhaIgual',
		'5'		=> 'Atribuição-Não Comercial',
		'6'		=> 'Atribuição',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'Licença de Documentação Gratuita GNU',
		'9'		=> 'Domínio Público / Uso Gratuito',
		'10'	=> 'Todos os direitos reservados',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Domínio público',
		'2'		=> 'Alguns direitos reservados',
		'3'		=> 'Todos os direitos reservados',
	],

	// Cache
	'ClearCache'				=> 'Limpar cache',
	'CacheCleared'				=> 'Cache limpo.',
	'ConfigCache'				=> 'Configurar cache',
	'FeedCache'					=> 'Cache de feed',
	'PageCache'					=> 'Cache de página',
	'SQLCache'					=> 'Cache de SQL',
	'TemplateCache'				=> 'Cache de modelos',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Por favor, introduza o endereço do recurso utilizando o parâmetro url. (e.g. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Título do Feed',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Por favor especifique um Feed com a url do Parâmetro. (e.g. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Não foi possível carregar ou analisar feed',
	'FeedSource'				=> 'Origem:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Alterações recentes',
	'ChangesXML'				=> 'Alterações recentes para o ',
	'CommentsXMLTitle'			=> ' - Recentemente comentadas',
	'CommentsXML'				=> 'Comentários recentes para ',
	'NewsXMLTitle'				=> ' - Notícias recentes',
	'NewsXML'					=> 'Notícias recentes para ',
	'RevisionXMLTip'			=> 'Clique para ver revisões recentes em formato XML.',
	'CommentsXMLTip'			=> 'Clique para ver os comentários recentes em formato XML.',
	'ChangesXMLTip'				=> 'Clique para ver as recentes alterações no formato XML.',
	'NewsXMLTip'				=> 'Clicar para ver notícias recentes em formato XML.',
	'RevisionsXML'				=> 'Revisões de ',
	'ExportClusterXML'			=> 'Exportação completa de ',
	'AccessDeniedXML'			=> 'Não está autorizado a aceder a esta informação.',

	'ChangesFeed'				=> 'Alterações',
	'CommentsFeed'				=> 'Comentários',
	'NewsFeed'					=> 'Notícia',
	'RevisionsFeed'				=> 'Revisões de ',

	'LastModification'			=> 'Última modificação',

	// Captcha
	'Captcha'					=> 'Por favor, digite a palavra que você lê na imagem',
	'CaptchaFailed'				=> 'Você digitou a palavra captcha incorretamente. Por favor, tente novamente.',
	'CaptchaReload'				=> 'Novo Captcha',
	'CaptchaReloadWarning'		=> 'Desculpe, não é possível recarregar a imagem do captcha, você terá que recarregar a página para fazer isso',

	// news
	'News'						=> 'Notícia',
	'NewsName'					=> 'Título:',
	'NewsNoName'				=> 'Você esqueceu de adicionar título de notícias.',
	'NewsNotAvailable'			=> 'Nenhuma notícia disponível.',
	'NewsNoClusterDefined'		=> 'Nenhum cluster de notícias definido.',
	'NewsDiscuss'				=> 'Discutir este artigo...',

	// blog
	'BlogNewTopic'				=> 'Criar uma nova postagem',
	'NoPostAvailable'			=> 'Nenhuma publicação disponível ainda.',

	// Review
	'Reviewer'					=> 'Revisor',
	'Reviewed'					=> 'revisado',
	'Review'					=> 'análise',
	'ReviewedBy'				=> 'revisado por',
	'RemoveReview'				=> 'Remover revisão desta página',
	'SetReview'					=> 'Revisado nesta página',
	'SetAsReviewed'				=> 'Definir página como revisada',
	'SetAsUnreviewed'			=> 'Definir página como não revisada',

	// word filter
	'PotentialSpam'				=> 'Spam Potencial Identificado',

	// moderation handler
	'Moderation'				=> 'Moderação',
	'Topics'					=> 'tópicos',
	'ModerateSection'			=> 'seção / página ',

	'NotModerator'				=> 'Você não tem autoridade para moderar essa página / capítulo',
	'ModerateDeleteTopic'		=> 'Excluir tópico / página',
	'ModerateDeletePosts'		=> 'Excluir comentários',
	'ModerateMove'				=> 'Mover',
	'ModerateSplit'				=> 'Dividir / Mover comentários',
	'ModerateMerge'				=> 'Fundir',
	'ModerateLock'				=> 'Bloquear',
	'ModerateUnlock'			=> 'Desbloquear',
	'ModerateAccept'			=> 'Aceitar',
	'ModerateDeleteConfirm'		=> 'Tem certeza que deseja remover <strong>remover</strong> os seguintes tópicos?',
	'ModerateRenameConfirm'		=> 'Digite um novo título para a página selecionada',
	'ModerateRenameExists'		=> 'Já existe uma página com o mesmo nome! Escolha um nome diferente.',
	'ModerateRename1Only'		=> 'Nota: somente a primeira página que você selecionou será renomeada!',
	'ModerateMovesConfirm'		=> 'Selecione a partição de destino para mover o fórum para',
	'ModerateMoveConfirm'		=> 'Selecione o fórum ou especifique o cluster para mover estes tópicos. Para mover uma página para a raiz do site, digite &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Especifique o nome do cluster em que colocar a página. Para mover uma página para a raiz do site, digite &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operação abortada: nesta seção já existem tópicos com o mesmo nome %1. Se você ainda precisa transferir os tópicos acima mencionados, por favor, renomee-os primeiro.',
	'ModerateMoveNotExists'		=> 'A página / cluster não existe. Por favor, verifique o nome e tente novamente.',
	'ModerateMergeConfirm'		=> 'Escolha um tópico, que deve combinar o restante',
	'ModerateMerge2Min'			=> 'Para se juntar você deve selecionar pelo menos dois tópicos!',
	'ModerateComDelConfirm'		=> 'Tem certeza que deseja remover <strong>remover</strong> %1 %2?',
	'ModerateComment'			=> 'Comentário',
	'ModerateComments'			=> 'Comentários',
	'ModerateSplitNewName'		=> 'Especifique um nome para um tópico separável e selecione um esquema de separação',
	'ModerateSplitPageName'		=> 'Digite o nome da página / tópico, onde mover comentários destacáveis e selecione um esquema de separação',
	'ModerateSplitAllAfter'		=> 'Desanexar todos os comentários após o primeiro selecionado (e incluindo)',
	'ModerateSplitSelected'		=> 'Separados apenas comentários selecionados (total %1)',
	'ModerateUserProfile'		=> 'Perfil',
	'ModerateNoItemChosen'		=> 'Por favor, selecione pelo menos um item através do botão Configurar.',

	'ModerateSection2'			=> 'seção moderada',
	'ModerateTopicsDeleted'		=> 'Tópicos selecionados excluídos com sucesso.',
	'ModerateTopicsRelocated'	=> 'Tópicos selecionados relocalizados com sucesso.',
	'ModerateTopicsRenamed'		=> 'Tópico renomeado com sucesso.',
	'ModerateTopicsMerged'		=> 'Tópicos selecionados mesclados com sucesso.',
	'ModerateTopicsBlocked'		=> 'Tópicos selecionados bloqueados com sucesso',
	'ModerateTopicsUnlocked'	=> 'Tópicos selecionados desbloqueados com sucesso.',
	'ModerateTopicDeleted'		=> 'O tópico foi removido com sucesso.',
	'ModeratePageMoved'			=> 'Página movida com sucesso.',
	'ModerateTopicRenamed'		=> 'Tópico renomeado com sucesso.',
	'ModerateTopicBlocked'		=> 'Tópico bloqueado com sucesso',
	'ModerateTopicUnlocked'		=> 'Tópico desbloqueado com sucesso.',
	'ModerateCommentsDeleted'	=> 'Comentários selecionados removidos com sucesso.',
	'ModerateCommentsSplit'		=> 'Comentários selecionados separados com sucesso em um novo tópico.',
	'ModerateCommentsSplitFailed'	=> 'Nota: Por alguma razão a separação dos comentários selecionados para um novo tópico falhou. U<br>geralmente isso não deve acontecer, então por favor notifique o administrador do site.<br>Como precaução, a questão foi preservada na sua forma original.',
	'ModerateCommentsMoved'		=> 'Comentários selecionados migraram com sucesso para uma determinada página.',

	// forum
	'ForumSubforums'			=> 'Fórum',
	'ForumTopic'				=> 'Tópico',
	'ForumTopics'				=> 'Tópicos',
	'ForumPosts'				=> 'Mensagens',
	'ForumReplies'				=> 'Respostas',
	'ForumAuthor'				=> 'Autor',
	'ForumViews'				=> 'Vistas',
	'ForumCreated'				=> 'Criado',
	'ForumComments'				=> 'Comentários',
	'ForumLastComment'			=> 'Último comentário',
	'ForumNoComments'			=> 'Não existem comentários.',
	'ForumNoTopics'				=> 'Não há mensagens ou tópicos neste fórum.',
	'ForumNewTopic'				=> 'Iniciar uma nova discussão',
	'ForumTopicName'			=> 'Nome do tópico:',
	'ForumTopicSubmit'			=> 'Enviar tópico',
	'ForumNoTopicName'			=> 'Especificar um nome para a nova página.',
	'ForumNewPosts'				=> 'nova postagem',
	'ForumLocked'				=> 'seção bloqueada',
	'ForumUpdated'				=> 'atualizado',
	'ForumNoClusterDefined'		=> 'Nenhum cluster de fórum definido.',
	'ForumOutsideCluster'		=> 'Certifique-se de que a ação %1 está localizada dentro do cluster do fórum.',

	// password complexity
	'PwdCplxShort'				=> 'A senha é muito curta.',
	'PwdCplxEquals'				=> 'A senha contém o nome de usuário.',
	'PwdCplxWeak'				=> 'A senha não atende aos requisitos de complexidade.',
	'PwdCplxDesc1'				=> 'Requisitos para a senha: ',
	'PwdCplxDesc2'				=> 'a senha não deve ter menos de %1 caracteres',
	'PwdCplxDesc3'				=> 'não deve conter seu nome de usuário',
	'PwdCplxDesc4'				=> 'deve consistir em ',
	'PwdCplxDesc41'				=> 'letras e números',
	'PwdCplxDesc42'				=> 'letras maiúsculas e minúsculas e números',
	'PwdCplxDesc43'				=> 'uppercase and lowercase letters, digits and non-alphabetic characters',
	'PwdCplxDesc5'				=> 'Você pode usar quaisquer letras, números e caracteres especiais, mas lacunas.',

	'PasswordTooShort'			=> 'Password com poucos caracteres.',
	'PasswordTooCommon'			=> 'Essa palavra-passe é demasiado comum.',
	'PasswordSameAsUsername'	=> 'A sua palavra-passe é a mesma que o seu nome de utilizador.',
	'PasswordSameAsEmail'		=> 'A sua palavra-passe é a mesma que o seu email.',

	'Timezone'					=> 'Fuso Horário',
	'DateFormat'				=> 'Formato da Data',

	'LanguageArray'	=> [
		'ar' => 'Arábico',
		'bg' => 'Búlgaro',
		'cs' => 'Tcheco',
		'da' => 'Dinamarquês',
		'de' => 'Alemão',
		'el' => 'Grego',
		'en' => 'Inglês',
		'es' => 'Espanhol',
		'et' => 'Estoniano',
		'fa' => 'Persa',
		'fi' => 'Finlandês',
		'fr' => 'Francês',
		'hi' => 'Hindi',
		'hu' => 'húngaro',
		'id' => 'Indonésio',
		'it' => 'Italiano',
		'ja' => 'Japonesas',
		'ko' => 'Coreano',
		'nl' => 'Holandês',
		'no' => 'Norueguês',
		'pl' => 'Polonês',
		'pt' => 'Português',
		'pt-br' => 'Português-Brasil',
		'ro' => 'Romanico',
		'ru' => 'Russo',
		'sv' => 'Sueco',
		'ta' => 'Tamil',
		'uk' => 'Ucraniano',
		'zh' => 'Chinês',
		'zh-tw' => 'Chinês',
	],

	'AccountStatus'				=> 'Status da conta',
	'AccountStatusArray' => [
		'0' => 'ativo',
		'1' => 'pendente',
		'2' => 'bloqueado',
		'3' => 'inativo',
	],

	'JustNow'		=> 'agora mesmo',
	'MinuteAgo'		=> 'um minuto atrás',
	'MinutesAgo'	=> '%1 minutos atrás',
	'HourAgo'		=> 'uma hora atrás',
	'HoursAgo'		=> '%1 horas atrás',
	'DayAgo'		=> 'ontem',
	'DaysAgo'		=> '%1 dias atrás',
	'WeekAgo'		=> 'uma semana atrás',
	'WeeksAgo'		=> '%1 semanas atrás',
	'MonthAgo'		=> 'um mês atrás',
	'MonthsAgo'		=> '%1 meses atrás',
	'YearAgo'		=> 'um ano atrás',
	'YearsAgo'		=> '%1 anos atrás',

	'InAMoment'		=> 'em um momento',
	'InAMinute'		=> 'em um minuto',
	'InMinutes'		=> 'em %1 minutos',
	'InAnHour'		=> 'em uma hora',
	'InHours'		=> 'em %1 horas',
	'Tomorrow'		=> 'amanhã',
	'InDays'		=> 'em %1 dias',
	'InAWeek'		=> 'em uma semana',
	'InWeeks'		=> 'em %1 semanas',
	'InAMonth'		=> 'em um mês',
	'InMonths'		=> 'em %1 meses',
	'InAYear'		=> 'em um ano',
	'InYears'		=> 'em %1 anos',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'KB', 'MB', 'BR', 'Tb', 'PCP', 'FB', 'ZB', 'PB'],
	'ByteDecimalLong'			=> ['byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'PM', 'Guiné', 'PT', 'PP', 'PE', 'ZP', 'PI'],
	'PixelDecimalLong'			=> ['Píxel', 'Kpx', 'Mpx', 'JPX', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Acção desconhecida',
	'UnknownMethod'				=> 'Método desconhecido',
	'FormatterNotFound'			=> 'Formatter %1 não encontrada',

	// log
	'LogAdminLoginSuccess'		=> 'Login bem sucedido no painel administrativo',
	'LogAdminLogout'			=> 'Sair do painel administrativo',
	'LogAdminLoginFailed'		=> '!!Falha ao autorizar o acesso ao painel administrativo!!',
	'LogAdminLoginLocked'		=> 'Login bloqueado para o painel administrativo',
	'LogUserCookieForged'		=> '!!**Uma tentativa de se conectar em um cookie forjado com o login ##%1##**!!',
	'LogInvalidFormToken'		=> 'Ataque potencial do CSRF detectado em andamento: %1',
	'LogRemovedPage'			=> '!!Página removida ##%1## (Usuário %2)!!',
	'LogRemovedCluster'			=> '!!Removido **cluster** ##%1## (usuário %2)!!',
	'LogRemovedRevision'		=> '!!Revisão removida ##%3## da página [[/%1]] (usuário %2)!!',
	'LogRemovedComment'			=> '!!Comentário removido de %3 na página [[/%1]] (usuário %2)!!',
	'LogRemovedFile'			=> '!!Arquivo removido ##%2## da página [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!Removido todos os comentários da página [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Removido todas as revisões da página [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Removido todos os arquivos, anexados a [[/%1]]!!',
	'LogTopicLocked'			=> 'Tópico do fórum está bloqueado [[/%1]]',
	'LogTopicUnlocked'			=> 'Tópico do fórum desbloqueado [[/%1]]',
	'LogAclUpdated'				=> 'Página ACL Atualizada [[/%1]]',
	'LogOwnershipChanged'		=> 'O proprietário da página [[/%1]] foi transferido para o usuário ##%2##',
	'LogUserLoginFailed'		=> '!!Tentativas malsucedidas de login com ##~%1##!!',
	'LogClonedPage'				=> 'Página ##%1## clonado para [[/%2]]',
	'LogRenamedPage'			=> 'Página ## ##%1## renomeado para [[/%2]]',
	'LogRenamedPage2'			=> '. A página antiga definida como o link para a nova',
	'LogSplittedPage'			=> 'Comentários da página [[/%1]] dividir-se na página [[/%2]]',
	'LogMergedPages'			=> 'Páginas %1 fundidas à página [[/%2]]',
	'LogUserPasswordReminded'	=> 'Usuário ##%1## pediu o processo de recuperação de senha para abordar ##%2##',
	'LogUserPasswordRecovered'	=> 'Usuário ##%1## recuperou com sucesso a senha esquecida',
	'LogUserPasswordChanged'	=> 'Usuário ##%1## atualizado com sucesso (alterado) a senha',
	'LogUserPasswordMismatch'	=> '!!Usuário ##%1## Falha ao alterar a senha: senha atual não confe!!',
	'LogUserIPSwitched'			=> 'Alteração de endereço IP não autorizado do usuário %1 do %2 para %3',
	'LogPageImported'			=> 'Página importada [[/%1]]',
	'LogSaveNoRights'			=> 'Sem permissões para salvar a página [[/%1]]',
	'LogPageCreated'			=> 'Criada nova página [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Propriedades de página atualizadas [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'O usuário conseguiu o proprietário da página [[/%1]]',
	'LogFileUploadedLocal'		=> 'Novo arquivo ##%2## enviado para a página [[/%1]] (tamanho %3)',
	'LogFileUploadedGlobal'		=> 'Novo arquivo ##%2## enviado para a pasta global (tamanho %3)',
	'LogPMSent'					=> 'Mensagem pessoal ##%1## -> ##%2## enviada com sucesso',
	'LogUserSimilarName'		=> 'Houve tentativas para se registrar sob o mesmo nome de usuário: ##%1##',
	'LogUserEmailNotAllowed'	=> 'E-mail ##%1## Não está na lista de domínios permitidos',
	'LogRegisterTiming'			=> 'O registo falhou, o tempo limite do formulário é de ##%1## segundos (foi ##%2##)',
	'LogUserRegistered'			=> 'Registrou um novo usuário com sucesso ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'E-mail ##%1## do utilizador ##%2## ativado com sucesso',
	'LogCommentPosted'			=> 'Adicionado [[/%1 novo(s) comentário(s)]] à página [[/%2]]',
	'LogUserLoginOK'			=> 'Usuário ##%1## logado com sucesso no sistema',
	'LogUserLoggedOut'			=> 'Usuário ##%1## desconectou do sistema com sucesso',
	'LogUserSessionContinued'	=> 'Usuário ##%1## continuou a sessão suspensa',
	'LogUserSettingsUpdate'		=> 'Usuário ##%1## atualizou configurações pessoais',
	'LogPageEdited'				=> 'Página editada [[/%1]]',
	'LogCommentEdited'			=> 'Comentário editado [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Metadados de arquivos atualizados para ##%2## da página [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Categorias de arquivos atualizadas para ##%2## da página [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'Sitemap XML gerado',
	'LogReferrersPurged'		=> 'Manutenção: referenciadores removidos',
	'LogRevisionsPurged'		=> 'Manutenção: revisões de páginas desatualizadas removidas',
	'LogDeletedPagesPurged'		=> 'Manutenção: páginas apagadas apagadas',
	'LogSystemLogPurged'		=> 'Manutenção: log do sistema limpo',
	'LogCachedPagesPurged'		=> 'Manutenção: páginas em cache removidas',
	'LogSqlCachePurged'			=> 'Manutenção: resultados do sql em cache purgado',
	'LogExpiredTokensPurged'	=> 'Manutenção: cookie_tokens excluídos expirados',
	'LogErrorSplitComments'		=> 'Erro ao separar comentários do tópico [[/%1]] um novo tópico ##%2##: página não foi criada',
	'LogCategoriesUpdated'		=> 'Categorias de página atualizadas [[/%1]]',
	'LogCategoryCreated'		=> 'Criado uma nova categoria //%1//',
	'LogCategoryRenamed'		=> 'Categoria ##%1## renomeada para ##%2##',
	'LogCategoryDebundled'		=> 'Categoria ##%1## debilitada',
	'LogCategoryGrouped'		=> 'Categoria ##%1## agrupada com a palavra ##%2##',
	'LogCategoryRemoved'		=> 'Categoria ##%1## removida do banco de dados',
	'LogThumbnailGeneration'	=> 'Miniaturas geram %1 seg.',

	'ErrorMinPHPVersion'		=> 'A Versão PHP deve ser maior do que <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' o seu servidor parece estar a executar uma versão <strong>' . PHP_VERSION . '</strong>.' .
									'  Deve actualizar para uma versão mais recente do PHP para que o WackoWiki funcione correctamente.',

];
