<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Chinese',
		'code'		=> 'zh-tw',
		'dir'		=> 'ltr',
		'locale'	=> 'zh_TW',
	],

	'date_formats'	 => [
		'default'	=> 'y年MM月dd日',
	],

	// common
	'AddButton'					=> '新增',
	'ArchiveButton'				=> '封存',
	'CancelButton'				=> '取消',
	'ContinueButton'			=> '繼續',
	'ConvertButton'				=> '轉換',
	'CreateButton'				=> '建立',
	'DeleteButton'				=> '刪除',
	'RemoveButton'				=> '移除',
	'RenameButton'				=> '重命名',
	'ResetButton'				=> '重置',
	'RestoreButton'				=> '復原',
	'SaveButton'				=> '儲存',
	'SearchButton'				=> '搜尋',
	'SendButton'				=> '發送',
	'SetButton'					=> '設定',
	'SubmitButton'				=> '提交',
	'UpdateButton'				=> '更新',

	'FormInvalid'				=> '提交的表格無效。 嘗試再次提交。',
	'UnitPixel'					=> 'px',
	'Number'					=> 'Number',

	// logged in panel
	'AccountText'				=> '帳',
	'AccountTip'				=> '帳號設定',
	'AdminText'					=> '管理',
	'AdminTip'					=> '管理面板',
	'LogoutLink'				=> '登出',
	'LogoutButton'				=> '登出',
	'LogoutAreYouSure'			=> '確定要登出嗎？',

	// registration panel
	'RegistrationWelcome'		=> '建立帳號：',
	'RegistrationButton'		=> '建立您的帳號',
	'UserNameOwned'				=> '此使用者名稱已被註冊，請選擇其他的名稱',
	'SiteRegistered'			=> '您已成功註冊網站 %1。',
	'RegistrationEmailInfo'		=> '有效的電子郵件地址。來自系統的所有電子郵件都將寄送到此地址。此電子郵件地址不會被公開，只有在您希望收取新密碼或希望透過電子郵件接收某些消息或通知時使用。',
	'EmailConfirmHint'			=> '我們已寄送一封電子郵件至您填寫的電子郵件信箱，請點信中的連結來確認您的電子郵件地址。<br>如果您不驗證您的電子郵件地址，您將無法在您遺失的密碼時取回您的密碼。<br>此外，您也不會收到頁面更新和評論的通知。',
	'EmailConfirmRequired'		=> '沒有經過確認的電子郵件地址，您將無法登錄。',
	'NameTooShort'				=> '使用者名稱太短，至少需要%2個字元。',
	'NameTooLong'				=> '使用者名稱太長，最多允許%2個字元。',
	'NameAlphanumOnly'			=> '使用者名稱長度必須在 %1 - %2 字元間，並且由字母和數字組合。允許大寫字母。',
	'NameCamelCaseOnly'			=> '使用者名稱長度必須在 %1 - %2 字元間，並且為WikiName的格式。',
	'NewUserAccount'			=> '新帳號',

	'NewAccountSubject'			=> '帳號註冊',
	'NewAccountAdminCreated'	=> '%1 使用 "%2" 作為使用者名稱為您建立了新的帳號。若要完成註冊，請造訪以下連結（確保連結以單行輸入），並設定您的密碼：',
	'NewAccountUsername'		=> '使用者名稱：',
	'AccountLanguage'			=> '語言：',
	'NewAccountEmail'			=> '電郵：',
	'NewAccountIP'				=> '遠端 IP 位址：',
	'NewAccountSignupInfo'		=> '已建立以下帳號：',

	'UserWaitingApproval'		=> '已寄送電子郵件給網站管理員。管理員將審核您送出的資料，並批准或拒絕您的請求。',
	'UserRequiresApproval'		=> '請至管理介面來批准或拒絕此使用者存取 %1。',
	'UserApprovalInfo'			=> '當您註冊後，您的註冊請求將寄送給網站管理員以供審核。 您將收到一封包含進一步說明的電子郵件。',
	'UserApprovalHint'			=> '在您的帳號成功啟用後，您會收到電子郵件通知。在此之前，您無法登入。',

	'UserApprovalPending'		=> '您的帳號正在等待審核。',
	'UserApprovalDenied'		=> '您的帳號已被拒絕存取此網站。',

	'RegistrationApproved'		=> '註冊已核准',
	'RegistrationDenied'		=> '註冊被拒絕',
	'PendingApproval'			=> '等待審核',

	'UserApprovedInfo'			=> '您已被核准存取 %1。',
	'UserDeniedInfo'			=> '您已被拒絕存取 %1。',

	'RegistrationThreshold'		=> '填寫表格的時間不應小於％1秒。',
	'Language'					=> '語言',

	// login panel
	'LoginWelcome'				=> '登入',
	'CreateAccount'				=> '註冊新帳號',
	'RegistrationLink'			=> '建立帳號',
	'LoginName'					=> '使用者名稱',
	'Password'					=> '密碼',
	'LoginButton'				=> '登入',
	'LoginLink'					=> '登入',
	'PersistentCookie'			=> '记住我的登录状态',
	'Session'					=> '工作階段',
	'SessionTip'				=> '目前工作階段的參數',
	'SessionDuration'			=> '工作階段持續時間',
	'SessionDurationSession'	=> '瀏覽器工作階段',
	'SessionDurationDay'		=> '1 天',
	'SessionDurationWeek'		=> '1 週',
	'SessionDurationMonth'		=> '1 個月',
	'LoggedInAs'				=> '您登入的身份',

	'ClearCookies'				=> '刪除所有 cookies',
	'BindSessionIp'				=> '將工作階段綁定到 IP 位址',
	'BindSessionIpOn'			=> '已啟用（目前 IP %1）',
	'TrafficProtection'			=> '流量保護',
	'SessionEnds'				=> '目前的工作階段結束',
	'LastVisit'					=> '最後一次造訪記錄',

	'LoginIncorrect'			=> '您輸入的使用者名稱或密碼無效。',
	'WelcomeBack'				=> '歡迎回來, %1',
	'LoginAttemptsExceeded'		=> '您嘗試超過了允許的最大登入次數<br>除了使用者名稱和密碼之外，您現在還需要解下方的驗證碼。',

	// session notice
	'IPAddressChanged'			=> 'IP 位址變更為為 %1 （原本是 %2 ）',

	'SessionReplay'				=> '工作階段因重放而終止。',
	'SessionObsolete'			=> '工作階段失效。',
	'SessionExpired'			=> '工作階段已過期。',
	'SessionTimeout'			=> '工作階段因逾時而終止。',
	'SessionInactivity'			=> '工作階段因沒有活動而終止。',
	'SessionUaChange'			=> '因為 User-Agent 已更改，工作階段已終止。',
	'SessionTLSChange'			=> '因為 TLS 狀態變更，工作階段已終止。',
	'SessionIPChange'			=> '工作階段因 IP 變更而終止。',

	// other
	'Guest'						=> '訪客',
	'Everybody'					=> 'Everybody',
	'Help'						=> '說明',
	'TopicSearchText'			=> '僅搜尋標題',
	'WordprocessorVersion'		=> '文字處理器版本',

	// notifications
	'EmailHello'				=> '你好 ',
	'EmailModerator'			=> '版主',
	'WatchedPageChanged'		=> '頁面變更 ',
	'SomeoneChangedThisPage'	=> ' 修改了您正在關注的頁面： ',
	'NewPageCreatedSubj'		=> '新頁面',
	'NewPageCreatedBody'		=> '使用者 %1 建立了一個新頁面： ',
	'FileUploadedSubj'			=> '新檔案',
	'FileUploadedBody'			=> '使用者 %1 上傳了一個新檔案： ',
	'FileReplacedBody'			=> '使用者 %1 已更換了檔案： ',

	'ActionDenied'				=> '此操作被拒。',
	'TocTitle'					=> '目錄 ',
	'OuterLink2'				=> '外部連結',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF 文件',
	'RDFLink'					=> 'RDF 文件',
	'EmailLink'					=> '撰寫電子郵件（啟動電子郵件客戶端）',
	'GeoLink'					=> '顯示此位置（啟動地圖應用程式）',
	'JabberLink'				=> '透過 XMPP 聊天（啟動 Jabber 客戶端）',
	'TelLink'					=> '撥打此號碼（啟動電話應用程式）',
	'PermaLink'					=> '固定連結',
	'PermaLinkTip'				=> '此頁面修訂的靜態連結',
	'PermaLink0Tip'				=> 'Permanent link to this page',

	'ShowTip'					=> '返回檢視模式',
	'ShowText'					=> '檢視',
	'WikieditAutocomplete'		=> '使用 Ctrl+Space 完成 wiki 連結',
	'WikiEditInactiveJs'		=> '為了能夠使用 WikiEdit，請在啟用瀏覽器的 JavaScript 。',
	'NumerateLinks'				=> 'Numerate links in print view',
	'Comment'					=> '評論',
	'Comments0'					=> '添加留言',
	'Comments1'					=> '閱讀評論（1則評論）',
	'CommentsN'					=> '閱讀評論（%1則評論）',
	'Comments'					=> '回應',
	'CommentHint'				=> '<a href="%1">登錄</a>或<a href="%2">創建帳戶</a>發表評論。',
	'CommentEdited'				=> '編輯',
	'Links'						=> '連接',
	'Version'					=> '版本',

	// details formatter
	'ShowHideDetails'			=> '詳情',

	'PrivacyPolicy'				=> '隱私政策',
	'TermsOfUse'				=> '使用條款',
	'AcceptTermsOfUse'			=> '我已閱讀、理解並同意本網站的使用條款。',

	'ShowComments'				=> '顯示評論/表單',
	'HideComments'				=> '隱藏評論/表單',
	'AddComment'				=> '在此頁面新增評論：',
	'AddCommentTitle'			=> '回應的標題：',
	'CommentTitleRe'			=> 'Re:',
	'AddCommentButton'			=> '發表留言',
	'HereLink'					=> '這裡',
	'PageHandlerMoreTip'		=> '更多',

	'ThemeCorrupt'				=> '主題已毀損',
	'InvalidNamespace'			=> '給定的命名空間無效。',
	'DoesNotExists'				=> '該頁不存在。',
	'PromptCreate'				=> '您是不是要 <strong><a href="%1">新建</a></strong> 它呢？',
	'RevisionHint'				=> '這是一個舊版本的 of <a href="%1">%2</a> from %3 edited by %4.',
	'ReadAccessDenied'			=> '您無權閱讀此頁面。',
	'ReadAccessDeniedHintGuest'	=> '請先登入才能閱讀此頁面。',
	'PageDeletedInfo'			=> '此頁面已被刪除。 ',
	'RevisionDeletedInfo'		=> '此修訂版已被刪除。',
	'CommentDeletedInfo'		=> '該評論已被刪除。',

	'LastEditedBy'				=> '最後編輯者',
	'YouAreOwner'				=> '你是本頁的所有者。',
	'Owner'						=> '所有者',
	'OwnerColon'				=> '所有者：',
	'Nobody'					=> '本页没有所有者',
	'TakeOwnership'				=> '成為所有者',
	'FilesTip'					=> '管理附加檔案',
	'FilesText'					=> '附加檔案',
	'DeleteTip'					=> 'Delete page, its files and comments',
	'DeleteCommentTip'			=> '刪除回應',
	'DeleteText'				=> '刪除',
	'AclText'					=> '權限',
	'AclTip'					=> '編輯權限',

	'PropertiesText'			=> '属性',
	'PropertiesTip'				=> 'Edit Page Properties',
	'EditTip'					=> '編輯該頁。',
	'EditText'					=> '編輯',
	'EditSection'				=> '編輯章節 %1',
	'EditSectionHint'			=> 'Section %1 of %2',
	'SectionHeadline'			=> '章節',
	'EditCommentTip'			=> 'Edit comment',
	'EditComment'				=> 'Edit this comment',
	'ReplyComment'				=> '回覆',
	'ReplyCommentTip'			=> 'Reply this comment',
	'RevisionTip'				=> '查看最近的修改歷史',
	'RevisionText'				=> '次修改',
	'ReferrersTip'				=> '查看連接到本頁的網址',
	'ReferrersText'				=> '來源',
	'ModerateTip'				=> 'Moderation of topics and forum posts',
	'ModerateText'				=> '管理',
	'SearchText'				=> '搜尋： ',

	'AclUpdated'				=> '權限設置已經更新',
	'AclGaveOwnership'			=> ' and gave ownership to %1.',
	'AclNoNewOwner'				=> 'Page ownership is not transferred, because the user %1 was not found.',
	'NewPageOwnership'			=> 'Transferred page ownership',
	'YouAreNewOwner'			=> 'former owner %1 transferred ownership ' . "\n" . 'of following page to you',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> '瀏覽權限：',
	'AclWrite'					=> '編輯權限：',
	'AclComment'				=> '回應：',
	'AclCreate'					=> '创建：',
	'AclUpload'					=> '上傳：',
	'AclFor'					=> 'Access Control Lists for %1',
	'SetOwner'					=> '設置擁有者:',
	'OwnerDontChange'			=> '不改變',
	'AclAccessDenied'			=> '您並非該頁的所有者。',
	'AclSyntaxError'			=> 'Access control list syntax error',
	'AclHelp'					=> '<code>*</code> - everyone is allowed<br>' .
									'<code>$</code> - only registered users<br>' .
									'<code>!</code> - a preceding exclamation mark denies the respective right<br>' .
									'<code>[UserName]</code> - names of allowed users<br>' .
									'<code>[GroupName]</code> - names of allowed usergroup (alias)<br>' .
									'<code>(an empty list)</code> - only the page owner has access',

	'AccessMode'				=> '可見性',
	'AccessDenied'				=> 'denied',
	'AccessPublic'				=> 'public',
	'AccessRegistered'			=> '註冊',
	'AccessPrivate'				=> 'private',
	'AccessCustom'				=> 'custom',

	// purge handler
	'PurgePage'					=> 'Purge page',
	'NotOwnerAndCantPurge'		=> 'You are not the owner of the page and you cannot purge it.',
	'ReallyPurge'				=> 'ATTENTION: Purging the page is irreversible!',
	'SelectPurgeOptions'		=> 'Select the necessary purge options:',
	'PurgeComments'				=> 'Purge all comments of the page',
	'CommentsPurged'			=> 'All comments were deleted.',
	'PurgeFiles'				=> 'Remove all attached files',
	'FilesPurged'				=> 'All attached files were removed.',
	'PurgeRevisions'			=> 'Purge all revisions of the page',
	'RevisionsPurged'			=> 'Revisions were purged.',
	'PurgeButton'				=> 'Purge',

	// categories handler
	'Categories'				=> '分類目錄',
	'CategoriesAssign'			=> 'assign',
	'CategoriesEdit'			=> '編輯',
	'Category'					=> '分類',
	'CategoriesFor'				=> 'Categories for',
	'CategoriesTip'				=> 'Edit categories',
	'CategoriesText'			=> '分類目錄',
	'CategoriesUpdated'			=> 'Categories updated',
	'CategoriesAlreadyExists'	=> '此類別 %1 已存在。',
	'CategoriesAdded'			=> '類別 %1 添加成功。',
	'CategoriesRenamed'			=> 'Category successfully renamed.',
	'CategoriesUngrouped'		=> 'Category debundled successfully.',
	'CategoriesGrouped'			=> 'The category entered in the new group.',
	'NoMultilevelGrouping'		=> 'Multilevel grouping categories is not possible.',
	'CategoriesDeleted'			=> 'The category was deleted from the database and all pages.',
	'CategoriesAdd'				=> '新增新分類',
	'CategoryDescription'		=> '說明',
	'CategoriesAddGrouped'		=> '按分類分組',
	'CategoriesAddGroupedNo'	=> 'No group.',
	'CategoriesRename'			=> 'Rename the category %1 to',
	'CategoriesRenameInfo'		=> '* Note: Change will affect all pages that are assigned to that category.',
	'CategoriesGroup'			=> 'Group categories %1 with',
	'CategoriesGroupInfo'		=> '* Select [no group] to debundle the category.',
	'CategoriesNoGroup'			=> '[no group]',
	'CategoriesDelete'			=> 'Are you sure you want to remove category %1?',
	'CategoriesDeleteInfo'		=> '* Note: Change will affect all pages that are assigned to that category. If the word has a sub-category, they will not be deleted, but only debundled.',
	'CategoriesStoreInfo'		=> '要將類別分配給頁面，請選中復選框。',
	'CategoriesStoreButton'		=> 'Save Categories',
	'CategoriesGroupButton'		=> '群組',
	'CategoriesEditInfo'		=> 'To edit the Category list select the radio button.',
	'NoCategoriesForThisLang'	=> 'Categories for this language are not specified.',
	'PagesCategory'				=> 'Pages category',
	'CategoryNotExists'			=> 'Category does not exist.',
	'CategoryEmpty'				=> 'Category empty.',
	'NoCategorySelected'		=> 'No category selected.',
	'NoCategoriesAssigned'		=> 'No assigned categories for this language.',
	'TagCloud'					=> 'Tag Cloud',
	'PagesTaggedWith'			=> '%1 pages tagged with %2',
	'CategoriesOfCluster'		=> 'of cluster',
	'TaggedWithTip'				=> 'show pages tagged %1',

	// source handler
	'SourceText'				=> '來源',
	'SourceTip'					=> '檢視原始碼',
	'SourceCopyToClipboard'		=> '複製到剪貼板',
	'SourceFor'					=> '檢視 %1 的原始碼',

	// Groups action
	'GroupsSearch'				=> 'Find Groups',
	'GroupsNoMatching'			=> 'Matching groups not found. Try a less strict search criteria.',
	'GroupsOpenProfile'			=> '檢視使用者資訊',
	'GroupsName'				=> '群組',
	'GroupsMembers'				=> '會員',
	'GroupsDescription'			=> '說明',
	'GroupsCreated'				=> '已建立',
	'GroupsNotFound'			=> 'Group %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'GroupsProfile'				=> '個人資料',
	'GroupsList'				=> 'View the entire list of groups',
	'GroupSpace'				=> 'Group space',

	'MetaUpdated'				=> 'Meta data updated',

	'PreviewButton'				=> '預覽',
	'Preview'					=> '預覽',
	'Chars'						=> 'chars',
	'PageBody'					=> 'Page body',
	'EditNote'					=> '編輯摘要',
	'EditNoteMissing'			=> 'Edit summary missing',
	'EditMinor'					=> '小修改',
	'MinorEditHide'				=> 'Hide minor edit',
	'MinorEditShow'				=> 'Show minor edit',
	'PostAnonymously'			=> 'Post anonymously without giving your name',
	'NotifyMe'					=> 'Notify me about new comments and changes of the page',
	'OverwriteAlert'			=> '覆寫警告：您編輯此頁面期間，他人已對其進行修改。<br>請複製您的變更內容並重新編輯此頁面。',
	'TextDbOversize'			=> '警告：您的文本長度超過了 %1 個字符所允許的最大值。 請將文本縮短到可接受的字符數。 提示：您可以將其余文本放在單獨的頁面上。',
	'EditingRevisionWarning'	=> 'You are editing an old revision of this page. If you publish it, any changes made since then will be removed. <br>You may wish to edit the current revision instead.',
	'WriteAccessDenied'			=> '您沒有編輯該頁的權限。',
	'EmptyPage'					=> 'Page body was empty - not saved!',
	'EmptyComment'				=> '留言沒有內容？ 不儲存留言！',
	'CommentAccessDenied'		=> 'Sorry, you\'re not allowed to post comments to this page.',
	'CommentFlooded'			=> 'The interval between the publication of the posts shall not be less than %1 seconds.',
	'CommentAdded'				=> 'Comment added.',
	'YouAreNowTheOwner'			=> '你現在成為了該頁的擁有者。',
	'PageSaved'					=> 'Page version %1 saved.',
	'CommentSaved'				=> 'Comment saved.',

	'RevisionsFor'				=> '文件歷史 %1',
	'DefaultDiffMode'			=> 'Default diff mode',
	'DiffMode'		=> [
		'0'		=> 'Full diff',
		'1'		=> 'Simple diff',
		'2'		=> '來源',
		'3'		=> '並排',
		'4'		=> '行內',
		'5'		=> 'Merged',
		'6'		=> 'Unified',
		'7'		=> 'Context',
	],

	'PreviousEdit'				=> '前次修改',
	'NextEdit'					=> '下次修改',

	'Diff'						=> '差異',
	'PreviousVersion'			=> '修訂',
	'LatestVersion'				=> '最新修訂',
	'NextVersion'				=> '下一修訂',

	'ShowDifferencesButton'		=> '檢視差異',
	'CancelReturnButton'		=> '取消並返回頁面',
	'Comparison'				=> 'Difference between revisions for %1',
	'RevisionAsOf'				=> 'Revision %1 as of',
	'SimpleDiffAdditions'		=> '新增內容：',
	'SimpleDiffDeletions'		=> '刪除內容：',
	'NoDifferences'				=> '两版本之间没有差异..',
	'ReEditOldRevision'			=> '重新編輯這個舊版本',

	'ExternalPages'				=> 'External pages linking to %1 (%2) (<a href="%3">see list of domains</a>):',
	'ExternalPagesGlobal'		=> 'Sites linking to this WackoWiki (%2) (<a href="%1">see list of domains</a>):',
	'Last24Hours'				=> 'last 24 hours',
	'LastDays'					=> 'last %1 days',
	'DomainsSitesPages'			=> 'Domains/sites pages linking to  %1 (%2)  (<a href="%3">see list of different URLs</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domains/sites linking to this WackoWiki (<a href="%1">see list of different URLs</a>):',
	'ViewReferrersPage'			=> 'to page',
	'ViewReferrersPerPage'		=> 'per page',
	'ViewReferrersByTime'		=> 'by time',
	'ViewReferrersGlobal'		=> '全域',
	'NoneReferrers'				=> '無',
	'NotOwnerCantDelete'		=> 'You aren\'t owner of this page and can\'t delete it',

	// remove
	'RemovePage'				=> '刪除頁面',
	'RemoveRevision'			=> 'Remove revision',
	'RemoveComment'				=> '刪除回應',
	'RemoveCluster'				=> 'Remove all pages of the cluster',
	'RemoveDontKeep'			=> 'Do not save a copy of a removed page and comments',
	'RemoveDontKeepPurge'		=> 'Do not save a copy of the removed files, revisions and comments',
	'RemoveDontKeepRevision'	=> 'Do not save a copy of the removed revision',
	'RemoveDontKeepComment'		=> 'Do not save a copy of the removed comment',
	'RemoveDontKeepFile'		=> 'Do not save a copy of the removed file',
	'ReferrersRemoved'			=> 'Referrers removed.',
	'LinksRemoved'				=> 'Links removed.',
	'CategoriesRemoved'			=> 'Pages categories deleted.',
	'AclsRemoved'				=> 'Page acls removed.',
	'BookmarksRemoved'			=> 'Bookmarks removed.',
	'WatchesRemoved'			=> 'Watches removed.',
	'CommentsRemoved'			=> 'Comments from page removed.',
	'FilesRemoved'				=> 'Files from page removed.',
	'PageRemoved'				=> 'Page removed.',
	'PageCachePurged'			=> 'Cache purged.',
	'ClusterRemoved'			=> 'All pages of the cluster removed.',
	'RevisionRemoved'			=> 'Revision %1 removed.',
	'RevisionsRemoved'			=> 'Revisions removed.',
	'ActionHaveNoUndo'			=> '這個動作無法被復原。',

	// restore
	'PageRestored'				=> 'Page restored.',
	'RevisionRestored'			=> 'Revision restored.',
	'LocalFilesRestored'		=> 'Local files restored.',

	'PrintVersion'				=> 'Print version',
	'PrintText'					=> '列印',
	'LinkedPages'				=> 'Linked pages:',
	'NoLinkedPages'				=> 'There are no linked pages',
	'ReferringPages'			=> 'Referring pages:',
	'NoReferringPages'			=> 'There are no referring pages',
	'Footnotes'					=> 'Footnotes:',
	'Footnote'					=> 'Footnote',
	'MostPopularPages'			=> '被最多人檢查的頁面',
	'MostCommentedPages'		=> 'Most commented pages',
	'NoAccessToSourcePage'		=> 'You aren\'t allowed to read action source page.',
	'SourcePageDoesntExist'		=> 'Action source page doesn\'t exist yet',
	'NotLoggedInThusEdited'		=> '因為您尚未登入,所以無法得知您曾經編輯過的頁面。',
	'DidntEditAnyPage'			=> '您尚未編輯任何頁面。',
	'NoPagesFound'				=> '沒有頁面發現。',
	'MyChangesTitle1'			=> 'This is the list of pages you\'ve edited, ordered by the time of your last change',
	'MyChangesTitle2'			=> 'This is the list of pages you\'ve edited, along with the time of your last change',
	'OrderABC'					=> 'alphabetically',
	'OrderCreation'				=> '依日期',
	'OrderChange'				=> 'by change',
	'ListOwnedPages'			=> 'This is the list of pages you own (ordered alphabetically)',
	'ListOwnedPages2'			=> 'This is the list of pages you own (ordered by date)',
	'ListOwnedPages3'			=> 'This is the list of pages you own (ordered by change)',
	'NotLoggedInThusOwned'		=> '因為您尚未登入,所以無法得知您擁有的頁面。',
	'NoOrphaned'				=> '沒有頁面被孤立,好極了！',
	'NoRecentComments'			=> 'No recent comments.',
	'LatestCommentBy'			=> 'latest comment by',
	'NoRecentlyCommented'		=> '沒有最近評論的頁面。',
	'NoDeletedPages'			=> 'No deleted pages found.',
	'NoDeletedRevisions'		=> 'No deleted revisions found.',
	'NoDeletedFiles'			=> 'No deleted files found.',
	'CommentsDisabled'			=> 'Comments are not available.',

	'SearchResults'				=> '搜尋 的結果 ',
	'NotFound'					=> 'not found',
	'NoResultsFor'				=> 'No results for ',
	'SearchFor'					=> '搜尋：',
	'TopicSearchResults'		=> 'Topics search results for ',
	'NotFoundInTopics'			=> 'not found in topics',
	'FilterLangNotAvailable'	=> 'The selected language is not available!',
	'SearchInPages'				=> '在頁面內容中搜尋',
	'SearchInComments'			=> '在評論中搜尋',
	'SearchInPageTitles'		=> '在頁面標題中搜尋',
	'SearchInNoOption'			=> '您必須至少選擇其中一個搜尋選項。',

	'PostedBy'					=> 'posted by',
	'ThisIsCommentOn'			=> 'This is a comment on',
	'At'						=> 'at',
	'To'						=> 'to',
	'By'						=> '由',
	'From'						=> 'from',
	'For'						=> 'for',
	'ReturnToCommented'			=> 'Return to commented page',
	'AbandonedComment'			=> 'The page to which this comment belongs no longer exists!',

	'PagesLinkingTo'			=> '以下頁面連接到',
	'NoPageLinkingTo'			=> '沒有頁面連接到',
	'NoWantedPages'				=> '呵呵，沒有等待建立的頁面！',
	'RemoveWatch'				=> '停止監視',
	'SetWatch'					=> '監視此頁面',
	'WatchText'					=> '監視',
	'UnwatchText'				=> '取消監視',
	'UserSettingsStored'		=> 'User settings saved.',
	'LoggedOut'					=> '您已經成功註銷.',
	'LoggedOutAuto'				=> '為安全起見，您的會話已結束。 請重新登錄。',

	// user settings
	'EmailConfirmResent'		=> 'Email confirmation code resent to your address.',
	'EmailConfirmNotSent'		=> 'Unable to send the confirmation code: email is not specified!',
	'Hello'						=> '你好',
	'UserName'					=> '使用者名稱',
	'EmailAddress'				=> '電子郵件地址',
	'RealName'					=> '姓名',
	'MenuItemsShown'			=> 'Menu items shown',
	'RecordsPerPage'			=> 'Records per page',
	'DoShowComments'			=> '預設顯示留言板',
	'DoubleclickEditing'		=> '雙擊頁面進行編輯',
	'UpdateSettingsButton'		=> '更新設置',

	'AccountDisabled'			=> 'Your account may be disabled or blocked.',
	'WrongPassword'				=> '密碼錯誤！',
	'ConfirmPassword'			=> '確認密碼',
	'Email'						=> '電子郵件地址',
	'MustBeWikiName'			=> '用戶名必須符合 <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> 格式！',
	'SpecifyEmail'				=> '您必須提供您的電子郵件地址。',
	'NotAEmail'					=> '您的郵件地址也許不是有效的。',
	'EmailTaken'				=> 'The entered email address is already in use.',
	'EmailDomainNotAllowed'		=> 'The entered email address %1 is not in allowed domains list.',
	'PasswordsDidntMatch'		=> '您輸入的密碼和確認密碼不一致。',
	'SpacesArentAllowed'		=> '密碼中不允許有空格。',
	'ListMyPages'				=> 'List your pages',
	'ListMyChanges'				=> 'List your changes',
	'ListMyWatches'				=> 'List of watched pages',
	'ListMyChangesWatches'		=> 'Changes among watched pages',
	'SeeListOfPages'			=> 'See a list of pages you own (MyPages) and pages you\'ve edited (MyChanges).',
	'AddBookmark'				=> 'Add current page to bookmarks',
	'RemoveBookmark'			=> 'Remove from bookmarks',

	'YourLanguage'				=> '選擇語言',
	'ShowSpaces'				=> 'Show spaces in WikiNames',
	'WrongPage4Redirect'		=> 'Cannot redirect because of wrong redirect parameter',
	'RedirectsToItself'			=> 'The page redirects to itself.',
	'ReallyDeletePage'			=> 'Do you really want to DELETE this page?<br>There is no undo for this action!<br><br>WARNING: Deleting this page will delete all page versions, comments, attachments, ACLs and referrers.',
	'CommentForWatchedPage'		=> 'New comment for page ',
	'SomeoneCommented'			=> ' commented this page that you are watching: ',
	'AlertReferringPages'		=> 'This page is referred to by these pages',

	'AccountDelete'				=> 'Delete account',
	'AccountDeleteConfirm'		=> 'Are you sure you want to delete the account?',
	'AccountDeleted'			=> 'Account successfully deleted',
	'AccountDeleteHeader'		=> 'Delete account %1',
	'AccountDeleteInfo'			=> 'Of the data you created (e.g. email, preferences, attachments, wiki entries) as much as possible will be deleted. Note, however, that data like attachments and wiki entries cannot be deleted without impeding the work of the other users. Such data is hence reassigned to an account called %1. As the data of every deleted account is reassigned to this account it will not be possible to distinguish the data you created from the data of another deleted account.',
	'AccountDeleteWarning'		=> 'Deleting the user account is an irreversible action.',
	'AccountDeleteHint'			=> 'Your account will be deleted from the system. Therefore, you will no longer be able to log in with your current credentials. If you choose to become a user of this application again, you can do so by using the means this application grants.',
	'AccountDeleteVerify'		=> 'Enter your login %1 to verify the deletion. Once submitted, you will be asked to confirm your password.',

	'MarkRead'					=> '標示全部為已閱讀',
	'CurrentTime'				=> 'It is currently',
	'Created'					=> '已建立',
	'Modified'					=> '修改時間',

	'EditIcon'					=> '編輯',
	'TreeClusterTitle'			=> 'Tree of cluster %1',
	'TreeSiteTitle'				=> 'Site tree',
	'TreeEmpty'					=> '%1 has no subpages',
	'TreeEmptyLevels'			=> '%1 has no subpages for given levels of depth. Increase the value for depth.',
	'TreeTooBig'				=> 'too many subpages',

	// clone handler
	'ClonePage'					=> 'Clone page',
	'CloneText'					=> '重製',
	'CloneName'					=> 'Enter new name for a clone of this page',
	'CloneButton'				=> '重製',
	'PageCloned'				=> 'Page %1 cloned.',
	'ClonedFrom'				=> 'Cloned from %1.',
	'MassClone'					=> 'Clone entire cluster',
	'MassCloning'				=> 'Cloning cluster.',
	'CloneCannotRead'			=> 'Unreadable page %1.',
	'CloneCannotCreate'			=> 'Uncreatable page %1.',

	'CommentOffset'				=> 'Comments page',
	'CommentOffsetFirst'		=> '第一頁',
	'CommentOffsetLast'			=> '最末頁',
	'SortComment'				=> 'Sort comments by',
	'SortCommentAsc'			=> 'Most recent on bottom',
	'SortCommentDesc'			=> 'Most recent on top',

	'RenamePage'				=> '重命名該頁',
	'RenameText'				=> '重命名',
	'RenameTip'					=> '重命名該頁',
	'NewName'					=> 'Enter new name for this page',
	'AlreadyExists'				=> 'Page %1 already exists.',
	'AlreadyNamed'				=> 'This page already named %1.',
	'PageRenamed'				=> 'Page renamed.',
	'NewNameOfPage'				=> 'New name of this page: ',
	'NotOwnerCantRename'		=> 'You aren\'t owner of this page and hence can\'t rename it',
	'NeedRedirect'				=> 'Create redirect to the new page on the old page',
	'RedirectCreated'			=> 'In the page %1 created redirect to the new one',

	'UserSettings'				=> '使用者設定',
	'UserSettingsGeneral'		=> '一般',
	'UserSettingsNotifications'	=> '通知',

	'NotifyMinorEdit'			=> 'Notify also minor edit',
	'NotifyPageEdit'			=> '編輯',
	'NotifyComment'				=> '評論',
	'NotifyOff'					=> '關閉',
	'NotifyAlways'				=> '總是',
	'NotifyPending'				=> 'Pending',
	'NotifyDigest'				=> 'Digest',
	'NotifyPendingPageTip'		=> 'Only one notification is sent for the first page change of a page you are watching.',
	'NotifyPendingCommentTip'	=> 'Only one notification is sent for the first comment to a page you are watching.',
	'NotifyPendingTip'			=> 'Notification is automatically re-enabled when you visit the current version of the page.',

	'FurtherPending'			=> 'There will be no other notifications in case of further changes unless you visit this page.',

	'UserSettingsEmailMe'		=> '接收电子邮件提醒 ...',

	'UserSettingsExtended'		=> '扩展',
	'UserSettingsOther'			=> 'Other settings',
	'UserSpace'					=> 'User space',
	'ChooseTheme'				=> '主题',

	'CreatePage'				=> '創建此頁面',
	'CreateNewPage'				=> '創建一個新頁面',
	'CreateNewPageText'			=> '建立',
	'CreateNewPageTip'			=> '創建一個新頁面',

	'CreateRandomPage'			=> 'Create a random page：',
	'CreateSubPage'				=> 'Create a sub page in the cluster：',
	'CreatePageParentCluster'	=> 'Create a page in the parent cluster：',
	'CreatePageDenied'			=> 'You do not have the necessary access rights.',
	'CreatePageDeniedAddress'	=> 'You do not have the right to create the page at this address.',
	'PageAlreadyExists'			=> 'According to the address provided the page %1 already exists.',
	'PageAlreadyExistsEdit'		=> 'Do you want %1 it?',
	'PageAlreadyExistsEdit2'	=> '編輯',
	'PageAlreadyExistsEditDenied'	=> 'You can\'t edit it.',

	'SimilarPagesExists'		=> 'Similar pages to %1 already exists:',
	'SimilarPagesHint'			=> 'There are existing similar pages to %1:',

	'PageReservedWord'			=> 'You can\'t use %1 as the part of the address as it\'s a reserved word.',
	'PageReservedNamespace'		=> '您無法將 %1 用作地址的起始部分，因為它是保留的命名空間。',
	'UserReservedWord'			=> 'User names cannot contain %1 as it\'s a reserved word.',

	'DontRedirect'				=> 'Do not allow automatic redirection by action Redirect.',
	'SendWatchEmail'			=> 'Send notifying email when someone (except you) changes any page you are watching',
	'AllowIntercom'				=> 'Allow personal messages from users of the system',
	'AllowMassemail'			=> 'Administrators can email me information',
	'HideLastSession'			=> 'Hide last session',
	'ValidateIP'				=> 'Tying session to IP',
	'AnonymousPub'				=> 'Preferably, published anonymously (to hide the name)',
	'PageMoved'					=> 'This page moved. You can find it at',
	'RedirectedFrom'			=> '重新導向自%1',
	'RedirectedTo'				=> '重新導向至',
	'CurrentPassword'			=> '現有密碼',
	'NewPassword'				=> '新密碼',
	'YouWantChangePassword'		=> '更改密碼',
	'ChangePasswordButton'		=> '更改密碼',
	'PasswordChanged'			=> '密碼已變更',
	'EmailWelcome'				=> 'You\'ve registered at ',
	'EmailRegistered'			=> 'You\'ve successfully registered at %1.' . "\n" . 'Your username: %2' . "\n\n",
	'EmailVerify'				=> 'If you want to receive notifications, you must verify your email address. Please click on or copy the following link to a web browser: ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Please return to the Wiki and login with your new username and password.',
	'EmailRegisteredIgnore'		=> 'If you did not request this registration, ignore this message and nothing will happen.',
	'EmailDoNotReply'			=> 'Do not reply to this message.',
	'EmailReverify'				=> 'Someone (maybe you) submitted your email as notification address at %1.' . "\n" . 'Your username: %2'."\n\n" . 'If you want to receive notifications, you need to approve your email. Please follow the link to do this.' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> '請驗證您的電子郵件',
	'EmailConfirmed'			=> '電子郵件已成功確認。',
	'EmailNotConfirmed'			=> 'Email cannot be confirmed. This may be due to an incorrect confirmation code or the email address may already be confirmed. You can check if the email address is already confirmed by logging in and viewing its status on your %1 page.',
	'EmailNotVerified'			=> '電子郵件未驗證！',
	'EmailNotVerifiedDesc'		=> 'You will not receive notification of changes or comments of watched pages, ' .
									'or messages from other users. Also, you <strong>will not be able to recover a forgotten password</strong>, ' .
									'until your email address is confirmed by following the link in the email sent to you. ' .
									'If, within days after registration you do not receive an email, ask for it again by clicking ',

	'ForgotPasswordHint'		=> 'Enter your login and email address,' . "\n" . 'then an email with instructions will be send to you.',
	'ForgotPassword'			=> '忘记密码？',
	'UserNotFound'				=> 'User with this name or email address was not found.',
	'NotConfirmedEmail'			=> 'Your email address is not confirmed.<br>Mail can\'t be send to a non-confirmed address.',
	'EmailForgotSubject'		=> 'Password renewal for ',
	'EmailForgotMessage'		=> 'Someone (maybe you) forgot your password for %1.' . "\n" . 'Your login: %2'."\n\n" . 'Click the link or copy it to the browser address line to change your password.' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> 'Password recovery instruction was sent to you by email.',
	'WrongCode'					=> 'Wrong code',
	'ChangePasswordForUser'		=> '%1\'s password change',

	'Watchers'					=> 'List of watchers for %1',
	'WatchersFor'				=> 'Watchers for',
	'NoWatchers'				=> 'There are no watchers for %1',
	'NotOwnerToViewWatchers'	=> 'You are not the owner of this page and you can\'t see list of watchers for it.',

	// thumbnail
	'TbnError'					=> '建立縮圖錯誤：%1',
	'TbnImageAreaTooBig'		=> '檔案的尺寸超過 %1',
	'TbnImageMissing'			=> '檔案遺失：%1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Generate the password hash for your <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Import in cluster:',
	'ImportWhat'				=> 'XML file to import:',
	'ImportButton'				=> '匯入',
	'ImportSuccess'				=> 'Imported successfully.',
	'ImportFailed'				=> 'IMPORT failed.',
	'ImportHint'				=> 'Please provide a cluster you want to import to, no relative addressing.',
	'ImportAttention'			=> 'Attention: Overwrites the same pages in the cluster.',
	'ImportNote'				=> 'Imported page',

	// mywatches action
	'WatchedPages'				=> 'List of all pages you follow for changes ',
	'UnwatchedPages'			=> 'List of all pages you do not watch',
	'NoWatchedPages'			=> 'You have no watched pages.',
	'NoUnwatchedPages'			=> 'You watch for changes in all pages.',
	'ViewWatchedPages'			=> 'Show watched pages',
	'ViewUnwatchedPages'		=> 'Show unwatched page',
	'NotLoggedInWatches'		=> 'You are not logged in, hence we couldn\'t identify your list of watches.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'List of all pages you watched that were edited by others since your last editing',
	'ResetChangesWatches'		=> 'reset the list of changes',
	'NoChangesWatches'			=> 'Among your watched pages are no changes...',

	// whatsnew action
	'NewCommentAdded'			=> 'Added new comment',
	'NewFileAdded'				=> 'Added new file',
	'NewPageCreated'			=> 'Created a new page',
	'NewRevisionAdded'			=> 'Changed page',
	'Cluster'					=> 'cluster',
	'PageDeleted'				=> 'Page deleted',
	'CommentDeleted'			=> 'Comment deleted',
	'FileDeleted'				=> 'File deleted',

	// users action
	'UsersSearch'				=> 'Find Users',
	'UsersOpenProfile'			=> '檢視使用者資訊',
	'UsersNoMatching'			=> 'Matching users not found. Try a less strict search criteria.',
	'UsersName'					=> '名稱',
	'UsersPages'				=> '頁面',
	'UsersChanges'				=> '變動',
	'UsersSubscription'			=> 'Subscription',
	'UsersWatches'				=> 'Watches',
	'UsersComments'				=> '回應',
	'UsersUploads'				=> '上傳',
	'UploadQuota'				=> 'Used space',
	'UploadQuotaTip'			=> 'Upload Space Quota',
	'UsersLogins'				=> 'Logins',
	'UsersRevisions'			=> '次修改',
	'UsersSignup'				=> '註冊',
	'UsersLastSession'			=> '上屆會議',
	'UsersNotFound'				=> 'User %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'UsersProfile'				=> 'P個人資料',
	'UsersContact'				=> '聯絡',
	'UsersList'					=> 'View the entire list of users',
	'UsersNA'					=> '[not set]',
	'UsersNA2'					=> '[No]',
	'UsersSignupDate'			=> 'Signup date',
	'UsersGroupMembership'		=> 'Group membership',
	'UsersPersonalInfo'			=> 'Personal info',
	'UsersOwnedPages'			=> 'Owned pages:',
	'UsersCommentsPosted'		=> 'Comments posted:',
	'UsersFilesUploaded'		=> 'Files uploaded:',
	'UsersRevisionsMade'		=> 'Revisions made:',
	'UsersDocsSortName'			=> '[Sort by name]',
	'UsersDocsSortCreation'		=> '[Sort by creation date]',
	'UsersChangesSortAsc'		=> '[昇冪排序]',
	'UsersChangesSortDesc'		=> '[降冪排序]',
	'UsersSessionNA'			=> '[not recorded]',
	'UsersSessionHidden'		=> '[隱藏]',
	'IntercomSubject'			=> '標題：',
	'IntercomMessage'			=> '訊息：',
	'IntercomCopy'				=> '給我發一份',
	'IntercomSubjectN'			=> '[start a new topic]',
	'IntercomDisabled'			=> 'Sorry, you do not want or cannot receive personal messages.',
	'IntercomHint'				=> 'Please log in first and follow the link again, if you want to answer the personal message you have received.',
	'IntercomDesc'				=> 'Note: Sending personal messages carried on the email recipient without disclosing your address. The recipient will be able to respond to you, using a similar form on your profile page. ',
	'PMOversized'				=> 'The length of the message exceeds the maximum allowed size by %1. Please shorten your message and submit again.',
	'PMFlooded'					=> 'The interval between sending personal messages should not be less than %1 seconds.',
	'PMSent'					=> 'Personal message was successfully sent to the user.',
	'PMBody'					=> 'This message has been sent to you by the user %1.',
	'PMBodyCopy'				=> '您向用戶 %1 發送了以下消息。',
	'PMReply'					=> 'To answer this email, click on the following link (do not use the Reply button / Reply in mailer):',
	'PMNotLoggedIn'				=> 'You are not registered in the system and cannot send personal messages to users.',

	// admin_replace action
	'ReplaceText'				=> '取代文字',
	'TextOriginal'				=> '原始文字：',
	'TextReplacement'			=> '取代文字：',
	'ReplaceTextRegex'			=> '使用正則表示法',
	'Namespace'					=> '命名空間：',
	'ReplaceTextCluster'		=> '僅在此集群內搜索和替換：',
	'ReplaceTextEditPages'		=> '取代頁面內容中的文字',
	'ReplaceTextEditComments'	=> '替換評論中的文字',
	'ReplaceTextEditTitles'		=> '取代頁面標題的文字',
	'ReplaceTextGiveTarget'		=> '您必須指定要被取代的字串。',
	'ReplaceTextNoNamespace'	=> '您至少要選擇一個命名空間。',
	'ReplaceTextNoDifference'	=> '替換文本和目標文本之間沒有區別。',
	'ReplaceTextNoOption'		=> '您至少要勾選一個取代選項。',
	'ReplaceTextPagesEdit'		=> '將下列%3 個頁面內容中的 %1 取代為 %2：',
	'ReplaceTextTitlesEdit'		=> '在以下 %3 頁的標題中將 %1 替換為 %2:',
	'ReplaceTextReplace'		=> '取代',
	'ReplaceTextSuccess'		=> '%3 個頁面中的 %1 將會被取代為 %2。',
	'ReplaceTextNoMatch'		=> '沒有任何頁面內容包含字串 %1。',
	'ReplaceTextNoTitleMatch'	=> '沒有任何頁面標題包含字串 %1。',
	'ReplaceTextEditFailed'		=> '替換文本失敗',
	'ReplaceTextTitleTooBig'	=> '原始文本或替換文本對於標題而言太大。',
	'ReplaceTextReturn'			=> '返回表單',
	'ReplaceTextWarning'		=> '警告：目前已有 %1 個頁面包含取代的字串 %$2，若您進行取代將無法區別原本存在的字串以及取代的字串。',
	'ReplaceTextBlankWarning'	=> '警告：因取代的字串為空白，此操作將無法還原。',
	'ReplaceTextEditSummary'	=> '文字取代： %1 → %2',
	'InvertSelection'			=> '反向選擇',

	// Properties
	'PropertiesFor'				=> 'Page properties for %1',
	'MetaTag'					=> '標籤',
	'MetaTitle'					=> '標題',
	'MetaKeywords'				=> '關鍵字',
	'MetaDescription'			=> '說明',
	'On'						=> '開啟',
	'Off'						=> '關閉',
	'Registered'				=> '已註冊',
	'MetaComments'				=> 'Show comments',
	'MetaFiles'					=> 'Show files panel',
	'MetaToc'					=> 'Show table of contents',
	'MetaIndex'					=> 'Show cluster section panel',
	'MetaIndexMode'				=> 'Show Level Mode',
	'MetaIndexFull'				=> 'Tree',
	'MetaIndexUpper'			=> 'Upper',
	'MetaIndexLower'			=> 'Lower',
	'MetaHtml'					=> 'HTML support for page',
	'MetaSafeHtml'				=> 'Filtering of unsafe HTML',
	'MetaTypografica'			=> 'Typographical Proofreader',
	'MetaNoIndex'				=> 'Block search engines',
	'SettingsID'				=> '頁面ID',
	'SettingsSize'				=> '大小',
	'SettingsSizeTip'			=> 'source / compiled',
	'SettingsCreated'			=> '已建立',
	'SettingsCurrent'			=> '修改時間',
	'SettingsTotalRevs'			=> '次修改',
	'SettingsTotalComs'			=> '回應',
	'SettingsWatchers'			=> 'Watchers',
	'SettingsHits'				=> '檢視',
	'SettingsText'				=> '設定',
	'SettingsEdit'				=> '編輯',
	'SettingsRevisions'			=> '次修改',
	'SettingsClone'				=> '重製',
	'SettingsRename'			=> '重命名',
	'MassRename'				=> 'for entire cluster',
	'SettingsRemove'			=> '移除',
	'SettingsPurge'				=> 'Purge',
	'SettingsModerate'			=> '管理',
	'SettingsPermissions'		=> '權限',
	'AclForEntireCluster'		=> 'for entire cluster',
	'SettingsAttachments'		=> '附加檔案',
	'SettingsUpload'			=> '上傳',
	'SettingsCategories'		=> '分類目錄',
	'SettingsLanguages'			=> '語言',
	'SettingsReferrers'			=> '來源',
	'SettingsWatch'				=> '監視',
	'SettingsLatex'				=> 'LaTeX version',
	'SettingsXML'				=> 'Export to XML',
	'NeedToChangeLang'			=> 'Unsupported page language %1 needs to be changed.',
	'SetLang'					=> '本頁語言',
	'SetMenuLabel'				=> 'Menu label',
	'SetShowMenuLabel'			=> 'Show in navigation',

	// upload
	'UploadFiles'				=> '上傳檔案',
	'UploadFor'					=> '檔案上傳：',
	'UploadButton'				=> '上傳',
	'UploadGlobalText'			=> 'for public access',
	'UploadGlobal'				=> '全域',
	'UploadLocalText'			=> '僅適用於被允許檢視目前頁面的使用者',
	'UploadAsName'				=> '名稱：',
	'UploadOverwrite'			=> '覆蓋已存在的檔案',
	'FileDesc'					=> '說明：',
	'UploadForbidden'			=> 'You are not allowed to upload files here.',
	'UploadOverwriteDenied'		=> '只有文件所有者或管理員可以覆蓋 %1 文件。',
	'UploadNoFile'				=> 'There was no file in form, for some reason.',
	'UploadMaxSizeReached'		=> 'File size is over allowed limit!',
	'UploadDirNotWritable'		=> 'File directory is not writable!',
	'UploadNotAPicture'			=> 'Picture uploads only are allowed. What are you trying to upload?',
	'UploadEmptyExtension'		=> '文件名和擴展名不能為空。',
	'FilenameTooLong'			=> '檔案名稱不可超過 240 個位元組。',
	'BannedFiletype'			=> '不允許使用檔案類型 %1。',
	'PermittedFiletype'			=> '允許的檔案類型：',
	'UploadMimeMismatch'		=> '檔案副檔名 %1 不符合偵測到的檔案 MIME 類型 (%2)。',
	'UploadBadMime'				=> '不允許上傳 MIME 類型為 %1 的檔案。',
	'FileIsDuplicate'			=> '上傳的檔案與目前版本的完全相同。',
	'FileHasDuplicate'			=> '此檔案與下列多個檔案重複：',

	'UploadMaxFileQuota'		=> 'You have reached your upload limit. This file can not be uploaded',
	'UploadDone'				=> 'File upload successful',
	'UploadFileForbidden'		=> 'File access prohibited',
	'UploadTitle'				=> 'Files accessible from this page',
	'UploadTitleGlobal'			=> 'Files accessible from anywhere',

	'UploadFile'				=> '上傳',
	'UploadMax'					=> 'No more than ',
	'UploadUsedStorage'			=> 'Storage in use ',

	// attachments
	'Attachments'				=> '附加檔案',
	'Attachment'				=> '附加檔案',
	'AttachmentsToPage'			=> 'to page',
	'AttachmentsToCluster'		=> 'cluster',
	'AttachmentsByTime'			=> 'by time',
	'AttachmentsGlobal'			=> '全域',
	'AttachmentsAll'			=> '所有',
	'AttachmentsLinked'			=> 'used',

	'FileViewProperties'		=> '檢視',
	'FileViewPropertiesTip'		=> 'View the metadata of this file',
	'FileEditProperties'		=> '編輯',
	'FileEditPropertiesTip'		=> 'Edit the metadata of this file',
	'FileEditedMeta'			=> 'Updated metadata of this file',
	'FileEditDenied'			=> 'You are not allowed to edit this file',
	'FileLabel'					=> '標籤',
	'FileLabelTip'				=> 'Label this file',
	'FileRemove'				=> '移除',
	'FileRemovedFromDB'			=> 'File removed from database',
	'FileRemovedFromFS'			=> 'File erased from physical hosting',
	'FileRemovedFromFSError'	=> 'It seems to be impossible to erase file!',
	'FileRemoveConfirm'			=> 'Sure to remove this file?',
	'FileRemoveDenied'			=> 'You are not allowed to remove this file',
	'FileNotFound'				=> 'File not found.',

	'FileSearch'				=> 'Find File:',
	'UploadBy'					=> 'Uploaded by:',
	'FileAdded'					=> 'Added:',
	'FileModified'				=> '修改時間：',
	'FileSize'					=> '大小：',
	'FileDimension'				=> '尺寸：',
	'MimeType'					=> 'Mime 類型：',
	'FileName'					=> '名稱：',
	'FileCaption'				=> '標題：',
	'FileAuthor'				=> '作者：',
	'FileSource'				=> '來源：',
	'FileSourceUrl'				=> 'URL：',
	'FileAttachedTo'			=> 'Attached to:',
	'FileSyntax'				=> '句法：',
	'FileAbsolutePath'			=> '絕對路徑',
	'FileRelativePath'			=> '相對路徑',
	'FileUsage'					=> '檔案用途：',
	'FileUsageText'				=> '以下个页面使用本文件：',
	'NoFileUsage'				=> 'No pages link to this file.',

	'FileSortExt'				=> 'extension',
	'FileSortName'				=> '名稱',
	'FileSortSize'				=> '大小',
	'FileSortTime'				=> '已建立',

	'SortBy'					=> 'Sort by',
	'Ascending'					=> 'ascending',
	'Decending'					=> 'decending',

	'Files0'					=> 'Attach Files',
	'Files1'					=> '顯示文件（1個文件）',
	'FilesN'					=> '顯示文件（%1個文件）',
	'Files'						=> '檔案',
	'File'						=> '檔案',
	'ShowFiles'					=> 'Display files / form',
	'HideFiles'					=> 'Hide files / form',
	'DoShowFiles'				=> 'Show files lists by default',
	'NoAttachments'				=> '没有要显示的附件。',

	'RegistrationLang'			=> '你的語言',
	'InvalidWikiName'			=> 'Chosen name is invalid',
	'InvalidUserName'			=> 'Chosen user name is invalid',
	'Bookmarks'					=> '最愛',
	'ReallyDeleteComment'		=> 'Do you really want to DELETE this comment?<br>There is no undo for this action!',
	'ReallyDeleteRevision'		=> 'Do you really want to DELETE this revision?<br>There is no undo for this action!',

	'RegistrationClosed'		=> '目前不開放註冊新使用者。 Try to contact site administrator.',
	'AclAreYouSure'				=> 'You are going to change ACLs of this page and all of its subpages. Continue?',

	'BookmarkDeleteSelected'	=> '刪除所選的',
	'BookmarkMark'				=> '標示',
	'BookmarkNumber'			=> 'No.',
	'BookmarkNone'				=> '您没有收藏.',
	'BookmarkTitle'				=> 'Bookmark title',
	'BookmarkPage'				=> '頁面',
	'BookmarkSaveChanges'		=> 'Save changes',
	'BookmarksAddPage'			=> 'Set a bookmark for the following page',
	'BookmarkAlreadyExists'		=> 'The bookmark already exists.',

	'PoweredBy'					=> '建構於',

	'MassRenaming'				=> 'Rename entire cluster',
	'MassNewName'				=> 'Enter new name for this cluster',
	'MassNeedRedirect'			=> 'Create redirect to the new pages on the old pages',

	// pagination
	'ToOverview'				=> '返回總覽',
	'Overview'					=> 'Overview',
	'ToThePage'					=> 'To page：',
	'Next'						=> '下一頁',
	'Prev'						=> '上一頁',
	'NextAcr'					=> '下一頁',
	'PrevAcr'					=> '上一頁',
	'Back'						=> '返回',

	// filter
	'Filter'					=> '篩選器',
	'OptionalFilters'			=> '過濾條件選項：',
	'Any'						=> 'Any',

	// My Groups
	'UserGroups'				=> 'Groups of users',
	'MyGroups'					=> 'Group Associations',
	'Group'						=> '群組',
	'Groups'					=> '群組',

	// license action
	'DistributedUnder'			=> 'Material is distributed under',
	'AuthorsDisplayHint'		=> 'The list of authors will be displayed when saving the page.',
	'AnonymousUsers'			=> 'Anonymous users',
	'License'					=> 'License',
	'LicenseArray'				=> [
		'1'		=> 'Attribution-NoDerivatives',
		'2'		=> 'Attribution-NonCommercial-ShareAlike',
		'3'		=> 'Attribution-NonCommercial-NoDerivatives',
		'4'		=> 'Attribution-ShareAlike',
		'5'		=> 'Attribution-NonCommercial',
		'6'		=> 'Attribution',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation License',
		'9'		=> '公有領域',
		'10'	=> '版權所有 不得轉載',
	],
	'LicenseMeta'				=> [
		'1'		=> '公共網域',
		'2'		=> '保留部分權利',
		'3'		=> '版權所有 不得轉載',
	],

	// Cache
	'ClearCache'				=> '清除快取',
	'CacheCleared'				=> 'Cache cleared.',
	'ConfigCache'				=> 'Config cache',
	'FeedCache'					=> 'Feed cache',
	'PageCache'					=> 'Page cache',
	'SQLCache'					=> 'SQL cache',
	'TemplateCache'				=> 'Template cache',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Please specify a address of the resource with the Parameter URL. (e.g. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Feed Title',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Please specify a Feed with the Parameter URL. (e.g. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Could not load or parse feed',
	'FeedSource'				=> '來源:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - 近期變動',
	'ChangesXML'				=> 'Recent changes to the ',
	'CommentsXMLTitle'			=> ' - 最近的評論',
	'CommentsXML'				=> 'Recent comments to the ',
	'NewsXMLTitle'				=> ' - 最近的新聞',
	'NewsXML'					=> 'Recent news to the ',
	'RevisionXMLTip'			=> 'Click to view recent page revisions in XML format.',
	'CommentsXMLTip'			=> 'Click to view recent comments in XML format.',
	'ChangesXMLTip'				=> 'Click to view recent changes in XML format.',
	'NewsXMLTip'				=> 'Click to view recent news in XML format.',
	'RevisionsXML'				=> 'Revisions of ',
	'ExportClusterXML'			=> 'Export of entire cluster of ',
	'AccessDeniedXML'			=> 'You\'re not allowed to access this information.',

	'ChangesFeed'				=> '變動',
	'CommentsFeed'				=> '回應',
	'NewsFeed'					=> '新聞動態',
	'RevisionsFeed'				=> 'Revisions of ',

	'LastModification'			=> 'Last Modification',

	// Captcha
	'Captcha'					=> '请输入您在图片中看见的文字',
	'CaptchaFailed'				=> 'You have entered the captcha word incorrectly. Please try again.',
	'CaptchaReload'				=> 'New Captcha',
	'CaptchaReloadWarning'		=> 'Sorry, cannot reload the captcha image, you will have to reload the page to do that',

	// news
	'News'						=> '新聞動態',
	'NewsName'					=> '標題：',
	'NewsNoName'				=> 'You forgot to add news headline.',
	'NewsNotAvailable'			=> 'No News available.',
	'NewsNoClusterDefined'		=> 'No News cluster defined.',
	'NewsDiscuss'				=> 'Discuss this article...',

	// blog
	'BlogNewTopic'				=> 'Create a new post',
	'NoPostAvailable'			=> 'No post available yet.',

	// Review
	'Reviewer'					=> 'Reviewer',
	'Reviewed'					=> 'reviewed',
	'Review'					=> 'review',
	'ReviewedBy'				=> 'reviewed by',
	'RemoveReview'				=> 'Remove review for this page',
	'SetReview'					=> 'Reviewed this page',
	'SetAsReviewed'				=> 'Set page as reviewed',
	'SetAsUnreviewed'			=> 'Set page as unreviewed',

	// word filter
	'PotentialSpam'				=> 'Identified Potential Spam',

	// moderation handler
	'Moderation'				=> 'Moderation',
	'Topics'					=> '主題',
	'ModerateSection'			=> 'section / page ',

	'NotModerator'				=> 'You do not have authority to moderate this page / chapter',
	'ModerateDeleteTopic'		=> 'Delete topic / page',
	'ModerateDeletePosts'		=> 'Delete comments',
	'ModerateMove'				=> '移動',
	'ModerateSplit'				=> 'Split / Move comments',
	'ModerateMerge'				=> 'Merge',
	'ModerateLock'				=> '锁定',
	'ModerateUnlock'			=> '解锁',
	'ModerateAccept'			=> 'Accept',
	'ModerateDeleteConfirm'		=> 'Are you sure you want to <strong>remove</strong> the following topics?',
	'ModerateRenameConfirm'		=> 'Enter a new title for the selected page',
	'ModerateRenameExists'		=> '已存在同名頁面！ 選擇一個不同的名稱。',
	'ModerateRename1Only'		=> 'Note: only the first page you selected will be renamed!',
	'ModerateMovesConfirm'		=> 'Select the target partition to move the forum to',
	'ModerateMoveConfirm'		=> 'Select the forum or specify the cluster to move these topics. To move a page to the root of the site, type &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Specify the name of the cluster in which to place the page. To move a page to the root of the site, type &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operation aborted: In this section already exists topics with the same name %1. If you still need to transfer the above-mentioned topics, please rename them first.',
	'ModerateMoveNotExists'		=> 'The page / cluster does not exist. Please check the name and try again.',
	'ModerateMergeConfirm'		=> 'Choose a topic, which should combine the remaining',
	'ModerateMerge2Min'			=> 'To join you must select at least two topics!',
	'ModerateComDelConfirm'		=> 'Are you sure you want to <strong>remove</strong> %1 %2?',
	'ModerateComment'			=> '評論',
	'ModerateComments'			=> '回應',
	'ModerateSplitNewName'		=> 'Specify a name for a separable topic and select a separation schema',
	'ModerateSplitPageName'		=> 'Enter the name of the page / topic, where to move detachable comments, and select a separation schema',
	'ModerateSplitAllAfter'		=> 'Detach all the comments after the first selected (and including)',
	'ModerateSplitSelected'		=> 'Separated only selected comments (total %1)',
	'ModerateUserProfile'		=> '個人資料',
	'ModerateNoItemChosen'		=> 'Please select at least one item via the Set button.',

	'ModerateSection2'			=> 'moderate section',
	'ModerateTopicsDeleted'		=> 'Selected topics successfully deleted.',
	'ModerateTopicsRelocated'	=> 'Selected topics successfully relocated.',
	'ModerateTopicsRenamed'		=> 'Topic successfully renamed.',
	'ModerateTopicsMerged'		=> 'Selected topics successfully merged.',
	'ModerateTopicsBlocked'		=> 'Selected topics successfully blocked',
	'ModerateTopicsUnlocked'	=> 'Selected topics successfully unlocked.',
	'ModerateTopicDeleted'		=> 'Topic has been successfully removed.',
	'ModeratePageMoved'			=> 'Page successfully moved.',
	'ModerateTopicRenamed'		=> 'Topic successfully renamed.',
	'ModerateTopicBlocked'		=> 'Topic successfully blocked',
	'ModerateTopicUnlocked'		=> 'Topic successfully unlocked.',
	'ModerateCommentsDeleted'	=> 'Selected comments removed successfully.',
	'ModerateCommentsSplit'		=> 'Selected comments successfully separated in a new topic.',
	'ModerateCommentsSplitFailed'	=> 'Note: For some reason separating the selected comments to a new topic failed.<br>Usually this should not happen, so please notify the site administrator.<br>As a precaution, the issue has been preserved in its original form.',
	'ModerateCommentsMoved'		=> 'Selected comments successfully migrated to the given page.',

	// forum
	'ForumSubforums'			=> '討論區',
	'ForumTopic'				=> '主題',
	'ForumTopics'				=> '主題',
	'ForumPosts'				=> '文章',
	'ForumReplies'				=> '回覆',
	'ForumAuthor'				=> '作者',
	'ForumViews'				=> '檢視',
	'ForumCreated'				=> '已建立',
	'ForumComments'				=> '回應',
	'ForumLastComment'			=> '最新回應',
	'ForumNoComments'			=> '沒有最新的評論。',
	'ForumNoTopics'				=> '這個版面還沒有主題或文章。',
	'ForumNewTopic'				=> 'Start a new discussion',
	'ForumTopicName'			=> 'Topic name：',
	'ForumTopicSubmit'			=> 'Submit topic',
	'ForumNoTopicName'			=> 'Specify a name for the new page.',
	'ForumNewPosts'				=> 'new post',
	'ForumLocked'				=> 'section locked',
	'ForumUpdated'				=> '已更新',
	'ForumNoClusterDefined'		=> 'No Forum cluster defined.',
	'ForumOutsideCluster'		=> 'Ensure that the %1 action is located inside the forum cluster.',

	// password complexity
	'PwdCplxShort'				=> '密碼太短了。',
	'PwdCplxEquals'				=> 'Password contains the user name.',
	'PwdCplxWeak'				=> 'Password does not meet complexity requirements.',
	'PwdCplxDesc1'				=> '密碼要求: ',
	'PwdCplxDesc2'				=> 'password should not be less than %1 characters',
	'PwdCplxDesc3'				=> 'must not contain your username',
	'PwdCplxDesc4'				=> 'should consist of ',
	'PwdCplxDesc41'				=> 'letters and numbers',
	'PwdCplxDesc42'				=> 'uppercase and lowercase letters and numbers',
	'PwdCplxDesc43'				=> 'uppercase and lowercase letters, digits and non-alphanumeric characters',
	'PwdCplxDesc5'				=> 'You can use any letters, numbers and special characters except spaces.',

	'PasswordTooShort'			=> '密碼太短了。',
	'PasswordTooCommon'			=> 'That password is too common.',
	'PasswordSameAsUsername'	=> 'Your password is the same as your username.',
	'PasswordSameAsEmail'		=> 'Your password is the same as your email.',

	'Timezone'					=> '時區',
	'DateFormat'				=> '日期格式',

	'LanguageArray'	=> [
		'ar' => 'Arabic',
		'bg' => '保加利亞語',
		'cs' => 'Czech',
		'da' => '丹麥文',
		'de' => '德語',
		'el' => '希臘語',
		'en' => '英語',
		'es' => '西班牙語',
		'et' => '愛沙尼亞語',
		'fa' => 'Persian',
		'fi' => 'Finnish',
		'fr' => '法語',
		'hi' => '印地語',
		'hu' => '匈牙利文',
		'id' => 'Indonesian',
		'it' => '意大利語',
		'ja' => '日語',
		'ko' => '韓文',
		'nl' => '荷蘭語',
		'no' => 'Norwegian',
		'pl' => '波蘭語',
		'pt' => '葡萄牙語',
		'pt-br' => 'Portuguese-Brazil',
		'ro' => 'Romainian',
		'ru' => '俄語',
		'sv' => 'Swedish',
		'ta' => 'Tamil',
		'uk' => 'Ukrainian',
		'zh' => '简体中文',
		'zh-tw' => '正體中文',
	],

	'AccountStatus'				=> 'Account status',
	'AccountStatusArray' => [
		'0' => 'active',
		'1' => 'pending',
		'2' => 'blocked',
		'3' => 'inactive',
	],

	'JustNow'		=> 'just now',
	'MinuteAgo'		=> 'a minute ago',
	'MinutesAgo'	=> '%1 minutes ago',
	'HourAgo'		=> 'an hour ago',
	'HoursAgo'		=> '%1 hours ago',
	'DayAgo'		=> 'yesterday',
	'DaysAgo'		=> '%1 days ago',
	'WeekAgo'		=> 'a week ago',
	'WeeksAgo'		=> '%1 weeks ago',
	'MonthAgo'		=> 'a month ago',
	'MonthsAgo'		=> '%1 months ago',
	'YearAgo'		=> 'a year ago',
	'YearsAgo'		=> '%1 years ago',

	'InAMoment'		=> 'in a moment',
	'InAMinute'		=> 'in a minute',
	'InMinutes'		=> 'in %1 minutes',
	'InAnHour'		=> 'in an hour',
	'InHours'		=> 'in %1 hours',
	'Tomorrow'		=> 'tomorrow',
	'InDays'		=> 'in %1 days',
	'InAWeek'		=> 'in a week',
	'InWeeks'		=> 'in %1 weeks',
	'InAMonth'		=> 'in a month',
	'InMonths'		=> 'in %1 months',
	'InAYear'		=> 'in a year',
	'InYears'		=> 'in %1 years',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['Byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['Byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'GP', 'TP', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['pixel', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Unknown action',
	'UnknownMethod'				=> 'Unknown method',
	'FormatterNotFound'			=> 'Formatter %1 not found',

	// log
	'LogAdminLoginSuccess'		=> 'Successful login into the administrative panel',
	'LogAdminLogout'			=> 'Logout of the administrative panel',
	'LogAdminLoginFailed'		=> '!!Failure to authorize access to administrative panel!!',
	'LogAdminLoginLocked'		=> 'Locked login to the administrative panel',
	'LogUserCookieForged'		=> '!!**An attempt to login on a forged cookie with login ##%1##**!!',
	'LogInvalidFormToken'		=> 'Potential CSRF attack in progress detected: %1',
	'LogRemovedPage'			=> '!!Removed page ##%1## (user %2)!!',
	'LogRemovedCluster'			=> '!!Removed **cluster** ##%1## (user %2)!!',
	'LogRemovedRevision'		=> '!!Removed revision ##%3## of page [[/%1]] (user %2)!!',
	'LogRemovedComment'			=> '!!Removed comment from %3 on page [[/%1]] (user %2)!!',
	'LogRemovedFile'			=> '!!Removed file ##%2## from page [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!Removed all comments of the page [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Removed all revisions of the page [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Removed all files, attached to [[/%1]]!!',
	'LogTopicLocked'			=> 'Forum topic is locked [[/%1]]',
	'LogTopicUnlocked'			=> 'Unlocked forum topic [[/%1]]',
	'LogAclUpdated'				=> 'Updated ACL page [[/%1]]',
	'LogOwnershipChanged'		=> 'Ownership of the page [[/%1]] transferred to the user ##%2##',
	'LogUserLoginFailed'		=> '!!Unsuccessful attempts to log in with ##~%1##!!',
	'LogClonedPage'				=> 'Page ##%1## cloned to [[/%2]]',
	'LogRenamedPage'			=> 'Page ##%1## renamed to [[/%2]]',
	'LogRenamedPage2'			=> '. The old page set as the link to the new one',
	'LogSplittedPage'			=> 'Comments on the page [[/%1]] splitted to page [[/%2]]',
	'LogMergedPages'			=> 'Pages %1 merged to page [[/%2]]',
	'LogUserPasswordReminded'	=> 'User ##%1## asked for the password recovery process to address ##%2##',
	'LogUserPasswordRecovered'	=> 'User ##%1## successfully recovered the forgotten password',
	'LogUserPasswordChanged'	=> 'User ##%1## successfully updated (changed) the password',
	'LogUserPasswordMismatch'	=> '!!User ##%1## failed to change the password: current password mismatch!!',
	'LogUserIPSwitched'			=> 'Unauthorized IP address change of the user %1 from %2 to %3',
	'LogPageImported'			=> 'Imported page [[/%1]]',
	'LogSaveNoRights'			=> 'No appropriate rights to save the page [[/%1]]',
	'LogPageCreated'			=> 'Created new page [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Updated page properties [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'The user got ownership of the page [[/%1]]',
	'LogFileUploadedLocal'		=> 'New file ##%2## uploaded to the page [[/%1]] (size %3)',
	'LogFileUploadedGlobal'		=> 'New file ##%2## uploaded to the global folder (size %3)',
	'LogPMSent'					=> 'Personal message ##%1## -> ##%2## successfully sent',
	'LogUserSimilarName'		=> 'There were attempts to register under the same user name: ##%1##',
	'LogUserEmailNotAllowed'	=> 'Email ##%1## not in allowed domains list',
	'LogRegisterTiming'			=> 'Registration failed, form time threshold is ##%1## seconds (was ##%2##)',
	'LogUserRegistered'			=> 'Successfully registered a new user ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Successfully activated email ##%1## of user ##%2##',
	'LogCommentPosted'			=> 'Added [[/%1 new comment(s)]] to page [[/%2]]',
	'LogUserLoginOK'			=> 'User ##%1## successfully logged in the system',
	'LogUserLoggedOut'			=> 'User ##%1## successfully logged out the system',
	'LogUserSessionContinued'	=> 'User ##%1## continued the suspended session',
	'LogUserSettingsUpdate'		=> 'User ##%1## updated personal settings',
	'LogPageEdited'				=> 'Edited page [[/%1]]',
	'LogCommentEdited'			=> 'Edited comment [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Updated file metadata for ##%2## from page [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Updated file categories for ##%2## from page [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'XML Sitemap generated',
	'LogReferrersPurged'		=> 'Maintenance: referrers purged',
	'LogRevisionsPurged'		=> 'Maintenance: outdated pages revisions purged',
	'LogDeletedPagesPurged'		=> 'Maintenance: deleted pages purged',
	'LogSystemLogPurged'		=> 'Maintenance: system log purged',
	'LogCachedPagesPurged'		=> 'Maintenance: cached pages purged',
	'LogSqlCachePurged'			=> 'Maintenance: cached sql results purged',
	'LogExpiredTokensPurged'	=> 'Maintenance: expired cookie_tokens purged',
	'LogErrorSplitComments'		=> 'Error when separating comments from the topic [[/%1]] a new topic ##%2##: page was not created',
	'LogCategoriesUpdated'		=> 'Updated page categories [[/%1]]',
	'LogCategoryCreated'		=> 'Created a new category //%1//',
	'LogCategoryRenamed'		=> 'Category ##%1## renamed to ##%2##',
	'LogCategoryDebundled'		=> 'Category ##%1## debundled',
	'LogCategoryGrouped'		=> 'Category ##%1## grouped with the word ##%2##',
	'LogCategoryRemoved'		=> 'Category ##%1## removed from the database',
	'LogThumbnailGeneration'	=> 'Thumbnail generation %1 sec.',

	'ErrorMinPHPVersion'		=> 'PHP 版本必須大於 <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' 您的服務器似乎正在運行' . PHP_VERSION . '</strong>。' .
									'  您應該升級到更新的 PHP 版本以使 WackoWiki 正常工作。',

];
