<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Norwegian',
		'code'		=> 'no',
		'dir'		=> 'ltr',
		'locale'	=> 'no_NO',
	],

	'date_formats'	 => [
		'default'	=> 'dd.MM.y',
	],

	// common
	'AddButton'					=> 'Legg til',
	'ArchiveButton'				=> 'Arkiv',
	'CancelButton'				=> 'Avbryt',
	'ContinueButton'			=> 'Fortsett',
	'ConvertButton'				=> 'Konverter',
	'CreateButton'				=> 'Opprett',
	'DeleteButton'				=> 'Slett',
	'RemoveButton'				=> 'Fjern',
	'RenameButton'				=> 'Omdøp',
	'ResetButton'				=> 'Reset',
	'RestoreButton'				=> 'Gjenopprett',
	'SaveButton'				=> 'Lagre',
	'SearchButton'				=> 'Søk',
	'SendButton'				=> 'Sende',
	'SetButton'					=> 'Angi',
	'SubmitButton'				=> 'Send',
	'UpdateButton'				=> 'Oppdater',

	'FormInvalid'				=> 'Det sendte skjemaet var ugyldig. Prøv å sende inn igjen.',
	'UnitPixel'					=> 'px',
	'Number'					=> 'Nummer',

	// logged in panel
	'AccountText'				=> 'Konto',
	'AccountTip'				=> 'Rediger profil',
	'AdminText'					=> 'Administrator',
	'AdminTip'					=> 'Administrativ panel',
	'LogoutLink'				=> 'Logg',
	'LogoutButton'				=> 'Logg ut',
	'LogoutAreYouSure'			=> 'Vil du virkelig logge ut?',

	// registration panel
	'RegistrationWelcome'		=> 'Ny brukerregistrering:',
	'RegistrationButton'		=> 'Registrer meg',
	'UserNameOwned'				=> 'Brukernavnet er allerede registrert. Velg et annet.',
	'SiteRegistered'			=> 'Du har nå registrert deg på nettstedet %1.',
	'RegistrationEmailInfo'		=> 'En gyldig e-postadresse. Alle e-post fra systemet vil bli sendt til denne adressen E-postadressen er ikke offentlig og vil kun brukes dersom du ønsker å motta et nytt passord eller ønsker å motta visse nyheter eller varsler via e-post.',
	'EmailConfirmHint'			=> 'Vennligst bekreft e-postadressen din ved å klikke på lenken i instruksjonene som er sendt til deg. <br>Hvis du ikke bekrefter e-postadressen din, vil du ikke kunne gjenopprette et mulig tapt passord. <br>Du vil heller ikke bli varslet om nylige sideendringer og kommentarer.',
	'EmailConfirmRequired'		=> 'Uten bekreftet epostadresse får du ikke lov til å logge inn.',
	'NameTooShort'				=> 'Brukernavnet er for kort, minimum %2 tegn.',
	'NameTooLong'				=> 'Brukernavnet er for langt, maksimalt %2 tegn er tillatt.',
	'NameAlphanumOnly'			=> 'Brukernavnet må være mellom %1 og %2 tegn lang og bare bruke alfanumeriske tegn. De store bokstavene er OK.',
	'NameCamelCaseOnly'			=> 'Brukernavnet må være mellom %1 og %2 tegn langt og WikiName formatert.',
	'NewUserAccount'			=> 'ny brukerkonto',

	'NewAccountSubject'			=> 'Registrering av konto',
	'NewAccountAdminCreated'	=> 'Brukeren %1 har opprettet en konto for deg med brukernavn "%2". For å fullføre registreringen din, besøk følgende URL (sørg for at det er skrevet som enkeltlinje) og angi ditt eget tilgangspassord:',
	'NewAccountUsername'		=> 'Brukernavn:',
	'AccountLanguage'			=> 'Språk:',
	'NewAccountEmail'			=> 'Email:',
	'NewAccountIP'				=> 'Ekstern IP-adresse:',
	'NewAccountSignupInfo'		=> 'Følgende konto er opprettet:',

	'UserWaitingApproval'		=> 'En e-post har blitt sendt til nettstedets administrator. Administratoren vil gjennomgå de opplysningene som er sendt inn og enten godkjenne eller avslå din forespørsel.',
	'UserRequiresApproval'		=> 'For å godkjenne eller nekte denne brukeren tilgang til %1 gå til admin-panelet.',
	'UserApprovalInfo'			=> 'Når du registrerer deg, blir forespørselen din sendt til nettstedets administrator for godkjenning. Du vil deretter motta en e-post med ytterligere instruksjoner.',
	'UserApprovalHint'			=> 'Den vellykkede aktiveringen av kontoen din blir annonsert i en spesifikk e-post. Innlogging er derfor ikke mulig.',

	'UserApprovalPending'		=> 'Kontoen din venter på godkjenning.',
	'UserApprovalDenied'		=> 'Kontoen din har blitt nektet tilgang til denne siden.',

	'RegistrationApproved'		=> 'Registrering godkjent',
	'RegistrationDenied'		=> 'Registrering nektet',
	'PendingApproval'			=> 'Venter på godkjenning',

	'UserApprovedInfo'			=> 'Du har blitt godkjent for tilgang til %1.',
	'UserDeniedInfo'			=> 'Du har blitt nektet tilgang til %1.',

	'RegistrationThreshold'		=> 'Tid for å fylle ut skjemaet må ikke være mindre enn %1 sekunder.',
	'Language'					=> 'Språk',

	// login panel
	'LoginWelcome'				=> 'Innlogging',
	'CreateAccount'				=> 'Opprett ny konto',
	'RegistrationLink'			=> 'Registrering',
	'LoginName'					=> 'Brukernavn',
	'Password'					=> 'Passord',
	'LoginButton'				=> 'Innlogging',
	'LoginLink'					=> 'Innlogging',
	'PersistentCookie'			=> 'Forbli pålogget',
	'Session'					=> 'Økt',
	'SessionTip'				=> 'parametre for gjeldende økt',
	'SessionDuration'			=> 'Sesjonens varighet',
	'SessionDurationSession'	=> 'nettleser økt',
	'SessionDurationDay'		=> '1 dag',
	'SessionDurationWeek'		=> '1 uke',
	'SessionDurationMonth'		=> '1 måned',
	'LoggedInAs'				=> 'Du er innlogget som',

	'ClearCookies'				=> 'Slett alle infokapsler',
	'BindSessionIp'				=> 'Bind økt til IP-adressen',
	'BindSessionIpOn'			=> 'aktivert (gjeldende IP %1)',
	'TrafficProtection'			=> 'Trafikk beskyttelse',
	'SessionEnds'				=> 'Den gjeldende sesjonen avsluttes',
	'LastVisit'					=> 'Siste besøk ble tatt opp',

	'LoginIncorrect'			=> 'Brukernavnet eller passordet du har skrevet inn er ugyldig.',
	'WelcomeBack'				=> 'Velkommen tilbake, %1',
	'LoginAttemptsExceeded'		=> 'Du har overskredet maksimalt tillatt antall påloggingsforsøk.<br>I tillegg til ditt brukernavn og passord som du nå må løse CAPTCHA nedenfor.',

	// session notice
	'IPAddressChanged'			=> 'IP-adressen endret til %1 (var %2)',

	'SessionReplay'				=> 'Økten ble avsluttet på grunn av replay.',
	'SessionObsolete'			=> 'Økten er utdatert.',
	'SessionExpired'			=> 'Økten er utløpt.',
	'SessionTimeout'			=> 'Økten ble avsluttet på grunn av tidsavbrudd.',
	'SessionInactivity'			=> 'Økten avsluttet på grunn av inaktivitet.',
	'SessionUaChange'			=> 'Økten ble avsluttet på grunn av endret brukeragens.',
	'SessionTLSChange'			=> 'Økten avsluttet på grunn av TLS-endringer.',
	'SessionIPChange'			=> 'Økten ble avsluttet på grunn av IP-endring.',

	// other
	'Guest'						=> 'Gjest',
	'Everybody'					=> 'Alle',
	'Help'						=> 'Hjelp',
	'TopicSearchText'			=> 'Søk bare i titler',
	'WordprocessorVersion'		=> 'Ord prosessor versjon',

	// notifications
	'EmailHello'				=> 'Hei ',
	'EmailModerator'			=> 'Moderator',
	'WatchedPageChanged'		=> 'Side endret ',
	'SomeoneChangedThisPage'	=> ' endret en side du følger: ',
	'NewPageCreatedSubj'		=> 'En ny side',
	'NewPageCreatedBody'		=> 'Bruker %1 har opprettet en ny side: ',
	'FileUploadedSubj'			=> 'En ny fil',
	'FileUploadedBody'			=> 'Brukeren %1 har lastet opp en ny fil: ',
	'FileReplacedBody'			=> 'Brukeren %1 har erstattet filen: ',

	'ActionDenied'				=> 'Handlingen er nektet her.',
	'TocTitle'					=> 'Innhold ',
	'OuterLink2'				=> 'Utgående lenke',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF dokument',
	'RDFLink'					=> 'RDF dokument',
	'EmailLink'					=> 'Skriv en e-post (brede-klient start)',
	'GeoLink'					=> 'Vis denne plasseringen (kart app start)',
	'JabberLink'				=> 'Chat via XMPP (Jabber-klient launch)',
	'TelLink'					=> 'Ring dette nummeret (telefon-app-startet)',
	'PermaLink'					=> 'Permalenke',
	'PermaLinkTip'				=> 'Permanent lenke til denne revisjonen av siden',
	'PermaLink0Tip'				=> 'Permanent lenke til denne siden',

	'ShowTip'					=> 'Tilbake i visningsmodus',
	'ShowText'					=> 'Vis',
	'WikieditAutocomplete'		=> 'Fullfør wikilinker ved hjelp av Ctrl+mellomrom',
	'WikiEditInactiveJs'		=> 'For å kunne bruke WikiEdit, må du aktivere JavaScript i nettleseren.',
	'NumerateLinks'				=> 'Numerer lenker i utskriftsvisning',
	'Comment'					=> 'Kommentar',
	'Comments0'					=> 'Legg til din kommentar',
	'Comments1'					=> 'Les kommentar (1 kommentar)',
	'CommentsN'					=> 'Les kommentarer (%1 kommentarer)',
	'Comments'					=> 'Kommentarer',
	'CommentHint'				=> '<a href="%1">logg inn</a> eller <a href="%2">oppretter en konto</a> for å legge inn en kommentar.',
	'CommentEdited'				=> 'redigert',
	'Links'						=> 'Lenker',
	'Version'					=> 'Versjon',

	// details formatter
	'ShowHideDetails'			=> 'Detaljer',

	'PrivacyPolicy'				=> 'Retningslinjer for personvern',
	'TermsOfUse'				=> 'Vilkår for bruk',
	'AcceptTermsOfUse'			=> 'Jeg har lest og forstått og samtykket i nettstedets vilkår.',

	'ShowComments'				=> 'Vis kommentarer / skjema',
	'HideComments'				=> 'Skjul kommentarer / skjema',
	'AddComment'				=> 'Legg ved en kommentar til denne siden:',
	'AddCommentTitle'			=> 'Tittelen på kommentaren:',
	'CommentTitleRe'			=> 'Sv:',
	'AddCommentButton'			=> 'Legg til kommentar',
	'HereLink'					=> 'her',
	'PageHandlerMoreTip'		=> 'mer',

	'ThemeCorrupt'				=> 'Temaet er korrupt',
	'InvalidNamespace'			=> 'Ugyldig navneområde oppgitt.',
	'DoesNotExists'				=> 'Denne siden finnes ikke.',
	'PromptCreate'				=> 'Vil du ha <strong><a href="%1">opprettelsen av</a></strong> det?',
	'RevisionHint'				=> 'Dette er en gammel revisjon av <a href="%1">%2</a> fra %3 redigert av %4.',
	'ReadAccessDenied'			=> 'Du har ikke lov til å lese denne siden.',
	'ReadAccessDeniedHintGuest'	=> 'For å lese denne siden bør du logge inn.',
	'PageDeletedInfo'			=> 'Denne siden er slettet.',
	'RevisionDeletedInfo'		=> 'Denne revisjonen har blitt slettet.',
	'CommentDeletedInfo'		=> 'Denne kommentaren har blitt slettet.',

	'LastEditedBy'				=> 'Sist endret av',
	'YouAreOwner'				=> 'Du er eieren av denne siden.',
	'Owner'						=> 'Eier:',
	'Nobody'					=> 'Ingen',
	'TakeOwnership'				=> 'Ta eierskap',
	'FilesTip'					=> 'Administrere vedlagte filer',
	'FilesText'					=> 'Vedlegg',
	'DeleteTip'					=> 'Slett siden, filer og kommentarer',
	'DeleteCommentTip'			=> 'Slett kommentar',
	'DeleteText'				=> 'Slett',
	'AclText'					=> 'Tillatelser',
	'AclTip'					=> 'Rediger rettigheter',

	'PropertiesText'			=> 'Egenskaper',
	'PropertiesTip'				=> 'Rediger sideegenskaper',
	'EditTip'					=> 'Rediger denne siden.',
	'EditText'					=> 'Rediger',
	'EditSection'				=> 'Rediger seksjon %1',
	'EditSectionHint'			=> 'Seksjon %1 av %2',
	'SectionHeadline'			=> 'Seksjon',
	'EditCommentTip'			=> 'Rediger kommentar',
	'EditComment'				=> 'Rediger denne kommentaren',
	'ReplyComment'				=> 'Svar',
	'ReplyCommentTip'			=> 'Svar på denne kommentaren',
	'RevisionTip'				=> 'Vis siderevisjoner',
	'RevisionText'				=> 'Revisjoner',
	'ReferrersTip'				=> 'Vis en liste over nettadresser som refererer til denne siden',
	'ReferrersText'				=> 'Henvisninger',
	'ModerateTip'				=> 'Moderering av emner og foruminnlegg',
	'ModerateText'				=> 'Moderat',
	'SearchText'				=> 'Søk: ',

	'AclUpdated'				=> 'Tilgangskontrollen er oppdatert',
	'AclGaveOwnership'			=> ' og gav eierskap til %1.',
	'AclNoNewOwner'				=> 'Sideeierskap er ikke overført fordi brukeren %1 ikke ble funnet.',
	'NewPageOwnership'			=> 'Overført sideeierskap',
	'YouAreNewOwner'			=> 'tidligere eier %1 overførte eierskapet ' . "\n" . 'på følgende side til deg',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Lest:',
	'AclWrite'					=> 'Skrift:',
	'AclComment'				=> 'Kommentarer:',
	'AclCreate'					=> 'Opprett:',
	'AclUpload'					=> 'Opplasting:',
	'AclFor'					=> 'Tilgangskontrolllister for %1',
	'SetOwner'					=> 'Angi eier:',
	'OwnerDontChange'			=> 'Ikke endre',
	'AclAccessDenied'			=> 'Du er ikke eier av denne siden.',
	'AclSyntaxError'			=> 'Adgangskontrollliste syntaksfeil',
	'AclHelp'					=> '<code>*</code> - alle er tillatt<br>' .
									'<code>$</code> - kun registrerte brukere<br>' .
									'<code>!</code> - et foregående utropstegn nekter de respektive høyre<br>' .
									'<code>[UserName]</code> - navn på tillatte brukere<br>' .
									'<code>[GroupName]</code> - navn på tillatt brukergruppe (alias)<br>' .
									'<code>(En tom liste)</code> - bare eieren av siden har tilgang',

	'AccessMode'				=> 'Synlighet',
	'AccessDenied'				=> 'nektet',
	'AccessPublic'				=> 'offentlig',
	'AccessRegistered'			=> 'registrert',
	'AccessPrivate'				=> 'privat',
	'AccessCustom'				=> 'tilpasset',

	// purge handler
	'PurgePage'					=> 'Purge page',
	'NotOwnerAndCantPurge'		=> 'Du er ikke eieren av siden og du kan ikke fjerne den.',
	'ReallyPurge'				=> 'ATTENTIG: Fjerning av siden er irreversibel!',
	'SelectPurgeOptions'		=> 'Velg de nødvendige fjerningsalternativer:',
	'PurgeComments'				=> 'Rens alle kommentarer på siden',
	'CommentsPurged'			=> 'Alle kommentarer ble slettet.',
	'PurgeFiles'				=> 'Fjern alle vedlagte filer',
	'FilesPurged'				=> 'Alle vedlagte filer ble fjernet.',
	'PurgeRevisions'			=> 'Tøm alle revisjoner av siden',
	'RevisionsPurged'			=> 'Revisjoner ble renset.',
	'PurgeButton'				=> 'Purge',

	// categories handler
	'Categories'				=> 'Kategorier',
	'CategoriesAssign'			=> 'tilordne',
	'CategoriesEdit'			=> 'rediger',
	'Category'					=> 'Kategori',
	'CategoriesFor'				=> 'Kategorier for',
	'CategoriesTip'				=> 'Rediger kategorier',
	'CategoriesText'			=> 'Kategorier',
	'CategoriesUpdated'			=> 'Kategorier oppdatert',
	'CategoriesAlreadyExists'	=> 'Kategorien %1 finnes allerede.',
	'CategoriesAdded'			=> 'Kategori %1 ble lagt til.',
	'CategoriesRenamed'			=> 'Kategori omdøpt navn.',
	'CategoriesUngrouped'		=> 'Kategorien ble belastet.',
	'CategoriesGrouped'			=> 'Kategorien som er angitt i den nye gruppen.',
	'NoMultilevelGrouping'		=> 'Flernivågruppering er ikke mulig.',
	'CategoriesDeleted'			=> 'Kategorien ble slettet fra databasen og alle sider.',
	'CategoriesAdd'				=> 'Legg til ny kategori',
	'CategoryDescription'		=> 'Beskrivelse',
	'CategoriesAddGrouped'		=> 'Gruppert med kategorien',
	'CategoriesAddGroupedNo'	=> 'Ingen gruppe.',
	'CategoriesRename'			=> 'Endre navn på kategorien %1 til',
	'CategoriesRenameInfo'		=> '* Merk: Endringer vil påvirke alle sider som er tilordnet denne kategorien.',
	'CategoriesGroup'			=> 'Gruppe kategorier %1 med',
	'CategoriesGroupInfo'		=> '* Velg [ingen gruppe] å debitere kategorien.',
	'CategoriesNoGroup'			=> '[ingen gruppe]',
	'CategoriesDelete'			=> 'Er du sikker på at du vil fjerne kategori %1?',
	'CategoriesDeleteInfo'		=> '* Merk: Endringer vil påvirke alle sider som er tilordnet denne kategorien. Hvis ordet har en underkategori, blir de ikke slettet, men bare belastet.',
	'CategoriesStoreInfo'		=> 'Hvis du vil tilordne kategorier til en side, velg avmerkingsboksene.',
	'CategoriesStoreButton'		=> 'Lagre kategorier',
	'CategoriesGroupButton'		=> 'Gruppe',
	'CategoriesEditInfo'		=> 'For å redigere kategorilisten, velg valgknappen.',
	'NoCategoriesForThisLang'	=> 'Kategorier for dette språket er ikke angitt.',
	'PagesCategory'				=> 'Sider kategori',
	'CategoryNotExists'			=> 'Kategori eksisterer ikke.',
	'CategoryEmpty'				=> 'Tom kategori.',
	'NoCategorySelected'		=> 'Ingen kategori er valgt.',
	'NoCategoriesAssigned'		=> 'Ingen tildelte kategorier for dette språket.',
	'TagCloud'					=> 'Tag Sky',
	'PagesTaggedWith'			=> '%1 sider merket med %2',
	'CategoriesOfCluster'		=> 'for cluster',
	'TaggedWithTip'				=> 'show pages tagged %1',

	// source handler
	'SourceText'				=> 'Kilde',
	'SourceTip'					=> 'Vis wiki-kilden',
	'SourceCopyToClipboard'		=> 'kopier til utklippstavlen',
	'SourceFor'					=> 'Vis kilde for %1',

	// Groups action
	'GroupsSearch'				=> 'Finn grupper',
	'GroupsNoMatching'			=> 'Samsvarende grupper ble ikke funnet. Prøv et mindre strengt søkekriterier.',
	'GroupsOpenProfile'			=> 'Vis profil',
	'GroupsName'				=> 'Gruppe',
	'GroupsMembers'				=> 'Medlemmer',
	'GroupsDescription'			=> 'Beskrivelse',
	'GroupsCreated'				=> 'Opprettet',
	'GroupsNotFound'			=> 'Gruppen %2 ble ikke funnet. Klikk <a href="%1">her</a>, for å gå til hovedlisten.',
	'GroupsProfile'				=> 'Profil',
	'GroupsList'				=> 'Vis hele listen over grupper',
	'GroupSpace'				=> 'Gruppe plass',

	'MetaUpdated'				=> 'Meta data oppdatert',

	'PreviewButton'				=> 'Forhåndsvisning',
	'Preview'					=> 'Forhåndsvisning',
	'Chars'						=> 'tegn',
	'PageBody'					=> 'Side brødtekst',
	'EditNote'					=> 'Rediger sammendrag',
	'EditNoteMissing'			=> 'Rediger sammendrag mangler',
	'EditMinor'					=> 'Mindre redigere',
	'MinorEditHide'				=> 'Skjul mindre redigering',
	'MinorEditShow'				=> 'Vis mindre redigere',
	'PostAnonymously'			=> 'Post anonymt uten å gi ditt navn',
	'NotifyMe'					=> 'Varsle meg om nye kommentarer og endringer på siden',
	'OverwriteAlert'			=> 'OVERSKRIV VARSEL: Denne siden ble endret av noen andre mens du redigerte den.<br>Kopier endringene og rediger denne siden på nytt.',
	'TextDbOversize'			=> 'Advarsel: Teksten din overskrider lengdegrensen på %1 tegn. Vennligst forkort teksten til et akseptabelt antall tegn. Tips: Du kan plassere den gjenstående teksten på en separat side.',
	'EditingRevisionWarning'	=> 'Du redigerer en gammel revisjon av denne siden. Hvis du publiserer den, vil eventuelle endringer som er gjort siden den ble fjernet. <br>Du vil kanskje redigere den gjeldende versjonen i stedet.',
	'WriteAccessDenied'			=> 'Du har ikke skrivetilgang til denne siden.',
	'EmptyPage'					=> 'Siden kroppen var tom - ikke lagret!',
	'EmptyComment'				=> 'Kommentarfeltet var tomt - ikke lagret!',
	'CommentAccessDenied'		=> 'Beklager, du har ikke tillatelse til å legge ut kommentarer på denne siden.',
	'CommentFlooded'			=> 'Intervallet mellom publiseringen av innleggene skal ikke være mindre enn %1 sekunder.',
	'CommentAdded'				=> 'Kommentar lagt til.',
	'YouAreNowTheOwner'			=> 'Du er nå eier av denne siden.',
	'PageSaved'					=> 'Sideversjon %1 er lagret.',
	'CommentSaved'				=> 'Kommentar lagret.',

	'RevisionsFor'				=> 'Revisjoner for %1',
	'DefaultDiffMode'			=> 'Standard diff modus',
	'DiffMode'		=> [
		'0'		=> 'Full diff',
		'1'		=> 'Enkel diff',
		'2'		=> 'Kilde',
		'3'		=> 'Side ved side',
		'4'		=> 'Innebygd',
		'5'		=> 'Flettet',
		'6'		=> 'Felles',
		'7'		=> 'Kontekst',
	],

	'PreviousEdit'				=> 'Forrige redigering',
	'NextEdit'					=> 'Neste redigering',

	'Diff'						=> 'Forskjell',
	'PreviousVersion'			=> 'Forrige revisjon',
	'LatestVersion'				=> 'Siste revisjon',
	'NextVersion'				=> 'Neste revisjon',

	'ShowDifferencesButton'		=> 'Vis forskjeller',
	'CancelReturnButton'		=> 'Avbryt og gå tilbake til siden',
	'Comparison'				=> 'Forskjell mellom revisjoner av %1',
	'RevisionAsOf'				=> 'Versjon %1 på grunn av',
	'SimpleDiffAdditions'		=> 'Tillegg',
	'SimpleDiffDeletions'		=> 'Slettinger:',
	'NoDifferences'				=> 'Ingen forskjeller.',
	'ReEditOldRevision'			=> 'Re-rediger denne gamle versjonen',

	'ExternalPages'				=> 'Eksterne sider som linker til %1 (%2) (<a href="%3">se listen over domener</a>):',
	'ExternalPagesGlobal'		=> 'Nettsteder som lenker til denne WackoWiki (%2) (<a href="%1">se listen over domener</a>):',
	'Last24Hours'				=> 'siste 24 timer',
	'LastDays'					=> 'siste %1 dager',
	'DomainsSitesPages'			=> 'Domenere/nettstedsider som lenker til  %1 (%2) (<a href="%3">se listen over forskjellige URL\'er</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domenere/nettsteder som lenker til denne WackoWiki (<a href="%1">se listen over forskjellige URLer</a>):',
	'ViewReferrersPage'			=> 'til side',
	'ViewReferrersPerPage'		=> 'per side',
	'ViewReferrersByTime'		=> 'etter tid',
	'ViewReferrersGlobal'		=> 'global',
	'NoneReferrers'				=> 'Ingen',
	'NotOwnerCantDelete'		=> 'Du er ikke eier av denne siden og kan ikke slette den',

	// remove
	'RemovePage'				=> 'Fjern side',
	'RemoveRevision'			=> 'Fjern revisjon',
	'RemoveComment'				=> 'Slett kommentar',
	'RemoveCluster'				=> 'Fjern alle sider av klyngen',
	'RemoveDontKeep'			=> 'Ikke lagre en kopi av en fjernet side og kommentarer',
	'RemoveDontKeepPurge'		=> 'Ikke lagre en kopi av en fjernede filene, versjonene og kommentarene',
	'RemoveDontKeepRevision'	=> 'Ikke lagre en kopi av den fjernede versjonen',
	'RemoveDontKeepComment'		=> 'Ikke lagre en kopi av den fjernede kommentaren',
	'RemoveDontKeepFile'		=> 'Ikke lagre kopi av den fjernede filen',
	'ReferrersRemoved'			=> 'Henvisninger fjernet.',
	'LinksRemoved'				=> 'Lenker fjernet.',
	'CategoriesRemoved'			=> 'Sidekategorier slettet.',
	'AclsRemoved'				=> 'Side acls fjernet.',
	'BookmarksRemoved'			=> 'Bokmerker fjernet.',
	'WatchesRemoved'			=> 'Følger fjernet.',
	'CommentsRemoved'			=> 'Kommentarer fra siden fjernet.',
	'FilesRemoved'				=> 'Filer fra siden fjernet.',
	'PageRemoved'				=> 'Siden ble fjernet.',
	'PageCachePurged'			=> 'Mellomlager tømt.',
	'ClusterRemoved'			=> 'Alle sidene i klyngen fjernet.',
	'RevisionRemoved'			=> 'Revisjon %1 fjernet.',
	'RevisionsRemoved'			=> 'Revisjoner fjernet.',
	'ActionHaveNoUndo'			=> 'Denne handlingen kan ikke angres.',

	// restore
	'PageRestored'				=> 'Siden ble gjenopprettet.',
	'RevisionRestored'			=> 'Revisjon gjenopprettet.',
	'LocalFilesRestored'		=> 'Lokale filer gjenopprettet.',

	'PrintVersion'				=> 'Skriv ut versjon',
	'PrintText'					=> 'Utskrift',
	'LinkedPages'				=> 'Lenkede sider:',
	'NoLinkedPages'				=> 'Det finnes ingen tilkoblede sider',
	'ReferringPages'			=> 'Sidehenvisende sider:',
	'NoReferringPages'			=> 'Det finnes ingen refererende sider',
	'Footnotes'					=> 'Fotnoter:',
	'Footnote'					=> 'Fotnote',
	'MostPopularPages'			=> 'Mest populære sider',
	'MostCommentedPages'		=> 'Mest kommenterte sider',
	'NoAccessToSourcePage'		=> 'Du har ikke lov til å lese handlingskildsiden.',
	'SourcePageDoesntExist'		=> 'Handlingskildsiden finnes ikke ennå',
	'NotLoggedInThusEdited'		=> 'Du er ikke logget inn, derfor kunne vi ikke identifisere sidene du har redigert.',
	'DidntEditAnyPage'			=> 'Du har ikke endret noen sider enda.',
	'NoPagesFound'				=> 'Ingen sider funnet.',
	'MyChangesTitle1'			=> 'Dette er listen over sider du har redigert, sortert etter tidspunktet for den siste endringen',
	'MyChangesTitle2'			=> 'Dette er listen av sider du har redigert, sammen med tidspunktet for den siste endringen',
	'OrderABC'					=> 'alfabetisk',
	'OrderCreation'				=> 'etter opprettelse',
	'OrderChange'				=> 'med endring',
	'ListOwnedPages'			=> 'Dette er listen av sider du eier (bestilt alfabetiske)',
	'ListOwnedPages2'			=> 'Dette er listen over sider du eier (bestilt etter dato)',
	'ListOwnedPages3'			=> 'Dette er listen over sider du eier (bestilt av endring)',
	'NotLoggedInThusOwned'		=> 'Du er ikke logget inn, derfor kunne vi ikke hente sidene.',
	'NoOrphaned'				=> 'Ingen foreldreløse sider. Beløp.',
	'NoRecentComments'			=> 'Ingen nylige kommentarer.',
	'LatestCommentBy'			=> 'siste kommentar av',
	'NoRecentlyCommented'		=> 'Ingen nylig kommenterte siden.',
	'NoDeletedPages'			=> 'Ingen slettede sider funnet.',
	'NoDeletedRevisions'		=> 'Ingen slettede versjoner funnet.',
	'NoDeletedFiles'			=> 'Ingen slettede filer funnet.',
	'CommentsDisabled'			=> 'Kommentarer er ikke tilgjengelige.',

	'SearchResults'				=> 'Søkeresultater for ',
	'NotFound'					=> 'ikke funnet',
	'NoResultsFor'				=> 'Ingen resultater for ',
	'SearchFor'					=> 'Søk etter:',
	'TopicSearchResults'		=> 'Emner søkeresultater for ',
	'NotFoundInTopics'			=> 'ikke funnet i emner',
	'FilterLangNotAvailable'	=> 'Det valgte språket er ikke tilgjengelig!',
	'SearchInPages'				=> 'Søk på sideinnhold',
	'SearchInComments'			=> 'Søk i kommentarer',
	'SearchInPageTitles'		=> 'Søk i sidetitler',
	'SearchInNoOption'			=> 'Du må velge minst ett av søkemulighetene.',

	'PostedBy'					=> 'Skrevet av',
	'ThisIsCommentOn'			=> 'Dette er en kommentar på',
	'At'						=> 'på',
	'To'						=> 'til',
	'By'						=> 'av',
	'From'						=> 'fra',
	'For'						=> 'for',
	'ReturnToCommented'			=> 'Returner til kommentert side',
	'AbandonedComment'			=> 'Siden som denne kommentaren ikke lenger finnes!',

	'PagesLinkingTo'			=> 'Sider linker til',
	'NoPageLinkingTo'			=> 'Ingen side linker til',
	'NoWantedPages'				=> 'Ingen ønskete sider. Godt.',
	'RemoveWatch'				=> 'Fjern klokke for denne siden',
	'SetWatch'					=> 'Se denne siden',
	'WatchText'					=> 'Overvåk',
	'UnwatchText'				=> 'Ikke følg',
	'UserSettingsStored'		=> 'Brukerinnstillinger ble lagret.',
	'LoggedOut'					=> 'Du er nå logget ut.',
	'LoggedOutAuto'				=> 'For sikkerhet, din sesjon er avsluttet. Logg inn på nytt.',

	// user settings
	'EmailConfirmResent'		=> 'E-post for bekreftelseskoden er sendt på nytt.',
	'EmailConfirmNotSent'		=> 'Kan ikke sende bekreftelseskoden, e-post er ikke angitt!',
	'Hello'						=> 'Hei',
	'UserName'					=> 'Brukernavn',
	'EmailAddress'				=> 'Epost adresse',
	'RealName'					=> 'Virkelig navn',
	'MenuItemsShown'			=> 'Menyelementer vist',
	'RecordsPerPage'			=> 'Oppføringer per side',
	'DoShowComments'			=> 'Vis kommentarer som standard',
	'DoubleclickEditing'		=> 'Dobbeltklikk på redigering',
	'UpdateSettingsButton'		=> 'Oppdater innstillinger',

	'AccountDisabled'			=> 'Kontoen din kan være deaktivert eller blokkert.',
	'WrongPassword'				=> 'Feil passord!',
	'ConfirmPassword'			=> 'Bekreft passord',
	'Email'						=> 'Epost adresse',
	'MustBeWikiName'			=> 'Brukernavn må være <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> formatert!',
	'SpecifyEmail'				=> 'Du må angi en e-postadresse.',
	'NotAEmail'					=> 'Det ser ikke ut som en gyldig e-postadresse.',
	'EmailTaken'				=> 'E-postadressen du skrev inn er allerede i bruk.',
	'EmailDomainNotAllowed'		=> 'E-postadressen som er skrevet inn %1 er ikke i den tillatte domenelisten.',
	'PasswordsDidntMatch'		=> 'Passordene samsvarer ikke.',
	'SpacesArentAllowed'		=> 'Mellomrom er ikke tillatt i passord.',
	'ListMyPages'				=> 'List sidene dine',
	'ListMyChanges'				=> 'List endringene dine',
	'ListMyWatches'				=> 'Liste over sette sider',
	'ListMyChangesWatches'		=> 'Endringer blant sette sider',
	'SeeListOfPages'			=> 'Se en liste over sider du eier (MyPages) og sider du har redigert (MyChanges).',
	'AddBookmark'				=> 'Legg denne siden til bokmerker',
	'RemoveBookmark'			=> 'Fjern fra bokmerker',

	'YourLanguage'				=> 'Velg språk',
	'ShowSpaces'				=> 'Vis mellomrom i WikiNames',
	'WrongPage4Redirect'		=> 'Kan ikke omdirigere på grunn av feil omadresseringsparameter',
	'RedirectsToItself'			=> 'Siden omadresserer til seg selv.',
	'ReallyDeletePage'			=> 'Vil du virkelig slette denne siden?<br>Det er ingen angre for denne handlingen!<br><br>ADVARSEL: Sletting av denne siden vil slette alle sideversjoner, kommentarer, vedlegg, ACL\'er og henvisninger.',
	'CommentForWatchedPage'		=> 'Ny kommentar på siden ',
	'SomeoneCommented'			=> ' kommenterte denne siden som du følger: ',
	'AlertReferringPages'		=> 'Denne siden er referert til på disse sidene',

	'AccountDelete'				=> 'Slett konto',
	'AccountDeleteConfirm'		=> 'Er du sikker på at du vil slette kontoen?',
	'AccountDeleted'			=> 'Kontoen ble slettet',
	'AccountDeleteHeader'		=> 'Slett kontoen %1',
	'AccountDeleteInfo'			=> 'Om dataene du opprettet (f.eks. e-post, innstillinger, vedlegg, wiki-oppføringer) så mye som mulig vil bli slettet. Men at data som vedlegg og wiki-oppføringer ikke kan slettes uten å påvirke arbeidet til de andre brukerne. Slike data blir derfor tilordnet en konto som heter %1. Fordi dataene til hver slettede konto blir flyttet til denne kontoen vil det ikke være mulig å skille dataene du opprettet fra data for en annen slettet konto.',
	'AccountDeleteWarning'		=> 'Sletting av en brukerkonto kan ikke angres.',
	'AccountDeleteHint'			=> 'Din konto blir slettet fra systemet. Dette innebærer at du ikke lenger kan logge inn med dine kontoopplysninger. Hvis du velger å bli en bruker av dette programmet igjen, kan du gjøre det ved å bruke det som en søknad gir.',
	'AccountDeleteVerify'		=> 'Skriv inn din pålogging %1 for å bekrefte slettingen. Når den er sendt inn, vil du bli bedt om å bekrefte passordet ditt.',

	'MarkRead'					=> 'Merk alle som lest',
	'CurrentTime'				=> 'Det er i dag',
	'Created'					=> 'opprettet',
	'Modified'					=> 'endret',

	'EditIcon'					=> 'rediger',
	'TreeClusterTitle'			=> 'Tre av klyngen %1',
	'TreeSiteTitle'				=> 'Stedets tre',
	'TreeEmpty'					=> '%1 har ingen undersider',
	'TreeEmptyLevels'			=> '%1 har ingen undersider for gitt dybde. Øk verdien for dyphet.',
	'TreeTooBig'				=> 'for mange undersider',

	// clone handler
	'ClonePage'					=> 'Dupliser side',
	'CloneText'					=> 'Klon',
	'CloneName'					=> 'Angi nytt navn for en klone av denne siden',
	'CloneButton'				=> 'Klon',
	'PageCloned'				=> 'Side %1 klonet.',
	'ClonedFrom'				=> 'Klonet fra %1.',
	'MassClone'					=> 'Klon hele klyngen',
	'MassCloning'				=> 'Klonende klyng.',
	'CloneCannotRead'			=> 'Uleselig side %1.',
	'CloneCannotCreate'			=> 'Uopprettelig side %1.',

	'CommentOffset'				=> 'Kommentarer Side',
	'CommentOffsetFirst'		=> 'første side',
	'CommentOffsetLast'			=> 'siste side',
	'SortComment'				=> 'Sorter kommentarer etter',
	'SortCommentAsc'			=> 'Nyeste på bunnen',
	'SortCommentDesc'			=> 'Nyeste på toppen',

	'RenamePage'				=> 'Endre navn på siden',
	'RenameText'				=> 'Omdøp',
	'RenameTip'					=> 'Endre navn på siden',
	'NewName'					=> 'Angi nytt navn for denne siden',
	'AlreadyExists'				=> 'Siden %1 finnes allerede.',
	'AlreadyNamed'				=> 'Denne siden har allerede navnet %1.',
	'PageRenamed'				=> 'Siden endret navn.',
	'NewNameOfPage'				=> 'Nytt navn på denne siden: ',
	'NotOwnerCantRename'		=> 'Du er ikke eier av denne siden og kan derfor ikke gi den nytt navn',
	'NeedRedirect'				=> 'Lag omdirigering til den nye siden på den gamle siden',
	'RedirectCreated'			=> 'I siden %1 opprettet omdirigering til den nye',

	'UserSettings'				=> 'Bruker innstillinger',
	'UserSettingsGeneral'		=> 'Generelt',
	'UserSettingsNotifications'	=> 'Varsler',

	'NotifyMinorEdit'			=> 'Varsle også mindre redigering',
	'NotifyPageEdit'			=> 'Rediger',
	'NotifyComment'				=> 'Kommentar',
	'NotifyOff'					=> 'Av',
	'NotifyAlways'				=> 'Alltid',
	'NotifyPending'				=> 'Ventende',
	'NotifyDigest'				=> 'Oppsummering',
	'NotifyPendingPageTip'		=> 'Bare ett varsel sendes for den første siden endring av en side du følger.',
	'NotifyPendingCommentTip'	=> 'Bare ett varsel sendes for den første kommentaren til en side du ser på.',
	'NotifyPendingTip'			=> 'Varsling aktiveres automatisk når du besøker gjeldende versjon av siden.',

	'FurtherPending'			=> 'Det vil ikke være andre varsler om endringer dersom du besøker denne siden.',

	'UserSettingsEmailMe'		=> 'Send meg e-post når ...',

	'UserSettingsExtended'		=> 'Utvidet',
	'UserSettingsOther'			=> 'Andre instillinger',
	'UserSpace'					=> 'Bruker område',
	'ChooseTheme'				=> 'Velg tema',

	'CreatePage'				=> 'Opprett denne siden',
	'CreateNewPage'				=> 'Lag en ny side',
	'CreateNewPageText'			=> 'Opprett',
	'CreateNewPageTip'			=> 'Lag en ny side',

	'CreateRandomPage'			=> 'Opprett en tilfeldig side:',
	'CreateSubPage'				=> 'Opprett en underside i klubben:',
	'CreatePageParentCluster'	=> 'Opprett en side i overordnet klynger:',
	'CreatePageDenied'			=> 'Du har ikke de nødvendige tilgangene.',
	'CreatePageDeniedAddress'	=> 'Du har ikke rettighet til å opprette side på denne adressen.',
	'PageAlreadyExists'			=> 'I følge adressen som er oppgitt finnes siden %1 allerede.',
	'PageAlreadyExistsEdit'		=> 'Do you want %1 it?',
	'PageAlreadyExistsEdit2'	=> 'rediger',
	'PageAlreadyExistsEditDenied'	=> 'Du kan ikke redigere det.',

	'SimilarPagesExists'		=> 'Lignende sider til %1 finnes allerede:',
	'SimilarPagesHint'			=> 'Det finnes eksisterende lignende sider som %1:',

	'PageReservedWord'			=> 'Du kan ikke bruke %1 som en del av adressen da det er et reservert ord.',
	'UserReservedWord'			=> 'Brukernavn kan ikke inneholde %1 fordi det er et reservert ord.',

	'DontRedirect'				=> 'Ikke tillat automatisk omdirigering med handlings omdirigering.',
	'SendWatchEmail'			=> 'Send varsler når noen (unntatt deg) endrer hvilken side du ser på',
	'AllowIntercom'				=> 'Tillat personlige meldinger fra brukere i systemet',
	'AllowMassemail'			=> 'Administratorer kan sende meg informasjon på e-post',
	'HideLastSession'			=> 'Skjul siste økt',
	'ValidateIP'				=> 'Prøver økt til IP',
	'AnonymousPub'				=> 'Publisert anonymt (for å skjule navnet)',
	'PageMoved'					=> 'Denne siden er flyttet. Du kan finne den på',
	'RedirectedFrom'			=> 'Videresendt fra %1',
	'RedirectedTo'				=> 'Omdirigert til',
	'CurrentPassword'			=> 'Nåværende passord',
	'NewPassword'				=> 'Nytt passord',
	'YouWantChangePassword'		=> 'Endre passord',
	'ChangePasswordButton'		=> 'Endre passord',
	'PasswordChanged'			=> 'Passord endret',
	'EmailWelcome'				=> 'Du har registrert deg på ',
	'EmailRegistered'			=> 'Du har registrert deg på %1.' . "\n" . 'Ditt brukernavn: %2' . "\n\n",
	'EmailVerify'				=> 'Hvis du vil motta varslinger, må du bekrefte din e-postadresse. Vennligst klikk på eller kopier følgende link til en nettleser: ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Gå tilbake til Wiki og logg inn med ditt nye brukernavn og passord.',
	'EmailRegisteredIgnore'		=> 'Hvis du ikke ba om denne registreringen, ignorer meldingen og ingenting vil skje.',
	'EmailDoNotReply'			=> 'Ikke svar på denne meldingen.',
	'EmailReverify'				=> 'Noen (kanskje du) sendte inn din e-post som varseladresse på %1.' . "\n" . 'Ditt brukernavn: %2'."\n\n" . 'Hvis du vil motta varslinger, må du godkjenne din e-post. Vennligst følg linken for å gjøre dette.' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'Bekreft e-postadressen din',
	'EmailConfirmed'			=> 'E-post bekreftet',
	'EmailNotConfirmed'			=> 'E-post kunne ikke bekreftes. Dette kan skyldes en feil bekreftelseskode eller at e-postadressen allerede er bekreftet. Du kan sjekke om e-postadressen allerede er bekreftet ved å logge inn og se dens status på %1 -siden.',
	'EmailNotVerified'			=> 'E-post ikke bekreftet!',
	'EmailNotVerifiedDesc'		=> 'Du vil ikke motta varsel om endringer eller kommentarer om sette opp sider, ' .
									'eller meldinger fra andre brukere. I tillegg, <strong>vil ikke kunne gjenopprette et glemt passord</strong>, ' .
									'frem til din e-postadresse er bekreftet ved å følge linken i e-posten som er sendt til deg. ' .
									'Hvis du i løpet av dager etter registreringen ikke får en e-post, spør om det igjen ved å klikke ',

	'ForgotPasswordHint'		=> 'Skriv inn din brukernavn og e-postadresse' . "\n" . 'deretter vil en e-post med instruksjoner bli sendt til deg.',
	'ForgotPassword'			=> 'Glemt passord?',
	'UserNotFound'				=> 'Bruker med dette navnet eller e-postadressen ble ikke funnet.',
	'NotConfirmedEmail'			=> 'Din e-postadresse er ikke bekreftet.<br>Mail kan ikke sendes til en ikke-bekreftet adresse.',
	'EmailForgotSubject'		=> 'Passordfornyelse for ',
	'EmailForgotMessage'		=> 'Noen (kanskje du) har glemt passordet ditt for %1.' . "\n" . 'Ditt innlogging: %2'."\n\n" . 'Klikk på lenken eller kopier den til adresselinjen i nettleseren for å endre passordet ditt.' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> 'Instruksjoner for passordgjenoppretting ble sendt til deg via e-post.',
	'WrongCode'					=> 'Feil kode',
	'ChangePasswordForUser'		=> '%1\'s password change',

	'Watchers'					=> 'Liste over overvåkere for %1',
	'WatchersFor'				=> 'Overvåkere for',
	'NoWatchers'				=> 'Det er ingen overvåkere for %1',
	'NotOwnerToViewWatchers'	=> 'Du er ikke eier av denne siden og du kan ikke se liste over overvåkere for den.',

	// thumbnail
	'TbnError'					=> 'Feil ved oppretting av miniatyrbilde: %1',
	'TbnImageAreaTooBig'		=> 'Fil med dimensjoner større enn %1',
	'TbnImageMissing'			=> 'Filen ser ut til å mangler: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Generer passordet hash for <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Importer med cluster:',
	'ImportWhat'				=> 'XML-filen som skal importeres:',
	'ImportButton'				=> 'Importer',
	'ImportSuccess'				=> 'Importering vellykket.',
	'ImportFailed'				=> 'IMPORT mislyktes.',
	'ImportHint'				=> 'Oppgi en klynge du ønsker å importere til, ingen relativ adresse.',
	'ImportAttention'			=> 'Merk: Overskriver de samme sidene i klyngen.',
	'ImportNote'				=> 'Importert side',

	// mywatches action
	'WatchedPages'				=> 'Liste over alle sider du følger for endringer ',
	'UnwatchedPages'			=> 'Liste over alle sider du ikke ser på',
	'NoWatchedPages'			=> 'Du har ingen overvåkede sider.',
	'NoUnwatchedPages'			=> 'Du ser etter endringer i alle sider.',
	'ViewWatchedPages'			=> 'Vis sette sider',
	'ViewUnwatchedPages'		=> 'Vis usette sider',
	'NotLoggedInWatches'		=> 'Du er ikke logget inn, derfor kunne vi ikke identifisere listen over overvåkninger.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'Liste over alle sider du så på som ble redigert av andre siden din siste redigering.',
	'ResetChangesWatches'		=> 'tilbakestill listen over endringer',
	'NoChangesWatches'			=> 'Blant dine sette sider er det ingen endringer...',

	// whatsnew action
	'NewCommentAdded'			=> 'Lagt til ny kommentar',
	'NewFileAdded'				=> 'Lagt til ny fil',
	'NewPageCreated'			=> 'Opprettet en ny side',
	'NewRevisionAdded'			=> 'Endret side',
	'Cluster'					=> 'gruppe',
	'PageDeleted'				=> 'Side slettet',
	'CommentDeleted'			=> 'Kommentar slettet av',
	'FileDeleted'				=> 'Fil slettet',

	// users action
	'UsersSearch'				=> 'Finn brukere',
	'UsersOpenProfile'			=> 'Vis profil',
	'UsersNoMatching'			=> 'Finner ikke samsvarende brukere. Prøv et mindre strengt søkekriterier.',
	'UsersName'					=> 'Navn',
	'UsersPages'				=> 'Sider',
	'UsersChanges'				=> 'Endringer',
	'UsersSubscription'			=> 'Abonnement',
	'UsersWatches'				=> 'Overvåkere',
	'UsersComments'				=> 'Kommentarer',
	'UsersUploads'				=> 'Opplastinger',
	'UploadQuota'				=> 'Benyttet lagringsplass',
	'UploadQuotaTip'			=> 'Last opp fellesskapskvote',
	'UsersLogins'				=> 'Innlogginger',
	'UsersRevisions'			=> 'Revisjoner',
	'UsersSignup'				=> 'Registrering',
	'UsersLastSession'			=> 'Siste økt',
	'UsersNotFound'				=> 'Bruker %2 ikke funnet. Klikk <a href="%1">her</a>, gå til hovedlisten.',
	'UsersProfile'				=> 'Profil',
	'UsersContact'				=> 'Kontakt',
	'UsersList'					=> 'Se hele listen over brukere',
	'UsersNA'					=> '[ikke angitt]',
	'UsersNA2'					=> '[No]',
	'UsersSignupDate'			=> 'Registreringsdato',
	'UsersGroupMembership'		=> 'Gruppe medlemskap',
	'UsersPersonalInfo'			=> 'Personlig info',
	'UsersOwnedPages'			=> 'Egne sider:',
	'UsersCommentsPosted'		=> 'Kommentarer skrevet:',
	'UsersFilesUploaded'		=> 'Opplastede filer:',
	'UsersRevisionsMade'		=> 'Revisjoner lager:',
	'UsersDocsSortName'			=> '[Sorter etter navn]',
	'UsersDocsSortCreation'		=> '[Sorter etter opprettelsesdato]',
	'UsersChangesSortAsc'		=> '[Sorter ascending]',
	'UsersChangesSortDesc'		=> '[Sorter ettersyn]',
	'UsersSessionNA'			=> '[ikke registrert]',
	'UsersSessionHidden'		=> '[hidden]',
	'IntercomSubject'			=> 'Emne:',
	'IntercomMessage'			=> 'Melding:',
	'IntercomCopy'				=> 'Send meg en kopi',
	'IntercomSubjectN'			=> '[start a new topic]',
	'IntercomDisabled'			=> 'Beklager, du ønsker ikke, eller kan ikke motta personlige meldinger.',
	'IntercomHint'				=> 'Vennligst logg inn først og følg linken igjen, hvis du vil svare på den personlige meldingen du har mottatt.',
	'IntercomDesc'				=> 'Merk: Sende personlige meldinger som er utført på e-postmottakeren uten å offentliggjøre din adresse. Mottakeren vil kunne svare deg ved hjelp av et lignende skjema på profilsiden din. ',
	'PMOversized'				=> 'Lengden på meldingen overskrider maksimal tillatt størrelse av %1. Forkort meldingen og send inn på nytt.',
	'PMFlooded'					=> 'Intervallet mellom å sende personlige meldinger bør ikke være mindre enn %1 sekunder.',
	'PMSent'					=> 'Personlig melding ble sendt til brukeren.',
	'PMBody'					=> 'Denne meldingen er sendt til deg av brukeren %1.',
	'PMBodyCopy'				=> 'Du sendte meldingen til brukeren %1.',
	'PMReply'					=> 'For å svare på denne e-posten, klikk på følgende lenke (bruk ikke svar-knappen / Svar i e-post):',
	'PMNotLoggedIn'				=> 'Du er ikke registrert i systemet og kan ikke sende personlige meldinger til brukere.',

	// admin_replace action
	'ReplaceText'				=> 'Erstatt teksten',
	'TextOriginal'				=> 'Opprinnelig tekst:',
	'TextReplacement'			=> 'Erstatningstekst:',
	'ReplaceTextRegex'			=> 'Bruk regulære uttrykk',
	'Namespace'					=> 'Navneområde:',
	'ReplaceTextCluster'		=> 'Søk og erstatt kun innenfor denne klyngen:',
	'ReplaceTextEditPages'		=> 'Erstatt tekst på sideinnhold',
	'ReplaceTextEditComments'	=> 'Erstatt tekst i kommentarer',
	'ReplaceTextEditTitles'		=> 'Erstatt tekst i sidetitler',
	'ReplaceTextGiveTarget'		=> 'Du må angi hvilken streng som skal erstattes.',
	'ReplaceTextNoNamespace'	=> 'Du må velge minst ett navneområde.',
	'ReplaceTextNoDifference'	=> 'Det er ingen forskjell mellom erstatte tekst og måltekst.',
	'ReplaceTextNoOption'		=> 'Du må velge minst én av erstatningsalternativene.',
	'ReplaceTextPagesEdit'		=> 'Erstatt %1 med %2 i teksten til følgende %3 sider:',
	'ReplaceTextTitlesEdit'		=> 'Erstatt %1 med %2 i titlene fra følgende %3 sider:',
	'ReplaceTextReplace'		=> 'Erstatt',
	'ReplaceTextSuccess'		=> '%1 har blitt erstattet med %2 i %3 sider.',
	'ReplaceTextNoMatch'		=> 'Ingen sider som inneholder strengen %1 . (Automatic Translation)',
	'ReplaceTextNoTitleMatch'	=> 'Ingen sider som inneholder navnet %1 ble funnet.',
	'ReplaceTextEditFailed'		=> 'Erstatning av tekst mislyktes',
	'ReplaceTextTitleTooBig'	=> 'Orginal eller erstatningstekst er for stor for tittel.',
	'ReplaceTextReturn'			=> 'Tilbake til skjema',
	'ReplaceTextWarning'		=> 'Advarsel: %1 sider som allerede inneholder erstatningsstrengen, %2. Hvis du lager denne erstatningen, vil du ikke kunne skille ut dine erstatning fra disse strengene.',
	'ReplaceTextBlankWarning'	=> 'Advarsel: Fordi erstatningsstrengen er tom, vil ikke denne operasjonen være reversibel.',
	'ReplaceTextEditSummary'	=> 'Erstatning av tekst: %1 → %2',
	'InvertSelection'			=> 'Inverter merking',

	// Properties
	'PropertiesFor'				=> 'Sideegenskaper for %1',
	'MetaTag'					=> 'Tagg',
	'MetaTitle'					=> 'Tittel',
	'MetaKeywords'				=> 'Nøkkelord',
	'MetaDescription'			=> 'Beskrivelse',
	'On'						=> 'På',
	'Off'						=> 'Av',
	'Registered'				=> 'Registrert',
	'MetaComments'				=> 'Vis kommentarer',
	'MetaFiles'					=> 'Vis fil-panel',
	'MetaToc'					=> 'Vis tabell over innhold',
	'MetaIndex'					=> 'Vis klynge del panel',
	'MetaIndexMode'				=> 'Vis nivåmodus',
	'MetaIndexFull'				=> 'Tre',
	'MetaIndexUpper'			=> 'Øvre',
	'MetaIndexLower'			=> 'Lavere',
	'MetaHtml'					=> 'HTML støtte for side',
	'MetaSafeHtml'				=> 'Filtrering av utrygg HTML',
	'MetaTypografica'			=> 'Typisk korrektor',
	'MetaNoIndex'				=> 'Blokker søkemotorer',
	'SettingsID'				=> 'Side id',
	'SettingsSize'				=> 'Størrelse',
	'SettingsSizeTip'			=> 'kilde / kompilert',
	'SettingsCreated'			=> 'Opprettet',
	'SettingsCurrent'			=> 'Endret',
	'SettingsTotalRevs'			=> 'Revisjoner',
	'SettingsTotalComs'			=> 'Kommentarer',
	'SettingsWatchers'			=> 'Overvåkere',
	'SettingsHits'				=> 'Visninger',
	'SettingsText'				=> 'Innstillinger',
	'SettingsEdit'				=> 'Rediger',
	'SettingsRevisions'			=> 'Revisjoner',
	'SettingsClone'				=> 'Klon',
	'SettingsRename'			=> 'Omdøp',
	'MassRename'				=> 'for hele klyngen',
	'SettingsRemove'			=> 'Fjern',
	'SettingsPurge'				=> 'Purge',
	'SettingsModerate'			=> 'Moderat',
	'SettingsPermissions'		=> 'Tillatelser',
	'AclForEntireCluster'		=> 'for hele klyngen',
	'SettingsAttachments'		=> 'Vedlegg',
	'SettingsUpload'			=> 'Last opp',
	'SettingsCategories'		=> 'Kategorier',
	'SettingsLanguages'			=> 'Språk',
	'SettingsReferrers'			=> 'Henvisninger',
	'SettingsWatch'				=> 'Overvåk',
	'SettingsLatex'				=> 'LaTeX versjon',
	'SettingsXML'				=> 'Eksporter til XML',
	'NeedToChangeLang'			=> 'Ustøttet språk %1 må endres.',
	'SetLang'					=> 'Språk på denne siden',
	'SetMenuLabel'				=> 'Etikett for meny',
	'SetShowMenuLabel'			=> 'Vis på navigering',

	// upload
	'UploadFiles'				=> 'Last opp filer',
	'UploadFor'					=> 'Opplasting av fil:',
	'UploadButton'				=> 'Last opp',
	'UploadGlobalText'			=> 'for offentlig tilgang',
	'UploadGlobal'				=> 'global',
	'UploadLocalText'			=> 'bare for brukere som har tilgang til denne siden',
	'UploadAsName'				=> 'Navn:',
	'UploadOverwrite'			=> 'Skriv over eksisterende filer',
	'FileDesc'					=> 'Beskrivelse:',
	'UploadForbidden'			=> 'Du kan ikke laste opp filer her.',
	'UploadOverwriteDenied'		=> 'Bare fileier eller administrator kan overskrive %1 -filen.',
	'UploadNoFile'				=> 'Det var av en eller annen grunn ingen fil i skjemaet.',
	'UploadMaxSizeReached'		=> 'Filstørrelsen er over tillatt grense!',
	'UploadDirNotWritable'		=> 'Filmappen er ikke skrivbar!',
	'UploadNotAPicture'			=> 'Kun bildeopplastinger er tillatt. Hva forsøker du å laste opp?',
	'UploadEmptyExtension'		=> 'Filnavnet og utvidelsen kan ikke være tomt.',
	'FilenameTooLong'			=> 'Det kan hende at filnavn ikke er lenger enn 240 byte.',
	'BannedFiletype'			=> '%1 er ikke en tillatt filtype.',
	'PermittedFiletype'			=> 'Tillatte filtyper:',
	'UploadMimeMismatch'		=> 'Filutvidelsen %1 samsvarer ikke med den oppdagede MIME-typen til filen (%2).',
	'UploadBadMime'				=> 'Filer av MIME-typen %1 kan ikke lastes opp.',
	'FileIsDuplicate'			=> 'Opplastingen er en eksakt duplikat av denne versjonen.',
	'FileHasDuplicate'			=> 'Denne filen er en duplikat av følgende filer:',

	'UploadMaxFileQuota'		=> 'Du har nådd grensen for opplasting. Filen kan ikke lastes opp',
	'UploadDone'				=> 'Filopplasting vellykket',
	'UploadFileForbidden'		=> 'Filtilgang er forbudt',
	'UploadTitle'				=> 'Filer som er tilgjengelige fra denne siden',
	'UploadTitleGlobal'			=> 'Tilgjengelige filer fra hvor som helst',

	'UploadFile'				=> 'Last opp',
	'UploadMax'					=> 'Ikke mer enn ',
	'UploadUsedStorage'			=> 'Oppbevaring i bruk ',

	// attachments
	'Attachments'				=> 'Vedlegg',
	'Attachment'				=> 'Vedlegg',
	'AttachmentsToPage'			=> 'til side',
	'AttachmentsToCluster'		=> 'gruppe',
	'AttachmentsByTime'			=> 'etter tid',
	'AttachmentsGlobal'			=> 'global',
	'AttachmentsAll'			=> 'alle',
	'AttachmentsLinked'			=> 'brukt',

	'FileViewProperties'		=> 'Vis',
	'FileViewPropertiesTip'		=> 'Vis metadata av denne filen',
	'FileEditProperties'		=> 'Rediger',
	'FileEditPropertiesTip'		=> 'Redigere metadata for denne filen',
	'FileEditedMeta'			=> 'Oppdaterte metadata av denne filen',
	'FileEditDenied'			=> 'Du har ikke rettigheter til å redigere denne filen',
	'FileLabel'					=> 'Etikett',
	'FileLabelTip'				=> 'Merk denne filen',
	'FileRemove'				=> 'Fjern',
	'FileRemovedFromDB'			=> 'Fil fjernet fra databasen',
	'FileRemovedFromFS'			=> 'Fil ble slettet fra fysisk hosting',
	'FileRemovedFromFSError'	=> 'Det synes å være umulig å slette filen!',
	'FileRemoveConfirm'			=> 'Sikker på at du vil fjerne denne filen?',
	'FileRemoveDenied'			=> 'Du har ikke rettigheter til å fjerne denne filen',
	'FileNotFound'				=> 'Finner ikke filen.',

	'FileSearch'				=> 'Finn fil',
	'UploadBy'					=> 'Lastet opp av:',
	'FileAdded'					=> 'Lagt til:',
	'FileModified'				=> 'Endret:',
	'FileSize'					=> 'Størrelse:',
	'FileDimension'				=> 'Dimensjon:',
	'MimeType'					=> 'Mimetype:',
	'FileName'					=> 'Navn:',
	'FileCaption'				=> 'Overskrift:',
	'FileAuthor'				=> 'Forfatter:',
	'FileSource'				=> 'Kilde:',
	'FileSourceUrl'				=> 'Url:',
	'FileAttachedTo'			=> 'Vedlagt til:',
	'FileSyntax'				=> 'Syntaks:',
	'FileAbsolutePath'			=> 'Absolutt sti',
	'FileRelativePath'			=> 'relativ sti',
	'FileUsage'					=> 'Filbruk:',
	'FileUsageText'				=> 'Lenke til denne filen på følgende sider:',
	'NoFileUsage'				=> 'Ingen sider lenke til denne filen.',

	'FileSortExt'				=> 'utvidelse',
	'FileSortName'				=> 'navn',
	'FileSortSize'				=> 'størrelse',
	'FileSortTime'				=> 'opprettet',

	'SortBy'					=> 'Sorter etter',
	'Ascending'					=> 'stigende',
	'Decending'					=> 'forfaller',

	'Files0'					=> 'Legg ved filer',
	'Files1'					=> 'Vis filer (1 fil)',
	'FilesN'					=> 'Vis filer (%1 filer)',
	'Files'						=> 'Filer',
	'File'						=> 'Fil',
	'ShowFiles'					=> 'Vis filer / skjema',
	'HideFiles'					=> 'Skjul filer / form',
	'DoShowFiles'				=> 'Vis fillister som standard',
	'NoAttachments'				=> 'Ingen vedlagte filer å vise.',

	'RegistrationLang'			=> 'Ditt språk',
	'InvalidWikiName'			=> 'Valgt navn er ugyldig',
	'InvalidUserName'			=> 'Valgt brukernavn er ugyldig',
	'Bookmarks'					=> 'Bokmerker',
	'ReallyDeleteComment'		=> 'Vil du virkelig slette denne kommentaren?<br>Det er ingen angre for denne handlingen!',
	'ReallyDeleteRevision'		=> 'Vil du virkelig slette denne versjonen?<br>Det er ingen angring for denne handlingen!',

	'RegistrationClosed'		=> 'Registrering er ikke tilgjengelig her. Prøv å kontakte websideadministrator.',
	'AclAreYouSure'				=> 'Du kommer til å endre ACLs på denne siden og alle dens undersider. Vil du fortsette?',

	'BookmarkDeleteSelected'	=> 'Slett valgte',
	'BookmarkMark'				=> 'Marker',
	'BookmarkNumber'			=> 'Nr.',
	'BookmarkNone'				=> 'Du har ingen bokmerker.',
	'BookmarkTitle'				=> 'Bokmerke tittel',
	'BookmarkPage'				=> 'Side',
	'BookmarkSaveChanges'		=> 'Lagre endringer',
	'BookmarksAddPage'			=> 'Angi et bokmerke for følgende side',
	'BookmarkAlreadyExists'		=> 'Bokmerket finnes allerede.',

	'PoweredBy'					=> 'Drives av',

	'MassRenaming'				=> 'Gi hele klyngen nytt navn',
	'MassNewName'				=> 'Angi nytt navn for denne klyngen',
	'MassNeedRedirect'			=> 'Lage omdirigering til de nye sidene på de gamle sidene',

	// pagination
	'ToOverview'				=> 'Tilbake til oversikten',
	'Overview'					=> 'Oversikt',
	'ToThePage'					=> 'Til side:',
	'Next'						=> 'Neste',
	'Prev'						=> 'Forrige',
	'NextAcr'					=> 'Neste',
	'PrevAcr'					=> 'Forrige',
	'Back'						=> 'Tilbake',

	// filter
	'Filter'					=> 'Filtrer',
	'OptionalFilters'			=> 'Valgfrie filtre:',
	'Any'						=> 'Alle',

	// My Groups
	'UserGroups'				=> 'Grupper av brukere',
	'MyGroups'					=> 'Gruppe tilknytninger',
	'Group'						=> 'gruppe',
	'Groups'					=> 'grupper',

	// license action
	'DistributedUnder'			=> 'Materialet er fordelt under',
	'AuthorsDisplayHint'		=> 'Liste over forfattere vises når du lagrer siden.',
	'AnonymousUsers'			=> 'Anonym brukere',
	'License'					=> 'Lisens',
	'LicenseArray'				=> [
		'1'		=> 'Navngivelse-IngenBearbeidelser',
		'2'		=> 'Navngivelse-IkkeKommersiell-DelPåSammeVilkår',
		'3'		=> 'Navngivelse-IkkeKommersiell-IngenBearbeidelser',
		'4'		=> 'Navngivelse-DelPåSammeVilkår',
		'5'		=> 'Navngivelse-IkkeKommersiell',
		'6'		=> 'Navngivelse',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation lisens',
		'9'		=> 'Offentlig eiendom / Gratis bruk',
		'10'	=> 'Alle rettigheter forbeholdt',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Offentlig eiendom',
		'2'		=> 'Noen rettigheter forbeholdt',
		'3'		=> 'Alle rettigheter forbeholdt',
	],

	// Cache
	'ClearCache'				=> 'Tøm hurtigminne',
	'CacheCleared'				=> 'Minne tømt.',
	'ConfigCache'				=> 'Config cache',
	'FeedCache'					=> 'Mellomlager for nyhetsmating',
	'PageCache'					=> 'Sidens mellomlager',
	'SQLCache'					=> 'SQL cache',
	'TemplateCache'				=> 'Mal cache',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Angi en adresse til ressursen med ParameterURL. (f.eks. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Tittel på nyhetsmating',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Vennligst angi en Feed med ParameterURL. (f.eks. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Kunne ikke laste eller analysere feed',
	'FeedSource'				=> 'Kilde:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Nylige endringer',
	'ChangesXML'				=> 'Siste endringer ',
	'CommentsXMLTitle'			=> ' - Siste kommentarer',
	'CommentsXML'				=> 'Siste kommentarer til ',
	'NewsXMLTitle'				=> ' - Siste nyheter',
	'NewsXML'					=> 'Siste nyheter til ',
	'RevisionXMLTip'			=> 'Klikk for å se nylige siderevisjoner i XML-format.',
	'CommentsXMLTip'			=> 'Klikk for å se de siste kommentarene i XML-format.',
	'ChangesXMLTip'				=> 'Klikk for å se de siste endringene i XML-format.',
	'NewsXMLTip'				=> 'Klikk for å vise de siste nyhetene i XML-format.',
	'RevisionsXML'				=> 'Revisjoner av ',
	'ExportClusterXML'			=> 'Eksport av hele klyngen ',
	'AccessDeniedXML'			=> 'Du har ikke tilgang til denne informasjonen.',

	'ChangesFeed'				=> 'Endringer',
	'CommentsFeed'				=> 'Kommentarer',
	'NewsFeed'					=> 'Nyheter',
	'RevisionsFeed'				=> 'Revisjoner av ',

	'LastModification'			=> 'Sist endret',

	// Captcha
	'Captcha'					=> 'Skriv inn ordet du leser i bildet',
	'CaptchaFailed'				=> 'Du har angitt captcha-ordet feil. Prøv på nytt.',
	'CaptchaReload'				=> 'Ny Captcha',
	'CaptchaReloadWarning'		=> 'Beklager, kan ikke laste inn bilde på nytt, du må laste inn siden på nytt for å gjøre det',

	// news
	'News'						=> 'Nyheter',
	'NewsName'					=> 'Tittel:',
	'NewsNoName'				=> 'Du glemte å legge til nyhetsoverskriften.',
	'NewsNotAvailable'			=> 'Ingen nyheter er tilgjengelige.',
	'NewsNoClusterDefined'		=> 'Ingen grupper for nyheter ble definert.',
	'NewsDiscuss'				=> 'Diskuter denne artikkel...',

	// blog
	'BlogNewTopic'				=> 'Lag nytt innlegg',
	'NoPostAvailable'			=> 'Ingen innlegg tilgjengelig ennå.',

	// Review
	'Reviewer'					=> 'Anmelder',
	'Reviewed'					=> 'revidert',
	'Review'					=> 'gjennomgåelse',
	'ReviewedBy'				=> 'vurdert av',
	'RemoveReview'				=> 'Fjern omtale for denne siden',
	'SetReview'					=> 'Anmeldt denne siden',
	'SetAsReviewed'				=> 'Angi side som revidert',
	'SetAsUnreviewed'			=> 'Angi side som uvurdert',

	// word filter
	'PotentialSpam'				=> 'Identifisert potensielle søppelpost',

	// moderation handler
	'Moderation'				=> 'Moderering',
	'Topics'					=> 'Emner',
	'ModerateSection'			=> 'seksjon / side ',

	'NotModerator'				=> 'Du har ikke myndighet til å moderere denne siden / kapittelet',
	'ModerateDeleteTopic'		=> 'Slett emne / side',
	'ModerateDeletePosts'		=> 'Slett kommentarer',
	'ModerateMove'				=> 'Flytt',
	'ModerateSplit'				=> 'Splitt / Flytt kommentarer',
	'ModerateMerge'				=> 'Flett',
	'ModerateLock'				=> 'Lås',
	'ModerateUnlock'			=> 'Lås opp',
	'ModerateAccept'			=> 'Godta',
	'ModerateDeleteConfirm'		=> 'Er du sikker på at du vil <strong>fjerne</strong> følgende emner?',
	'ModerateRenameConfirm'		=> 'Angi en ny tittel for den valgte siden',
	'ModerateRenameExists'		=> 'Side med samme navn eksisterer allerede! Velg et annet navn.',
	'ModerateRename1Only'		=> 'Merk: Kun den første siden du valgte endres om!',
	'ModerateMovesConfirm'		=> 'Velg målpartisjonen til å flytte forumet til',
	'ModerateMoveConfirm'		=> 'Velg forumet eller spesifiser klyngen å flytte disse emnene. Hvis du vil flytte en side til roten av nettstedet, skriver du &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Angi navnet på klyngen hvor siden skal plasseres. Hvis du vil flytte en side til roten av nettstedet, type &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operasjonen avbrutt: I denne seksjonen finnes det allerede emner med samme navn %1. Hvis du fortsatt trenger å overføre de nevnte emnene ovenfor må du først endre navn på dem.',
	'ModerateMoveNotExists'		=> 'Siden / klyngen eksisterer ikke. Sjekk navnet og prøv på nytt.',
	'ModerateMergeConfirm'		=> 'Velg et emne, som skal kombinere de resterende',
	'ModerateMerge2Min'			=> 'For å bli med må du velge minst to emner!',
	'ModerateComDelConfirm'		=> 'Er du sikker på at du vil <strong>fjerne</strong> %1 %2?',
	'ModerateComment'			=> 'Kommentar',
	'ModerateComments'			=> 'Kommentarer',
	'ModerateSplitNewName'		=> 'Angi et navn for et selvvalgt emne og velg et separasjonsskjema',
	'ModerateSplitPageName'		=> 'Skriv inn navnet på siden / emnet, hvor du vil flytte samtidige kommentarer, og velg et separasjonsskjema',
	'ModerateSplitAllAfter'		=> 'Løsne alle kommentarene etter den første valgte (og inkludert)',
	'ModerateSplitSelected'		=> 'Separerte bare valgte kommentarer (total %1)',
	'ModerateUserProfile'		=> 'profil',
	'ModerateNoItemChosen'		=> 'Vennligst velg minst ett element via Sett-knappen.',

	'ModerateSection2'			=> 'moderat nedsatt leverfunksjon',
	'ModerateTopicsDeleted'		=> 'Valgte emner slettet.',
	'ModerateTopicsRelocated'	=> 'Valgte emner flyttet på nytt.',
	'ModerateTopicsRenamed'		=> 'Emnet endret navn.',
	'ModerateTopicsMerged'		=> 'Valgte emner ble slått sammen.',
	'ModerateTopicsBlocked'		=> 'Valgte emner ble blokkert',
	'ModerateTopicsUnlocked'	=> 'Valgte emner låses opp.',
	'ModerateTopicDeleted'		=> 'Emnet har blitt fjernet.',
	'ModeratePageMoved'			=> 'Siden ble flyttet.',
	'ModerateTopicRenamed'		=> 'Emnet endret navn.',
	'ModerateTopicBlocked'		=> 'Emne ble blokkert',
	'ModerateTopicUnlocked'		=> 'Emne låses opp.',
	'ModerateCommentsDeleted'	=> 'Valgte kommentarer ble fjernet.',
	'ModerateCommentsSplit'		=> 'Valgte kommentarer er separert i et nytt emne.',
	'ModerateCommentsSplitFailed'	=> 'Merk: Av en eller annen grunn kan du skille ut de valgte kommentarene til et nytt emne mislyktes.<br>Vanligvis bør dette ikke skje, så meld fra til nettstedets administrator.<br>Som en forholdsregel, er problemet blitt bevart i originalskjemaet.',
	'ModerateCommentsMoved'		=> 'Valgte kommentarer ble overført til den angitte siden.',

	// forum
	'ForumSubforums'			=> 'Forum',
	'ForumTopic'				=> 'Emne',
	'ForumTopics'				=> 'Emner',
	'ForumPosts'				=> 'Innlegg',
	'ForumReplies'				=> 'Svar',
	'ForumAuthor'				=> 'Forfatter',
	'ForumViews'				=> 'Visninger',
	'ForumCreated'				=> 'Opprettet',
	'ForumComments'				=> 'Kommentarer',
	'ForumLastComment'			=> 'Siste kommentar',
	'ForumNoComments'			=> 'Ingen kommentarer',
	'ForumNoTopics'				=> 'Det finnes ingen emner eller innlegg i dette forumet.',
	'ForumNewTopic'				=> 'Start en ny diskusjon',
	'ForumTopicName'			=> 'Emnet navn:',
	'ForumTopicSubmit'			=> 'Send inn emne',
	'ForumNoTopicName'			=> 'Angi et navn på den nye siden.',
	'ForumNewPosts'				=> 'nytt innlegg',
	'ForumLocked'				=> 'seksjonen låst',
	'ForumUpdated'				=> 'oppdatert',
	'ForumNoClusterDefined'		=> 'Ingen forum klynge definert.',
	'ForumOutsideCluster'		=> 'Pass på at handlingen %1 er plassert i forumklyngen',

	// password complexity
	'PwdCplxShort'				=> 'Passordet er for kort.',
	'PwdCplxEquals'				=> 'Passordet inneholder brukernavnet.',
	'PwdCplxWeak'				=> 'Passordet oppfyller ikke kompleksitetskrav.',
	'PwdCplxDesc1'				=> 'Krav til passordet: ',
	'PwdCplxDesc2'				=> 'Passordet kan ikke være mindre enn %1 tegn',
	'PwdCplxDesc3'				=> 'må ikke inneholde ditt brukernavn',
	'PwdCplxDesc4'				=> 'bør bestå av ',
	'PwdCplxDesc41'				=> 'bokstaver og tall',
	'PwdCplxDesc42'				=> 'store bokstaver og tall',
	'PwdCplxDesc43'				=> 'store og små bokstaver, tall og ikke-alfanumeriske tegn',
	'PwdCplxDesc5'				=> 'Du kan bruke bokstaver, tall og spesialtegn unntatt mellomrom.',

	'PasswordTooShort'			=> 'Passordet er for kort.',
	'PasswordTooCommon'			=> 'Passordet er for vanlig.',
	'PasswordSameAsUsername'	=> 'Passordet er det samme som brukernavnet ditt.',
	'PasswordSameAsEmail'		=> 'Passordet er det samme som din epost.',

	'Timezone'					=> 'Timezone',
	'DateFormat'				=> 'Dato format',

	'LanguageArray'	=> [
		'ar' => 'Arabisk',
		'bg' => 'Bulgarsk',
		'cs' => 'Tsjekkisk',
		'da' => 'Dansk',
		'de' => 'Tysk',
		'el' => 'Gresk',
		'en' => 'Engelsk',
		'es' => 'Spansk',
		'et' => 'Estisk',
		'fa' => 'Persisk',
		'fi' => 'Finsk',
		'fr' => 'Fransk',
		'hi' => 'hindi',
		'hu' => 'Ungarsk',
		'id' => 'Indonesisk',
		'it' => 'Italiensk',
		'ja' => 'Japansk',
		'ko' => 'Koreansk',
		'nl' => 'Nederlandsk',
		'no' => 'Norsk',
		'pl' => 'Polsk',
		'pt' => 'Portugisisk',
		'pt-br' => 'Portugisisk Brasil',
		'ro' => 'Romainsk/e',
		'ru' => 'Russisk',
		'sv' => 'Svensk',
		'ta' => 'Tamil',
		'uk' => 'Ukrainsk',
		'zh' => 'Kinesisk',
		'zh-tw' => 'Kinesisk',
	],

	'AccountStatus'				=> 'Konto status',
	'AccountStatusArray' => [
		'0' => 'aktiv',
		'1' => 'venter',
		'2' => 'blokkert',
		'3' => 'inaktiv',
	],

	'JustNow'		=> 'akkurat nå',
	'MinuteAgo'		=> 'for ett minutt siden',
	'MinutesAgo'	=> '%1 minutter siden',
	'HourAgo'		=> 'for en time siden',
	'HoursAgo'		=> '%1 timer siden',
	'DayAgo'		=> 'I går',
	'DaysAgo'		=> '%1 dager siden',
	'WeekAgo'		=> 'en uke siden',
	'WeeksAgo'		=> '%1 uker siden',
	'MonthAgo'		=> 'en måned siden',
	'MonthsAgo'		=> '%1 måneder siden',
	'YearAgo'		=> 'ett år siden',
	'YearsAgo'		=> '%1 år siden',

	'InAMoment'		=> 'et øyeblikk',
	'InAMinute'		=> 'om ett minutt',
	'InMinutes'		=> 'i %1 minutter',
	'InAnHour'		=> 'om én time',
	'InHours'		=> 'i %1 timer',
	'Tomorrow'		=> 'I morgen',
	'InDays'		=> 'i %1 dager',
	'InAWeek'		=> 'om en uke',
	'InWeeks'		=> 'i %1 uker',
	'InAMonth'		=> 'i en måned',
	'InMonths'		=> 'i %1 måneder',
	'InAYear'		=> 'om et år',
	'InYears'		=> 'i %1 år',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'kB', 'Mb', 'NO', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['Byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'IB'],
	'ByteBinaryLong'			=> ['Byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'Gruppe', 'Tast', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['piksel', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Ukjent handling',
	'UnknownMethod'				=> 'Ukjent metode',
	'FormatterNotFound'			=> 'Villkafee %1 ikke funnet',

	// log
	'LogAdminLoginSuccess'		=> 'Vellykket innlogging i administrasjonspanelet',
	'LogAdminLogout'			=> 'Utlogging av det administrative panelet',
	'LogAdminLoginFailed'		=> '!!Klarer ikke få tilgang til administrasjonspanelet!',
	'LogAdminLoginLocked'		=> 'Låst innlogging til administrasjonspanelet',
	'LogUserCookieForged'		=> '!!**Et forsøk på å logge inn på en smidd informasjonskapsel med innlogging ##%1##**!!',
	'LogInvalidFormToken'		=> 'Potensiell CSRF-angrep under fremgang oppdaget: %1',
	'LogRemovedPage'			=> '!!Fjernet side ##%1## (bruker %2)!!',
	'LogRemovedCluster'			=> '!!Fjernet **cluster** ##%1## (bruker %2)!!',
	'LogRemovedRevision'		=> '!!Fjernet revisjon ##%3## på siden [[/%1]] (bruker %2)!!',
	'LogRemovedComment'			=> '!!Fjernet kommentar fra %3 på siden [[/%1]] (bruker %2)!!',
	'LogRemovedFile'			=> '!!Fjernet fil ##%2## fra side [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!Fjernet alle kommentarer på siden [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Fjernet alle revisjoner av siden [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Fjernet alle filer, koblet til [[/%1]]!!',
	'LogTopicLocked'			=> 'Forumemne er låst [[/%1]]',
	'LogTopicUnlocked'			=> 'Opplåst forumemne [[/%1]]',
	'LogAclUpdated'				=> 'Oppdatert ACL-side [[/%1]]',
	'LogOwnershipChanged'		=> 'Eierskap til siden [[/%1]] overført til brukeren ##%2##',
	'LogUserLoginFailed'		=> '!!Mislykte forsøk på å logge inn med ##~%1##!!',
	'LogClonedPage'				=> 'Side ##%1## klonet til [[/%2]]',
	'LogRenamedPage'			=> 'Side ##%1## endret navn til [[/%2]]',
	'LogRenamedPage2'			=> '. Den gamle siden angitt som link til den nye',
	'LogSplittedPage'			=> 'kommentarer på siden [[/%1]] delt på side [[/%2]]',
	'LogMergedPages'			=> 'Sider %1 slått sammen til side [[/%2]]',
	'LogUserPasswordReminded'	=> 'Bruker ##%1## ba om at passordet burde gjenopprette prosessen til adressen ##%2##',
	'LogUserPasswordRecovered'	=> 'Bruker ##%1## ble vellykket gjenopprettet det glemte passordet',
	'LogUserPasswordChanged'	=> 'Bruker ##%1## ble oppdatert (endret) passordet',
	'LogUserPasswordMismatch'	=> '!!User ##%1## kunne ikke endre passordet: nåværende passordulikhet!!',
	'LogUserIPSwitched'			=> 'Uautorisert IP-adresse endring i bruker %1 fra %2 til %3',
	'LogPageImported'			=> 'Importert side [[/%1]]',
	'LogSaveNoRights'			=> 'Ingen passende rettigheter til å lagre siden [[/%1]]',
	'LogPageCreated'			=> 'Opprettet ny side [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Oppdaterte sideegenskaper [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'Brukeren fikk eierskap av siden [[/%1]]',
	'LogFileUploadedLocal'		=> 'Ny fil ##%2## lastet opp til siden [[/%1]] (størrelse %3)',
	'LogFileUploadedGlobal'		=> 'Ny fil ##%2## lastet opp til den globale mappen (størrelse %3)',
	'LogPMSent'					=> 'Personlig melding ##%1## -> ##%2## sendt',
	'LogUserSimilarName'		=> 'Det var forsøk på å registrere under samme brukernavn: ##%1##',
	'LogUserEmailNotAllowed'	=> 'E-post ##%1## ikke i listen over tillatte domener',
	'LogRegisterTiming'			=> 'Registrering mislyktes, tidsterskelen er ##%1## sekunder (var ##%2##)',
	'LogUserRegistered'			=> 'En ny bruker ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Vellykket aktivert e-post ##%1## av brukeren ##%2##',
	'LogCommentPosted'			=> 'La til [[/%1 nye kommentar(er)]] til siden [[/%2]]',
	'LogUserLoginOK'			=> 'Brukeren ##%1## ble vellykket logget inn i systemet',
	'LogUserLoggedOut'			=> 'Brukeren ##%1## ble vellykket utlogget systemet',
	'LogUserSessionContinued'	=> 'Bruker ##%1## fortsatte den suspenderte sesjonen',
	'LogUserSettingsUpdate'		=> 'Bruker ##%1## oppdaterte personlige innstillinger',
	'LogPageEdited'				=> 'Redigert side [[/%1]]',
	'LogCommentEdited'			=> 'Redigert kommentar [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Oppdatert filmetadata for ##%2## fra side [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Oppdaterte filkategorier for ##%2## fra side [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'XML Sidekart generert',
	'LogReferrersPurged'		=> 'Vedlikehold: rensede referenter',
	'LogRevisionsPurged'		=> 'Vedlikehold: utdaterte sider revidert',
	'LogDeletedPagesPurged'		=> 'slettede sider renset',
	'LogSystemLogPurged'		=> 'Vedlikehold: renset systemlogg',
	'LogCachedPagesPurged'		=> 'Vedlikehold: slettede sider på mellomlager',
	'LogSqlCachePurged'			=> 'Mellomliggende sql-resultater tømt',
	'LogExpiredTokensPurged'	=> 'Utgått cookie_tokens tømt',
	'LogErrorSplitComments'		=> 'En feil ved separering av kommentarer fra emnet [[/%1]] et nytt emne ##%2##: siden ble ikke opprettet',
	'LogCategoriesUpdated'		=> 'Oppdaterte sidekategorier [[/%1]]',
	'LogCategoryCreated'		=> 'Opprettet en ny kategori //%1//',
	'LogCategoryRenamed'		=> 'Kategori ##%1## endret navn til ##%2##',
	'LogCategoryDebundled'		=> 'Kategori ##%1## trukket',
	'LogCategoryGrouped'		=> 'Kategori ##%1## gruppert med ordet ##%2##',
	'LogCategoryRemoved'		=> 'Kategori ##%1## fjernet fra databasen',
	'LogThumbnailGeneration'	=> 'Miniatyrbilde generasjon %1 sek.',

	'ErrorMinPHPVersion'		=> 'PHP-versjonen må være større enn <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' det ser ut til at serveren din kjører <strong>' . PHP_VERSION . '</strong>.' .
									'  Du bør oppgradere til en nyere PHP-versjon for at WackoWiki skal fungere riktig.',

];
