<?php

// config values
if (in_array($config['db_driver'], ['mysqli', 'mysql_pdo']) && empty($config['db_port']))
{
	$config['db_port'] = '3306';
}

if ($config['db_collation'] == '0')
{
	$config['db_collation'] = 'utf8mb4_unicode_520_ci';
}
// reset config defaults for SQLite
if (in_array($config['db_driver'], ['sqlite', 'sqlite_pdo']))
{
	$config['db_charset']	= '';
	$config['db_collation']	= '';
	$config['db_engine']	= 'SQLite3';
	$config['db_vendor']	= '';
	$config['db_host']		= '';
	$config['db_port']		= '';
	$config['db_name']		= select_sqlite_db_path()[$config['sqlite_db_path']];
	$config['db_user']		= '';
	$config['db_password']	= '';
	$config['table_prefix']	= '';
}

if (!$config['system_seed'])
{
	$config['system_seed'] = Ut::random_token(20, 3);
}

if (!$config['hashid_seed'])
{
	$config['hashid_seed'] = Ut::random_token(20, 3);
}

$config_file = [];

///////////////////////////////////////////////////////////////////////////////////////////
//	BEGIN MANDATORY CONFIGURATION
///////////////////////////////////////////////////////////////////////////////////////////
$config_file['base_url']			= $config['base_url'];
// database connection
$config_file['db_charset']			= $config['db_charset'];
$config_file['db_collation']		= $config['db_collation'];
$config_file['db_driver']			= $config['db_driver'];
$config_file['db_engine']			= $config['db_engine'];
$config_file['db_vendor']			= $config['db_vendor'];
$config_file['db_host']				= $config['db_host'];
$config_file['db_port']				= $config['db_port'];
$config_file['db_name']				= $config['db_name'];
$config_file['db_user']				= $config['db_user'];
$config_file['db_password']			= $config['db_password'];
$config_file['sql_mode']			= $config['sql_mode'];
$config_file['table_prefix']		= $config['table_prefix'];
// security values
$config_file['system_seed']			= $config['system_seed'];
$config_file['recovery_password']	= $config['recovery_password'];
$config_file['hashid_seed']			= $config['hashid_seed'];
// version
$config_file['wacko_version']		= WACKO_VERSION;

///////////////////////////////////////////////////////////////////////////////////////////
//	END MANDATORY CONFIGURATION
///////////////////////////////////////////////////////////////////////////////////////////

// convert config array into PHP code
$fmt			= new IntlDateFormatter(
					_t('LangLocale'),
					IntlDateFormatter::FULL,
					IntlDateFormatter::FULL,
					null,
					null,
					'EEEEEE dd MMM yyyy HH:mm:ss zzz');
$config_code	= '<?php' . "\n" .
				'// config.php ' . _t('WrittenAt') . $fmt->format(time()) . "\n" .
				'// ' . _t('ConfigDescription') . "\n" .
				'// ' . _t('DontChange') . "\n\n" .
				array_to_str($config_file);

// try to write configuration file
echo '<h2>' . _t('FinalStep') . '</h2>' . "\n";
echo '<ul>' . "\n";
echo	'<li>' . _t('Writing') . '   ';

$perm_changed	= true;
$file_name		= CONFIG_FILE;

if (is_writable($file_name))
{
	$write_file		= file_put_contents($file_name, $config_code);

	if ($write_file)
	{
		// Try and make it non-writable
		@chmod($file_name, CHMOD_SAFE);
		$perm_changed = !is_writable($file_name);

		echo output_image(true) . '</li>' . "\n";

		echo '<li>' . _t('RemovingWritePrivilege') . '   ' . output_image($perm_changed) . '</li>' . "\n";
	}
	else
	{
		// Problem saving file
		echo output_image(false) . '</li>' . "\n";
	}
}
else
{
	// Folder is non-writable
	$write_file = false;
	echo output_image(false) . '</li>' . "\n";
}

echo '</ul>' . "\n";

// purge old cache files
Ut::purge_directory(CACHE_PAGE_DIR);
Ut::purge_directory(CACHE_SQL_DIR);
Ut::purge_directory(CACHE_CONFIG_DIR);
Ut::purge_directory(CACHE_TEMPLATE_DIR);

echo '<h2>' . _t('SecurityConsiderations') . '</h2>' . "\n";
echo '<ul class="attention">' . "\n";

if (!$perm_changed)
{
	echo
		'<li>' .
			Ut::perc_replace(_t('SecurityRisk'),
				'<code>' . CONFIG_FILE . '</code>',
				'<code>chmod ' . decoct(CHMOD_SAFE) . ' ' . CONFIG_FILE . '</code>') .
		'</li>' . "\n";
}

echo	'<li>' .
			Ut::perc_replace(_t('RemoveSetupDirectory'),
				'<code>setup/</code>') .
		'</li>' . "\n";

if (!$write_file)
{
	echo
		'<li>' .
			Ut::perc_replace(_t('ErrorGivePrivileges'),
				'<code>' . CONFIG_FILE . '</code>',
				'<code>touch ' . CONFIG_FILE . '</code><br><code>chmod ' . decoct(CHMOD_FILE) . ' ' . CONFIG_FILE . '</code>',
				'<code>chmod ' . decoct(CHMOD_SAFE) . ' ' . CONFIG_FILE . '</code>') .
			(!$config['is_update']
				? Ut::perc_replace(_t('ErrorPrivilegesInstall'),
					'<code>' . CONFIG_FILE . '</code>')
				: _t('ErrorPrivilegesUpgrade')) .
		'</li>' . "\n";
}

echo	'</ul>' . "\n";

// If there was a problem then show the "Try Again" button.
if ($write_file)
{
	echo
		'<h2>' . _t('InstallationComplete') . '</h2>' . "\n" .
		'<p>' . Ut::perc_replace(_t('ThatsAll'), $config['base_url']) . '</p>' . "\n";
}
else
{
	echo
		'<form action="' . $base_path . '?installAction=write-config" method="post">' . "\n" .
			write_config_hidden_nodes($config_parameters, false) .
			'<button type="submit" class="next">' . _t('TryAgain') . '</button>' . "\n" .
		'</form>' . "\n";

	// show final config only for new installation
	if (!$config['wacko_version'])
	{
		echo
			'<div id="config_code" class="config_code"><pre>' .
				htmlentities($config_code, ENT_COMPAT | ENT_HTML5, HTML_ENTITIES_CHARSET) .
			'</pre></div>' . "\n";
	}
}
?>
<br>